/*
 * Decompiled with CFR 0.152.
 */
package org.skills.utils.versionsupport;

import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.skills.utils.MathUtils;
import org.skills.utils.versionsupport.VersionSupportFuture;
import org.skills.utils.versionsupport.VersionSupportOld;
import org.skills.utils.xseries.XMaterial;

public class VersionSupport {
    public static ExperienceOrb dropExp(Location location, int n) {
        ExperienceOrb experienceOrb = (ExperienceOrb)location.getWorld().spawn(location, ExperienceOrb.class);
        experienceOrb.setExperience(n);
        return experienceOrb;
    }

    public static int getHealthPercent(LivingEntity livingEntity) {
        return VersionSupport.getHealthPercent(livingEntity, 0.0);
    }

    public static int getHealthPercent(LivingEntity livingEntity, EntityDamageEvent entityDamageEvent) {
        return VersionSupport.getHealthPercent(livingEntity, entityDamageEvent.getFinalDamage());
    }

    public static int getHealthPercent(LivingEntity livingEntity, double d) {
        return (int)MathUtils.getPercent(livingEntity.getHealth() - d, VersionSupport.getMaxHealth(livingEntity));
    }

    public static void heal(Player player, double d) {
        EntityRegainHealthEvent entityRegainHealthEvent = new EntityRegainHealthEvent((Entity)player, d, EntityRegainHealthEvent.RegainReason.CUSTOM);
        Bukkit.getPluginManager().callEvent((Event)entityRegainHealthEvent);
        d = Math.min(player.getHealth() + entityRegainHealthEvent.getAmount(), VersionSupport.getMaxHealth((LivingEntity)player));
        player.setHealth(d);
    }

    public static void spawnColouredDust(Location location) {
        VersionSupport.spawnColouredDust(location, Color.BLACK);
    }

    public static void spawnColouredDust(Location location, Color color) {
        if (XMaterial.isNewVersion()) {
            VersionSupportFuture.spawnColouredDust(location, color);
        } else {
            VersionSupportOld.spawnColouredDust(location, color.asRGB());
        }
    }

    public static boolean isPassenger(Entity entity, Entity entity2) {
        if (XMaterial.isNewVersion()) {
            return VersionSupportFuture.isPassenger(entity, entity2);
        }
        return VersionSupportOld.isPassenger(entity, entity2);
    }

    public static double getMaxHealth(LivingEntity livingEntity) {
        if (XMaterial.isNewVersion()) {
            return VersionSupportFuture.getMaxHealth(livingEntity);
        }
        return VersionSupportOld.getMaxHealth(livingEntity);
    }

    public static void addHealth(LivingEntity livingEntity, double d) {
        if (d == 0.0) {
            return;
        }
        if (XMaterial.isNewVersion()) {
            VersionSupportFuture.setMaxHealth(livingEntity, livingEntity.getHealth() + d);
        } else {
            VersionSupportOld.setMaxHealth(livingEntity, livingEntity.getHealth() + d);
        }
    }

    public static void setMaxHealth(LivingEntity livingEntity, double d) {
        if (d == 0.0) {
            return;
        }
        if (d < 0.0) {
            throw new IllegalArgumentException("Invalid max health for player: " + d);
        }
        if (XMaterial.isNewVersion()) {
            VersionSupportFuture.setMaxHealth(livingEntity, d);
        } else {
            VersionSupportOld.setMaxHealth(livingEntity, d);
        }
    }

    public static boolean isCropFullyGrown(Block block) {
        if (XMaterial.isNewVersion()) {
            return VersionSupportFuture.isCropFullyGrown(block);
        }
        return VersionSupportOld.isCropFullyGrown(block);
    }
}

