/*
 * Decompiled with CFR 0.152.
 */
package org.skills.utils.nbt;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.skills.utils.nbt.NBTType;
import org.skills.utils.xseries.ReflectionUtils;
import org.skills.utils.xseries.XMaterial;

public class NBTWrappers {
    private static Object findNBTData(Object object) {
        try {
            Field field = object.getClass().getDeclaredField("data");
            field.setAccessible(true);
            return field.get(object);
        }
        catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
            reflectiveOperationException.printStackTrace();
            return null;
        }
    }

    public static class NBTTagFloat
    extends INBTNumber<Float> {
        private static final MethodHandle NBT_TAG_LONG_CONSTRUCTOR;

        public NBTTagFloat(float f) {
            super(Float.valueOf(f));
        }

        public static NBTTagFloat fromNBT(Object object) {
            Float f = (Float)NBTWrappers.findNBTData(object);
            return new NBTTagFloat(f == null ? 0.0f : f.floatValue());
        }

        @Override
        public double getAsDouble() {
            return ((Float)this.getValue()).floatValue();
        }

        @Override
        public Object toNBT() {
            try {
                return NBT_TAG_LONG_CONSTRUCTOR.invoke(this.getAsFloat());
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                return null;
            }
        }

        public String toString() {
            return "NBTTagFloat{" + this.value + '}';
        }

        static {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            Class<?> clazz = ReflectionUtils.getNMSClass("NBTTagFloat");
            MethodHandle methodHandle = null;
            try {
                methodHandle = XMaterial.supports(15) ? lookup.findStatic(clazz, "a", MethodType.methodType(clazz, Float.TYPE)) : lookup.findConstructor(clazz, MethodType.methodType(Void.TYPE, Float.TYPE));
            }
            catch (IllegalAccessException | NoSuchMethodException reflectiveOperationException) {
                reflectiveOperationException.printStackTrace();
            }
            NBT_TAG_LONG_CONSTRUCTOR = methodHandle;
        }
    }

    public static class NBTTagLong
    extends INBTNumber<Long> {
        private static final MethodHandle NBT_TAG_LONG_CONSTRUCTOR;

        public NBTTagLong(long l) {
            super(l);
        }

        public static NBTTagLong fromNBT(Object object) {
            Long l = (Long)NBTWrappers.findNBTData(object);
            return new NBTTagLong(l == null ? 0L : l);
        }

        @Override
        public double getAsDouble() {
            return ((Long)this.getValue()).longValue();
        }

        @Override
        public Object toNBT() {
            try {
                return NBT_TAG_LONG_CONSTRUCTOR.invoke(this.getAsLong());
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                return null;
            }
        }

        public String toString() {
            return "NBTTagLong{" + this.value + '}';
        }

        static {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            Class<?> clazz = ReflectionUtils.getNMSClass("NBTTagLong");
            MethodHandle methodHandle = null;
            try {
                methodHandle = XMaterial.supports(15) ? lookup.findStatic(clazz, "a", MethodType.methodType(clazz, Long.TYPE)) : lookup.findConstructor(clazz, MethodType.methodType(Void.TYPE, Long.TYPE));
            }
            catch (IllegalAccessException | NoSuchMethodException reflectiveOperationException) {
                reflectiveOperationException.printStackTrace();
            }
            NBT_TAG_LONG_CONSTRUCTOR = methodHandle;
        }
    }

    public static class NBTTagShort
    extends INBTNumber<Short> {
        private static final MethodHandle NBT_TAG_SHORT_CONSTRUCTOR;

        public NBTTagShort(short s2) {
            super(s2);
        }

        public static NBTTagShort fromNBT(Object object) {
            Short s2 = (Short)NBTWrappers.findNBTData(object);
            return new NBTTagShort(s2 == null ? (short)0 : s2);
        }

        @Override
        public double getAsDouble() {
            return ((Short)this.getValue()).shortValue();
        }

        @Override
        public Object toNBT() {
            try {
                return NBT_TAG_SHORT_CONSTRUCTOR.invoke(this.getAsShort());
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                return null;
            }
        }

        public String toString() {
            return "NBTTagShort{" + this.value + '}';
        }

        static {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            Class<?> clazz = ReflectionUtils.getNMSClass("NBTTagShort");
            MethodHandle methodHandle = null;
            try {
                methodHandle = XMaterial.supports(15) ? lookup.findStatic(clazz, "a", MethodType.methodType(clazz, Short.TYPE)) : lookup.findConstructor(clazz, MethodType.methodType(Void.TYPE, Short.TYPE));
            }
            catch (IllegalAccessException | NoSuchMethodException reflectiveOperationException) {
                reflectiveOperationException.printStackTrace();
            }
            NBT_TAG_SHORT_CONSTRUCTOR = methodHandle;
        }
    }

    public static class NBTTagByteArray
    extends NBTBase<byte[]> {
        private static final MethodHandle NBT_TAG_BYTE_ARRAY_CONSTRUCTOR;

        public NBTTagByteArray(byte[] byArray) {
            super(byArray);
        }

        public static NBTTagByteArray fromNBT(Object object) {
            byte[] byArray = null;
            for (Method method : object.getClass().getMethods()) {
                if (method.getReturnType() != byte[].class) continue;
                try {
                    byArray = (byte[])method.invoke(object, new Object[0]);
                }
                catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
                    reflectiveOperationException.printStackTrace();
                }
            }
            return new NBTTagByteArray(byArray);
        }

        @Override
        public Object toNBT() {
            try {
                return NBT_TAG_BYTE_ARRAY_CONSTRUCTOR.invoke((byte[])this.getValue());
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                return null;
            }
        }

        public String toString() {
            return "NBTTagByteArray{" + Arrays.toString((byte[])this.value) + '}';
        }

        static {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            MethodHandle methodHandle = null;
            try {
                methodHandle = lookup.findConstructor(ReflectionUtils.getNMSClass("NBTTagByteArray"), MethodType.methodType(Void.TYPE, byte[].class));
            }
            catch (IllegalAccessException | NoSuchMethodException reflectiveOperationException) {
                reflectiveOperationException.printStackTrace();
            }
            NBT_TAG_BYTE_ARRAY_CONSTRUCTOR = methodHandle;
        }
    }

    public static class NBTTagByte
    extends INBTNumber<Byte> {
        private static final MethodHandle NBT_TAG_BYTE_CONSTRUCTOR;

        public NBTTagByte(byte by) {
            super(by);
        }

        public static NBTBase<Byte> fromNBT(Object object) {
            Byte by = (Byte)NBTWrappers.findNBTData(object);
            return new NBTTagByte(by == null ? (byte)0 : by);
        }

        @Override
        public double getAsDouble() {
            return ((Byte)this.getValue()).byteValue();
        }

        @Override
        public Object toNBT() {
            try {
                return NBT_TAG_BYTE_CONSTRUCTOR.invoke(this.getAsByte());
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                return null;
            }
        }

        public String toString() {
            return "NBTTagByte{" + this.value + '}';
        }

        static {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            MethodHandle methodHandle = null;
            Class<?> clazz = ReflectionUtils.getNMSClass("NBTTagByte");
            try {
                methodHandle = XMaterial.supports(15) ? lookup.findStatic(clazz, "a", MethodType.methodType(clazz, Byte.TYPE)) : lookup.findConstructor(clazz, MethodType.methodType(Void.TYPE, Byte.TYPE));
            }
            catch (IllegalAccessException | NoSuchMethodException reflectiveOperationException) {
                reflectiveOperationException.printStackTrace();
            }
            NBT_TAG_BYTE_CONSTRUCTOR = methodHandle;
        }
    }

    public static class NBTTagIntArray
    extends NBTBase<int[]> {
        private static final MethodHandle NBT_TAG_INT_ARRAY_CONSTRUCTOR;

        public NBTTagIntArray(int[] nArray) {
            super(nArray);
        }

        public static NBTTagIntArray fromNBT(Object object) {
            int[] nArray = null;
            for (Method method : object.getClass().getMethods()) {
                if (method.getReturnType() != int[].class) continue;
                try {
                    nArray = (int[])method.invoke(object, new Object[0]);
                }
                catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
                    reflectiveOperationException.printStackTrace();
                }
            }
            return new NBTTagIntArray(nArray);
        }

        @Override
        public Object toNBT() {
            try {
                return NBT_TAG_INT_ARRAY_CONSTRUCTOR.invoke((int[])this.getValue());
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                return null;
            }
        }

        public String toString() {
            return "NBTTagIntArray{" + Arrays.toString((int[])this.value) + '}';
        }

        static {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            MethodHandle methodHandle = null;
            try {
                methodHandle = lookup.findConstructor(ReflectionUtils.getNMSClass("NBTTagIntArray"), MethodType.methodType(Void.TYPE, int[].class));
            }
            catch (IllegalAccessException | NoSuchMethodException reflectiveOperationException) {
                reflectiveOperationException.printStackTrace();
            }
            NBT_TAG_INT_ARRAY_CONSTRUCTOR = methodHandle;
        }
    }

    public static class NBTTagInt
    extends INBTNumber<Integer> {
        private static final MethodHandle NBT_TAG_INT_CONSTRUCTOR;

        public NBTTagInt(int n) {
            super(n);
        }

        public static NBTTagInt fromNBT(Object object) {
            Integer n = (Integer)NBTWrappers.findNBTData(object);
            return new NBTTagInt(n == null ? 0 : n);
        }

        @Override
        public double getAsDouble() {
            return ((Integer)this.getValue()).intValue();
        }

        @Override
        public Object toNBT() {
            try {
                return NBT_TAG_INT_CONSTRUCTOR.invoke(this.getAsInt());
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                return null;
            }
        }

        public String toString() {
            return "NBTTagInt{" + this.value + '}';
        }

        static {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            Class<?> clazz = ReflectionUtils.getNMSClass("NBTTagInt");
            MethodHandle methodHandle = null;
            try {
                methodHandle = XMaterial.supports(15) ? lookup.findStatic(clazz, "a", MethodType.methodType(clazz, Integer.TYPE)) : lookup.findConstructor(clazz, MethodType.methodType(Void.TYPE, Integer.TYPE));
            }
            catch (IllegalAccessException | NoSuchMethodException reflectiveOperationException) {
                reflectiveOperationException.printStackTrace();
            }
            NBT_TAG_INT_CONSTRUCTOR = methodHandle;
        }
    }

    public static class NBTTagDouble
    extends INBTNumber<Double> {
        private static final MethodHandle NBT_TAG_DOUBLE_CONSTRUCTOR;

        public NBTTagDouble(double d) {
            super(d);
        }

        public static NBTTagDouble fromNBT(Object object) {
            Double d = (Double)NBTWrappers.findNBTData(object);
            return d == null ? new NBTTagDouble(-1.0) : new NBTTagDouble(d);
        }

        @Override
        public Object toNBT() {
            try {
                return NBT_TAG_DOUBLE_CONSTRUCTOR.invoke(this.getAsDouble());
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                return null;
            }
        }

        public String toString() {
            return "NBTTagDouble{" + this.value + '}';
        }

        @Override
        public double getAsDouble() {
            return (Double)this.getValue();
        }

        static {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            Class<?> clazz = ReflectionUtils.getNMSClass("NBTTagDouble");
            MethodHandle methodHandle = null;
            try {
                methodHandle = XMaterial.supports(15) ? lookup.findStatic(clazz, "a", MethodType.methodType(clazz, Double.TYPE)) : lookup.findConstructor(clazz, MethodType.methodType(Void.TYPE, Double.TYPE));
            }
            catch (IllegalAccessException | NoSuchMethodException reflectiveOperationException) {
                reflectiveOperationException.printStackTrace();
            }
            NBT_TAG_DOUBLE_CONSTRUCTOR = methodHandle;
        }
    }

    public static abstract class INBTNumber<T extends Number>
    extends NBTBase<T> {
        public INBTNumber(T t) {
            super(t);
        }

        public int getAsInt() {
            return (int)Math.floor(this.getAsDouble());
        }

        public long getAsLong() {
            return (long)Math.floor(this.getAsDouble());
        }

        public abstract double getAsDouble();

        public float getAsFloat() {
            return (float)this.getAsDouble();
        }

        public byte getAsByte() {
            return (byte)(this.getAsInt() & 0xFF);
        }

        public short getAsShort() {
            return (short)(this.getAsInt() & 0xFFFF);
        }
    }

    public static class NBTTagList<T>
    extends NBTBase<List<NBTBase<T>>> {
        private static final MethodHandle NBT_TAG_LIST_CONSTRUCTOR;

        public NBTTagList(List<NBTBase<T>> list) {
            super(list);
        }

        public NBTTagList() {
            super(new ArrayList());
        }

        public static NBTTagList<?> fromNBT(Object object) {
            NBTTagList nBTTagList = new NBTTagList();
            List list = null;
            try {
                Field field = object.getClass().getDeclaredField("list");
                field.setAccessible(true);
                list = (List)field.get(object);
            }
            catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
                reflectiveOperationException.printStackTrace();
            }
            if (list == null) {
                return nBTTagList;
            }
            for (Object e : list) {
                nBTTagList.add(NBTBase.fromNBT(e));
            }
            return nBTTagList;
        }

        public boolean add(NBTBase nBTBase) {
            return this.isType(nBTBase.getClass()) && ((List)this.getValue()).add(nBTBase);
        }

        public boolean isType(Class<? extends NBTBase> clazz) {
            return ((List)this.getValue()).isEmpty() || ((NBTBase)((List)this.getValue()).get(0)).getClass() == clazz;
        }

        @Override
        public Object toNBT() {
            Object object = null;
            try {
                object = NBT_TAG_LIST_CONSTRUCTOR.invoke();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            Method method = null;
            try {
                method = XMaterial.supports(14) ? object.getClass().getMethod("add", Integer.TYPE, ReflectionUtils.getNMSClass("NBTBase")) : object.getClass().getMethod("add", ReflectionUtils.getNMSClass("NBTBase"));
            }
            catch (NoSuchMethodException noSuchMethodException) {
                noSuchMethodException.printStackTrace();
            }
            int n = 0;
            for (NBTBase nBTBase : (List)this.getValue()) {
                try {
                    if (XMaterial.supports(14)) {
                        method.invoke(object, n, nBTBase.toNBT());
                    } else {
                        method.invoke(object, nBTBase.toNBT());
                    }
                    ++n;
                }
                catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
                    reflectiveOperationException.printStackTrace();
                }
            }
            return object;
        }

        public String toString() {
            return "NBTTagList{" + Arrays.toString(((List)this.value).toArray()) + '}';
        }

        static {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            MethodHandle methodHandle = null;
            try {
                methodHandle = lookup.findConstructor(ReflectionUtils.getNMSClass("NBTTagList"), MethodType.methodType(Void.TYPE));
            }
            catch (IllegalAccessException | NoSuchMethodException reflectiveOperationException) {
                reflectiveOperationException.printStackTrace();
            }
            NBT_TAG_LIST_CONSTRUCTOR = methodHandle;
        }
    }

    public static class NBTTagCompound
    extends NBTBase<Map<String, NBTBase<?>>> {
        private static final MethodHandle NBT_TAG_COMPOUND_CONSTRUCTOR;
        private static final MethodHandle SET_TAG_METHOD;
        private static final MethodHandle GET_COMPOUND_MAP;

        public NBTTagCompound(Map<String, NBTBase<?>> map) {
            super(map);
        }

        public NBTTagCompound() {
            this(new HashMap());
        }

        public static NBTTagCompound fromNBT(Object object) {
            Map map = null;
            try {
                map = GET_COMPOUND_MAP.invoke(object);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            NBTTagCompound nBTTagCompound = new NBTTagCompound();
            for (Map.Entry entry : map.entrySet()) {
                NBTBase<?> nBTBase = NBTBase.fromNBT(entry.getValue());
                if (nBTBase == null) continue;
                nBTTagCompound.set((String)entry.getKey(), nBTBase);
            }
            return nBTTagCompound;
        }

        public <T> void set(String string, NBTType<T> nBTType, T t) {
            NBTBase nBTBase = null;
            if (nBTType == NBTType.STRING) {
                nBTBase = new NBTTagString((String)t);
            } else if (nBTType == NBTType.BYTE) {
                nBTBase = new NBTTagByte((Byte)t);
            } else if (nBTType == NBTType.BOOLEAN) {
                nBTBase = new NBTTagByte((byte)((Boolean)t != false ? 1 : 0));
            } else if (nBTType == NBTType.SHORT) {
                nBTBase = new NBTTagShort((Short)t);
            } else if (nBTType == NBTType.INTEGER) {
                nBTBase = new NBTTagInt((Integer)t);
            } else if (nBTType == NBTType.LONG) {
                nBTBase = new NBTTagLong((Long)t);
            } else if (nBTType == NBTType.FLOAT) {
                nBTBase = new NBTTagFloat(((Float)t).floatValue());
            } else if (nBTType == NBTType.DOUBLE) {
                nBTBase = new NBTTagDouble((Double)t);
            } else if (nBTType == NBTType.BYTE_ARRAY) {
                nBTBase = new NBTTagByteArray((byte[])t);
            } else if (nBTType == NBTType.INTEGER_ARRAY) {
                nBTBase = new NBTTagIntArray((int[])t);
            } else if (nBTType == NBTType.LONG_ARRAY) {
                nBTBase = new NBTTagLong((Long)t);
            } else if (nBTType == NBTType.TAG_CONTAINER) {
                nBTBase = (NBTTagCompound)t;
            }
            ((Map)this.getValue()).put(string, nBTBase);
        }

        public <T> T get(String string, NBTType<T> nBTType) {
            NBTBase nBTBase = (NBTBase)((Map)this.getValue()).get(string);
            if (nBTBase == null) {
                return null;
            }
            return nBTBase.value;
        }

        public void set(String string, NBTBase<?> nBTBase) {
            ((Map)this.getValue()).put(string, nBTBase);
        }

        public void setByte(String string, byte by) {
            ((Map)this.getValue()).put(string, new NBTTagByte(by));
        }

        public void setShort(String string, short s2) {
            ((Map)this.getValue()).put(string, new NBTTagShort(s2));
        }

        public void setInt(String string, int n) {
            ((Map)this.getValue()).put(string, new NBTTagInt(n));
        }

        public void setLong(String string, long l) {
            ((Map)this.getValue()).put(string, new NBTTagLong(l));
        }

        public void setFloat(String string, float f) {
            ((Map)this.getValue()).put(string, new NBTTagFloat(f));
        }

        public void setDouble(String string, double d) {
            ((Map)this.getValue()).put(string, new NBTTagDouble(d));
        }

        public void setString(String string, String string2) {
            ((Map)this.getValue()).put(string, new NBTTagString(string2));
        }

        public void setCompound(String string, NBTTagCompound nBTTagCompound) {
            ((Map)this.getValue()).put(string, nBTTagCompound);
        }

        public void setByteArray(String string, byte[] byArray) {
            ((Map)this.getValue()).put(string, new NBTTagByteArray(byArray));
        }

        public void setIntArray(String string, int[] nArray) {
            ((Map)this.getValue()).put(string, new NBTTagIntArray(nArray));
        }

        public void setBoolean(String string, boolean bl) {
            this.setByte(string, (byte)(bl ? 1 : 0));
        }

        public NBTBase<?> get(String string) {
            return (NBTBase)((Map)this.value).get(string);
        }

        public byte getByte(String string) {
            NBTBase<?> nBTBase = this.get(string);
            if (!(nBTBase instanceof NBTTagByte)) {
                return 0;
            }
            return ((NBTTagByte)nBTBase).getAsByte();
        }

        public short getShort(String string) {
            NBTBase<?> nBTBase = this.get(string);
            if (!(nBTBase instanceof NBTTagShort)) {
                return 0;
            }
            return ((NBTTagShort)nBTBase).getAsShort();
        }

        public int getInt(String string) {
            NBTBase<?> nBTBase = this.get(string);
            if (!(nBTBase instanceof NBTTagInt)) {
                return 0;
            }
            return ((NBTTagInt)nBTBase).getAsShort();
        }

        public long getLong(String string) {
            NBTBase<?> nBTBase = this.get(string);
            if (!(nBTBase instanceof NBTTagLong)) {
                return 0L;
            }
            return ((NBTTagLong)nBTBase).getAsLong();
        }

        public NBTTagCompound getCompound(String string) {
            NBTBase<?> nBTBase = this.get(string);
            if (!(nBTBase instanceof NBTTagCompound)) {
                return null;
            }
            return (NBTTagCompound)nBTBase;
        }

        public float getFloat(String string) {
            NBTBase<?> nBTBase = this.get(string);
            if (!(nBTBase instanceof NBTTagFloat)) {
                return 0.0f;
            }
            return ((NBTTagFloat)nBTBase).getAsFloat();
        }

        public double getDouble(String string) {
            NBTBase<?> nBTBase = this.get(string);
            if (!(nBTBase instanceof NBTTagDouble)) {
                return 0.0;
            }
            return ((NBTTagDouble)nBTBase).getAsDouble();
        }

        public String getString(String string) {
            NBTBase<?> nBTBase = this.get(string);
            if (!(nBTBase instanceof NBTTagString)) {
                return null;
            }
            return (String)((NBTTagString)nBTBase).getValue();
        }

        public byte[] getByteArray(String string) {
            NBTBase<?> nBTBase = this.get(string);
            if (!(nBTBase instanceof NBTTagByteArray)) {
                return null;
            }
            return (byte[])((NBTTagByteArray)nBTBase).getValue();
        }

        public int[] getIntArray(String string) {
            NBTBase<?> nBTBase = this.get(string);
            if (!(nBTBase instanceof NBTTagIntArray)) {
                return null;
            }
            return (int[])((NBTTagIntArray)nBTBase).getValue();
        }

        public boolean getBoolean(String string) {
            return this.getByte(string) != 0;
        }

        @Override
        public Object toNBT() {
            Object object = null;
            try {
                object = NBT_TAG_COMPOUND_CONSTRUCTOR.invoke();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            for (Map.Entry entry : ((Map)this.getValue()).entrySet()) {
                try {
                    SET_TAG_METHOD.invoke(object, (String)entry.getKey(), ((NBTBase)entry.getValue()).toNBT());
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
            return object;
        }

        public String toString() {
            return "NBTTagCompound{" + this.value + '}';
        }

        static {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            Class<?> clazz = ReflectionUtils.getNMSClass("NBTTagCompound");
            Class<?> clazz2 = ReflectionUtils.getNMSClass("NBTBase");
            MethodHandle methodHandle = null;
            MethodHandle methodHandle2 = null;
            MethodHandle methodHandle3 = null;
            try {
                methodHandle = lookup.findConstructor(clazz, MethodType.methodType(Void.TYPE));
                methodHandle2 = XMaterial.supports(14) ? lookup.findVirtual(clazz, "set", MethodType.methodType(clazz2, String.class, clazz2)) : lookup.findVirtual(clazz, "set", MethodType.methodType(Void.TYPE, String.class, clazz2));
                Field field = clazz.getDeclaredField("map");
                field.setAccessible(true);
                methodHandle3 = lookup.unreflectGetter(field);
            }
            catch (IllegalAccessException | NoSuchFieldException | NoSuchMethodException reflectiveOperationException) {
                reflectiveOperationException.printStackTrace();
            }
            NBT_TAG_COMPOUND_CONSTRUCTOR = methodHandle;
            SET_TAG_METHOD = methodHandle2;
            GET_COMPOUND_MAP = methodHandle3;
        }
    }

    public static class NBTTagString
    extends NBTBase<String> {
        private static final MethodHandle NBT_TAG_STRING_CONSTRUCTOR;

        public NBTTagString(String string) {
            super(string);
        }

        public static NBTBase<String> fromNBT(Object object) {
            return new NBTTagString((String)NBTWrappers.findNBTData(object));
        }

        @Override
        public Object toNBT() {
            try {
                return NBT_TAG_STRING_CONSTRUCTOR.invoke((String)this.getValue());
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                return null;
            }
        }

        public String toString() {
            return "NBTTagString{" + (String)this.value + '}';
        }

        static {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            Class<?> clazz = ReflectionUtils.getNMSClass("NBTTagString");
            MethodHandle methodHandle = null;
            try {
                methodHandle = XMaterial.supports(15) ? lookup.findStatic(clazz, "a", MethodType.methodType(clazz, String.class)) : lookup.findConstructor(clazz, MethodType.methodType(Void.TYPE, String.class));
            }
            catch (IllegalAccessException | NoSuchMethodException reflectiveOperationException) {
                reflectiveOperationException.printStackTrace();
            }
            NBT_TAG_STRING_CONSTRUCTOR = methodHandle;
        }
    }

    public static abstract class NBTBase<T> {
        protected final T value;

        public NBTBase(T t) {
            this.value = t;
        }

        public static NBTBase<?> fromNBT(Object object) {
            switch (object.getClass().getSimpleName()) {
                case "NBTTagCompound": {
                    return NBTTagCompound.fromNBT(object);
                }
                case "NBTTagString": {
                    return NBTTagString.fromNBT(object);
                }
                case "NBTTagByte": {
                    return NBTTagByte.fromNBT(object);
                }
                case "NBTTagShort": {
                    return NBTTagShort.fromNBT(object);
                }
                case "NBTTagInt": {
                    return NBTTagInt.fromNBT(object);
                }
                case "NBTTagLong": {
                    return NBTTagLong.fromNBT(object);
                }
                case "NBTTagFloat": {
                    return NBTTagFloat.fromNBT(object);
                }
                case "NBTTagDouble": {
                    return NBTTagDouble.fromNBT(object);
                }
                case "NBTTagByteArray": {
                    return NBTTagByteArray.fromNBT(object);
                }
                case "NBTTagIntArray": {
                    return NBTTagIntArray.fromNBT(object);
                }
                case "NBTTagList": {
                    return NBTTagList.fromNBT(object);
                }
            }
            return null;
        }

        public T getValue() {
            return this.value;
        }

        abstract Object toNBT();
    }
}

