/*
 * Decompiled with CFR 0.152.
 */
package org.skills.utils.nbt;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.skills.utils.nbt.NBTType;
import org.skills.utils.nbt.NBTWrappers;
import org.skills.utils.xseries.ReflectionUtils;
import org.skills.utils.xseries.XMaterial;

public class ItemNBT {
    public static final boolean CAN_ACCESS_UNBREAKABLE;
    private static final MethodHandle AS_NMS_COPY;
    private static final MethodHandle AS_BUKKIT_COPY;
    private static final MethodHandle SET_TAG;
    private static final MethodHandle GET_TAG;

    public static ItemStack addSimpleTag(ItemStack itemStack, String string, String string2) {
        NBTWrappers.NBTTagCompound nBTTagCompound = ItemNBT.getTag(itemStack);
        nBTTagCompound.setString(string, string2);
        return ItemNBT.setTag(itemStack, nBTTagCompound);
    }

    private static Object asNMSCopy(ItemStack itemStack) {
        try {
            return AS_NMS_COPY.invoke(itemStack);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    private static ItemStack asBukkitCopy(Object object) {
        try {
            return AS_BUKKIT_COPY.invoke(object);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    public static ItemStack setTag(ItemStack itemStack, NBTWrappers.NBTTagCompound nBTTagCompound) {
        Object object = nBTTagCompound.toNBT();
        Object object2 = ItemNBT.asNMSCopy(itemStack);
        try {
            SET_TAG.invoke(object2, object);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return ItemNBT.asBukkitCopy(object2);
    }

    public static NBTWrappers.NBTTagCompound getTag(ItemStack itemStack) {
        Object object;
        if (XMaterial.isNewVersion()) {
            object = itemStack.getItemMeta();
            if (XMaterial.supports(14)) {
                // empty if block
            }
        }
        object = ItemNBT.asNMSCopy(itemStack);
        Object object2 = null;
        try {
            object2 = GET_TAG.invoke(object);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        if (object2 == null) {
            return new NBTWrappers.NBTTagCompound();
        }
        NBTWrappers.NBTBase<?> nBTBase = NBTWrappers.NBTBase.fromNBT(object2);
        if (nBTBase == null || nBTBase.getClass() != NBTWrappers.NBTTagCompound.class) {
            return new NBTWrappers.NBTTagCompound();
        }
        return (NBTWrappers.NBTTagCompound)nBTBase;
    }

    public static ItemStack setUnbreakable(ItemStack itemStack, boolean bl) {
        if (CAN_ACCESS_UNBREAKABLE) {
            ItemMeta itemMeta = itemStack.getItemMeta();
            itemMeta.setUnbreakable(bl);
            itemStack.setItemMeta(itemMeta);
            return itemStack;
        }
        NBTWrappers.NBTTagCompound nBTTagCompound = ItemNBT.getTag(itemStack);
        nBTTagCompound.set("Unbreakable", NBTType.BOOLEAN, bl);
        return ItemNBT.setTag(itemStack, nBTTagCompound);
    }

    protected static ItemStack setAttributes(ItemStack itemStack, boolean bl) {
        if (XMaterial.supports(9)) {
            ItemMeta itemMeta = itemStack.getItemMeta();
            itemMeta.addAttributeModifier(Attribute.GENERIC_MAX_HEALTH, new AttributeModifier("34", 343.0, AttributeModifier.Operation.ADD_NUMBER));
            itemStack.setItemMeta(itemMeta);
            return itemStack;
        }
        NBTWrappers.NBTTagCompound nBTTagCompound = ItemNBT.getTag(itemStack);
        NBTWrappers.NBTTagList nBTTagList = new NBTWrappers.NBTTagList();
        NBTWrappers.NBTTagCompound nBTTagCompound2 = new NBTWrappers.NBTTagCompound();
        UUID uUID = UUID.randomUUID();
        nBTTagCompound2.set("AttributeName", NBTType.STRING, "generic.attackSpeed");
        nBTTagCompound2.set("Name", NBTType.STRING, "generic.attackSpeed");
        nBTTagCompound2.set("Amount", NBTType.INTEGER, 34);
        nBTTagCompound2.set("Operation", NBTType.INTEGER, 3);
        nBTTagCompound2.set("UUIDLeast", NBTType.INTEGER, (int)uUID.getLeastSignificantBits());
        nBTTagCompound2.set("UUIDMost", NBTType.INTEGER, (int)uUID.getMostSignificantBits());
        nBTTagCompound2.set("Slot", NBTType.STRING, EquipmentSlot.OFF_HAND.name().toLowerCase().replace("_", ""));
        nBTTagList.add(nBTTagCompound2);
        nBTTagCompound.set("AttributeModifiers", nBTTagList);
        return ItemNBT.setTag(itemStack, nBTTagCompound);
    }

    static {
        String string = XMaterial.getMajorVersion(Bukkit.getVersion());
        CAN_ACCESS_UNBREAKABLE = string.startsWith("1.1") && Integer.parseInt(string.substring(3, 4)) != 0;
        MethodHandle methodHandle = null;
        MethodHandle methodHandle2 = null;
        MethodHandle methodHandle3 = null;
        MethodHandle methodHandle4 = null;
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        Class<?> clazz = ReflectionUtils.getCraftClass("inventory.CraftItemStack");
        Class<?> clazz2 = ReflectionUtils.getNMSClass("ItemStack");
        Class<?> clazz3 = ReflectionUtils.getNMSClass("NBTTagCompound");
        Class<?> clazz4 = ReflectionUtils.getNMSClass("NBTBase");
        try {
            methodHandle = lookup.findStatic(clazz, "asNMSCopy", MethodType.methodType(clazz2, ItemStack.class));
            methodHandle2 = lookup.findStatic(clazz, "asBukkitCopy", MethodType.methodType(ItemStack.class, clazz2));
            methodHandle3 = lookup.findVirtual(clazz2, "setTag", MethodType.methodType(Void.TYPE, clazz3));
            methodHandle4 = lookup.findVirtual(clazz2, "getTag", MethodType.methodType(clazz3));
        }
        catch (IllegalAccessException | NoSuchMethodException reflectiveOperationException) {
            reflectiveOperationException.printStackTrace();
        }
        AS_NMS_COPY = methodHandle;
        AS_BUKKIT_COPY = methodHandle2;
        SET_TAG = methodHandle3;
        GET_TAG = methodHandle4;
    }
}

