/*
 * Decompiled with CFR 0.152.
 */
package org.skills.utils.caffeine.checkerframework.checker.signedness;

import java.io.RandomAccessFile;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.skills.utils.caffeine.checkerframework.checker.signedness.qual.Unsigned;

public final class SignednessUtil {
    private SignednessUtil() {
        throw new Error("Do not instantiate");
    }

    public static ByteBuffer wrapUnsigned(@Unsigned byte[] byArray) {
        return ByteBuffer.wrap(byArray);
    }

    public static ByteBuffer wrapUnsigned(@Unsigned byte[] byArray, int n, int n2) {
        return ByteBuffer.wrap(byArray, n, n2);
    }

    public static @Unsigned int getUnsignedInt(ByteBuffer byteBuffer) {
        return byteBuffer.getInt();
    }

    public static @Unsigned short getUnsignedShort(ByteBuffer byteBuffer) {
        return byteBuffer.getShort();
    }

    public static @Unsigned byte getUnsigned(ByteBuffer byteBuffer) {
        return byteBuffer.get();
    }

    public static @Unsigned byte getUnsigned(ByteBuffer byteBuffer, int n) {
        return byteBuffer.get(n);
    }

    public static ByteBuffer getUnsigned(ByteBuffer byteBuffer, byte[] byArray, int n, int n2) {
        return byteBuffer.get(byArray, n, n2);
    }

    public static ByteBuffer putUnsigned(ByteBuffer byteBuffer, @Unsigned byte by) {
        return byteBuffer.put(by);
    }

    public static ByteBuffer putUnsigned(ByteBuffer byteBuffer, int n, @Unsigned byte by) {
        return byteBuffer.put(n, by);
    }

    public static IntBuffer putUnsigned(IntBuffer intBuffer, @Unsigned int n) {
        return intBuffer.put(n);
    }

    public static IntBuffer putUnsigned(IntBuffer intBuffer, int n, @Unsigned int n2) {
        return intBuffer.put(n, n2);
    }

    public static IntBuffer putUnsigned(IntBuffer intBuffer, @Unsigned int[] nArray) {
        return intBuffer.put(nArray);
    }

    public static IntBuffer putUnsigned(IntBuffer intBuffer, @Unsigned int[] nArray, int n, int n2) {
        return intBuffer.put(nArray, n, n2);
    }

    public static @Unsigned int getUnsigned(IntBuffer intBuffer, int n) {
        return intBuffer.get(n);
    }

    public static ByteBuffer putUnsignedShort(ByteBuffer byteBuffer, @Unsigned short s2) {
        return byteBuffer.putShort(s2);
    }

    public static ByteBuffer putUnsignedShort(ByteBuffer byteBuffer, int n, @Unsigned short s2) {
        return byteBuffer.putShort(n, s2);
    }

    public static ByteBuffer putUnsignedInt(ByteBuffer byteBuffer, @Unsigned int n) {
        return byteBuffer.putInt(n);
    }

    public static ByteBuffer putUnsignedInt(ByteBuffer byteBuffer, int n, @Unsigned int n2) {
        return byteBuffer.putInt(n, n2);
    }

    public static ByteBuffer putUnsignedLong(ByteBuffer byteBuffer, int n, @Unsigned long l) {
        return byteBuffer.putLong(n, l);
    }

    public static @Unsigned char readUnsignedChar(RandomAccessFile randomAccessFile) {
        return randomAccessFile.readChar();
    }

    public static @Unsigned int readUnsignedInt(RandomAccessFile randomAccessFile) {
        return randomAccessFile.readInt();
    }

    public static @Unsigned long readUnsignedLong(RandomAccessFile randomAccessFile) {
        return randomAccessFile.readLong();
    }

    public static int readUnsigned(RandomAccessFile randomAccessFile, @Unsigned byte[] byArray, int n, int n2) {
        return randomAccessFile.read(byArray, n, n2);
    }

    public static void readFullyUnsigned(RandomAccessFile randomAccessFile, @Unsigned byte[] byArray) {
        randomAccessFile.readFully(byArray);
    }

    public static void writeUnsigned(RandomAccessFile randomAccessFile, @Unsigned byte[] byArray, int n, int n2) {
        randomAccessFile.write(byArray, n, n2);
    }

    public static void writeUnsignedByte(RandomAccessFile randomAccessFile, @Unsigned byte by) {
        randomAccessFile.writeByte(Byte.toUnsignedInt(by));
    }

    public static void writeUnsignedChar(RandomAccessFile randomAccessFile, @Unsigned char c) {
        randomAccessFile.writeChar(SignednessUtil.toUnsignedInt(c));
    }

    public static void writeUnsignedShort(RandomAccessFile randomAccessFile, @Unsigned short s2) {
        randomAccessFile.writeShort(Short.toUnsignedInt(s2));
    }

    public static void writeUnsignedInt(RandomAccessFile randomAccessFile, @Unsigned int n) {
        randomAccessFile.writeInt(n);
    }

    public static void writeUnsignedLong(RandomAccessFile randomAccessFile, @Unsigned long l) {
        randomAccessFile.writeLong(l);
    }

    public static void getUnsigned(ByteBuffer byteBuffer, @Unsigned byte[] byArray) {
        byteBuffer.get(byArray);
    }

    public static int compareUnsigned(@Unsigned short s2, @Unsigned short s3) {
        return Integer.compareUnsigned(Short.toUnsignedInt(s2), Short.toUnsignedInt(s3));
    }

    public static int compareUnsigned(@Unsigned byte by, @Unsigned byte by2) {
        return Integer.compareUnsigned(Byte.toUnsignedInt(by), Byte.toUnsignedInt(by2));
    }

    public static String toUnsignedString(@Unsigned short s2) {
        return Long.toString(Short.toUnsignedLong(s2));
    }

    public static String toUnsignedString(@Unsigned short s2, int n) {
        return Integer.toUnsignedString(Short.toUnsignedInt(s2), n);
    }

    public static String toUnsignedString(@Unsigned byte by) {
        return Integer.toUnsignedString(Byte.toUnsignedInt(by));
    }

    public static String toUnsignedString(@Unsigned byte by, int n) {
        return Integer.toUnsignedString(Byte.toUnsignedInt(by), n);
    }

    private static @Unsigned BigInteger toUnsignedBigInteger(@Unsigned long l) {
        if (l >= 0L) {
            return BigInteger.valueOf(l);
        }
        int n = (int)(l >>> 32);
        int n2 = (int)l;
        return BigInteger.valueOf(Integer.toUnsignedLong(n)).shiftLeft(32).add(BigInteger.valueOf(Integer.toUnsignedLong(n2)));
    }

    public static @Unsigned short toUnsignedShort(@Unsigned byte by) {
        return (short)(by & 0xFF);
    }

    public static @Unsigned long toUnsignedLong(@Unsigned char c) {
        return (long)c & 0xFFL;
    }

    public static @Unsigned int toUnsignedInt(@Unsigned char c) {
        return c & 0xFF;
    }

    public static @Unsigned short toUnsignedShort(@Unsigned char c) {
        return (short)(c & 0xFF);
    }

    public static float toFloat(@Unsigned byte by) {
        return SignednessUtil.toUnsignedBigInteger(Byte.toUnsignedLong(by)).floatValue();
    }

    public static float toFloat(@Unsigned short s2) {
        return SignednessUtil.toUnsignedBigInteger(Short.toUnsignedLong(s2)).floatValue();
    }

    public static float toFloat(@Unsigned int n) {
        return SignednessUtil.toUnsignedBigInteger(Integer.toUnsignedLong(n)).floatValue();
    }

    public static float toFloat(@Unsigned long l) {
        return SignednessUtil.toUnsignedBigInteger(l).floatValue();
    }

    public static double toDouble(@Unsigned byte by) {
        return SignednessUtil.toUnsignedBigInteger(Byte.toUnsignedLong(by)).doubleValue();
    }

    public static double toDouble(@Unsigned short s2) {
        return SignednessUtil.toUnsignedBigInteger(Short.toUnsignedLong(s2)).doubleValue();
    }

    public static double toDouble(@Unsigned int n) {
        return SignednessUtil.toUnsignedBigInteger(Integer.toUnsignedLong(n)).doubleValue();
    }

    public static double toDouble(@Unsigned long l) {
        return SignednessUtil.toUnsignedBigInteger(l).doubleValue();
    }

    public static @Unsigned byte byteFromFloat(float f) {
        assert (f >= 0.0f);
        return (byte)f;
    }

    public static @Unsigned short shortFromFloat(float f) {
        assert (f >= 0.0f);
        return (short)f;
    }

    public static @Unsigned int intFromFloat(float f) {
        assert (f >= 0.0f);
        return (int)f;
    }

    public static @Unsigned long longFromFloat(float f) {
        assert (f >= 0.0f);
        return (long)f;
    }

    public static @Unsigned byte byteFromDouble(double d) {
        assert (d >= 0.0);
        return (byte)d;
    }

    public static @Unsigned short shortFromDouble(double d) {
        assert (d >= 0.0);
        return (short)d;
    }

    public static @Unsigned int intFromDouble(double d) {
        assert (d >= 0.0);
        return (int)d;
    }

    public static @Unsigned long longFromDouble(double d) {
        assert (d >= 0.0);
        return (long)d;
    }
}

