/*
 * Decompiled with CFR 0.152.
 */
package org.skills.utils.caffeine.checkerframework.checker.regex;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.skills.utils.caffeine.checkerframework.checker.index.qual.GTENegativeOne;
import org.skills.utils.caffeine.checkerframework.checker.lock.qual.GuardSatisfied;
import org.skills.utils.caffeine.checkerframework.checker.nullness.qual.Nullable;
import org.skills.utils.caffeine.checkerframework.checker.regex.qual.Regex;
import org.skills.utils.caffeine.checkerframework.dataflow.qual.Pure;
import org.skills.utils.caffeine.checkerframework.dataflow.qual.SideEffectFree;
import org.skills.utils.caffeine.checkerframework.framework.qual.EnsuresQualifierIf;

public final class RegexUtil {
    private RegexUtil() {
        throw new Error("do not instantiate");
    }

    @Pure
    @EnsuresQualifierIf(result=true, expression={"#1"}, qualifier=Regex.class)
    public static boolean isRegex(String string) {
        return RegexUtil.isRegex(string, 0);
    }

    @Pure
    @EnsuresQualifierIf(result=true, expression={"#1"}, qualifier=Regex.class)
    public static boolean isRegex(String string, int n) {
        Pattern pattern;
        try {
            pattern = Pattern.compile(string);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            return false;
        }
        return RegexUtil.getGroupCount(pattern) >= n;
    }

    @Pure
    @EnsuresQualifierIf(result=true, expression={"#1"}, qualifier=Regex.class)
    public static boolean isRegex(char c) {
        return RegexUtil.isRegex(Character.toString(c));
    }

    @SideEffectFree
    public static @Nullable String regexError(String string) {
        return RegexUtil.regexError(string, 0);
    }

    @SideEffectFree
    public static @Nullable String regexError(String string, int n) {
        try {
            Pattern pattern = Pattern.compile(string);
            int n2 = RegexUtil.getGroupCount(pattern);
            if (n2 < n) {
                return RegexUtil.regexErrorMessage(string, n, n2);
            }
        }
        catch (PatternSyntaxException patternSyntaxException) {
            return patternSyntaxException.getMessage();
        }
        return null;
    }

    @SideEffectFree
    public static @Nullable PatternSyntaxException regexException(String string) {
        return RegexUtil.regexException(string, 0);
    }

    @SideEffectFree
    public static @Nullable PatternSyntaxException regexException(String string, int n) {
        try {
            Pattern pattern = Pattern.compile(string);
            int n2 = RegexUtil.getGroupCount(pattern);
            if (n2 < n) {
                return new PatternSyntaxException(RegexUtil.regexErrorMessage(string, n, n2), string, -1);
            }
        }
        catch (PatternSyntaxException patternSyntaxException) {
            return patternSyntaxException;
        }
        return null;
    }

    @SideEffectFree
    public static @Regex String asRegex(String string) {
        return RegexUtil.asRegex(string, 0);
    }

    @SideEffectFree
    public static @Regex String asRegex(String string, int n) {
        try {
            Pattern pattern = Pattern.compile(string);
            int n2 = RegexUtil.getGroupCount(pattern);
            if (n2 < n) {
                throw new Error(RegexUtil.regexErrorMessage(string, n, n2));
            }
            return string;
        }
        catch (PatternSyntaxException patternSyntaxException) {
            throw new Error(patternSyntaxException);
        }
    }

    @SideEffectFree
    private static String regexErrorMessage(String string, int n, int n2) {
        return "regex \"" + string + "\" has " + n2 + " groups, but " + n + " groups are needed.";
    }

    @Pure
    private static int getGroupCount(Pattern pattern) {
        return pattern.matcher("").groupCount();
    }

    public static class CheckedPatternSyntaxException
    extends Exception {
        private static final long serialVersionUID = 6266881831979001480L;
        private final PatternSyntaxException pse;

        public CheckedPatternSyntaxException(PatternSyntaxException patternSyntaxException) {
            this.pse = patternSyntaxException;
        }

        public CheckedPatternSyntaxException(String string, String string2, @GTENegativeOne int n) {
            this(new PatternSyntaxException(string, string2, n));
        }

        public String getDescription() {
            return this.pse.getDescription();
        }

        public int getIndex() {
            return this.pse.getIndex();
        }

        @Override
        @Pure
        public String getMessage(@GuardSatisfied CheckedPatternSyntaxException this) {
            return this.pse.getMessage();
        }

        public String getPattern() {
            return this.pse.getPattern();
        }
    }
}

