/*
 * Decompiled with CFR 0.152.
 */
package org.skills.utils.caffeine.checkerframework.checker.nullness;

import java.util.NoSuchElementException;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.skills.utils.caffeine.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.skills.utils.caffeine.checkerframework.checker.nullness.qual.NonNull;
import org.skills.utils.caffeine.checkerframework.checker.nullness.qual.Nullable;

public final class Opt {
    private Opt() {
        throw new AssertionError((Object)"shouldn't be instantiated");
    }

    public static <T> T get(T t) {
        if (t == null) {
            throw new NoSuchElementException("No value present");
        }
        return t;
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    public static boolean isPresent(@Nullable Object object) {
        return object != null;
    }

    public static <T> void ifPresent(T t, Consumer<@NonNull ? super @NonNull T> consumer) {
        if (t != null) {
            consumer.accept(t);
        }
    }

    public static <T> @Nullable T filter(T t, Predicate<@NonNull ? super @NonNull T> predicate) {
        if (t == null) {
            return null;
        }
        return (T)(predicate.test(t) ? t : null);
    }

    public static <T, U> @Nullable U map(T t, Function<@NonNull ? super @NonNull T, ? extends U> function) {
        if (t == null) {
            return null;
        }
        return function.apply(t);
    }

    public static <T> @NonNull T orElse(T t, @NonNull T t2) {
        return t != null ? t : t2;
    }

    public static <T> @NonNull T orElseGet(T t, Supplier<? extends @NonNull T> supplier) {
        return t != null ? t : supplier.get();
    }

    public static <T, X extends Throwable> T orElseThrow(T t, Supplier<? extends X> supplier) {
        if (t != null) {
            return t;
        }
        throw (Throwable)supplier.get();
    }
}

