/*
 * Decompiled with CFR 0.152.
 */
package org.skills.utils.caffeine.checkerframework.checker.nullness;

import org.skills.utils.caffeine.checkerframework.checker.nullness.qual.EnsuresNonNull;
import org.skills.utils.caffeine.checkerframework.checker.nullness.qual.NonNull;
import org.skills.utils.caffeine.checkerframework.checker.nullness.qual.Nullable;

public final class NullnessUtil {
    private NullnessUtil() {
        throw new AssertionError((Object)"shouldn't be instantiated");
    }

    @EnsuresNonNull(value={"#1"})
    public static <T> @NonNull T castNonNull(@Nullable T t) {
        assert (t != null) : "Misuse of castNonNull: called with a null argument";
        return t;
    }

    @EnsuresNonNull(value={"#1"})
    public static <T> @NonNull T castNonNull(@Nullable T t, String string) {
        assert (t != null) : "Misuse of castNonNull: called with a null argument: " + string;
        return t;
    }

    @EnsuresNonNull(value={"#1"})
    public static <T> @NonNull T @NonNull [] castNonNullDeep(T @Nullable [] TArray) {
        return NullnessUtil.castNonNullArray(TArray, null);
    }

    @EnsuresNonNull(value={"#1"})
    public static <T> @NonNull T @NonNull [] castNonNullDeep(T @Nullable [] TArray, String string) {
        return NullnessUtil.castNonNullArray(TArray, string);
    }

    @EnsuresNonNull(value={"#1"})
    public static <T> @NonNull T @NonNull [][] castNonNullDeep(T @Nullable [] @Nullable [] TArray) {
        return (Object[][])NullnessUtil.castNonNullArray(TArray, null);
    }

    @EnsuresNonNull(value={"#1"})
    public static <T> @NonNull T @NonNull [][] castNonNullDeep(T @Nullable [] @Nullable [] TArray, String string) {
        return (Object[][])NullnessUtil.castNonNullArray(TArray, string);
    }

    @EnsuresNonNull(value={"#1"})
    public static <T> @NonNull T @NonNull [][][] castNonNullDeep(T @Nullable [] @Nullable [] @Nullable [] TArray) {
        return (Object[][][])NullnessUtil.castNonNullArray(TArray, null);
    }

    @EnsuresNonNull(value={"#1"})
    public static <T> @NonNull T @NonNull [][][] castNonNullDeep(T @Nullable [] @Nullable [] @Nullable [] TArray, String string) {
        return (Object[][][])NullnessUtil.castNonNullArray(TArray, string);
    }

    @EnsuresNonNull(value={"#1"})
    public static <T> @NonNull T @NonNull [][][][] castNonNullDeep(T @Nullable [] @Nullable [] @Nullable [] @Nullable [] TArray) {
        return (Object[][][][])NullnessUtil.castNonNullArray(TArray, null);
    }

    @EnsuresNonNull(value={"#1"})
    public static <T> @NonNull T @NonNull [][][][] castNonNullDeep(T @Nullable [] @Nullable [] @Nullable [] @Nullable [] TArray, String string) {
        return (Object[][][][])NullnessUtil.castNonNullArray(TArray, string);
    }

    @EnsuresNonNull(value={"#1"})
    public static <T> @NonNull T @NonNull [][][][][] castNonNullDeep(T @Nullable [] @Nullable [] @Nullable [] @Nullable [] @Nullable [] TArray) {
        return (Object[][][][][])NullnessUtil.castNonNullArray(TArray, null);
    }

    @EnsuresNonNull(value={"#1"})
    public static <T> @NonNull T @NonNull [][][][][] castNonNullDeep(T @Nullable [] @Nullable [] @Nullable [] @Nullable [] @Nullable [] TArray, String string) {
        return (Object[][][][][])NullnessUtil.castNonNullArray(TArray, string);
    }

    private static <T> @NonNull T @NonNull [] castNonNullArray(T @Nullable [] TArray, @Nullable String string) {
        assert (TArray != null) : "Misuse of castNonNullArray: called with a null array argument" + (string == null ? "" : ": " + string);
        for (int i = 0; i < TArray.length; ++i) {
            assert (TArray[i] != null) : "Misuse of castNonNull: called with a null array element" + (string == null ? "" : ": " + string);
            NullnessUtil.checkIfArray(TArray[i], string);
        }
        return TArray;
    }

    private static void checkIfArray(@NonNull Object object, @Nullable String string) {
        assert (object != null) : "Misuse of checkIfArray: called with a null argument" + (string == null ? "" : ": " + string);
        Class<?> clazz = object.getClass().getComponentType();
        if (clazz != null && !clazz.isPrimitive()) {
            NullnessUtil.castNonNullArray((Object[])object, string);
        }
    }
}

