/*
 * Decompiled with CFR 0.152.
 */
package org.skills.utils.caffeine.checkerframework.checker.i18nformatter;

import java.text.ChoiceFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.skills.utils.caffeine.checkerframework.checker.i18nformatter.qual.I18nChecksFormat;
import org.skills.utils.caffeine.checkerframework.checker.i18nformatter.qual.I18nConversionCategory;
import org.skills.utils.caffeine.checkerframework.checker.i18nformatter.qual.I18nValidFormat;
import org.skills.utils.caffeine.checkerframework.checker.interning.qual.InternedDistinct;
import org.skills.utils.caffeine.checkerframework.checker.nullness.qual.EnsuresNonNull;
import org.skills.utils.caffeine.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.skills.utils.caffeine.checkerframework.checker.nullness.qual.Nullable;
import org.skills.utils.caffeine.checkerframework.checker.nullness.qual.RequiresNonNull;

public class I18nFormatUtil {
    public static void tryFormatSatisfiability(String string) {
        MessageFormat.format(string, null);
    }

    public static I18nConversionCategory[] formatParameterCategories(String string) {
        I18nFormatUtil.tryFormatSatisfiability(string);
        I18nConversion[] i18nConversionArray = MessageFormatParser.parse(string);
        int n = -1;
        HashMap<Integer, I18nConversionCategory> hashMap = new HashMap<Integer, I18nConversionCategory>();
        I18nConversion[] objectArray = i18nConversionArray;
        int n2 = objectArray.length;
        for (int n4 = 0; n4 < n2; ++n4) {
            I18nConversion i18nConversion = objectArray[n4];
            int n3 = i18nConversion.index;
            Integer n5 = n3;
            hashMap.put(n5, I18nConversionCategory.intersect(i18nConversion.category, hashMap.containsKey(n5) ? (I18nConversionCategory)((Object)hashMap.get(n5)) : I18nConversionCategory.UNUSED));
            n = Math.max(n, n3);
        }
        I18nConversionCategory[] i18nConversionCategoryArray = new I18nConversionCategory[n + 1];
        for (n2 = 0; n2 <= n; ++n2) {
            Integer n6 = n2;
            i18nConversionCategoryArray[n2] = hashMap.containsKey(n6) ? (I18nConversionCategory)((Object)hashMap.get(n6)) : I18nConversionCategory.UNUSED;
        }
        return i18nConversionCategoryArray;
    }

    @I18nChecksFormat
    public static boolean hasFormat(String string, I18nConversionCategory ... i18nConversionCategoryArray) {
        I18nConversionCategory[] i18nConversionCategoryArray2 = I18nFormatUtil.formatParameterCategories(string);
        if (i18nConversionCategoryArray2.length != i18nConversionCategoryArray.length) {
            return false;
        }
        for (int i = 0; i < i18nConversionCategoryArray.length; ++i) {
            if (I18nConversionCategory.isSubsetOf(i18nConversionCategoryArray[i], i18nConversionCategoryArray2[i])) continue;
            return false;
        }
        return true;
    }

    @I18nValidFormat
    public static boolean isFormat(String string) {
        try {
            I18nFormatUtil.formatParameterCategories(string);
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    private static class MessageFormatParser {
        public static int maxOffset;
        private static @MonotonicNonNull Locale locale;
        private static @MonotonicNonNull List<I18nConversionCategory> categories;
        private static @MonotonicNonNull List<Integer> argumentIndices;
        private static int numFormat;
        private static final int SEG_RAW = 0;
        private static final int SEG_INDEX = 1;
        private static final int SEG_TYPE = 2;
        private static final int SEG_MODIFIER = 3;
        private static final int TYPE_NULL = 0;
        private static final int TYPE_NUMBER = 1;
        private static final int TYPE_DATE = 2;
        private static final int TYPE_TIME = 3;
        private static final int TYPE_CHOICE = 4;
        private static final String[] TYPE_KEYWORDS;
        private static final int MODIFIER_DEFAULT = 0;
        private static final int MODIFIER_CURRENCY = 1;
        private static final int MODIFIER_PERCENT = 2;
        private static final int MODIFIER_INTEGER = 3;
        private static final String[] NUMBER_MODIFIER_KEYWORDS;
        private static final String[] DATE_TIME_MODIFIER_KEYWORDS;

        private MessageFormatParser() {
        }

        @EnsuresNonNull(value={"categories", "argumentIndices", "locale"})
        public static I18nConversion[] parse(String string) {
            categories = new ArrayList<I18nConversionCategory>();
            argumentIndices = new ArrayList<Integer>();
            locale = Locale.getDefault(Locale.Category.FORMAT);
            MessageFormatParser.applyPattern(string);
            I18nConversion[] i18nConversionArray = new I18nConversion[numFormat];
            for (int i = 0; i < numFormat; ++i) {
                i18nConversionArray[i] = new I18nConversion(argumentIndices.get(i), categories.get(i));
            }
            return i18nConversionArray;
        }

        @RequiresNonNull(value={"argumentIndices", "categories", "locale"})
        private static void applyPattern(String string) {
            @Nullable StringBuilder[] stringBuilderArray = new StringBuilder[4];
            stringBuilderArray[0] = new StringBuilder();
            int n = 0;
            numFormat = 0;
            boolean bl = false;
            int n2 = 0;
            maxOffset = -1;
            block7: for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (n == 0) {
                    if (c == '\'') {
                        if (i + 1 < string.length() && string.charAt(i + 1) == '\'') {
                            stringBuilderArray[n].append(c);
                            ++i;
                            continue;
                        }
                        bl = !bl;
                        continue;
                    }
                    if (c == '{' && !bl) {
                        n = 1;
                        if (stringBuilderArray[1] != null) continue;
                        stringBuilderArray[1] = new StringBuilder();
                        continue;
                    }
                    stringBuilderArray[n].append(c);
                    continue;
                }
                if (bl) {
                    stringBuilderArray[n].append(c);
                    if (c != '\'') continue;
                    bl = false;
                    continue;
                }
                switch (c) {
                    case ',': {
                        if (n < 3) {
                            if (stringBuilderArray[++n] != null) continue block7;
                            stringBuilderArray[n] = new StringBuilder();
                            continue block7;
                        }
                        stringBuilderArray[n].append(c);
                        continue block7;
                    }
                    case '{': {
                        ++n2;
                        stringBuilderArray[n].append(c);
                        continue block7;
                    }
                    case '}': {
                        if (n2 == 0) {
                            n = 0;
                            MessageFormatParser.makeFormat(numFormat, stringBuilderArray);
                            ++numFormat;
                            stringBuilderArray[1] = null;
                            stringBuilderArray[2] = null;
                            stringBuilderArray[3] = null;
                            continue block7;
                        }
                        --n2;
                        stringBuilderArray[n].append(c);
                        continue block7;
                    }
                    case ' ': {
                        if (n == 2 && stringBuilderArray[2].length() <= 0) continue block7;
                        stringBuilderArray[n].append(c);
                        continue block7;
                    }
                    case '\'': {
                        bl = true;
                        stringBuilderArray[n].append(c);
                        continue block7;
                    }
                    default: {
                        stringBuilderArray[n].append(c);
                    }
                }
            }
            if (n2 == 0 && n != 0) {
                maxOffset = -1;
                throw new IllegalArgumentException("Unmatched braces in the pattern");
            }
        }

        @RequiresNonNull(value={"argumentIndices", "categories", "locale"})
        private static void makeFormat(int n, @Nullable StringBuilder[] stringBuilderArray) {
            int n2;
            String[] stringArray = new String[stringBuilderArray.length];
            for (n2 = 0; n2 < stringBuilderArray.length; ++n2) {
                StringBuilder stringBuilder = stringBuilderArray[n2];
                stringArray[n2] = stringBuilder != null ? stringBuilder.toString() : "";
            }
            try {
                n2 = Integer.parseInt(stringArray[1]);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException("can't parse argument number: " + stringArray[1], numberFormatException);
            }
            if (n2 < 0) {
                throw new IllegalArgumentException("negative argument number: " + n2);
            }
            int n3 = maxOffset;
            maxOffset = n;
            argumentIndices.add(n2);
            I18nConversionCategory i18nConversionCategory = null;
            if (stringArray[2].length() != 0) {
                int n4 = MessageFormatParser.findKeyword(stringArray[2], TYPE_KEYWORDS);
                switch (n4) {
                    case 0: {
                        i18nConversionCategory = I18nConversionCategory.GENERAL;
                        break;
                    }
                    case 1: {
                        switch (MessageFormatParser.findKeyword(stringArray[3], NUMBER_MODIFIER_KEYWORDS)) {
                            case 0: 
                            case 1: 
                            case 2: 
                            case 3: {
                                break;
                            }
                            default: {
                                try {
                                    new DecimalFormat(stringArray[3], DecimalFormatSymbols.getInstance(locale));
                                    break;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    maxOffset = n3;
                                    throw illegalArgumentException;
                                }
                            }
                        }
                        i18nConversionCategory = I18nConversionCategory.NUMBER;
                        break;
                    }
                    case 2: 
                    case 3: {
                        int n5 = MessageFormatParser.findKeyword(stringArray[3], DATE_TIME_MODIFIER_KEYWORDS);
                        if (n5 < 0 || n5 >= DATE_TIME_MODIFIER_KEYWORDS.length) {
                            try {
                                new SimpleDateFormat(stringArray[3], locale);
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                maxOffset = n3;
                                throw illegalArgumentException;
                            }
                        }
                        i18nConversionCategory = I18nConversionCategory.DATE;
                        break;
                    }
                    case 4: {
                        if (stringArray[3].length() == 0) {
                            throw new IllegalArgumentException("Choice Pattern requires Subformat Pattern: " + stringArray[3]);
                        }
                        try {
                            new ChoiceFormat(stringArray[3]);
                        }
                        catch (Exception exception) {
                            maxOffset = n3;
                            throw new IllegalArgumentException("Choice Pattern incorrect: " + stringArray[3], exception);
                        }
                        i18nConversionCategory = I18nConversionCategory.NUMBER;
                        break;
                    }
                    default: {
                        maxOffset = n3;
                        throw new IllegalArgumentException("unknown format type: " + stringArray[2]);
                    }
                }
            } else {
                i18nConversionCategory = I18nConversionCategory.GENERAL;
            }
            categories.add(i18nConversionCategory);
        }

        private static final int findKeyword(String string, String[] stringArray) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (!string.equals(stringArray[i])) continue;
                return i;
            }
            @InternedDistinct String string2 = string.trim().toLowerCase(Locale.ROOT);
            if (string2 != string) {
                for (int i = 0; i < stringArray.length; ++i) {
                    if (!string2.equals(stringArray[i])) continue;
                    return i;
                }
            }
            return -1;
        }

        static {
            TYPE_KEYWORDS = new String[]{"", "number", "date", "time", "choice"};
            NUMBER_MODIFIER_KEYWORDS = new String[]{"", "currency", "percent", "integer"};
            DATE_TIME_MODIFIER_KEYWORDS = new String[]{"", "short", "medium", "long", "full"};
        }
    }

    private static class I18nConversion {
        public int index;
        public I18nConversionCategory category;

        public I18nConversion(int n, I18nConversionCategory i18nConversionCategory) {
            this.index = n;
            this.category = i18nConversionCategory;
        }

        public String toString() {
            return this.category.toString() + "(index: " + this.index + ")";
        }
    }
}

