/*
 * Decompiled with CFR 0.152.
 */
package org.skills.utils.caffeine.checkerframework.checker.formatter.qual;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.StringJoiner;
import org.skills.utils.caffeine.checkerframework.checker.nullness.qual.Nullable;
import org.skills.utils.caffeine.checkerframework.dataflow.qual.Pure;

public enum ConversionCategory {
    GENERAL(null, "bBhHsS"),
    CHAR(new Class[]{Character.class, Byte.class, Short.class, Integer.class}, "cC"),
    INT(new Class[]{Byte.class, Short.class, Integer.class, Long.class, BigInteger.class}, "doxX"),
    FLOAT(new Class[]{Float.class, Double.class, BigDecimal.class}, "eEfgGaA"),
    TIME(new Class[]{Long.class, Calendar.class, Date.class}, "tT"),
    CHAR_AND_INT(new Class[]{Byte.class, Short.class, Integer.class}, null),
    INT_AND_TIME(new Class[]{Long.class}, null),
    NULL(new Class[0], null),
    UNUSED(null, null);

    public final Class<?> @Nullable [] types;
    public final @Nullable String chars;

    private ConversionCategory(Class<?>[] classArray, String string2) {
        this.types = classArray;
        this.chars = string2;
    }

    public static ConversionCategory fromConversionChar(char c) {
        for (ConversionCategory conversionCategory : new ConversionCategory[]{GENERAL, CHAR, INT, FLOAT, TIME}) {
            if (!conversionCategory.chars.contains(String.valueOf(c))) continue;
            return conversionCategory;
        }
        throw new IllegalArgumentException("Bad conversion character " + c);
    }

    private static <E> Set<E> arrayToSet(E[] EArray) {
        return new HashSet<E>(Arrays.asList(EArray));
    }

    public static boolean isSubsetOf(ConversionCategory conversionCategory, ConversionCategory conversionCategory2) {
        return ConversionCategory.intersect(conversionCategory, conversionCategory2) == conversionCategory;
    }

    public static ConversionCategory intersect(ConversionCategory conversionCategory, ConversionCategory conversionCategory2) {
        if (conversionCategory == UNUSED) {
            return conversionCategory2;
        }
        if (conversionCategory2 == UNUSED) {
            return conversionCategory;
        }
        if (conversionCategory == GENERAL) {
            return conversionCategory2;
        }
        if (conversionCategory2 == GENERAL) {
            return conversionCategory;
        }
        Set<Class<Class<?>>> set = ConversionCategory.arrayToSet(conversionCategory.types);
        Set<Class<?>> set2 = ConversionCategory.arrayToSet(conversionCategory2.types);
        set.retainAll(set2);
        for (ConversionCategory conversionCategory3 : new ConversionCategory[]{CHAR, INT, FLOAT, TIME, CHAR_AND_INT, INT_AND_TIME, NULL}) {
            Set<Class<?>> set3 = ConversionCategory.arrayToSet(conversionCategory3.types);
            if (!set3.equals(set)) continue;
            return conversionCategory3;
        }
        throw new RuntimeException();
    }

    public static ConversionCategory union(ConversionCategory conversionCategory, ConversionCategory conversionCategory2) {
        if (conversionCategory == UNUSED || conversionCategory2 == UNUSED) {
            return UNUSED;
        }
        if (conversionCategory == GENERAL || conversionCategory2 == GENERAL) {
            return GENERAL;
        }
        if (conversionCategory == CHAR_AND_INT && conversionCategory2 == INT_AND_TIME || conversionCategory == INT_AND_TIME && conversionCategory2 == CHAR_AND_INT) {
            return INT;
        }
        Set<Class<?>> set = ConversionCategory.arrayToSet(conversionCategory.types);
        Set<Class<?>> set2 = ConversionCategory.arrayToSet(conversionCategory2.types);
        set.addAll(set2);
        for (ConversionCategory conversionCategory3 : new ConversionCategory[]{NULL, CHAR_AND_INT, INT_AND_TIME, CHAR, INT, FLOAT, TIME}) {
            Set<Class<?>> set3 = ConversionCategory.arrayToSet(conversionCategory3.types);
            if (!set3.equals(set)) continue;
            return conversionCategory3;
        }
        return GENERAL;
    }

    private String className(Class<?> clazz) {
        if (clazz == Boolean.class) {
            return "boolean";
        }
        if (clazz == Character.class) {
            return "char";
        }
        if (clazz == Byte.class) {
            return "byte";
        }
        if (clazz == Short.class) {
            return "short";
        }
        if (clazz == Integer.class) {
            return "int";
        }
        if (clazz == Long.class) {
            return "long";
        }
        if (clazz == Float.class) {
            return "float";
        }
        if (clazz == Double.class) {
            return "double";
        }
        return clazz.getSimpleName();
    }

    @Pure
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.name());
        if (this != UNUSED && this != GENERAL) {
            StringJoiner stringJoiner = new StringJoiner(", ", " conversion category (one of: ", ")");
            for (Class<?> clazz : this.types) {
                stringJoiner.add(this.className(clazz));
            }
            stringBuilder.append(stringJoiner);
        }
        return stringBuilder.toString();
    }
}

