/*
 * Decompiled with CFR 0.152.
 */
package org.skills.utils.caffeine.checkerframework.checker.formatter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.IllegalFormatConversionException;
import java.util.MissingFormatArgumentException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.skills.utils.caffeine.checkerframework.checker.formatter.qual.ConversionCategory;
import org.skills.utils.caffeine.checkerframework.checker.formatter.qual.ReturnsFormat;
import org.skills.utils.caffeine.checkerframework.checker.regex.qual.Regex;

public class FormatUtil {
    private static final @Regex(value=6) String formatSpecifier = "%(\\d+\\$)?([-#+ 0,(\\<]*)?(\\d+)?(\\.\\d+)?([tT])?([a-zA-Z%])";
    private static final int formatSpecifierT = 5;
    private static final int formatSpecifierConversion = 6;
    private static @Regex(value=6) Pattern fsPattern = Pattern.compile("%(\\d+\\$)?([-#+ 0,(\\<]*)?(\\d+)?(\\.\\d+)?([tT])?([a-zA-Z%])");

    @ReturnsFormat
    public static String asFormat(String string, ConversionCategory ... conversionCategoryArray) {
        ConversionCategory[] conversionCategoryArray2 = FormatUtil.formatParameterCategories(string);
        if (conversionCategoryArray2.length != conversionCategoryArray.length) {
            throw new ExcessiveOrMissingFormatArgumentException(conversionCategoryArray.length, conversionCategoryArray2.length);
        }
        for (int i = 0; i < conversionCategoryArray.length; ++i) {
            if (conversionCategoryArray[i] == conversionCategoryArray2[i]) continue;
            throw new IllegalFormatConversionCategoryException(conversionCategoryArray[i], conversionCategoryArray2[i]);
        }
        return string;
    }

    public static void tryFormatSatisfiability(String string) {
        String string2 = String.format(string, (Object[])null);
    }

    public static ConversionCategory[] formatParameterCategories(String string) {
        FormatUtil.tryFormatSatisfiability(string);
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        Conversion[] conversionArray = FormatUtil.parse(string);
        HashMap<Integer, ConversionCategory> hashMap = new HashMap<Integer, ConversionCategory>();
        Conversion[] objectArray = conversionArray;
        int n4 = objectArray.length;
        for (int n6 = 0; n6 < n4; ++n6) {
            Conversion conversion = objectArray[n6];
            int n5 = conversion.index();
            switch (n5) {
                case -1: {
                    break;
                }
                case 0: {
                    n = ++n2;
                    break;
                }
                default: {
                    n = n5 - 1;
                }
            }
            n3 = Math.max(n3, n);
            Integer n7 = n;
            hashMap.put(n, ConversionCategory.intersect(hashMap.containsKey(n7) ? (ConversionCategory)((Object)hashMap.get(n7)) : ConversionCategory.UNUSED, conversion.category()));
        }
        ConversionCategory[] conversionCategoryArray = new ConversionCategory[n3 + 1];
        for (n4 = 0; n4 <= n3; ++n4) {
            Integer n8 = n4;
            conversionCategoryArray[n4] = hashMap.containsKey(n8) ? (ConversionCategory)((Object)hashMap.get(n8)) : ConversionCategory.UNUSED;
        }
        return conversionCategoryArray;
    }

    private static int indexFromFormat(Matcher matcher) {
        String string;
        String string2 = matcher.group(1);
        int n = string2 != null ? Integer.parseInt(string2.substring(0, string2.length() - 1)) : ((string = matcher.group(2)) != null && string.contains(String.valueOf('<')) ? -1 : 0);
        return n;
    }

    private static char conversionCharFromFormat(@Regex(value=6) Matcher matcher) {
        String string = matcher.group(5);
        if (string != null) {
            return string.charAt(0);
        }
        return matcher.group(6).charAt(0);
    }

    @Deprecated
    public static char conversionCharFromFormat(String string) {
        Matcher matcher = fsPattern.matcher(string);
        assert (matcher.find());
        return FormatUtil.conversionCharFromFormat(matcher);
    }

    private static Conversion[] parse(String string) {
        ArrayList<Conversion> arrayList = new ArrayList<Conversion>();
        @Regex(value=7) Matcher matcher = fsPattern.matcher(string);
        block3: while (matcher.find()) {
            char c = FormatUtil.conversionCharFromFormat(matcher);
            switch (c) {
                case '%': 
                case 'n': {
                    continue block3;
                }
            }
            arrayList.add(new Conversion(c, FormatUtil.indexFromFormat(matcher)));
        }
        return arrayList.toArray(new Conversion[arrayList.size()]);
    }

    public static class IllegalFormatConversionCategoryException
    extends IllegalFormatConversionException {
        private static final long serialVersionUID = 17000126L;
        private final ConversionCategory expected;
        private final ConversionCategory found;

        public IllegalFormatConversionCategoryException(ConversionCategory conversionCategory, ConversionCategory conversionCategory2) {
            super(conversionCategory.chars == null || conversionCategory.chars.length() == 0 ? (char)'-' : (char)conversionCategory.chars.charAt(0), conversionCategory2.types == null ? Object.class : conversionCategory2.types[0]);
            this.expected = conversionCategory;
            this.found = conversionCategory2;
        }

        public ConversionCategory getExpected() {
            return this.expected;
        }

        public ConversionCategory getFound() {
            return this.found;
        }

        @Override
        public String getMessage() {
            return String.format("Expected category %s but found %s.", new Object[]{this.expected, this.found});
        }
    }

    public static class ExcessiveOrMissingFormatArgumentException
    extends MissingFormatArgumentException {
        private static final long serialVersionUID = 17000126L;
        private final int expected;
        private final int found;

        public ExcessiveOrMissingFormatArgumentException(int n, int n2) {
            super("-");
            this.expected = n;
            this.found = n2;
        }

        public int getExpected() {
            return this.expected;
        }

        public int getFound() {
            return this.found;
        }

        @Override
        public String getMessage() {
            return String.format("Expected %d arguments but found %d.", this.expected, this.found);
        }
    }

    private static class Conversion {
        private final int index;
        private final ConversionCategory cath;

        public Conversion(char c, int n) {
            this.index = n;
            this.cath = ConversionCategory.fromConversionChar(c);
        }

        int index() {
            return this.index;
        }

        ConversionCategory category() {
            return this.cath;
        }
    }
}

