/*
 * Decompiled with CFR 0.152.
 */
package org.skills.utils.caffeine.cache.stats;

import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.skills.utils.caffeine.cache.RemovalCause;
import org.skills.utils.caffeine.cache.stats.CacheStats;
import org.skills.utils.caffeine.cache.stats.StatsCounter;

final class GuardedStatsCounter
implements StatsCounter {
    static final Logger logger = Logger.getLogger(GuardedStatsCounter.class.getName());
    final StatsCounter delegate;

    GuardedStatsCounter(StatsCounter statsCounter) {
        this.delegate = Objects.requireNonNull(statsCounter);
    }

    @Override
    public void recordHits(int n) {
        try {
            this.delegate.recordHits(n);
        }
        catch (Throwable throwable) {
            logger.log(Level.WARNING, "Exception thrown by stats counter", throwable);
        }
    }

    @Override
    public void recordMisses(int n) {
        try {
            this.delegate.recordMisses(n);
        }
        catch (Throwable throwable) {
            logger.log(Level.WARNING, "Exception thrown by stats counter", throwable);
        }
    }

    @Override
    public void recordLoadSuccess(long l) {
        try {
            this.delegate.recordLoadSuccess(l);
        }
        catch (Throwable throwable) {
            logger.log(Level.WARNING, "Exception thrown by stats counter", throwable);
        }
    }

    @Override
    public void recordLoadFailure(long l) {
        try {
            this.delegate.recordLoadFailure(l);
        }
        catch (Throwable throwable) {
            logger.log(Level.WARNING, "Exception thrown by stats counter", throwable);
        }
    }

    @Override
    public void recordEviction() {
        try {
            this.delegate.recordEviction();
        }
        catch (Throwable throwable) {
            logger.log(Level.WARNING, "Exception thrown by stats counter", throwable);
        }
    }

    @Override
    public void recordEviction(int n) {
        try {
            this.delegate.recordEviction(n);
        }
        catch (Throwable throwable) {
            logger.log(Level.WARNING, "Exception thrown by stats counter", throwable);
        }
    }

    @Override
    public void recordEviction(int n, RemovalCause removalCause) {
        try {
            this.delegate.recordEviction(n, removalCause);
        }
        catch (Throwable throwable) {
            logger.log(Level.WARNING, "Exception thrown by stats counter", throwable);
        }
    }

    @Override
    public CacheStats snapshot() {
        try {
            return this.delegate.snapshot();
        }
        catch (Throwable throwable) {
            logger.log(Level.WARNING, "Exception thrown by stats counter", throwable);
            return CacheStats.empty();
        }
    }

    public String toString() {
        return this.delegate.toString();
    }
}

