/*
 * Decompiled with CFR 0.152.
 */
package org.skills.utils.caffeine.cache.stats;

import java.util.Objects;
import org.skills.utils.caffeine.checkerframework.checker.index.qual.NonNegative;
import org.skills.utils.caffeine.checkerframework.checker.nullness.qual.NonNull;
import org.skills.utils.caffeine.errorprone.annotations.Immutable;

@Immutable
public final class CacheStats {
    private static final CacheStats EMPTY_STATS = new CacheStats(0L, 0L, 0L, 0L, 0L, 0L, 0L);
    private final long hitCount;
    private final long missCount;
    private final long loadSuccessCount;
    private final long loadFailureCount;
    private final long totalLoadTime;
    private final long evictionCount;
    private final long evictionWeight;

    @Deprecated
    public CacheStats(@NonNegative long l, @NonNegative long l2, @NonNegative long l3, @NonNegative long l4, @NonNegative long l5, @NonNegative long l6) {
        this(l, l2, l3, l4, l5, l6, 0L);
    }

    public CacheStats(@NonNegative long l, @NonNegative long l2, @NonNegative long l3, @NonNegative long l4, @NonNegative long l5, @NonNegative long l6, @NonNegative long l7) {
        if (l < 0L || l2 < 0L || l3 < 0L || l4 < 0L || l5 < 0L || l6 < 0L || l7 < 0L) {
            throw new IllegalArgumentException();
        }
        this.hitCount = l;
        this.missCount = l2;
        this.loadSuccessCount = l3;
        this.loadFailureCount = l4;
        this.totalLoadTime = l5;
        this.evictionCount = l6;
        this.evictionWeight = l7;
    }

    public static @NonNull CacheStats empty() {
        return EMPTY_STATS;
    }

    public @NonNegative long requestCount() {
        return CacheStats.saturatedAdd(this.hitCount, this.missCount);
    }

    public @NonNegative long hitCount() {
        return this.hitCount;
    }

    public @NonNegative double hitRate() {
        long l = this.requestCount();
        return l == 0L ? 1.0 : (double)this.hitCount / (double)l;
    }

    public @NonNegative long missCount() {
        return this.missCount;
    }

    public @NonNegative double missRate() {
        long l = this.requestCount();
        return l == 0L ? 0.0 : (double)this.missCount / (double)l;
    }

    public @NonNegative long loadCount() {
        return CacheStats.saturatedAdd(this.loadSuccessCount, this.loadFailureCount);
    }

    public @NonNegative long loadSuccessCount() {
        return this.loadSuccessCount;
    }

    public @NonNegative long loadFailureCount() {
        return this.loadFailureCount;
    }

    public @NonNegative double loadFailureRate() {
        long l = CacheStats.saturatedAdd(this.loadSuccessCount, this.loadFailureCount);
        return l == 0L ? 0.0 : (double)this.loadFailureCount / (double)l;
    }

    public @NonNegative long totalLoadTime() {
        return this.totalLoadTime;
    }

    public @NonNegative double averageLoadPenalty() {
        long l = CacheStats.saturatedAdd(this.loadSuccessCount, this.loadFailureCount);
        return l == 0L ? 0.0 : (double)this.totalLoadTime / (double)l;
    }

    public @NonNegative long evictionCount() {
        return this.evictionCount;
    }

    public @NonNegative long evictionWeight() {
        return this.evictionWeight;
    }

    public @NonNull CacheStats minus(@NonNull CacheStats cacheStats) {
        return new CacheStats(Math.max(0L, CacheStats.saturatedSubtract(this.hitCount, cacheStats.hitCount)), Math.max(0L, CacheStats.saturatedSubtract(this.missCount, cacheStats.missCount)), Math.max(0L, CacheStats.saturatedSubtract(this.loadSuccessCount, cacheStats.loadSuccessCount)), Math.max(0L, CacheStats.saturatedSubtract(this.loadFailureCount, cacheStats.loadFailureCount)), Math.max(0L, CacheStats.saturatedSubtract(this.totalLoadTime, cacheStats.totalLoadTime)), Math.max(0L, CacheStats.saturatedSubtract(this.evictionCount, cacheStats.evictionCount)), Math.max(0L, CacheStats.saturatedSubtract(this.evictionWeight, cacheStats.evictionWeight)));
    }

    public @NonNull CacheStats plus(@NonNull CacheStats cacheStats) {
        return new CacheStats(CacheStats.saturatedAdd(this.hitCount, cacheStats.hitCount), CacheStats.saturatedAdd(this.missCount, cacheStats.missCount), CacheStats.saturatedAdd(this.loadSuccessCount, cacheStats.loadSuccessCount), CacheStats.saturatedAdd(this.loadFailureCount, cacheStats.loadFailureCount), CacheStats.saturatedAdd(this.totalLoadTime, cacheStats.totalLoadTime), CacheStats.saturatedAdd(this.evictionCount, cacheStats.evictionCount), CacheStats.saturatedAdd(this.evictionWeight, cacheStats.evictionWeight));
    }

    private static long saturatedSubtract(long l, long l2) {
        long l3;
        if ((l ^ l2) >= 0L | (l ^ (l3 = l - l2)) >= 0L) {
            return l3;
        }
        return Long.MAX_VALUE + (l3 >>> 63 ^ 1L);
    }

    private static long saturatedAdd(long l, long l2) {
        long l3;
        if ((l ^ l2) < 0L | (l ^ (l3 = l + l2)) >= 0L) {
            return l3;
        }
        return Long.MAX_VALUE + (l3 >>> 63 ^ 1L);
    }

    public int hashCode() {
        return Objects.hash(this.hitCount, this.missCount, this.loadSuccessCount, this.loadFailureCount, this.totalLoadTime, this.evictionCount, this.evictionWeight);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof CacheStats)) {
            return false;
        }
        CacheStats cacheStats = (CacheStats)object;
        return this.hitCount == cacheStats.hitCount && this.missCount == cacheStats.missCount && this.loadSuccessCount == cacheStats.loadSuccessCount && this.loadFailureCount == cacheStats.loadFailureCount && this.totalLoadTime == cacheStats.totalLoadTime && this.evictionCount == cacheStats.evictionCount && this.evictionWeight == cacheStats.evictionWeight;
    }

    public String toString() {
        return this.getClass().getSimpleName() + '{' + "hitCount=" + this.hitCount + ", missCount=" + this.missCount + ", loadSuccessCount=" + this.loadSuccessCount + ", loadFailureCount=" + this.loadFailureCount + ", totalLoadTime=" + this.totalLoadTime + ", evictionCount=" + this.evictionCount + ", evictionWeight=" + this.evictionWeight + '}';
    }
}

