/*
 * Decompiled with CFR 0.152.
 */
package org.skills.utils.caffeine.cache;

import java.lang.ref.ReferenceQueue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.skills.utils.caffeine.cache.BoundedLocalCache;
import org.skills.utils.caffeine.cache.Caffeine;
import org.skills.utils.caffeine.cache.Node;
import org.skills.utils.caffeine.cache.RemovalCause;
import org.skills.utils.caffeine.checkerframework.checker.nullness.qual.NonNull;
import org.skills.utils.caffeine.checkerframework.checker.nullness.qual.Nullable;

final class TimerWheel<K, V> {
    static final int[] BUCKETS = new int[]{64, 64, 32, 4, 1};
    static final long[] SPANS = new long[]{Caffeine.ceilingPowerOfTwo(TimeUnit.SECONDS.toNanos(1L)), Caffeine.ceilingPowerOfTwo(TimeUnit.MINUTES.toNanos(1L)), Caffeine.ceilingPowerOfTwo(TimeUnit.HOURS.toNanos(1L)), Caffeine.ceilingPowerOfTwo(TimeUnit.DAYS.toNanos(1L)), (long)BUCKETS[3] * Caffeine.ceilingPowerOfTwo(TimeUnit.DAYS.toNanos(1L)), (long)BUCKETS[3] * Caffeine.ceilingPowerOfTwo(TimeUnit.DAYS.toNanos(1L))};
    static final long[] SHIFT = new long[]{Long.numberOfTrailingZeros(SPANS[0]), Long.numberOfTrailingZeros(SPANS[1]), Long.numberOfTrailingZeros(SPANS[2]), Long.numberOfTrailingZeros(SPANS[3]), Long.numberOfTrailingZeros(SPANS[4])};
    final BoundedLocalCache<K, V> cache;
    final Node<K, V>[][] wheel;
    long nanos;

    TimerWheel(BoundedLocalCache<K, V> boundedLocalCache) {
        this.cache = Objects.requireNonNull(boundedLocalCache);
        this.wheel = new Node[BUCKETS.length][1];
        for (int i = 0; i < this.wheel.length; ++i) {
            this.wheel[i] = new Node[BUCKETS[i]];
            for (int j = 0; j < this.wheel[i].length; ++j) {
                this.wheel[i][j] = new Sentinel();
            }
        }
    }

    public void advance(long l) {
        long l2 = this.nanos;
        try {
            long l3;
            long l4;
            this.nanos = l;
            for (int i = 0; i < SHIFT.length && (l4 = l >>> (int)SHIFT[i]) - (l3 = l2 >>> (int)SHIFT[i]) > 0L; ++i) {
                this.expire(i, l3, l4);
            }
        }
        catch (Throwable throwable) {
            this.nanos = l2;
            throw throwable;
        }
    }

    void expire(int n, long l, long l2) {
        int n2;
        int n3;
        Node<K, V>[] nodeArray = this.wheel[n];
        if (l2 - l >= (long)nodeArray.length) {
            n3 = nodeArray.length;
            n2 = 0;
        } else {
            long l3 = SPANS[n] - 1L;
            n2 = (int)(l & l3);
            n3 = 1 + (int)(l2 & l3);
        }
        int n4 = nodeArray.length - 1;
        for (int i = n2; i < n3; ++i) {
            Node<K, V> node = nodeArray[i & n4];
            Node<K, V> node2 = node.getPreviousInVariableOrder();
            Node<K, V> node3 = node.getNextInVariableOrder();
            node.setPreviousInVariableOrder(node);
            node.setNextInVariableOrder(node);
            while (node3 != node) {
                Node<K, V> node4 = node3.getNextInVariableOrder();
                node3.setPreviousInVariableOrder(null);
                node3.setNextInVariableOrder(null);
                try {
                    if (node3.getVariableTime() - this.nanos > 0L || !this.cache.evictEntry(node3, RemovalCause.EXPIRED, this.nanos)) {
                        this.schedule(node3);
                    }
                    node3 = node4;
                }
                catch (Throwable throwable) {
                    node3.setPreviousInVariableOrder(node.getPreviousInVariableOrder());
                    node3.setNextInVariableOrder(node4);
                    node.getPreviousInVariableOrder().setNextInVariableOrder(node3);
                    node.setPreviousInVariableOrder(node2);
                    throw throwable;
                }
            }
        }
    }

    public void schedule(@NonNull Node<K, V> node) {
        Node<K, V> node2 = this.findBucket(node.getVariableTime());
        this.link(node2, node);
    }

    public void reschedule(@NonNull Node<K, V> node) {
        if (node.getNextInVariableOrder() != null) {
            this.unlink(node);
            this.schedule(node);
        }
    }

    public void deschedule(@NonNull Node<K, V> node) {
        this.unlink(node);
        node.setNextInVariableOrder(null);
        node.setPreviousInVariableOrder(null);
    }

    Node<K, V> findBucket(long l) {
        long l2 = l - this.nanos;
        int n = this.wheel.length - 1;
        for (int i = 0; i < n; ++i) {
            if (l2 >= SPANS[i + 1]) continue;
            long l3 = l >>> (int)SHIFT[i];
            int n2 = (int)(l3 & (long)(this.wheel[i].length - 1));
            return this.wheel[i][n2];
        }
        return this.wheel[n][0];
    }

    void link(Node<K, V> node, Node<K, V> node2) {
        node2.setPreviousInVariableOrder(node.getPreviousInVariableOrder());
        node2.setNextInVariableOrder(node);
        node.getPreviousInVariableOrder().setNextInVariableOrder(node2);
        node.setPreviousInVariableOrder(node2);
    }

    void unlink(Node<K, V> node) {
        Node<K, V> node2 = node.getNextInVariableOrder();
        if (node2 != null) {
            Node<K, V> node3 = node.getPreviousInVariableOrder();
            node2.setPreviousInVariableOrder(node3);
            node3.setNextInVariableOrder(node2);
        }
    }

    public long getExpirationDelay() {
        for (int i = 0; i < SHIFT.length; ++i) {
            Node<K, V>[] nodeArray = this.wheel[i];
            long l = this.nanos >>> (int)SHIFT[i];
            long l2 = SPANS[i] - 1L;
            int n = (int)(l & l2);
            int n2 = n + nodeArray.length;
            int n3 = nodeArray.length - 1;
            for (int j = n; j < n2; ++j) {
                Node<K, V> node = nodeArray[j & n3];
                Node<K, V> node2 = node.getNextInVariableOrder();
                if (node2 == node) continue;
                long l3 = j - n;
                long l4 = (l3 << (int)SHIFT[i]) - (this.nanos & l2);
                l4 = l4 > 0L ? l4 : SPANS[i];
                for (int k = i + 1; k < SHIFT.length; ++k) {
                    long l5 = this.peekAhead(k);
                    l4 = Math.min(l4, l5);
                }
                return l4;
            }
        }
        return Long.MAX_VALUE;
    }

    long peekAhead(int n) {
        long l = this.nanos >>> (int)SHIFT[n];
        Node<K, V>[] nodeArray = this.wheel[n];
        long l2 = SPANS[n] - 1L;
        int n2 = nodeArray.length - 1;
        int n3 = (int)(l + 1L & (long)n2);
        Node<K, V> node = nodeArray[n3];
        Node<K, V> node2 = node.getNextInVariableOrder();
        return node2 == node ? Long.MAX_VALUE : SPANS[n] - (this.nanos & l2);
    }

    public Map<K, V> snapshot(boolean bl, int n, @NonNull Function<V, V> function) {
        Caffeine.requireArgument(n >= 0);
        LinkedHashMap<K, V> linkedHashMap = new LinkedHashMap<K, V>(Math.min(n, this.cache.size()));
        int n2 = bl ? 0 : this.wheel.length - 1;
        for (int i = 0; i < this.wheel.length; ++i) {
            int n3 = bl ? i : -i;
            int n4 = n2 + n3;
            int n5 = (int)(this.nanos >>> (int)SHIFT[n4]);
            int n6 = this.wheel[n4].length - 1;
            int n7 = (n5 & n6) + (bl ? 1 : 0);
            for (int j = 0; j < this.wheel[n4].length; ++j) {
                int n8 = bl ? j : -j;
                Node<K, V> node = this.wheel[n4][n7 + n8 & n6];
                Node<K, V> node2 = TimerWheel.traverse(bl, node);
                while (node2 != node && linkedHashMap.size() < n) {
                    K k = node2.getKey();
                    V v = function.apply(node2.getValue());
                    if (k != null && v != null && node2.isAlive()) {
                        linkedHashMap.put(k, v);
                    }
                    node2 = TimerWheel.traverse(bl, node2);
                }
            }
        }
        return Collections.unmodifiableMap(linkedHashMap);
    }

    static <K, V> Node<K, V> traverse(boolean bl, Node<K, V> node) {
        return bl ? node.getNextInVariableOrder() : node.getPreviousInVariableOrder();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.wheel.length; ++i) {
            TreeMap treeMap = new TreeMap();
            for (int j = 0; j < this.wheel[i].length; ++j) {
                ArrayList<K> arrayList = new ArrayList<K>();
                for (Node<K, V> node = this.wheel[i][j].getNextInVariableOrder(); node != this.wheel[i][j]; node = node.getNextInVariableOrder()) {
                    arrayList.add(node.getKey());
                }
                if (arrayList.isEmpty()) continue;
                treeMap.put(j, arrayList);
            }
            stringBuilder.append("Wheel #").append(i + 1).append(": ").append(treeMap).append('\n');
        }
        return stringBuilder.deleteCharAt(stringBuilder.length() - 1).toString();
    }

    static final class Sentinel<K, V>
    extends Node<K, V> {
        Node<K, V> prev;
        Node<K, V> next;

        Sentinel() {
            this.prev = this.next = this;
        }

        @Override
        public Node<K, V> getPreviousInVariableOrder() {
            return this.prev;
        }

        @Override
        public void setPreviousInVariableOrder(@Nullable Node<K, V> node) {
            this.prev = node;
        }

        @Override
        public Node<K, V> getNextInVariableOrder() {
            return this.next;
        }

        @Override
        public void setNextInVariableOrder(@Nullable Node<K, V> node) {
            this.next = node;
        }

        @Override
        public @Nullable K getKey() {
            return null;
        }

        @Override
        public Object getKeyReference() {
            throw new UnsupportedOperationException();
        }

        @Override
        public @Nullable V getValue() {
            return null;
        }

        @Override
        public Object getValueReference() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setValue(V v, @Nullable ReferenceQueue<V> referenceQueue) {
        }

        @Override
        public boolean containsValue(Object object) {
            return false;
        }

        @Override
        public boolean isAlive() {
            return false;
        }

        @Override
        public boolean isRetired() {
            return false;
        }

        @Override
        public boolean isDead() {
            return false;
        }

        @Override
        public void retire() {
        }

        @Override
        public void die() {
        }
    }
}

