/*
 * Decompiled with CFR 0.152.
 */
package org.skills.utils.caffeine.cache;

import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import org.skills.utils.caffeine.cache.AsyncCacheLoader;
import org.skills.utils.caffeine.cache.CacheLoader;
import org.skills.utils.caffeine.cache.CacheWriter;
import org.skills.utils.caffeine.cache.Caffeine;
import org.skills.utils.caffeine.cache.Expiry;
import org.skills.utils.caffeine.cache.RemovalListener;
import org.skills.utils.caffeine.cache.Ticker;
import org.skills.utils.caffeine.cache.Weigher;
import org.skills.utils.caffeine.checkerframework.checker.nullness.qual.Nullable;

final class SerializationProxy<K, V>
implements Serializable {
    private static final long serialVersionUID = 1L;
    boolean async;
    boolean weakKeys;
    boolean weakValues;
    boolean softValues;
    boolean isRecordingStats;
    long refreshAfterWriteNanos;
    long expiresAfterWriteNanos;
    long expiresAfterAccessNanos;
    long maximumSize = -1L;
    long maximumWeight = -1L;
    @Nullable Ticker ticker;
    @Nullable Expiry<?, ?> expiry;
    @Nullable Weigher<?, ?> weigher;
    @Nullable CacheWriter<?, ?> writer;
    @Nullable AsyncCacheLoader<?, ?> loader;
    @Nullable RemovalListener<?, ?> removalListener;

    SerializationProxy() {
    }

    Caffeine<Object, Object> recreateCaffeine() {
        Caffeine<Object, Object> caffeine = Caffeine.newBuilder();
        if (this.ticker != null) {
            caffeine.ticker(this.ticker);
        }
        if (this.isRecordingStats) {
            caffeine.recordStats();
        }
        if (this.maximumSize != -1L) {
            caffeine.maximumSize(this.maximumSize);
        }
        if (this.weigher != null) {
            caffeine.maximumWeight(this.maximumWeight);
            caffeine.weigher(this.weigher);
        }
        if (this.expiry != null) {
            caffeine.expireAfter(this.expiry);
        }
        if (this.expiresAfterWriteNanos > 0L) {
            caffeine.expireAfterWrite(this.expiresAfterWriteNanos, TimeUnit.NANOSECONDS);
        }
        if (this.expiresAfterAccessNanos > 0L) {
            caffeine.expireAfterAccess(this.expiresAfterAccessNanos, TimeUnit.NANOSECONDS);
        }
        if (this.refreshAfterWriteNanos > 0L) {
            caffeine.refreshAfterWrite(this.refreshAfterWriteNanos, TimeUnit.NANOSECONDS);
        }
        if (this.weakKeys) {
            caffeine.weakKeys();
        }
        if (this.weakValues) {
            caffeine.weakValues();
        }
        if (this.softValues) {
            caffeine.softValues();
        }
        if (this.removalListener != null) {
            caffeine.removalListener(this.removalListener);
        }
        if (this.writer != null && this.writer != CacheWriter.disabledWriter()) {
            caffeine.writer(this.writer);
        }
        return caffeine;
    }

    Object readResolve() {
        Caffeine<Object, Object> caffeine = this.recreateCaffeine();
        if (this.async) {
            if (this.loader == null) {
                return caffeine.buildAsync();
            }
            AsyncCacheLoader<?, ?> asyncCacheLoader = this.loader;
            return caffeine.buildAsync(asyncCacheLoader);
        }
        if (this.loader == null) {
            return caffeine.build();
        }
        CacheLoader cacheLoader = (CacheLoader)this.loader;
        return caffeine.build(cacheLoader);
    }
}

