/*
 * Decompiled with CFR 0.152.
 */
package org.skills.utils.caffeine.cache;

import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.skills.utils.caffeine.cache.Caffeine;
import org.skills.utils.caffeine.cache.Scheduler;
import org.skills.utils.caffeine.checkerframework.checker.nullness.qual.Nullable;

final class Pacer {
    static final long TOLERANCE = Caffeine.ceilingPowerOfTwo(TimeUnit.SECONDS.toNanos(1L));
    final Scheduler scheduler;
    long nextFireTime;
    @Nullable Future<?> future;

    Pacer(Scheduler scheduler) {
        this.scheduler = Objects.requireNonNull(scheduler);
    }

    public void schedule(Executor executor, Runnable runnable, long l, long l2) {
        long l3 = l + l2;
        if (this.future == null) {
            if (this.nextFireTime != 0L) {
                return;
            }
        } else if (this.nextFireTime - l > 0L) {
            if (this.maySkip(l3)) {
                return;
            }
            this.future.cancel(false);
        }
        long l4 = this.calculateSchedule(l, l2, l3);
        this.future = this.scheduler.schedule(executor, runnable, l4, TimeUnit.NANOSECONDS);
    }

    boolean maySkip(long l) {
        long l2 = l - this.nextFireTime;
        return l2 >= 0L || -l2 <= TOLERANCE;
    }

    long calculateSchedule(long l, long l2, long l3) {
        if (l2 <= TOLERANCE) {
            this.nextFireTime = l + TOLERANCE;
            return TOLERANCE;
        }
        this.nextFireTime = l3;
        return l2;
    }
}

