/*
 * Decompiled with CFR 0.152.
 */
package org.skills.utils.caffeine.cache;

import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.skills.utils.caffeine.cache.Async;
import org.skills.utils.caffeine.cache.AsyncCache;
import org.skills.utils.caffeine.cache.Cache;
import org.skills.utils.caffeine.cache.Caffeine;
import org.skills.utils.caffeine.cache.LocalCache;
import org.skills.utils.caffeine.cache.Policy;
import org.skills.utils.caffeine.cache.WriteThroughEntry;
import org.skills.utils.caffeine.cache.stats.CacheStats;
import org.skills.utils.caffeine.checkerframework.checker.nullness.qual.NonNull;
import org.skills.utils.caffeine.checkerframework.checker.nullness.qual.Nullable;

interface LocalAsyncCache<K, V>
extends AsyncCache<K, V> {
    public static final Logger logger = Logger.getLogger(LocalAsyncCache.class.getName());

    public LocalCache<K, CompletableFuture<V>> cache();

    public Policy<K, V> policy();

    @Override
    default public @Nullable CompletableFuture<V> getIfPresent(@NonNull Object key) {
        return this.cache().getIfPresent(key, true);
    }

    @Override
    default public CompletableFuture<V> get(@NonNull K key, @NonNull Function<? super K, ? extends V> mappingFunction) {
        Objects.requireNonNull(mappingFunction);
        return this.get(key, (? super K k1, Executor executor) -> CompletableFuture.supplyAsync(() -> mappingFunction.apply((Object)key), executor));
    }

    @Override
    default public CompletableFuture<V> get(K key, BiFunction<? super K, Executor, CompletableFuture<V>> mappingFunction) {
        return this.get(key, mappingFunction, true);
    }

    default public CompletableFuture<V> get(K key, BiFunction<? super K, Executor, CompletableFuture<V>> mappingFunction, boolean recordStats) {
        long startTime = this.cache().statsTicker().read();
        CompletableFuture[] result = new CompletableFuture[1];
        CompletableFuture future = this.cache().computeIfAbsent(key, k -> {
            result[0] = (CompletableFuture)mappingFunction.apply((K)key, this.cache().executor());
            return Objects.requireNonNull(result[0]);
        }, recordStats, false);
        if (result[0] != null) {
            this.handleCompletion(key, result[0], startTime, false);
        }
        return future;
    }

    @Override
    default public CompletableFuture<Map<K, V>> getAll(Iterable<? extends @NonNull K> keys, Function<Iterable<? extends K>, Map<K, V>> mappingFunction) {
        Objects.requireNonNull(mappingFunction);
        return this.getAll(keys, (Iterable<? extends K> keysToLoad, Executor executor) -> CompletableFuture.supplyAsync(() -> (Map)mappingFunction.apply((Iterable)keysToLoad), executor));
    }

    @Override
    default public CompletableFuture<Map<K, V>> getAll(Iterable<? extends @NonNull K> keys, BiFunction<Iterable<? extends K>, Executor, CompletableFuture<Map<K, V>>> mappingFunction) {
        Objects.requireNonNull(mappingFunction);
        Objects.requireNonNull(keys);
        LinkedHashMap<K, CompletableFuture<V>> futures = new LinkedHashMap<K, CompletableFuture<V>>();
        HashMap proxies = new HashMap();
        for (K key : keys) {
            if (futures.containsKey(key)) continue;
            CompletableFuture<Object> future = this.cache().getIfPresent(key, false);
            if (future == null) {
                CompletableFuture proxy = new CompletableFuture();
                future = this.cache().putIfAbsent(key, proxy);
                if (future == null) {
                    future = proxy;
                    proxies.put(key, proxy);
                }
            }
            futures.put(key, future);
        }
        this.cache().statsCounter().recordMisses(proxies.size());
        this.cache().statsCounter().recordHits(futures.size() - proxies.size());
        if (proxies.isEmpty()) {
            return this.composeResult(futures);
        }
        AsyncBulkCompleter completer = new AsyncBulkCompleter(this.cache(), proxies);
        try {
            mappingFunction.apply(proxies.keySet(), this.cache().executor()).whenComplete((BiConsumer)completer);
            return this.composeResult(futures);
        }
        catch (Throwable t) {
            completer.accept(null, t);
            throw t;
        }
    }

    default public CompletableFuture<Map<K, V>> composeResult(Map<K, CompletableFuture<V>> futures) {
        if (futures.isEmpty()) {
            return CompletableFuture.completedFuture(Collections.emptyMap());
        }
        CompletableFuture[] array = futures.values().toArray(new CompletableFuture[0]);
        return CompletableFuture.allOf(array).thenApply(ignored -> {
            LinkedHashMap result = new LinkedHashMap(futures.size());
            futures.forEach((key, future) -> {
                Object value = future.getNow(null);
                if (value != null) {
                    result.put(key, value);
                }
            });
            return Collections.unmodifiableMap(result);
        });
    }

    @Override
    default public void put(K key, CompletableFuture<V> valueFuture) {
        if (valueFuture.isCompletedExceptionally() || valueFuture.isDone() && valueFuture.join() == null) {
            this.cache().statsCounter().recordLoadFailure(0L);
            this.cache().remove(key);
            return;
        }
        long startTime = this.cache().statsTicker().read();
        this.cache().put(key, valueFuture);
        this.handleCompletion(key, valueFuture, startTime, false);
    }

    default public void handleCompletion(K key, CompletableFuture<V> valueFuture, long startTime, boolean recordMiss) {
        AtomicBoolean completed = new AtomicBoolean();
        valueFuture.whenComplete((value, error) -> {
            if (!completed.compareAndSet(false, true)) {
                return;
            }
            long loadTime = this.cache().statsTicker().read() - startTime;
            if (value == null) {
                if (error != null) {
                    logger.log(Level.WARNING, "Exception thrown during asynchronous load", (Throwable)error);
                }
                this.cache().remove(key, valueFuture);
                this.cache().statsCounter().recordLoadFailure(loadTime);
                if (recordMiss) {
                    this.cache().statsCounter().recordMisses(1);
                }
            } else {
                this.cache().replace(key, valueFuture, valueFuture);
                this.cache().statsCounter().recordLoadSuccess(loadTime);
                if (recordMiss) {
                    this.cache().statsCounter().recordMisses(1);
                }
            }
        });
    }

    public static final class AsMapView<K, V>
    extends AbstractMap<K, V>
    implements ConcurrentMap<K, V> {
        final LocalCache<K, CompletableFuture<V>> delegate;
        @Nullable Collection<V> values;
        @Nullable Set<Map.Entry<K, V>> entries;

        AsMapView(LocalCache<K, CompletableFuture<V>> localCache) {
            this.delegate = localCache;
        }

        @Override
        public boolean isEmpty() {
            return this.delegate.isEmpty();
        }

        @Override
        public int size() {
            return this.delegate.size();
        }

        @Override
        public void clear() {
            this.delegate.clear();
        }

        @Override
        public boolean containsKey(Object object) {
            return this.delegate.containsKey(object);
        }

        @Override
        public boolean containsValue(Object object) {
            Objects.requireNonNull(object);
            for (CompletableFuture completableFuture : this.delegate.values()) {
                if (!object.equals(Async.getIfReady(completableFuture))) continue;
                return true;
            }
            return false;
        }

        @Override
        public @Nullable V get(Object object) {
            return Async.getIfReady((CompletableFuture)this.delegate.get(object));
        }

        @Override
        public @Nullable V putIfAbsent(K k, V v) {
            Object v2;
            Objects.requireNonNull(v);
            while (true) {
                Object object;
                CompletableFuture completableFuture2;
                if ((completableFuture2 = (CompletableFuture)this.delegate.get(k)) != null) {
                    if (!completableFuture2.isDone()) {
                        Async.getWhenSuccessful(completableFuture2);
                        continue;
                    }
                    object = Async.getWhenSuccessful(completableFuture2);
                    if (object != null) {
                        return object;
                    }
                }
                object = new boolean[]{false};
                CompletableFuture completableFuture3 = this.delegate.compute(k, (object2, completableFuture) -> {
                    blArray[0] = completableFuture == null || completableFuture.isDone() && Async.getIfReady(completableFuture) == null;
                    return object[0] ? CompletableFuture.completedFuture(v) : completableFuture;
                }, false, false, false);
                if (object[0] != false) {
                    return null;
                }
                v2 = Async.getWhenSuccessful(completableFuture3);
                if (v2 != null) break;
            }
            return v2;
        }

        @Override
        public @Nullable V put(K k, V v) {
            Objects.requireNonNull(v);
            CompletableFuture<V> completableFuture = this.delegate.put(k, CompletableFuture.completedFuture(v));
            return Async.getWhenSuccessful(completableFuture);
        }

        @Override
        public @Nullable V remove(Object object) {
            CompletableFuture completableFuture = (CompletableFuture)this.delegate.remove(object);
            return Async.getWhenSuccessful(completableFuture);
        }

        @Override
        public boolean remove(Object object, Object object3) {
            Objects.requireNonNull(object);
            if (object3 == null) {
                return false;
            }
            Object object4 = object;
            boolean[] blArray = new boolean[]{false};
            boolean[] blArray2 = new boolean[]{false};
            do {
                CompletableFuture completableFuture2;
                if ((completableFuture2 = (CompletableFuture)this.delegate.get(object)) == null || completableFuture2.isCompletedExceptionally()) {
                    return false;
                }
                Async.getWhenSuccessful(completableFuture2);
                this.delegate.compute(object4, (object2, completableFuture) -> {
                    if (completableFuture == null) {
                        blArray[0] = true;
                        return null;
                    }
                    if (!completableFuture.isDone()) {
                        return completableFuture;
                    }
                    blArray[0] = true;
                    Object v = Async.getIfReady(completableFuture);
                    blArray2[0] = object3.equals(v);
                    return v == null || blArray2[0] ? null : completableFuture;
                }, false, false, true);
            } while (!blArray[0]);
            return blArray2[0];
        }

        @Override
        public @Nullable V replace(K k, V v) {
            Objects.requireNonNull(v);
            Object[] objectArray = new Object[1];
            boolean[] blArray = new boolean[]{false};
            do {
                CompletableFuture completableFuture2;
                if ((completableFuture2 = (CompletableFuture)this.delegate.get(k)) == null || completableFuture2.isCompletedExceptionally()) {
                    return null;
                }
                Async.getWhenSuccessful(completableFuture2);
                this.delegate.compute(k, (object2, completableFuture) -> {
                    if (completableFuture == null) {
                        blArray[0] = true;
                        return null;
                    }
                    if (!completableFuture.isDone()) {
                        return completableFuture;
                    }
                    blArray[0] = true;
                    objectArray[0] = Async.getIfReady(completableFuture);
                    return objectArray[0] == null ? null : CompletableFuture.completedFuture(v);
                }, false, false, false);
            } while (!blArray[0]);
            return (V)objectArray[0];
        }

        @Override
        public boolean replace(K k, V v, V v2) {
            Objects.requireNonNull(v);
            Objects.requireNonNull(v2);
            boolean[] blArray = new boolean[]{false};
            boolean[] blArray2 = new boolean[]{false};
            do {
                CompletableFuture completableFuture2;
                if ((completableFuture2 = (CompletableFuture)this.delegate.get(k)) == null || completableFuture2.isCompletedExceptionally()) {
                    return false;
                }
                Async.getWhenSuccessful(completableFuture2);
                this.delegate.compute(k, (object3, completableFuture) -> {
                    if (completableFuture == null) {
                        blArray[0] = true;
                        return null;
                    }
                    if (!completableFuture.isDone()) {
                        return completableFuture;
                    }
                    blArray[0] = true;
                    blArray2[0] = v.equals(Async.getIfReady(completableFuture));
                    return blArray2[0] ? CompletableFuture.completedFuture(v2) : completableFuture;
                }, false, false, false);
            } while (!blArray[0]);
            return blArray2[0];
        }

        @Override
        public @Nullable V computeIfAbsent(K k, Function<? super K, ? extends V> function) {
            Object v;
            Objects.requireNonNull(function);
            while (true) {
                Object object;
                CompletableFuture completableFuture;
                if ((completableFuture = (CompletableFuture)this.delegate.get(k)) != null) {
                    if (!completableFuture.isDone()) {
                        Async.getWhenSuccessful(completableFuture);
                        continue;
                    }
                    object = Async.getWhenSuccessful(completableFuture);
                    if (object != null) {
                        this.delegate.statsCounter().recordHits(1);
                        return (V)object;
                    }
                }
                object = new CompletableFuture[1];
                CompletableFuture completableFuture2 = this.delegate.compute(k, (arg_0, arg_1) -> this.lambda$computeIfAbsent$4(function, k, (CompletableFuture[])object, arg_0, arg_1), false, false, false);
                v = Async.getWhenSuccessful(completableFuture2);
                if (completableFuture2 == object[0] || v != null) break;
            }
            return v;
        }

        @Override
        public @Nullable V computeIfPresent(K k, BiFunction<? super K, ? super V, ? extends V> biFunction) {
            CompletableFuture completableFuture2;
            Objects.requireNonNull(biFunction);
            Object[] objectArray = new Object[1];
            do {
                Async.getWhenSuccessful((CompletableFuture)this.delegate.get(k));
                completableFuture2 = this.delegate.computeIfPresent(k, (object2, completableFuture) -> {
                    if (!completableFuture.isDone()) {
                        return completableFuture;
                    }
                    Object v = Async.getIfReady(completableFuture);
                    if (v == null) {
                        return null;
                    }
                    objectArray[0] = biFunction.apply((Object)k, (Object)v);
                    return objectArray[0] == null ? null : CompletableFuture.completedFuture(objectArray[0]);
                });
                if (objectArray[0] == null) continue;
                return (V)objectArray[0];
            } while (completableFuture2 != null);
            return null;
        }

        @Override
        public @Nullable V compute(K k, BiFunction<? super K, ? super V, ? extends V> biFunction) {
            CompletableFuture completableFuture2;
            Objects.requireNonNull(biFunction);
            Object[] objectArray = new Object[1];
            do {
                Async.getWhenSuccessful((CompletableFuture)this.delegate.get(k));
                completableFuture2 = this.delegate.compute(k, (object2, completableFuture) -> {
                    if (completableFuture != null && !completableFuture.isDone()) {
                        return completableFuture;
                    }
                    Object v = Async.getIfReady(completableFuture);
                    BiFunction biFunction2 = this.delegate.statsAware(biFunction, false, true, true);
                    objectArray[0] = biFunction2.apply(k, v);
                    return objectArray[0] == null ? null : CompletableFuture.completedFuture(objectArray[0]);
                }, false, false, false);
                if (objectArray[0] == null) continue;
                return (V)objectArray[0];
            } while (completableFuture2 != null);
            return null;
        }

        @Override
        public @Nullable V merge(K k, V v, BiFunction<? super V, ? super V, ? extends V> biFunction) {
            CompletableFuture completableFuture3;
            Objects.requireNonNull(v);
            Objects.requireNonNull(biFunction);
            CompletableFuture<V> completableFuture4 = CompletableFuture.completedFuture(v);
            boolean[] blArray = new boolean[]{false};
            do {
                Async.getWhenSuccessful((CompletableFuture)this.delegate.get(k));
                completableFuture3 = this.delegate.merge(k, completableFuture4, (completableFuture, completableFuture2) -> {
                    if (completableFuture != null && !completableFuture.isDone()) {
                        return completableFuture;
                    }
                    blArray[0] = true;
                    Object v = Async.getIfReady(completableFuture);
                    if (v == null) {
                        return completableFuture2;
                    }
                    Object r = biFunction.apply((Object)v, (Object)v);
                    if (r == null) {
                        return null;
                    }
                    if (r == v) {
                        return completableFuture;
                    }
                    if (r == v) {
                        return completableFuture2;
                    }
                    return CompletableFuture.completedFuture(r);
                });
            } while (!blArray[0] && completableFuture3 != completableFuture4);
            return Async.getWhenSuccessful(completableFuture3);
        }

        @Override
        public Set<K> keySet() {
            return this.delegate.keySet();
        }

        @Override
        public Collection<V> values() {
            return this.values == null ? (this.values = new Values()) : this.values;
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return this.entries == null ? (this.entries = new EntrySet()) : this.entries;
        }

        private /* synthetic */ CompletableFuture lambda$computeIfAbsent$4(Function function, Object object, CompletableFuture[] completableFutureArray, Object object2, CompletableFuture completableFuture) {
            if (completableFuture != null && completableFuture.isDone() && Async.getIfReady(completableFuture) != null) {
                return completableFuture;
            }
            Object r = this.delegate.statsAware(function, true).apply(object);
            if (r == null) {
                return null;
            }
            completableFutureArray[0] = CompletableFuture.completedFuture(r);
            return completableFutureArray[0];
        }

        private final class EntrySet
        extends AbstractSet<Map.Entry<K, V>> {
            private EntrySet() {
            }

            @Override
            public boolean isEmpty() {
                return AsMapView.this.isEmpty();
            }

            @Override
            public int size() {
                return AsMapView.this.size();
            }

            @Override
            public boolean contains(Object object) {
                if (!(object instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry entry = (Map.Entry)object;
                Object v = AsMapView.this.get(entry.getKey());
                return v != null && v.equals(entry.getValue());
            }

            @Override
            public boolean remove(Object object) {
                if (!(object instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry entry = (Map.Entry)object;
                return AsMapView.this.remove(entry.getKey(), entry.getValue());
            }

            @Override
            public void clear() {
                AsMapView.this.clear();
            }

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return new Iterator<Map.Entry<K, V>>(){
                    Iterator<Map.Entry<K, CompletableFuture<V>>> iterator;
                    @Nullable Map.Entry<K, V> cursor;
                    @Nullable K removalKey;
                    {
                        this.iterator = AsMapView.this.delegate.entrySet().iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        while (this.cursor == null && this.iterator.hasNext()) {
                            Map.Entry entry = this.iterator.next();
                            Object v = Async.getIfReady(entry.getValue());
                            if (v == null) continue;
                            this.cursor = new WriteThroughEntry(AsMapView.this, entry.getKey(), v);
                        }
                        return this.cursor != null;
                    }

                    @Override
                    public Map.Entry<K, V> next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        Object k = this.cursor.getKey();
                        Map.Entry entry = this.cursor;
                        this.removalKey = k;
                        this.cursor = null;
                        return entry;
                    }

                    @Override
                    public void remove() {
                        Caffeine.requireState(this.removalKey != null);
                        AsMapView.this.delegate.remove(this.removalKey);
                        this.removalKey = null;
                    }
                };
            }
        }

        private final class Values
        extends AbstractCollection<V> {
            private Values() {
            }

            @Override
            public boolean isEmpty() {
                return AsMapView.this.isEmpty();
            }

            @Override
            public int size() {
                return AsMapView.this.size();
            }

            @Override
            public boolean contains(Object object) {
                return AsMapView.this.containsValue(object);
            }

            @Override
            public void clear() {
                AsMapView.this.clear();
            }

            @Override
            public Iterator<V> iterator() {
                return new Iterator<V>(){
                    Iterator<Map.Entry<K, V>> iterator;
                    {
                        this.iterator = AsMapView.this.entrySet().iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.iterator.hasNext();
                    }

                    @Override
                    public V next() {
                        return this.iterator.next().getValue();
                    }

                    @Override
                    public void remove() {
                        this.iterator.remove();
                    }
                };
            }
        }
    }

    public static abstract class AbstractCacheView<K, V>
    implements Cache<K, V>,
    Serializable {
        transient @Nullable AsMapView<K, V> asMapView;

        abstract LocalAsyncCache<K, V> asyncCache();

        @Override
        public @Nullable V getIfPresent(Object object) {
            CompletableFuture<V> completableFuture = this.asyncCache().cache().getIfPresent(object, true);
            return Async.getIfReady(completableFuture);
        }

        @Override
        public Map<K, V> getAllPresent(Iterable<?> iterable) {
            Object object2;
            LinkedHashSet linkedHashSet = new LinkedHashSet();
            for (Object object2 : iterable) {
                linkedHashSet.add(object2);
            }
            int n = 0;
            object2 = new LinkedHashMap();
            for (Object e : linkedHashSet) {
                CompletableFuture completableFuture = (CompletableFuture)this.asyncCache().cache().get(e);
                Object v = Async.getIfReady(completableFuture);
                if (v == null) {
                    ++n;
                    continue;
                }
                object2.put(e, v);
            }
            this.asyncCache().cache().statsCounter().recordMisses(n);
            this.asyncCache().cache().statsCounter().recordHits(object2.size());
            Object object3 = object2;
            return Collections.unmodifiableMap(object3);
        }

        @Override
        public V get(K k, Function<? super K, ? extends V> function) {
            return AbstractCacheView.resolve(this.asyncCache().get((K)k, function));
        }

        @Override
        public Map<K, V> getAll(Iterable<? extends K> iterable, Function<Iterable<? extends K>, Map<K, V>> function) {
            return AbstractCacheView.resolve(this.asyncCache().getAll(iterable, function));
        }

        protected static <T> T resolve(CompletableFuture<T> completableFuture) {
            try {
                return completableFuture.get();
            }
            catch (ExecutionException executionException) {
                if (executionException.getCause() instanceof AsyncBulkCompleter.NullMapCompletionException) {
                    throw new NullPointerException(executionException.getCause().getMessage());
                }
                if (executionException.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)executionException.getCause();
                }
                if (executionException.getCause() instanceof Error) {
                    throw (Error)executionException.getCause();
                }
                throw new CompletionException(executionException.getCause());
            }
            catch (InterruptedException interruptedException) {
                throw new CompletionException(interruptedException);
            }
        }

        @Override
        public void put(K k, V v) {
            Objects.requireNonNull(v);
            this.asyncCache().cache().put(k, CompletableFuture.completedFuture(v));
        }

        @Override
        public void putAll(Map<? extends K, ? extends V> map) {
            map.forEach(this::put);
        }

        @Override
        public void invalidate(Object object) {
            this.asyncCache().cache().remove(object);
        }

        @Override
        public void invalidateAll(Iterable<?> iterable) {
            this.asyncCache().cache().invalidateAll(iterable);
        }

        @Override
        public void invalidateAll() {
            this.asyncCache().cache().clear();
        }

        @Override
        public long estimatedSize() {
            return this.asyncCache().cache().size();
        }

        @Override
        public CacheStats stats() {
            return this.asyncCache().cache().statsCounter().snapshot();
        }

        @Override
        public void cleanUp() {
            this.asyncCache().cache().cleanUp();
        }

        @Override
        public Policy<K, V> policy() {
            return this.asyncCache().policy();
        }

        @Override
        public ConcurrentMap<K, V> asMap() {
            return this.asMapView == null ? (this.asMapView = new AsMapView<K, V>(this.asyncCache().cache())) : this.asMapView;
        }
    }

    public static final class CacheView<K, V>
    extends AbstractCacheView<K, V> {
        private static final long serialVersionUID = 1L;
        final LocalAsyncCache<K, V> asyncCache;

        CacheView(LocalAsyncCache<K, V> localAsyncCache) {
            this.asyncCache = Objects.requireNonNull(localAsyncCache);
        }

        @Override
        LocalAsyncCache<K, V> asyncCache() {
            return this.asyncCache;
        }
    }

    public static final class AsyncAsMapView<K, V>
    implements ConcurrentMap<K, CompletableFuture<V>> {
        final LocalAsyncCache<K, V> asyncCache;

        AsyncAsMapView(LocalAsyncCache<K, V> localAsyncCache) {
            this.asyncCache = Objects.requireNonNull(localAsyncCache);
        }

        @Override
        public boolean isEmpty() {
            return this.asyncCache.cache().isEmpty();
        }

        @Override
        public int size() {
            return this.asyncCache.cache().size();
        }

        @Override
        public void clear() {
            this.asyncCache.cache().clear();
        }

        @Override
        public boolean containsKey(Object object) {
            return this.asyncCache.cache().containsKey(object);
        }

        @Override
        public boolean containsValue(Object object) {
            return this.asyncCache.cache().containsValue(object);
        }

        @Override
        public @Nullable CompletableFuture<V> get(Object object) {
            return (CompletableFuture)this.asyncCache.cache().get(object);
        }

        @Override
        public CompletableFuture<V> putIfAbsent(K k, CompletableFuture<V> completableFuture) {
            CompletableFuture<V> completableFuture2 = this.asyncCache.cache().putIfAbsent(k, completableFuture);
            long l = this.asyncCache.cache().statsTicker().read();
            if (completableFuture2 == null) {
                this.asyncCache.handleCompletion(k, completableFuture, l, false);
            }
            return completableFuture2;
        }

        @Override
        public CompletableFuture<V> put(K k, CompletableFuture<V> completableFuture) {
            CompletableFuture<V> completableFuture2 = this.asyncCache.cache().put(k, completableFuture);
            long l = this.asyncCache.cache().statsTicker().read();
            this.asyncCache.handleCompletion(k, completableFuture, l, false);
            return completableFuture2;
        }

        @Override
        public void putAll(Map<? extends K, ? extends CompletableFuture<V>> map) {
            map.forEach(this::put);
        }

        @Override
        public CompletableFuture<V> replace(K k, CompletableFuture<V> completableFuture) {
            CompletableFuture<V> completableFuture2 = this.asyncCache.cache().replace(k, completableFuture);
            long l = this.asyncCache.cache().statsTicker().read();
            if (completableFuture2 != null) {
                this.asyncCache.handleCompletion(k, completableFuture, l, false);
            }
            return completableFuture2;
        }

        @Override
        public boolean replace(K k, CompletableFuture<V> completableFuture, CompletableFuture<V> completableFuture2) {
            boolean bl = this.asyncCache.cache().replace(k, completableFuture, completableFuture2);
            long l = this.asyncCache.cache().statsTicker().read();
            if (bl) {
                this.asyncCache.handleCompletion(k, completableFuture2, l, false);
            }
            return bl;
        }

        @Override
        public CompletableFuture<V> remove(Object object) {
            return (CompletableFuture)this.asyncCache.cache().remove(object);
        }

        @Override
        public boolean remove(Object object, Object object2) {
            return this.asyncCache.cache().remove(object, object2);
        }

        @Override
        public @Nullable CompletableFuture<V> computeIfAbsent(K k, Function<? super K, ? extends CompletableFuture<V>> function) {
            Objects.requireNonNull(function);
            CompletableFuture[] completableFutureArray = new CompletableFuture[1];
            long l = this.asyncCache.cache().statsTicker().read();
            CompletableFuture completableFuture = this.asyncCache.cache().computeIfAbsent(k, object -> {
                completableFutureArray[0] = (CompletableFuture)function.apply((Object)object);
                return completableFutureArray[0];
            }, false, false);
            if (completableFutureArray[0] == null) {
                if (completableFuture != null && this.asyncCache.cache().isRecordingStats()) {
                    completableFuture.whenComplete((object, throwable) -> {
                        if (object != null || throwable == null) {
                            this.asyncCache.cache().statsCounter().recordHits(1);
                        }
                    });
                }
            } else {
                this.asyncCache.handleCompletion(k, completableFutureArray[0], l, true);
            }
            return completableFuture;
        }

        @Override
        public CompletableFuture<V> computeIfPresent(K k, BiFunction<? super K, ? super CompletableFuture<V>, ? extends CompletableFuture<V>> biFunction) {
            Objects.requireNonNull(biFunction);
            CompletableFuture[] completableFutureArray = new CompletableFuture[1];
            long l = this.asyncCache.cache().statsTicker().read();
            this.asyncCache.cache().compute(k, (object, completableFuture) -> {
                completableFutureArray[0] = completableFuture == null ? null : (CompletableFuture)biFunction.apply((Object)object, (Object)completableFuture);
                return completableFutureArray[0];
            }, false, false, false);
            if (completableFutureArray[0] != null) {
                this.asyncCache.handleCompletion(k, completableFutureArray[0], l, false);
            }
            return completableFutureArray[0];
        }

        @Override
        public CompletableFuture<V> compute(K k, BiFunction<? super K, ? super CompletableFuture<V>, ? extends CompletableFuture<V>> biFunction) {
            Objects.requireNonNull(biFunction);
            CompletableFuture[] completableFutureArray = new CompletableFuture[1];
            long l = this.asyncCache.cache().statsTicker().read();
            this.asyncCache.cache().compute(k, (object, completableFuture) -> {
                completableFutureArray[0] = (CompletableFuture)biFunction.apply((Object)object, (Object)completableFuture);
                return completableFutureArray[0];
            }, false, false, false);
            if (completableFutureArray[0] != null) {
                this.asyncCache.handleCompletion(k, completableFutureArray[0], l, false);
            }
            return completableFutureArray[0];
        }

        @Override
        public CompletableFuture<V> merge(K k, CompletableFuture<V> completableFuture, BiFunction<? super CompletableFuture<V>, ? super CompletableFuture<V>, ? extends CompletableFuture<V>> biFunction) {
            Objects.requireNonNull(completableFuture);
            Objects.requireNonNull(biFunction);
            CompletableFuture[] completableFutureArray = new CompletableFuture[1];
            long l = this.asyncCache.cache().statsTicker().read();
            this.asyncCache.cache().compute(k, (object, completableFuture2) -> {
                completableFutureArray[0] = completableFuture2 == null ? completableFuture : (CompletableFuture)biFunction.apply((Object)completableFuture2, (Object)completableFuture);
                return completableFutureArray[0];
            }, false, false, false);
            if (completableFutureArray[0] != null) {
                this.asyncCache.handleCompletion(k, completableFutureArray[0], l, false);
            }
            return completableFutureArray[0];
        }

        @Override
        public Set<K> keySet() {
            return this.asyncCache.cache().keySet();
        }

        @Override
        public Collection<CompletableFuture<V>> values() {
            return this.asyncCache.cache().values();
        }

        @Override
        public Set<Map.Entry<K, CompletableFuture<V>>> entrySet() {
            return this.asyncCache.cache().entrySet();
        }

        @Override
        public boolean equals(Object object) {
            return this.asyncCache.cache().equals(object);
        }

        @Override
        public int hashCode() {
            return this.asyncCache.cache().hashCode();
        }

        public String toString() {
            return this.asyncCache.cache().toString();
        }
    }

    public static final class AsyncBulkCompleter<K, V>
    implements BiConsumer<Map<K, V>, Throwable> {
        private final LocalCache<K, CompletableFuture<V>> cache;
        private final Map<K, CompletableFuture<V>> proxies;
        private final long startTime;

        AsyncBulkCompleter(LocalCache<K, CompletableFuture<V>> localCache, Map<K, CompletableFuture<V>> map) {
            this.startTime = localCache.statsTicker().read();
            this.proxies = map;
            this.cache = localCache;
        }

        @Override
        public void accept(@Nullable Map<K, V> map, @Nullable Throwable throwable) {
            long l = this.cache.statsTicker().read() - this.startTime;
            if (map == null) {
                if (throwable == null) {
                    throwable = new NullMapCompletionException();
                }
                for (Map.Entry<K, CompletableFuture<V>> entry : this.proxies.entrySet()) {
                    this.cache.remove(entry.getKey(), entry.getValue());
                    entry.getValue().obtrudeException(throwable);
                }
                this.cache.statsCounter().recordLoadFailure(l);
                logger.log(Level.WARNING, "Exception thrown during asynchronous load", throwable);
            } else {
                this.fillProxies(map);
                this.addNewEntries(map);
                this.cache.statsCounter().recordLoadSuccess(l);
            }
        }

        private void fillProxies(Map<K, V> map) {
            this.proxies.forEach((object, completableFuture) -> {
                Object v = map.get(object);
                completableFuture.obtrudeValue(v);
                if (v == null) {
                    this.cache.remove(object, completableFuture);
                } else {
                    this.cache.replace(object, (CompletableFuture<CompletableFuture>)completableFuture, (CompletableFuture<CompletableFuture>)completableFuture);
                }
            });
        }

        private void addNewEntries(Map<K, V> map) {
            if (this.proxies.size() == map.size()) {
                return;
            }
            map.forEach((object, object2) -> {
                if (!this.proxies.containsKey(object)) {
                    this.cache.put(object, CompletableFuture.completedFuture(object2));
                }
            });
        }

        static final class NullMapCompletionException
        extends CompletionException {
            private static final long serialVersionUID = 1L;

            public NullMapCompletionException() {
                super("null map", null);
            }
        }
    }
}

