/*
 * Decompiled with CFR 0.152.
 */
package org.skills.utils.caffeine.cache;

import java.io.Serializable;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.skills.utils.caffeine.cache.DisabledFuture;
import org.skills.utils.caffeine.cache.Scheduler;
import org.skills.utils.caffeine.checkerframework.checker.nullness.qual.NonNull;

final class GuardedScheduler
implements Scheduler,
Serializable {
    static final Logger logger = Logger.getLogger(GuardedScheduler.class.getName());
    static final long serialVersionUID = 1L;
    final Scheduler delegate;

    GuardedScheduler(Scheduler scheduler) {
        this.delegate = Objects.requireNonNull(scheduler);
    }

    @Override
    public @NonNull Future<?> schedule(@NonNull Executor executor, @NonNull Runnable runnable, long l, @NonNull TimeUnit timeUnit) {
        try {
            Future<?> future = this.delegate.schedule(executor, runnable, l, timeUnit);
            return future == null ? DisabledFuture.INSTANCE : future;
        }
        catch (Throwable throwable) {
            logger.log(Level.WARNING, "Exception thrown by scheduler; discarded task", throwable);
            return DisabledFuture.INSTANCE;
        }
    }
}

