/*
 * Decompiled with CFR 0.152.
 */
package org.skills.utils.caffeine.cache;

import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.skills.utils.caffeine.cache.Caffeine;
import org.skills.utils.caffeine.checkerframework.checker.nullness.qual.NonNull;
import org.skills.utils.caffeine.checkerframework.checker.nullness.qual.Nullable;

public final class CaffeineSpec {
    static final String SPLIT_OPTIONS = ",";
    static final String SPLIT_KEY_VALUE = "=";
    final String specification;
    int initialCapacity = -1;
    long maximumWeight = -1L;
    long maximumSize = -1L;
    boolean recordStats;
    @Nullable Caffeine.Strength keyStrength;
    @Nullable Caffeine.Strength valueStrength;
    long expireAfterAccessDuration = -1L;
    @Nullable TimeUnit expireAfterAccessTimeUnit;
    long expireAfterWriteDuration = -1L;
    @Nullable TimeUnit expireAfterWriteTimeUnit;
    long refreshAfterWriteDuration = -1L;
    @Nullable TimeUnit refreshAfterWriteTimeUnit;

    private CaffeineSpec(String string) {
        this.specification = Objects.requireNonNull(string);
    }

    Caffeine<Object, Object> toBuilder() {
        Caffeine<Object, Object> caffeine = Caffeine.newBuilder();
        if (this.initialCapacity != -1) {
            caffeine.initialCapacity(this.initialCapacity);
        }
        if (this.maximumSize != -1L) {
            caffeine.maximumSize(this.maximumSize);
        }
        if (this.maximumWeight != -1L) {
            caffeine.maximumWeight(this.maximumWeight);
        }
        if (this.keyStrength != null) {
            Caffeine.requireState(this.keyStrength == Caffeine.Strength.WEAK);
            caffeine.weakKeys();
        }
        if (this.valueStrength != null) {
            if (this.valueStrength == Caffeine.Strength.WEAK) {
                caffeine.weakValues();
            } else if (this.valueStrength == Caffeine.Strength.SOFT) {
                caffeine.softValues();
            } else {
                throw new IllegalStateException();
            }
        }
        if (this.expireAfterAccessTimeUnit != null) {
            caffeine.expireAfterAccess(this.expireAfterAccessDuration, this.expireAfterAccessTimeUnit);
        }
        if (this.expireAfterWriteTimeUnit != null) {
            caffeine.expireAfterWrite(this.expireAfterWriteDuration, this.expireAfterWriteTimeUnit);
        }
        if (this.refreshAfterWriteTimeUnit != null) {
            caffeine.refreshAfterWrite(this.refreshAfterWriteDuration, this.refreshAfterWriteTimeUnit);
        }
        if (this.recordStats) {
            caffeine.recordStats();
        }
        return caffeine;
    }

    public static @NonNull CaffeineSpec parse(@NonNull String string) {
        CaffeineSpec caffeineSpec = new CaffeineSpec(string);
        for (String string2 : string.split(SPLIT_OPTIONS)) {
            caffeineSpec.parseOption(string2.trim());
        }
        return caffeineSpec;
    }

    void parseOption(String string) {
        if (string.isEmpty()) {
            return;
        }
        String[] stringArray = string.split(SPLIT_KEY_VALUE);
        Caffeine.requireArgument(stringArray.length <= 2, "key-value pair %s with more than one equals sign", string);
        String string2 = stringArray[0].trim();
        String string3 = stringArray.length == 1 ? null : stringArray[1].trim();
        this.configure(string2, string3);
    }

    void configure(String string, @Nullable String string2) {
        switch (string) {
            case "initialCapacity": {
                this.initialCapacity(string, string2);
                return;
            }
            case "maximumSize": {
                this.maximumSize(string, string2);
                return;
            }
            case "maximumWeight": {
                this.maximumWeight(string, string2);
                return;
            }
            case "weakKeys": {
                this.weakKeys(string2);
                return;
            }
            case "weakValues": {
                this.valueStrength(string, string2, Caffeine.Strength.WEAK);
                return;
            }
            case "softValues": {
                this.valueStrength(string, string2, Caffeine.Strength.SOFT);
                return;
            }
            case "expireAfterAccess": {
                this.expireAfterAccess(string, string2);
                return;
            }
            case "expireAfterWrite": {
                this.expireAfterWrite(string, string2);
                return;
            }
            case "refreshAfterWrite": {
                this.refreshAfterWrite(string, string2);
                return;
            }
            case "recordStats": {
                this.recordStats(string2);
                return;
            }
        }
        throw new IllegalArgumentException("Unknown key " + string);
    }

    void initialCapacity(String string, @Nullable String string2) {
        Caffeine.requireArgument(this.initialCapacity == -1, "initial capacity was already set to %,d", this.initialCapacity);
        this.initialCapacity = CaffeineSpec.parseInt(string, string2);
    }

    void maximumSize(String string, @Nullable String string2) {
        Caffeine.requireArgument(this.maximumSize == -1L, "maximum size was already set to %,d", this.maximumSize);
        Caffeine.requireArgument(this.maximumWeight == -1L, "maximum weight was already set to %,d", this.maximumWeight);
        this.maximumSize = CaffeineSpec.parseLong(string, string2);
    }

    void maximumWeight(String string, @Nullable String string2) {
        Caffeine.requireArgument(this.maximumWeight == -1L, "maximum weight was already set to %,d", this.maximumWeight);
        Caffeine.requireArgument(this.maximumSize == -1L, "maximum size was already set to %,d", this.maximumSize);
        this.maximumWeight = CaffeineSpec.parseLong(string, string2);
    }

    void weakKeys(@Nullable String string) {
        Caffeine.requireArgument(string == null, "weak keys does not take a value", new Object[0]);
        Caffeine.requireArgument(this.keyStrength == null, "weak keys was already set", new Object[0]);
        this.keyStrength = Caffeine.Strength.WEAK;
    }

    void valueStrength(String string, @Nullable String string2, Caffeine.Strength strength) {
        Caffeine.requireArgument(string2 == null, "%s does not take a value", string);
        Caffeine.requireArgument(this.valueStrength == null, "%s was already set to %s", new Object[]{string, this.valueStrength});
        this.valueStrength = strength;
    }

    void expireAfterAccess(String string, @Nullable String string2) {
        Caffeine.requireArgument(this.expireAfterAccessDuration == -1L, "expireAfterAccess was already set", new Object[0]);
        this.expireAfterAccessDuration = CaffeineSpec.parseDuration(string, string2);
        this.expireAfterAccessTimeUnit = CaffeineSpec.parseTimeUnit(string, string2);
    }

    void expireAfterWrite(String string, @Nullable String string2) {
        Caffeine.requireArgument(this.expireAfterWriteDuration == -1L, "expireAfterWrite was already set", new Object[0]);
        this.expireAfterWriteDuration = CaffeineSpec.parseDuration(string, string2);
        this.expireAfterWriteTimeUnit = CaffeineSpec.parseTimeUnit(string, string2);
    }

    void refreshAfterWrite(String string, @Nullable String string2) {
        Caffeine.requireArgument(this.refreshAfterWriteDuration == -1L, "refreshAfterWrite was already set", new Object[0]);
        this.refreshAfterWriteDuration = CaffeineSpec.parseDuration(string, string2);
        this.refreshAfterWriteTimeUnit = CaffeineSpec.parseTimeUnit(string, string2);
    }

    void recordStats(@Nullable String string) {
        Caffeine.requireArgument(string == null, "record stats does not take a value", new Object[0]);
        Caffeine.requireArgument(!this.recordStats, "record stats was already set", new Object[0]);
        this.recordStats = true;
    }

    static int parseInt(String string, @Nullable String string2) {
        Caffeine.requireArgument(string2 != null && !string2.isEmpty(), "value of key %s was omitted", string);
        try {
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException(String.format("key %s value was set to %s, must be an integer", string, string2), numberFormatException);
        }
    }

    static long parseLong(String string, @Nullable String string2) {
        Caffeine.requireArgument(string2 != null && !string2.isEmpty(), "value of key %s was omitted", string);
        try {
            return Long.parseLong(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException(String.format("key %s value was set to %s, must be a long", string, string2), numberFormatException);
        }
    }

    static long parseDuration(String string, @Nullable String string2) {
        Caffeine.requireArgument(string2 != null && !string2.isEmpty(), "value of key %s omitted", string);
        String string3 = string2.substring(0, string2.length() - 1);
        return CaffeineSpec.parseLong(string, string3);
    }

    static TimeUnit parseTimeUnit(String string, @Nullable String string2) {
        Caffeine.requireArgument(string2 != null && !string2.isEmpty(), "value of key %s omitted", string);
        char c = Character.toLowerCase(string2.charAt(string2.length() - 1));
        switch (c) {
            case 'd': {
                return TimeUnit.DAYS;
            }
            case 'h': {
                return TimeUnit.HOURS;
            }
            case 'm': {
                return TimeUnit.MINUTES;
            }
            case 's': {
                return TimeUnit.SECONDS;
            }
        }
        throw new IllegalArgumentException(String.format("key %s invalid format; was %s, must end with one of [dDhHmMsS]", string, string2));
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof CaffeineSpec)) {
            return false;
        }
        CaffeineSpec caffeineSpec = (CaffeineSpec)object;
        return Objects.equals(this.initialCapacity, caffeineSpec.initialCapacity) && Objects.equals(this.maximumSize, caffeineSpec.maximumSize) && Objects.equals(this.maximumWeight, caffeineSpec.maximumWeight) && Objects.equals((Object)this.keyStrength, (Object)caffeineSpec.keyStrength) && Objects.equals((Object)this.valueStrength, (Object)caffeineSpec.valueStrength) && Objects.equals(this.recordStats, caffeineSpec.recordStats) && CaffeineSpec.durationInNanos(this.expireAfterAccessDuration, this.expireAfterAccessTimeUnit) == CaffeineSpec.durationInNanos(caffeineSpec.expireAfterAccessDuration, caffeineSpec.expireAfterAccessTimeUnit) && CaffeineSpec.durationInNanos(this.expireAfterWriteDuration, this.expireAfterWriteTimeUnit) == CaffeineSpec.durationInNanos(caffeineSpec.expireAfterWriteDuration, caffeineSpec.expireAfterWriteTimeUnit) && CaffeineSpec.durationInNanos(this.refreshAfterWriteDuration, this.refreshAfterWriteTimeUnit) == CaffeineSpec.durationInNanos(caffeineSpec.refreshAfterWriteDuration, caffeineSpec.refreshAfterWriteTimeUnit);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.initialCapacity, this.maximumSize, this.maximumWeight, this.keyStrength, this.valueStrength, this.recordStats, CaffeineSpec.durationInNanos(this.expireAfterAccessDuration, this.expireAfterAccessTimeUnit), CaffeineSpec.durationInNanos(this.expireAfterWriteDuration, this.expireAfterWriteTimeUnit), CaffeineSpec.durationInNanos(this.refreshAfterWriteDuration, this.refreshAfterWriteTimeUnit)});
    }

    static long durationInNanos(long l, @Nullable TimeUnit timeUnit) {
        return timeUnit == null ? -1L : timeUnit.toNanos(l);
    }

    public String toParsableString() {
        return this.specification;
    }

    public String toString() {
        return this.getClass().getSimpleName() + '{' + this.toParsableString() + '}';
    }
}

