/*
 * Decompiled with CFR 0.152.
 */
package org.skills.utils.caffeine.cache;

import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Set;
import java.util.Spliterator;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import org.skills.utils.caffeine.cache.AccessOrderDeque;
import org.skills.utils.caffeine.cache.Async;
import org.skills.utils.caffeine.cache.AsyncCacheLoader;
import org.skills.utils.caffeine.cache.BLCHeader;
import org.skills.utils.caffeine.cache.BoundedBuffer;
import org.skills.utils.caffeine.cache.Buffer;
import org.skills.utils.caffeine.cache.Cache;
import org.skills.utils.caffeine.cache.CacheLoader;
import org.skills.utils.caffeine.cache.CacheWriter;
import org.skills.utils.caffeine.cache.Caffeine;
import org.skills.utils.caffeine.cache.Expiry;
import org.skills.utils.caffeine.cache.FrequencySketch;
import org.skills.utils.caffeine.cache.LinkedDeque;
import org.skills.utils.caffeine.cache.LocalAsyncCache;
import org.skills.utils.caffeine.cache.LocalAsyncLoadingCache;
import org.skills.utils.caffeine.cache.LocalCache;
import org.skills.utils.caffeine.cache.LocalCacheFactory;
import org.skills.utils.caffeine.cache.LocalLoadingCache;
import org.skills.utils.caffeine.cache.LocalManualCache;
import org.skills.utils.caffeine.cache.MpscGrowableArrayQueue;
import org.skills.utils.caffeine.cache.Node;
import org.skills.utils.caffeine.cache.NodeFactory;
import org.skills.utils.caffeine.cache.Pacer;
import org.skills.utils.caffeine.cache.Policy;
import org.skills.utils.caffeine.cache.References;
import org.skills.utils.caffeine.cache.RemovalCause;
import org.skills.utils.caffeine.cache.RemovalListener;
import org.skills.utils.caffeine.cache.SerializationProxy;
import org.skills.utils.caffeine.cache.Ticker;
import org.skills.utils.caffeine.cache.TimerWheel;
import org.skills.utils.caffeine.cache.Weigher;
import org.skills.utils.caffeine.cache.WriteOrderDeque;
import org.skills.utils.caffeine.cache.WriteThroughEntry;
import org.skills.utils.caffeine.cache.stats.StatsCounter;
import org.skills.utils.caffeine.checkerframework.checker.nullness.qual.NonNull;
import org.skills.utils.caffeine.checkerframework.checker.nullness.qual.Nullable;
import org.skills.utils.caffeine.errorprone.annotations.concurrent.GuardedBy;

abstract class BoundedLocalCache<K, V>
extends BLCHeader.DrainStatusRef<K, V>
implements LocalCache<K, V> {
    static final Logger logger = Logger.getLogger(BoundedLocalCache.class.getName());
    static final int NCPU = Runtime.getRuntime().availableProcessors();
    static final int WRITE_BUFFER_MIN = 4;
    static final int WRITE_BUFFER_MAX = 128 * Caffeine.ceilingPowerOfTwo(NCPU);
    static final int WRITE_BUFFER_RETRIES = 100;
    static final long MAXIMUM_CAPACITY = 9223372034707292160L;
    static final double PERCENT_MAIN = 0.99;
    static final double PERCENT_MAIN_PROTECTED = 0.8;
    static final double HILL_CLIMBER_RESTART_THRESHOLD = 0.05;
    static final double HILL_CLIMBER_STEP_PERCENT = 0.0625;
    static final double HILL_CLIMBER_STEP_DECAY_RATE = 0.98;
    static final int QUEUE_TRANSFER_THRESHOLD = 1000;
    static final long EXPIRE_WRITE_TOLERANCE = TimeUnit.SECONDS.toNanos(1L);
    static final long MAXIMUM_EXPIRY = 0x3FFFFFFFFFFFFFFFL;
    final ConcurrentHashMap<Object, Node<K, V>> data;
    final @Nullable CacheLoader<K, V> cacheLoader;
    final PerformCleanupTask drainBuffersTask;
    final Consumer<Node<K, V>> accessPolicy;
    final Buffer<Node<K, V>> readBuffer;
    final NodeFactory<K, V> nodeFactory;
    final ReentrantLock evictionLock;
    final CacheWriter<K, V> writer;
    final Weigher<K, V> weigher;
    final Executor executor;
    final boolean isAsync;
    transient @Nullable Set<K> keySet;
    transient @Nullable Collection<V> values;
    transient @Nullable Set<Map.Entry<K, V>> entrySet;

    protected BoundedLocalCache(Caffeine<K, V> caffeine, @Nullable CacheLoader<K, V> cacheLoader, boolean bl) {
        this.isAsync = bl;
        this.cacheLoader = cacheLoader;
        this.executor = caffeine.getExecutor();
        this.writer = caffeine.getCacheWriter();
        this.evictionLock = new ReentrantLock();
        this.weigher = caffeine.getWeigher(bl);
        this.drainBuffersTask = new PerformCleanupTask(this);
        this.nodeFactory = NodeFactory.newFactory(caffeine, bl);
        this.data = new ConcurrentHashMap(caffeine.getInitialCapacity());
        this.readBuffer = this.evicts() || this.collectKeys() || this.collectValues() || this.expiresAfterAccess() ? new BoundedBuffer<Node<K, V>>() : Buffer.disabled();
        Consumer<Node> consumer = this.accessPolicy = this.evicts() || this.expiresAfterAccess() ? this::onAccess : node -> {};
        if (this.evicts()) {
            this.setMaximumSize(caffeine.getMaximum());
        }
    }

    final boolean isComputingAsync(Node<?, ?> node) {
        return this.isAsync && !Async.isReady((CompletableFuture)node.getValue());
    }

    @GuardedBy(value="evictionLock")
    protected AccessOrderDeque<Node<K, V>> accessOrderWindowDeque() {
        throw new UnsupportedOperationException();
    }

    @GuardedBy(value="evictionLock")
    protected AccessOrderDeque<Node<K, V>> accessOrderProbationDeque() {
        throw new UnsupportedOperationException();
    }

    @GuardedBy(value="evictionLock")
    protected AccessOrderDeque<Node<K, V>> accessOrderProtectedDeque() {
        throw new UnsupportedOperationException();
    }

    @GuardedBy(value="evictionLock")
    protected WriteOrderDeque<Node<K, V>> writeOrderDeque() {
        throw new UnsupportedOperationException();
    }

    protected boolean buffersWrites() {
        return false;
    }

    protected MpscGrowableArrayQueue<Runnable> writeBuffer() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final Executor executor() {
        return this.executor;
    }

    protected boolean hasWriter() {
        return this.writer != CacheWriter.disabledWriter();
    }

    @Override
    public boolean isRecordingStats() {
        return false;
    }

    @Override
    public StatsCounter statsCounter() {
        return StatsCounter.disabledStatsCounter();
    }

    @Override
    public Ticker statsTicker() {
        return Ticker.disabledTicker();
    }

    @Override
    public RemovalListener<K, V> removalListener() {
        return null;
    }

    @Override
    public boolean hasRemovalListener() {
        return false;
    }

    @Override
    public void notifyRemoval(@Nullable K k, @Nullable V v, RemovalCause removalCause) {
        Caffeine.requireState(this.hasRemovalListener(), "Notification should be guarded with a check", new Object[0]);
        Runnable runnable = () -> {
            try {
                this.removalListener().onRemoval(k, v, removalCause);
            }
            catch (Throwable throwable) {
                logger.log(Level.WARNING, "Exception thrown by removal listener", throwable);
            }
        };
        try {
            this.executor.execute(runnable);
        }
        catch (Throwable throwable) {
            logger.log(Level.SEVERE, "Exception thrown when submitting removal listener", throwable);
            runnable.run();
        }
    }

    protected boolean collectKeys() {
        return false;
    }

    protected boolean collectValues() {
        return false;
    }

    protected ReferenceQueue<K> keyReferenceQueue() {
        return null;
    }

    protected ReferenceQueue<V> valueReferenceQueue() {
        return null;
    }

    protected @Nullable Pacer pacer() {
        return null;
    }

    protected boolean expiresVariable() {
        return false;
    }

    protected boolean expiresAfterAccess() {
        return false;
    }

    protected long expiresAfterAccessNanos() {
        throw new UnsupportedOperationException();
    }

    protected void setExpiresAfterAccessNanos(long l) {
        throw new UnsupportedOperationException();
    }

    protected boolean expiresAfterWrite() {
        return false;
    }

    protected long expiresAfterWriteNanos() {
        throw new UnsupportedOperationException();
    }

    protected void setExpiresAfterWriteNanos(long l) {
        throw new UnsupportedOperationException();
    }

    protected boolean refreshAfterWrite() {
        return false;
    }

    protected long refreshAfterWriteNanos() {
        throw new UnsupportedOperationException();
    }

    protected void setRefreshAfterWriteNanos(long l) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasWriteTime() {
        return this.expiresAfterWrite() || this.refreshAfterWrite();
    }

    protected Expiry<K, V> expiry() {
        return null;
    }

    @Override
    public Ticker expirationTicker() {
        return Ticker.disabledTicker();
    }

    protected TimerWheel<K, V> timerWheel() {
        throw new UnsupportedOperationException();
    }

    protected boolean evicts() {
        return false;
    }

    protected boolean isWeighted() {
        return this.weigher != Weigher.singletonWeigher();
    }

    protected FrequencySketch<K> frequencySketch() {
        throw new UnsupportedOperationException();
    }

    protected boolean fastpath() {
        return false;
    }

    protected long maximum() {
        throw new UnsupportedOperationException();
    }

    protected long windowMaximum() {
        throw new UnsupportedOperationException();
    }

    protected long mainProtectedMaximum() {
        throw new UnsupportedOperationException();
    }

    @GuardedBy(value="evictionLock")
    protected void setMaximum(long l) {
        throw new UnsupportedOperationException();
    }

    @GuardedBy(value="evictionLock")
    protected void setWindowMaximum(long l) {
        throw new UnsupportedOperationException();
    }

    @GuardedBy(value="evictionLock")
    protected void setMainProtectedMaximum(long l) {
        throw new UnsupportedOperationException();
    }

    protected long weightedSize() {
        throw new UnsupportedOperationException();
    }

    protected long windowWeightedSize() {
        throw new UnsupportedOperationException();
    }

    protected long mainProtectedWeightedSize() {
        throw new UnsupportedOperationException();
    }

    @GuardedBy(value="evictionLock")
    protected void setWeightedSize(long l) {
        throw new UnsupportedOperationException();
    }

    @GuardedBy(value="evictionLock")
    protected void setWindowWeightedSize(long l) {
        throw new UnsupportedOperationException();
    }

    @GuardedBy(value="evictionLock")
    protected void setMainProtectedWeightedSize(long l) {
        throw new UnsupportedOperationException();
    }

    protected int hitsInSample() {
        throw new UnsupportedOperationException();
    }

    protected int missesInSample() {
        throw new UnsupportedOperationException();
    }

    protected int sampleCount() {
        throw new UnsupportedOperationException();
    }

    protected double stepSize() {
        throw new UnsupportedOperationException();
    }

    protected double previousSampleHitRate() {
        throw new UnsupportedOperationException();
    }

    protected long adjustment() {
        throw new UnsupportedOperationException();
    }

    @GuardedBy(value="evictionLock")
    protected void setHitsInSample(int n) {
        throw new UnsupportedOperationException();
    }

    @GuardedBy(value="evictionLock")
    protected void setMissesInSample(int n) {
        throw new UnsupportedOperationException();
    }

    @GuardedBy(value="evictionLock")
    protected void setSampleCount(int n) {
        throw new UnsupportedOperationException();
    }

    @GuardedBy(value="evictionLock")
    protected void setStepSize(double d) {
        throw new UnsupportedOperationException();
    }

    @GuardedBy(value="evictionLock")
    protected void setPreviousSampleHitRate(double d) {
        throw new UnsupportedOperationException();
    }

    @GuardedBy(value="evictionLock")
    protected void setAdjustment(long l) {
        throw new UnsupportedOperationException();
    }

    @GuardedBy(value="evictionLock")
    void setMaximumSize(long l) {
        Caffeine.requireArgument(l >= 0L, "maximum must not be negative", new Object[0]);
        if (l == this.maximum()) {
            return;
        }
        long l2 = Math.min(l, 9223372034707292160L);
        long l3 = l2 - (long)(0.99 * (double)l2);
        long l4 = (long)(0.8 * (double)(l2 - l3));
        this.setMaximum(l2);
        this.setWindowMaximum(l3);
        this.setMainProtectedMaximum(l4);
        this.setHitsInSample(0);
        this.setMissesInSample(0);
        this.setStepSize(-0.0625 * (double)l2);
        if (this.frequencySketch() != null && !this.isWeighted() && this.weightedSize() >= l2 >>> 1) {
            this.frequencySketch().ensureCapacity(l2);
        }
    }

    @GuardedBy(value="evictionLock")
    void evictEntries() {
        if (!this.evicts()) {
            return;
        }
        int n = this.evictFromWindow();
        this.evictFromMain(n);
    }

    @GuardedBy(value="evictionLock")
    int evictFromWindow() {
        int n = 0;
        AccessOrderDeque.AccessOrder accessOrder = (Node)this.accessOrderWindowDeque().peek();
        while (this.windowWeightedSize() > this.windowMaximum() && accessOrder != null) {
            AccessOrderDeque.AccessOrder accessOrder2 = ((Node)accessOrder).getNextInAccessOrder();
            if (((Node)accessOrder).getPolicyWeight() != 0) {
                ((Node)accessOrder).makeMainProbation();
                this.accessOrderWindowDeque().remove((Node<K, V>)accessOrder);
                this.accessOrderProbationDeque().add((Node<K, V>)accessOrder);
                ++n;
                this.setWindowWeightedSize(this.windowWeightedSize() - (long)((Node)accessOrder).getPolicyWeight());
            }
            accessOrder = accessOrder2;
        }
        return n;
    }

    @GuardedBy(value="evictionLock")
    void evictFromMain(int n) {
        int n2 = 1;
        AccessOrderDeque.AccessOrder accessOrder = (Node)this.accessOrderProbationDeque().peekFirst();
        AccessOrderDeque.AccessOrder accessOrder2 = (Node)this.accessOrderProbationDeque().peekLast();
        while (this.weightedSize() > this.maximum()) {
            AccessOrderDeque.AccessOrder accessOrder3;
            AccessOrderDeque.AccessOrder accessOrder4;
            AccessOrderDeque.AccessOrder<Object> accessOrder5;
            if (n == 0) {
                accessOrder2 = null;
            }
            if (accessOrder2 == null && accessOrder == null) {
                if (n2 == 1) {
                    accessOrder = (Node)this.accessOrderProtectedDeque().peekFirst();
                    n2 = 2;
                    continue;
                }
                if (n2 != 2) break;
                accessOrder = (Node)this.accessOrderWindowDeque().peekFirst();
                n2 = 0;
                continue;
            }
            if (accessOrder != null && ((Node)accessOrder).getPolicyWeight() == 0) {
                accessOrder = ((Node)accessOrder).getNextInAccessOrder();
                continue;
            }
            if (accessOrder2 != null && ((Node)accessOrder2).getPolicyWeight() == 0) {
                accessOrder2 = ((Node)accessOrder2).getPreviousInAccessOrder();
                --n;
                continue;
            }
            if (accessOrder == null) {
                accessOrder5 = ((Node)accessOrder2).getPreviousInAccessOrder();
                accessOrder4 = accessOrder2;
                accessOrder2 = accessOrder5;
                --n;
                this.evictEntry((Node<K, V>)accessOrder4, RemovalCause.SIZE, 0L);
                continue;
            }
            if (accessOrder2 == null) {
                accessOrder5 = accessOrder;
                accessOrder = ((Node)accessOrder).getNextInAccessOrder();
                this.evictEntry((Node<K, V>)accessOrder5, RemovalCause.SIZE, 0L);
                continue;
            }
            accessOrder5 = ((Node)accessOrder).getKey();
            accessOrder4 = ((Node)accessOrder2).getKey();
            if (accessOrder5 == null) {
                accessOrder3 = accessOrder;
                accessOrder = ((Node)accessOrder).getNextInAccessOrder();
                this.evictEntry((Node<K, V>)accessOrder3, RemovalCause.COLLECTED, 0L);
                continue;
            }
            if (accessOrder4 == null) {
                --n;
                accessOrder3 = accessOrder2;
                accessOrder2 = ((Node)accessOrder2).getPreviousInAccessOrder();
                this.evictEntry((Node<K, V>)accessOrder3, RemovalCause.COLLECTED, 0L);
                continue;
            }
            if ((long)((Node)accessOrder2).getPolicyWeight() > this.maximum()) {
                --n;
                accessOrder3 = accessOrder2;
                accessOrder2 = ((Node)accessOrder2).getPreviousInAccessOrder();
                this.evictEntry((Node<K, V>)accessOrder3, RemovalCause.SIZE, 0L);
                continue;
            }
            --n;
            if (this.admit(accessOrder4, accessOrder5)) {
                accessOrder3 = accessOrder;
                accessOrder = ((Node)accessOrder).getNextInAccessOrder();
                this.evictEntry((Node<K, V>)accessOrder3, RemovalCause.SIZE, 0L);
                accessOrder2 = ((Node)accessOrder2).getPreviousInAccessOrder();
                continue;
            }
            accessOrder3 = accessOrder2;
            accessOrder2 = ((Node)accessOrder2).getPreviousInAccessOrder();
            this.evictEntry((Node<K, V>)accessOrder3, RemovalCause.SIZE, 0L);
        }
    }

    @GuardedBy(value="evictionLock")
    boolean admit(K k, K k2) {
        int n = this.frequencySketch().frequency(k2);
        int n2 = this.frequencySketch().frequency(k);
        if (n2 > n) {
            return true;
        }
        if (n2 <= 5) {
            return false;
        }
        int n3 = ThreadLocalRandom.current().nextInt();
        return (n3 & 0x7F) == 0;
    }

    @GuardedBy(value="evictionLock")
    void expireEntries() {
        long l;
        long l2 = this.expirationTicker().read();
        this.expireAfterAccessEntries(l2);
        this.expireAfterWriteEntries(l2);
        this.expireVariableEntries(l2);
        Pacer pacer = this.pacer();
        if (pacer != null && (l = this.getExpirationDelay(l2)) != Long.MAX_VALUE) {
            pacer.schedule(this.executor, this.drainBuffersTask, l2, l);
        }
    }

    @GuardedBy(value="evictionLock")
    void expireAfterAccessEntries(long l) {
        if (!this.expiresAfterAccess()) {
            return;
        }
        this.expireAfterAccessEntries(this.accessOrderWindowDeque(), l);
        if (this.evicts()) {
            this.expireAfterAccessEntries(this.accessOrderProbationDeque(), l);
            this.expireAfterAccessEntries(this.accessOrderProtectedDeque(), l);
        }
    }

    @GuardedBy(value="evictionLock")
    void expireAfterAccessEntries(AccessOrderDeque<Node<K, V>> accessOrderDeque, long l) {
        long l2 = this.expiresAfterAccessNanos();
        Node node;
        while ((node = (Node)accessOrderDeque.peekFirst()) != null && l - node.getAccessTime() >= l2) {
            this.evictEntry(node, RemovalCause.EXPIRED, l);
        }
        return;
    }

    @GuardedBy(value="evictionLock")
    void expireAfterWriteEntries(long l) {
        Node node;
        if (!this.expiresAfterWrite()) {
            return;
        }
        long l2 = this.expiresAfterWriteNanos();
        while ((node = (Node)this.writeOrderDeque().peekFirst()) != null && l - node.getWriteTime() >= l2) {
            this.evictEntry(node, RemovalCause.EXPIRED, l);
        }
    }

    @GuardedBy(value="evictionLock")
    void expireVariableEntries(long l) {
        if (this.expiresVariable()) {
            this.timerWheel().advance(l);
        }
    }

    @GuardedBy(value="evictionLock")
    private long getExpirationDelay(long l) {
        Node node;
        long l2 = Long.MAX_VALUE;
        if (this.expiresAfterAccess()) {
            node = (Node)this.accessOrderWindowDeque().peekFirst();
            if (node != null) {
                l2 = Math.min(l2, this.expiresAfterAccessNanos() - (l - node.getAccessTime()));
            }
            if (this.evicts()) {
                node = (Node)this.accessOrderProbationDeque().peekFirst();
                if (node != null) {
                    l2 = Math.min(l2, this.expiresAfterAccessNanos() - (l - node.getAccessTime()));
                }
                if ((node = (Node)this.accessOrderProtectedDeque().peekFirst()) != null) {
                    l2 = Math.min(l2, this.expiresAfterAccessNanos() - (l - node.getAccessTime()));
                }
            }
        }
        if (this.expiresAfterWrite() && (node = (Node)this.writeOrderDeque().peekFirst()) != null) {
            l2 = Math.min(l2, this.expiresAfterWriteNanos() - (l - node.getWriteTime()));
        }
        if (this.expiresVariable()) {
            l2 = Math.min(l2, this.timerWheel().getExpirationDelay());
        }
        return l2;
    }

    boolean hasExpired(Node<K, V> node, long l) {
        return (this.expiresAfterAccess() && l - node.getAccessTime() >= this.expiresAfterAccessNanos()) | (this.expiresAfterWrite() && l - node.getWriteTime() >= this.expiresAfterWriteNanos()) | (this.expiresVariable() && l - node.getVariableTime() >= 0L);
    }

    @GuardedBy(value="evictionLock")
    boolean evictEntry(Node<K, V> node, RemovalCause removalCause, long l) {
        K k = node.getKey();
        Object[] objectArray = new Object[1];
        boolean[] blArray = new boolean[1];
        boolean[] blArray2 = new boolean[1];
        RemovalCause[] removalCauseArray = new RemovalCause[1];
        this.data.computeIfPresent(node.getKeyReference(), (object2, node2) -> {
            if (node2 != node) {
                return node2;
            }
            Node node3 = node2;
            synchronized (node3) {
                int n;
                objectArray[0] = node2.getValue();
                RemovalCause removalCause2 = removalCauseArray[0] = k == null || objectArray[0] == null ? RemovalCause.COLLECTED : removalCause;
                if (removalCauseArray[0] == RemovalCause.EXPIRED) {
                    boolean bl = false;
                    if (this.expiresAfterAccess()) {
                        bl |= l - node2.getAccessTime() >= this.expiresAfterAccessNanos();
                    }
                    if (this.expiresAfterWrite()) {
                        bl |= l - node2.getWriteTime() >= this.expiresAfterWriteNanos();
                    }
                    if (this.expiresVariable()) {
                        bl |= node2.getVariableTime() <= l;
                    }
                    if (!bl) {
                        blArray[0] = true;
                        return node2;
                    }
                } else if (removalCauseArray[0] == RemovalCause.SIZE && (n = node.getWeight()) == 0) {
                    blArray[0] = true;
                    return node2;
                }
                if (k != null) {
                    this.writer.delete(k, objectArray[0], removalCauseArray[0]);
                }
                this.makeDead((Node<K, V>)node2);
            }
            blArray2[0] = true;
            return null;
        });
        if (blArray2[0]) {
            return false;
        }
        if (node.inWindow() && (this.evicts() || this.expiresAfterAccess())) {
            this.accessOrderWindowDeque().remove(node);
        } else if (this.evicts()) {
            if (node.inMainProbation()) {
                this.accessOrderProbationDeque().remove(node);
            } else {
                this.accessOrderProtectedDeque().remove(node);
            }
        }
        if (this.expiresAfterWrite()) {
            this.writeOrderDeque().remove(node);
        } else if (this.expiresVariable()) {
            this.timerWheel().deschedule(node);
        }
        if (blArray[0]) {
            this.statsCounter().recordEviction(node.getWeight(), removalCauseArray[0]);
            if (this.hasRemovalListener()) {
                this.notifyRemoval(k, objectArray[0], removalCauseArray[0]);
            }
        } else {
            this.makeDead(node);
        }
        return true;
    }

    @GuardedBy(value="evictionLock")
    void climb() {
        if (!this.evicts()) {
            return;
        }
        this.determineAdjustment();
        this.demoteFromMainProtected();
        long l = this.adjustment();
        if (l == 0L) {
            return;
        }
        if (l > 0L) {
            this.increaseWindow();
        } else {
            this.decreaseWindow();
        }
    }

    @GuardedBy(value="evictionLock")
    void determineAdjustment() {
        double d;
        if (this.frequencySketch().isNotInitialized()) {
            this.setPreviousSampleHitRate(0.0);
            this.setMissesInSample(0);
            this.setHitsInSample(0);
            return;
        }
        int n = this.hitsInSample() + this.missesInSample();
        if (n < this.frequencySketch().sampleSize) {
            return;
        }
        double d2 = (double)this.hitsInSample() / (double)n;
        double d3 = d2 - this.previousSampleHitRate();
        double d4 = d = d3 >= 0.0 ? this.stepSize() : -this.stepSize();
        double d5 = Math.abs(d3) >= 0.05 ? 0.0625 * (double)this.maximum() * (double)(d >= 0.0 ? 1 : -1) : 0.98 * d;
        this.setPreviousSampleHitRate(d2);
        this.setAdjustment((long)d);
        this.setStepSize(d5);
        this.setMissesInSample(0);
        this.setHitsInSample(0);
    }

    @GuardedBy(value="evictionLock")
    void increaseWindow() {
        if (this.mainProtectedMaximum() == 0L) {
            return;
        }
        long l = Math.min(this.adjustment(), this.mainProtectedMaximum());
        this.setMainProtectedMaximum(this.mainProtectedMaximum() - l);
        this.setWindowMaximum(this.windowMaximum() + l);
        this.demoteFromMainProtected();
        for (int i = 0; i < 1000; ++i) {
            int n;
            Node node = (Node)this.accessOrderProbationDeque().peek();
            boolean bl = true;
            if (node == null || l < (long)node.getPolicyWeight()) {
                node = (Node)this.accessOrderProtectedDeque().peek();
                bl = false;
            }
            if (node == null || l < (long)(n = node.getPolicyWeight())) break;
            l -= (long)n;
            if (bl) {
                this.accessOrderProbationDeque().remove(node);
            } else {
                this.setMainProtectedWeightedSize(this.mainProtectedWeightedSize() - (long)n);
                this.accessOrderProtectedDeque().remove(node);
            }
            this.setWindowWeightedSize(this.windowWeightedSize() + (long)n);
            this.accessOrderWindowDeque().add(node);
            node.makeWindow();
        }
        this.setMainProtectedMaximum(this.mainProtectedMaximum() + l);
        this.setWindowMaximum(this.windowMaximum() - l);
        this.setAdjustment(l);
    }

    @GuardedBy(value="evictionLock")
    void decreaseWindow() {
        Node node;
        int n;
        if (this.windowMaximum() <= 1L) {
            return;
        }
        long l = Math.min(-this.adjustment(), Math.max(0L, this.windowMaximum() - 1L));
        this.setMainProtectedMaximum(this.mainProtectedMaximum() + l);
        this.setWindowMaximum(this.windowMaximum() - l);
        for (int i = 0; i < 1000 && (node = (Node)this.accessOrderWindowDeque().peek()) != null && l >= (long)(n = node.getPolicyWeight()); l -= (long)n, ++i) {
            this.setMainProtectedWeightedSize(this.mainProtectedWeightedSize() + (long)n);
            this.setWindowWeightedSize(this.windowWeightedSize() - (long)n);
            this.accessOrderWindowDeque().remove(node);
            this.accessOrderProbationDeque().add(node);
            node.makeMainProbation();
        }
        this.setMainProtectedMaximum(this.mainProtectedMaximum() - l);
        this.setWindowMaximum(this.windowMaximum() + l);
        this.setAdjustment(-l);
    }

    @GuardedBy(value="evictionLock")
    void demoteFromMainProtected() {
        Node node;
        long l = this.mainProtectedMaximum();
        long l2 = this.mainProtectedWeightedSize();
        if (l2 <= l) {
            return;
        }
        for (int i = 0; i < 1000 && l2 > l && (node = (Node)this.accessOrderProtectedDeque().poll()) != null; l2 -= (long)node.getPolicyWeight(), ++i) {
            node.makeMainProbation();
            this.accessOrderProbationDeque().add(node);
        }
        this.setMainProtectedWeightedSize(l2);
    }

    void afterRead(Node<K, V> node, long l, boolean bl) {
        boolean bl2;
        if (bl) {
            this.statsCounter().recordHits(1);
        }
        boolean bl3 = bl2 = this.skipReadBuffer() || this.readBuffer.offer(node) != 1;
        if (this.shouldDrainBuffers(bl2)) {
            this.scheduleDrainBuffers();
        }
        this.refreshIfNeeded(node, l);
    }

    boolean skipReadBuffer() {
        return this.fastpath() && this.frequencySketch().isNotInitialized();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void refreshIfNeeded(Node<K, V> node, long l) {
        if (!this.refreshAfterWrite()) {
            return;
        }
        long l2 = node.getWriteTime();
        long l3 = l + 0x5FFFFFFFFFFFFFFEL;
        if (l - l2 <= this.refreshAfterWriteNanos()) return;
        K k = node.getKey();
        if (k == null) return;
        V v = node.getValue();
        if (v == null) return;
        if (!node.casWriteTime(l2, l3)) return;
        try {
            void var10_13;
            long l4 = this.statsTicker().read();
            if (this.isAsync) {
                CompletionStage completionStage;
                CompletableFuture completableFuture = (CompletableFuture)v;
                if (!Async.isReady(completableFuture)) {
                    node.casWriteTime(l3, l2);
                    return;
                }
                CompletionStage completionStage2 = completionStage = completableFuture.thenCompose(object2 -> this.cacheLoader.asyncReload(k, object2, this.executor));
            } else {
                CompletableFuture<V> completableFuture;
                CompletableFuture<V> completableFuture2 = completableFuture = this.cacheLoader.asyncReload(k, v, this.executor);
            }
            var10_13.whenComplete((arg_0, arg_1) -> this.lambda$refreshIfNeeded$5(l4, node, l3, l2, (CompletableFuture)var10_13, k, v, arg_0, arg_1));
            return;
        }
        catch (Throwable throwable) {
            node.casWriteTime(l3, l2);
            logger.log(Level.SEVERE, "Exception thrown when submitting refresh task", throwable);
        }
    }

    long expireAfterCreate(@Nullable K k, @Nullable V v, Expiry<K, V> expiry, long l) {
        if (this.expiresVariable() && k != null && v != null) {
            long l2 = expiry.expireAfterCreate(k, v, l);
            return this.isAsync ? l + l2 : l + Math.min(l2, 0x3FFFFFFFFFFFFFFFL);
        }
        return 0L;
    }

    long expireAfterUpdate(Node<K, V> node, @Nullable K k, @Nullable V v, Expiry<K, V> expiry, long l) {
        if (this.expiresVariable() && k != null && v != null) {
            long l2 = Math.max(1L, node.getVariableTime() - l);
            long l3 = expiry.expireAfterUpdate(k, v, l, l2);
            return this.isAsync ? l + l3 : l + Math.min(l3, 0x3FFFFFFFFFFFFFFFL);
        }
        return 0L;
    }

    long expireAfterRead(Node<K, V> node, @Nullable K k, @Nullable V v, Expiry<K, V> expiry, long l) {
        if (this.expiresVariable() && k != null && v != null) {
            long l2 = Math.max(1L, node.getVariableTime() - l);
            long l3 = expiry.expireAfterRead(k, v, l, l2);
            return this.isAsync ? l + l3 : l + Math.min(l3, 0x3FFFFFFFFFFFFFFFL);
        }
        return 0L;
    }

    void tryExpireAfterRead(Node<K, V> node, @Nullable K k, @Nullable V v, Expiry<K, V> expiry, long l) {
        if (!this.expiresVariable() || k == null || v == null) {
            return;
        }
        long l2 = node.getVariableTime();
        long l3 = Math.max(1L, l2 - l);
        if (this.isAsync && l3 > 0x3FFFFFFFFFFFFFFFL) {
            return;
        }
        long l4 = expiry.expireAfterRead(k, v, l, l3);
        if (l4 != l3) {
            long l5 = this.isAsync ? l + l4 : l + Math.min(l4, 0x3FFFFFFFFFFFFFFFL);
            node.casVariableTime(l2, l5);
        }
    }

    void setVariableTime(Node<K, V> node, long l) {
        if (this.expiresVariable()) {
            node.setVariableTime(l);
        }
    }

    void setWriteTime(Node<K, V> node, long l) {
        if (this.expiresAfterWrite() || this.refreshAfterWrite()) {
            node.setWriteTime(l);
        }
    }

    void setAccessTime(Node<K, V> node, long l) {
        if (this.expiresAfterAccess()) {
            node.setAccessTime(l);
        }
    }

    void afterWrite(Runnable runnable) {
        if (this.buffersWrites()) {
            for (int i = 0; i < 100; ++i) {
                if (this.writeBuffer().offer(runnable)) {
                    this.scheduleAfterWrite();
                    return;
                }
                this.scheduleDrainBuffers();
            }
            try {
                this.performCleanUp(runnable);
            }
            catch (RuntimeException runtimeException) {
                logger.log(Level.SEVERE, "Exception thrown when performing the maintenance task", runtimeException);
            }
        } else {
            this.scheduleAfterWrite();
        }
    }

    void scheduleAfterWrite() {
        block6: while (true) {
            switch (this.drainStatus()) {
                case 0: {
                    this.casDrainStatus(0, 1);
                    this.scheduleDrainBuffers();
                    return;
                }
                case 1: {
                    this.scheduleDrainBuffers();
                    return;
                }
                case 2: {
                    if (!this.casDrainStatus(2, 3)) continue block6;
                    return;
                }
                case 3: {
                    return;
                }
            }
            break;
        }
        throw new IllegalStateException();
    }

    void scheduleDrainBuffers() {
        if (this.drainStatus() >= 2) {
            return;
        }
        if (this.evictionLock.tryLock()) {
            try {
                int n = this.drainStatus();
                if (n >= 2) {
                    return;
                }
                this.lazySetDrainStatus(2);
                this.executor.execute(this.drainBuffersTask);
            }
            catch (Throwable throwable) {
                logger.log(Level.WARNING, "Exception thrown when submitting maintenance task", throwable);
                this.maintenance(null);
            }
            finally {
                this.evictionLock.unlock();
            }
        }
    }

    @Override
    public void cleanUp() {
        try {
            this.performCleanUp(null);
        }
        catch (RuntimeException runtimeException) {
            logger.log(Level.SEVERE, "Exception thrown when performing the maintenance task", runtimeException);
        }
    }

    void performCleanUp(@Nullable Runnable runnable) {
        this.evictionLock.lock();
        try {
            this.maintenance(runnable);
        }
        finally {
            this.evictionLock.unlock();
        }
        if (this.drainStatus() == 1 && this.executor == ForkJoinPool.commonPool()) {
            this.scheduleDrainBuffers();
        }
    }

    @GuardedBy(value="evictionLock")
    void maintenance(@Nullable Runnable runnable) {
        this.lazySetDrainStatus(2);
        try {
            this.drainReadBuffer();
            this.drainWriteBuffer();
            if (runnable != null) {
                runnable.run();
            }
            this.drainKeyReferences();
            this.drainValueReferences();
            this.expireEntries();
            this.evictEntries();
            this.climb();
        }
        finally {
            if (this.drainStatus() != 2 || !this.casDrainStatus(2, 0)) {
                this.lazySetDrainStatus(1);
            }
        }
    }

    @GuardedBy(value="evictionLock")
    void drainKeyReferences() {
        Reference<K> reference;
        if (!this.collectKeys()) {
            return;
        }
        while ((reference = this.keyReferenceQueue().poll()) != null) {
            Node<K, V> node = this.data.get(reference);
            if (node == null) continue;
            this.evictEntry(node, RemovalCause.COLLECTED, 0L);
        }
    }

    @GuardedBy(value="evictionLock")
    void drainValueReferences() {
        Reference<V> reference;
        if (!this.collectValues()) {
            return;
        }
        while ((reference = this.valueReferenceQueue().poll()) != null) {
            References.InternalReference internalReference = (References.InternalReference)((Object)reference);
            Node<K, V> node = this.data.get(internalReference.getKeyReference());
            if (node == null || reference != node.getValueReference()) continue;
            this.evictEntry(node, RemovalCause.COLLECTED, 0L);
        }
    }

    @GuardedBy(value="evictionLock")
    void drainReadBuffer() {
        if (!this.skipReadBuffer()) {
            this.readBuffer.drainTo(this.accessPolicy);
        }
    }

    @GuardedBy(value="evictionLock")
    void onAccess(Node<K, V> node) {
        if (this.evicts()) {
            K k = node.getKey();
            if (k == null) {
                return;
            }
            this.frequencySketch().increment(k);
            if (node.inWindow()) {
                BoundedLocalCache.reorder(this.accessOrderWindowDeque(), node);
            } else if (node.inMainProbation()) {
                this.reorderProbation(node);
            } else {
                BoundedLocalCache.reorder(this.accessOrderProtectedDeque(), node);
            }
            this.setHitsInSample(this.hitsInSample() + 1);
        } else if (this.expiresAfterAccess()) {
            BoundedLocalCache.reorder(this.accessOrderWindowDeque(), node);
        }
        if (this.expiresVariable()) {
            this.timerWheel().reschedule(node);
        }
    }

    @GuardedBy(value="evictionLock")
    void reorderProbation(Node<K, V> node) {
        if (!this.accessOrderProbationDeque().contains(node)) {
            return;
        }
        if ((long)node.getPolicyWeight() > this.mainProtectedMaximum()) {
            return;
        }
        this.setMainProtectedWeightedSize(this.mainProtectedWeightedSize() + (long)node.getPolicyWeight());
        this.accessOrderProbationDeque().remove(node);
        this.accessOrderProtectedDeque().add(node);
        node.makeMainProtected();
    }

    static <K, V> void reorder(LinkedDeque<Node<K, V>> linkedDeque, Node<K, V> node) {
        if (linkedDeque.contains(node)) {
            linkedDeque.moveToBack(node);
        }
    }

    @GuardedBy(value="evictionLock")
    void drainWriteBuffer() {
        if (!this.buffersWrites()) {
            return;
        }
        for (int i = 0; i < WRITE_BUFFER_MAX; ++i) {
            Runnable runnable = (Runnable)this.writeBuffer().poll();
            if (runnable == null) {
                return;
            }
            runnable.run();
        }
        this.lazySetDrainStatus(3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GuardedBy(value="evictionLock")
    void makeDead(Node<K, V> node) {
        Node<K, V> node2 = node;
        synchronized (node2) {
            if (node.isDead()) {
                return;
            }
            if (this.evicts()) {
                if (node.inWindow()) {
                    this.setWindowWeightedSize(this.windowWeightedSize() - (long)node.getWeight());
                } else if (node.inMainProtected()) {
                    this.setMainProtectedWeightedSize(this.mainProtectedWeightedSize() - (long)node.getWeight());
                }
                this.setWeightedSize(this.weightedSize() - (long)node.getWeight());
            }
            node.die();
        }
    }

    @Override
    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    @Override
    public int size() {
        return this.data.size();
    }

    @Override
    public long estimatedSize() {
        return this.data.mappingCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        this.evictionLock.lock();
        try {
            Runnable runnable;
            long l = this.expirationTicker().read();
            while (this.buffersWrites() && (runnable = (Runnable)this.writeBuffer().poll()) != null) {
                runnable.run();
            }
            for (Node<K, V> node2 : this.data.values()) {
                this.removeNode(node2, l);
            }
            this.readBuffer.drainTo(node -> {});
        }
        finally {
            this.evictionLock.unlock();
        }
    }

    @GuardedBy(value="evictionLock")
    void removeNode(Node<K, V> node, long l) {
        K k = node.getKey();
        Object[] objectArray = new Object[1];
        RemovalCause[] removalCauseArray = new RemovalCause[1];
        this.data.computeIfPresent(node.getKeyReference(), (object2, node2) -> {
            if (node2 != node) {
                return node2;
            }
            Node node3 = node2;
            synchronized (node3) {
                objectArray[0] = node2.getValue();
                removalCauseArray[0] = k == null || objectArray[0] == null ? RemovalCause.COLLECTED : (this.hasExpired((Node<K, V>)node2, l) ? RemovalCause.EXPIRED : RemovalCause.EXPLICIT);
                if (k != null) {
                    this.writer.delete(k, objectArray[0], removalCauseArray[0]);
                }
                this.makeDead((Node<K, V>)node2);
                return null;
            }
        });
        if (node.inWindow() && (this.evicts() || this.expiresAfterAccess())) {
            this.accessOrderWindowDeque().remove(node);
        } else if (this.evicts()) {
            if (node.inMainProbation()) {
                this.accessOrderProbationDeque().remove(node);
            } else {
                this.accessOrderProtectedDeque().remove(node);
            }
        }
        if (this.expiresAfterWrite()) {
            this.writeOrderDeque().remove(node);
        } else if (this.expiresVariable()) {
            this.timerWheel().deschedule(node);
        }
        if (removalCauseArray[0] != null && this.hasRemovalListener()) {
            this.notifyRemoval(k, objectArray[0], removalCauseArray[0]);
        }
    }

    @Override
    public boolean containsKey(Object object) {
        Node<K, V> node = this.data.get(this.nodeFactory.newLookupKey(object));
        return node != null && node.getValue() != null && !this.hasExpired(node, this.expirationTicker().read());
    }

    @Override
    public boolean containsValue(Object object) {
        Objects.requireNonNull(object);
        long l = this.expirationTicker().read();
        for (Node<K, V> node : this.data.values()) {
            if (!node.containsValue(object) || this.hasExpired(node, l) || node.getKey() == null) continue;
            return true;
        }
        return false;
    }

    @Override
    public @Nullable V get(Object object) {
        return this.getIfPresent(object, false);
    }

    @Override
    public @Nullable V getIfPresent(Object object, boolean bl) {
        Node<K, V> node = this.data.get(this.nodeFactory.newLookupKey(object));
        if (node == null) {
            if (bl) {
                this.statsCounter().recordMisses(1);
            }
            if (this.drainStatus() == 1) {
                this.scheduleDrainBuffers();
            }
            return null;
        }
        V v = node.getValue();
        long l = this.expirationTicker().read();
        if (this.hasExpired(node, l) || this.collectValues() && v == null) {
            if (bl) {
                this.statsCounter().recordMisses(1);
            }
            this.scheduleDrainBuffers();
            return null;
        }
        if (!this.isComputingAsync(node)) {
            Object object2 = object;
            this.setAccessTime(node, l);
            this.tryExpireAfterRead(node, object2, v, this.expiry(), l);
        }
        this.afterRead(node, l, bl);
        return v;
    }

    @Override
    public @Nullable V getIfPresentQuietly(Object object, long[] lArray) {
        V v;
        Node<K, V> node = this.data.get(this.nodeFactory.newLookupKey(object));
        if (node == null || (v = node.getValue()) == null || this.hasExpired(node, this.expirationTicker().read())) {
            return null;
        }
        lArray[0] = node.getWriteTime();
        return v;
    }

    @Override
    public Map<K, V> getAllPresent(Iterable<?> iterable) {
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        for (Object obj : iterable) {
            linkedHashSet.add(obj);
        }
        int n = 0;
        long l = this.expirationTicker().read();
        LinkedHashMap linkedHashMap = new LinkedHashMap(linkedHashSet.size());
        for (Object e : linkedHashSet) {
            V v;
            Node<K, V> node = this.data.get(this.nodeFactory.newLookupKey(e));
            if (node == null || (v = node.getValue()) == null || this.hasExpired(node, l)) {
                ++n;
                continue;
            }
            linkedHashMap.put(e, v);
            if (!this.isComputingAsync(node)) {
                Object e2 = e;
                this.tryExpireAfterRead(node, e2, v, this.expiry(), l);
                this.setAccessTime(node, l);
            }
            this.afterRead(node, l, false);
        }
        this.statsCounter().recordMisses(n);
        this.statsCounter().recordHits(linkedHashMap.size());
        LinkedHashMap linkedHashMap2 = linkedHashMap;
        return Collections.unmodifiableMap(linkedHashMap2);
    }

    @Override
    public @Nullable V put(K k, V v) {
        return this.put(k, v, this.expiry(), true, false);
    }

    @Override
    public @Nullable V put(K k, V v, boolean bl) {
        return this.put(k, v, this.expiry(), bl, false);
    }

    @Override
    public @Nullable V putIfAbsent(K k, V v) {
        return this.put(k, v, this.expiry(), true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Nullable V put(K k, V v, Expiry<K, V> expiry, boolean bl, boolean bl2) {
        V v2;
        int n;
        long l;
        boolean bl3;
        boolean bl4;
        boolean bl5;
        Object object;
        Node node;
        Objects.requireNonNull(k);
        Objects.requireNonNull(v);
        Node<K, V> node2 = null;
        long l2 = this.expirationTicker().read();
        int n2 = this.weigher.weigh(k, v);
        while (true) {
            if ((node = this.data.get(this.nodeFactory.newLookupKey(k))) == null) {
                if (node2 == null) {
                    node2 = this.nodeFactory.newNode(k, this.keyReferenceQueue(), v, this.valueReferenceQueue(), n2, l2);
                    this.setVariableTime(node2, this.expireAfterCreate(k, v, expiry, l2));
                }
                if (bl && this.hasWriter()) {
                    object = node2;
                    node = this.data.computeIfAbsent(node2.getKeyReference(), object3 -> {
                        this.writer.write(k, v);
                        return object;
                    });
                    if (node == node2) {
                        this.afterWrite(new AddTask(node2, n2));
                        return null;
                    }
                } else {
                    node = this.data.putIfAbsent(node2.getKeyReference(), node2);
                    if (node == null) {
                        this.afterWrite(new AddTask(node2, n2));
                        return null;
                    }
                }
            } else if (bl2 && (object = node.getValue()) != null && !this.hasExpired(node, l2)) {
                if (!this.isComputingAsync(node)) {
                    this.tryExpireAfterRead(node, k, object, this.expiry(), l2);
                    this.setAccessTime(node, l2);
                }
                this.afterRead(node, l2, false);
                return object;
            }
            bl5 = false;
            bl4 = true;
            bl3 = true;
            Node node3 = node;
            // MONITORENTER : node3
            if (node.isAlive()) break;
            // MONITOREXIT : node3
        }
        object = node.getValue();
        int n3 = node.getWeight();
        if (object == null) {
            l = this.expireAfterCreate(k, v, expiry, l2);
            this.writer.delete(k, null, RemovalCause.COLLECTED);
        } else if (this.hasExpired(node, l2)) {
            bl5 = true;
            l = this.expireAfterCreate(k, v, expiry, l2);
            this.writer.delete(k, object, RemovalCause.EXPIRED);
        } else if (bl2) {
            bl4 = false;
            l = this.expireAfterRead(node, k, v, expiry, l2);
        } else {
            l = this.expireAfterUpdate(node, k, v, expiry, l2);
        }
        if (bl && (bl5 || bl4 && v != object)) {
            this.writer.write(k, v);
        }
        if (bl4) {
            bl3 = l2 - node.getWriteTime() > EXPIRE_WRITE_TOLERANCE;
            this.setWriteTime(node, l2);
            node.setWeight(n2);
            node.setValue(v, this.valueReferenceQueue());
        }
        this.setVariableTime(node, l);
        this.setAccessTime(node, l2);
        // MONITOREXIT : node3
        if (this.hasRemovalListener()) {
            if (bl5) {
                this.notifyRemoval(k, object, RemovalCause.EXPIRED);
            } else if (object == null) {
                this.notifyRemoval(k, null, RemovalCause.COLLECTED);
            } else if (bl4 && v != object) {
                this.notifyRemoval(k, object, RemovalCause.REPLACED);
            }
        }
        int n4 = n = bl4 ? n2 - n3 : 0;
        if (object == null || n != 0 || bl5) {
            this.afterWrite(new UpdateTask(node, n));
        } else if (!bl2 && this.expiresAfterWrite() && bl3) {
            this.afterWrite(new UpdateTask(node, n));
        } else {
            if (bl4) {
                this.setWriteTime(node, l2);
            }
            this.afterRead(node, l2, false);
        }
        if (bl5) {
            v2 = null;
            return v2;
        }
        v2 = object;
        return v2;
    }

    @Override
    public @Nullable V remove(Object object) {
        Object object3 = object;
        Node[] nodeArray = new Node[1];
        Object[] objectArray = new Object[1];
        RemovalCause[] removalCauseArray = new RemovalCause[1];
        this.data.computeIfPresent(this.nodeFactory.newLookupKey(object), (object2, node) -> {
            Node node2 = node;
            synchronized (node2) {
                objectArray[0] = node.getValue();
                removalCauseArray[0] = objectArray[0] == null ? RemovalCause.COLLECTED : (this.hasExpired((Node<K, V>)node, this.expirationTicker().read()) ? RemovalCause.EXPIRED : RemovalCause.EXPLICIT);
                this.writer.delete(object3, objectArray[0], removalCauseArray[0]);
                node.retire();
            }
            nodeArray[0] = node;
            return null;
        });
        if (removalCauseArray[0] != null) {
            this.afterWrite(new RemovalTask(nodeArray[0]));
            if (this.hasRemovalListener()) {
                this.notifyRemoval(object3, objectArray[0], removalCauseArray[0]);
            }
        }
        return (V)(removalCauseArray[0] == RemovalCause.EXPLICIT ? objectArray[0] : null);
    }

    @Override
    public boolean remove(Object object, Object object3) {
        Objects.requireNonNull(object);
        if (object3 == null) {
            return false;
        }
        Node[] nodeArray = new Node[1];
        Object[] objectArray = new Object[1];
        Object[] objectArray2 = new Object[1];
        RemovalCause[] removalCauseArray = new RemovalCause[1];
        this.data.computeIfPresent(this.nodeFactory.newLookupKey(object), (object2, node) -> {
            Node node2 = node;
            synchronized (node2) {
                objectArray[0] = node.getKey();
                objectArray2[0] = node.getValue();
                if (objectArray[0] == null) {
                    removalCauseArray[0] = RemovalCause.COLLECTED;
                } else if (this.hasExpired((Node<K, V>)node, this.expirationTicker().read())) {
                    removalCauseArray[0] = RemovalCause.EXPIRED;
                } else if (node.containsValue(object3)) {
                    removalCauseArray[0] = RemovalCause.EXPLICIT;
                } else {
                    return node;
                }
                this.writer.delete(objectArray[0], objectArray2[0], removalCauseArray[0]);
                nodeArray[0] = node;
                node.retire();
                return null;
            }
        });
        if (nodeArray[0] == null) {
            return false;
        }
        if (this.hasRemovalListener()) {
            this.notifyRemoval(objectArray[0], objectArray2[0], removalCauseArray[0]);
        }
        this.afterWrite(new RemovalTask(nodeArray[0]));
        return removalCauseArray[0] == RemovalCause.EXPLICIT;
    }

    @Override
    public @Nullable V replace(K k, V v) {
        Objects.requireNonNull(k);
        Objects.requireNonNull(v);
        int[] nArray = new int[1];
        Object[] objectArray = new Object[1];
        Object[] objectArray2 = new Object[1];
        long[] lArray = new long[1];
        int n = this.weigher.weigh(k, v);
        Node node2 = this.data.computeIfPresent(this.nodeFactory.newLookupKey(k), (object3, node) -> {
            Node node2 = node;
            synchronized (node2) {
                objectArray[0] = node.getKey();
                objectArray2[0] = node.getValue();
                nArray[0] = node.getWeight();
                if (objectArray[0] == null || objectArray2[0] == null || this.hasExpired((Node<K, V>)node, lArray[0] = this.expirationTicker().read())) {
                    objectArray2[0] = null;
                    return node;
                }
                long l = this.expireAfterUpdate((Node<K, V>)node, k, v, this.expiry(), lArray[0]);
                if (v != objectArray2[0]) {
                    this.writer.write(objectArray[0], v);
                }
                node.setValue(v, this.valueReferenceQueue());
                node.setWeight(n);
                this.setVariableTime((Node<K, V>)node, l);
                this.setAccessTime((Node<K, V>)node, lArray[0]);
                this.setWriteTime((Node<K, V>)node, lArray[0]);
                return node;
            }
        });
        if (objectArray2[0] == null) {
            return null;
        }
        int n2 = n - nArray[0];
        if (this.expiresAfterWrite() || n2 != 0) {
            this.afterWrite(new UpdateTask(node2, n2));
        } else {
            this.afterRead(node2, lArray[0], false);
        }
        if (this.hasRemovalListener() && v != objectArray2[0]) {
            this.notifyRemoval(objectArray[0], objectArray2[0], RemovalCause.REPLACED);
        }
        return (V)objectArray2[0];
    }

    @Override
    public boolean replace(K k, V v, V v2) {
        Objects.requireNonNull(k);
        Objects.requireNonNull(v);
        Objects.requireNonNull(v2);
        int n = this.weigher.weigh(k, v2);
        boolean[] blArray = new boolean[1];
        Object[] objectArray = new Object[1];
        Object[] objectArray2 = new Object[1];
        int[] nArray = new int[1];
        long[] lArray = new long[1];
        Node node2 = this.data.computeIfPresent(this.nodeFactory.newLookupKey(k), (object4, node) -> {
            Node node2 = node;
            synchronized (node2) {
                objectArray[0] = node.getKey();
                objectArray2[0] = node.getValue();
                nArray[0] = node.getWeight();
                if (objectArray[0] == null || objectArray2[0] == null || !node.containsValue(v) || this.hasExpired((Node<K, V>)node, lArray[0] = this.expirationTicker().read())) {
                    return node;
                }
                long l = this.expireAfterUpdate((Node<K, V>)node, k, v2, this.expiry(), lArray[0]);
                if (v2 != objectArray2[0]) {
                    this.writer.write(k, v2);
                }
                node.setValue(v2, this.valueReferenceQueue());
                node.setWeight(n);
                this.setVariableTime((Node<K, V>)node, l);
                this.setAccessTime((Node<K, V>)node, lArray[0]);
                this.setWriteTime((Node<K, V>)node, lArray[0]);
                blArray[0] = true;
            }
            return node;
        });
        if (!blArray[0]) {
            return false;
        }
        int n2 = n - nArray[0];
        if (this.expiresAfterWrite() || n2 != 0) {
            this.afterWrite(new UpdateTask(node2, n2));
        } else {
            this.afterRead(node2, lArray[0], false);
        }
        if (this.hasRemovalListener() && v != v2) {
            this.notifyRemoval(objectArray[0], objectArray2[0], RemovalCause.REPLACED);
        }
        return true;
    }

    @Override
    public void replaceAll(BiFunction<? super K, ? super V, ? extends V> biFunction) {
        Objects.requireNonNull(biFunction);
        BiFunction<Object, Object, Object> biFunction2 = (object, object2) -> {
            Object r = Objects.requireNonNull(biFunction.apply((K)object, (V)object2));
            if (object2 != r) {
                this.writer.write(object, r);
            }
            return r;
        };
        for (K k : this.keySet()) {
            long[] lArray = new long[]{this.expirationTicker().read()};
            Object object3 = this.nodeFactory.newLookupKey(k);
            this.remap(k, object3, biFunction2, lArray, false);
        }
    }

    @Override
    public @Nullable V computeIfAbsent(K k, Function<? super K, ? extends V> function, boolean bl, boolean bl2) {
        Object object;
        Objects.requireNonNull(k);
        Objects.requireNonNull(function);
        long l = this.expirationTicker().read();
        Node<K, V> node = this.data.get(this.nodeFactory.newLookupKey(k));
        if (node != null && (object = node.getValue()) != null && !this.hasExpired(node, l)) {
            if (!this.isComputingAsync(node)) {
                this.tryExpireAfterRead(node, k, object, this.expiry(), l);
                this.setAccessTime(node, l);
            }
            this.afterRead(node, l, bl);
            return object;
        }
        if (bl) {
            function = this.statsAware(function, bl2);
        }
        object = this.nodeFactory.newReferenceKey(k, this.keyReferenceQueue());
        return this.doComputeIfAbsent(k, object, function, new long[]{l}, bl);
    }

    @Nullable V doComputeIfAbsent(K k, Object object, Function<? super K, ? extends V> function, long[] lArray, boolean bl) {
        Object[] objectArray = new Object[1];
        int[] nArray = new int[2];
        Object[] objectArray2 = new Object[1];
        Object[] objectArray3 = new Object[1];
        RemovalCause[] removalCauseArray = new RemovalCause[1];
        Node[] nodeArray = new Node[1];
        Node node2 = this.data.compute(object, (object2, node) -> {
            if (node == null) {
                objectArray[0] = function.apply((K)k);
                if (objectArray[0] == null) {
                    return null;
                }
                lArray[0] = this.expirationTicker().read();
                nArray[1] = this.weigher.weigh(k, objectArray[0]);
                node = this.nodeFactory.newNode(k, this.keyReferenceQueue(), objectArray[0], this.valueReferenceQueue(), nArray[1], lArray[0]);
                this.setVariableTime((Node<K, V>)node, this.expireAfterCreate(k, objectArray[0], this.expiry(), lArray[0]));
                return node;
            }
            Node<Object, Object> node2 = node;
            synchronized (node2) {
                objectArray2[0] = node.getKey();
                nArray[0] = node.getWeight();
                objectArray3[0] = node.getValue();
                if (objectArray2[0] == null || objectArray3[0] == null) {
                    removalCauseArray[0] = RemovalCause.COLLECTED;
                } else if (this.hasExpired((Node<K, V>)node, lArray[0])) {
                    removalCauseArray[0] = RemovalCause.EXPIRED;
                } else {
                    return node;
                }
                this.writer.delete(objectArray2[0], objectArray3[0], removalCauseArray[0]);
                objectArray[0] = function.apply((K)k);
                if (objectArray[0] == null) {
                    nodeArray[0] = node;
                    node.retire();
                    return null;
                }
                nArray[1] = this.weigher.weigh(k, objectArray[0]);
                node.setValue(objectArray[0], this.valueReferenceQueue());
                node.setWeight(nArray[1]);
                lArray[0] = this.expirationTicker().read();
                this.setVariableTime((Node<K, V>)node, this.expireAfterCreate(k, objectArray[0], this.expiry(), lArray[0]));
                this.setAccessTime((Node<K, V>)node, lArray[0]);
                this.setWriteTime((Node<K, V>)node, lArray[0]);
                return node;
            }
        });
        if (node2 == null) {
            if (nodeArray[0] != null) {
                this.afterWrite(new RemovalTask(nodeArray[0]));
            }
            return null;
        }
        if (removalCauseArray[0] != null) {
            if (this.hasRemovalListener()) {
                this.notifyRemoval(objectArray2[0], objectArray3[0], removalCauseArray[0]);
            }
            this.statsCounter().recordEviction(nArray[0], removalCauseArray[0]);
        }
        if (objectArray[0] == null) {
            if (!this.isComputingAsync(node2)) {
                this.tryExpireAfterRead(node2, k, objectArray3[0], this.expiry(), lArray[0]);
                this.setAccessTime(node2, lArray[0]);
            }
            this.afterRead(node2, lArray[0], bl);
            return (V)objectArray3[0];
        }
        if (objectArray3[0] == null && removalCauseArray[0] == null) {
            this.afterWrite(new AddTask(node2, nArray[1]));
        } else {
            int n = nArray[1] - nArray[0];
            this.afterWrite(new UpdateTask(node2, n));
        }
        return (V)objectArray[0];
    }

    @Override
    public @Nullable V computeIfPresent(K k, BiFunction<? super K, ? super V, ? extends V> biFunction) {
        long l;
        Objects.requireNonNull(k);
        Objects.requireNonNull(biFunction);
        Object object = this.nodeFactory.newLookupKey(k);
        @Nullable Node<K, V> node = this.data.get(object);
        if (node == null) {
            return null;
        }
        if (node.getValue() == null || this.hasExpired(node, l = this.expirationTicker().read())) {
            this.scheduleDrainBuffers();
            return null;
        }
        BiFunction<? super K, ? super V, ? extends V> biFunction2 = this.statsAware(biFunction, false, true, true);
        return this.remap(k, object, biFunction2, new long[]{l}, false);
    }

    @Override
    public @Nullable V compute(K k, BiFunction<? super K, ? super V, ? extends V> biFunction, boolean bl, boolean bl2, boolean bl3) {
        Objects.requireNonNull(k);
        Objects.requireNonNull(biFunction);
        long[] lArray = new long[]{this.expirationTicker().read()};
        Object object = this.nodeFactory.newReferenceKey(k, this.keyReferenceQueue());
        BiFunction<? super K, ? super V, ? extends V> biFunction2 = this.statsAware(biFunction, bl, bl2, bl3);
        return this.remap(k, object, biFunction2, lArray, true);
    }

    @Override
    public @Nullable V merge(K k, V v, BiFunction<? super V, ? super V, ? extends V> biFunction) {
        Objects.requireNonNull(k);
        Objects.requireNonNull(v);
        Objects.requireNonNull(biFunction);
        long[] lArray = new long[]{this.expirationTicker().read()};
        Object object = this.nodeFactory.newReferenceKey(k, this.keyReferenceQueue());
        BiFunction<Object, Object, Object> biFunction2 = (object2, object3) -> object3 == null ? v : this.statsAware(biFunction).apply(object3, v);
        return (V)this.remap(k, object, biFunction2, lArray, true);
    }

    @Nullable V remap(K k, Object object, BiFunction<? super K, ? super V, ? extends V> biFunction, long[] lArray, boolean bl) {
        Object[] objectArray = new Object[1];
        Object[] objectArray2 = new Object[1];
        Object[] objectArray3 = new Object[1];
        Node[] nodeArray = new Node[1];
        int[] nArray = new int[2];
        RemovalCause[] removalCauseArray = new RemovalCause[1];
        Node node2 = this.data.compute(object, (object3, node) -> {
            if (node == null) {
                if (!bl) {
                    return null;
                }
                objectArray[0] = biFunction.apply((K)k, (V)null);
                if (objectArray3[0] == null) {
                    return null;
                }
                lArray[0] = this.expirationTicker().read();
                nArray[1] = this.weigher.weigh(k, objectArray3[0]);
                node = this.nodeFactory.newNode(object, objectArray3[0], this.valueReferenceQueue(), nArray[1], lArray[0]);
                this.setVariableTime((Node<K, V>)node, this.expireAfterCreate(k, objectArray3[0], this.expiry(), lArray[0]));
                return node;
            }
            Node<K, Object> node2 = node;
            synchronized (node2) {
                objectArray2[0] = node.getKey();
                objectArray3[0] = node.getValue();
                if (objectArray[0] == null || objectArray2[0] == null) {
                    removalCauseArray[0] = RemovalCause.COLLECTED;
                } else if (this.hasExpired((Node<K, V>)node, lArray[0])) {
                    removalCauseArray[0] = RemovalCause.EXPIRED;
                }
                if (removalCauseArray[0] != null) {
                    this.writer.delete(objectArray[0], objectArray2[0], removalCauseArray[0]);
                    if (!bl) {
                        nodeArray[0] = node;
                        node.retire();
                        return null;
                    }
                }
                objectArray[0] = biFunction.apply((K)objectArray[0], (V)(removalCauseArray[0] == null ? objectArray2[0] : null));
                if (objectArray3[0] == null) {
                    if (removalCauseArray[0] == null) {
                        removalCauseArray[0] = RemovalCause.EXPLICIT;
                    }
                    nodeArray[0] = node;
                    node.retire();
                    return null;
                }
                nArray[0] = node.getWeight();
                nArray[1] = this.weigher.weigh(k, objectArray3[0]);
                lArray[0] = this.expirationTicker().read();
                if (removalCauseArray[0] == null) {
                    if (objectArray3[0] != objectArray2[0]) {
                        removalCauseArray[0] = RemovalCause.REPLACED;
                    }
                    this.setVariableTime((Node<K, V>)node, this.expireAfterUpdate((Node<K, V>)node, k, (V)objectArray3[0], this.expiry(), lArray[0]));
                } else {
                    this.setVariableTime((Node<K, V>)node, this.expireAfterCreate(k, objectArray3[0], this.expiry(), lArray[0]));
                }
                node.setValue(objectArray3[0], this.valueReferenceQueue());
                node.setWeight(nArray[1]);
                this.setAccessTime((Node<K, V>)node, lArray[0]);
                this.setWriteTime((Node<K, V>)node, lArray[0]);
                return node;
            }
        });
        if (removalCauseArray[0] != null) {
            if (removalCauseArray[0].wasEvicted()) {
                this.statsCounter().recordEviction(nArray[0], removalCauseArray[0]);
            }
            if (this.hasRemovalListener()) {
                this.notifyRemoval(objectArray[0], objectArray2[0], removalCauseArray[0]);
            }
        }
        if (nodeArray[0] != null) {
            this.afterWrite(new RemovalTask(nodeArray[0]));
        } else if (node2 != null) {
            if (objectArray2[0] == null && removalCauseArray[0] == null) {
                this.afterWrite(new AddTask(node2, nArray[1]));
            } else {
                int n = nArray[1] - nArray[0];
                if (this.expiresAfterWrite() || n != 0) {
                    this.afterWrite(new UpdateTask(node2, n));
                } else {
                    if (removalCauseArray[0] == null) {
                        if (!this.isComputingAsync(node2)) {
                            this.tryExpireAfterRead(node2, k, objectArray3[0], this.expiry(), lArray[0]);
                            this.setAccessTime(node2, lArray[0]);
                        }
                    } else if (removalCauseArray[0] == RemovalCause.COLLECTED) {
                        this.scheduleDrainBuffers();
                    }
                    this.afterRead(node2, lArray[0], false);
                }
            }
        }
        return (V)objectArray3[0];
    }

    @Override
    public Set<K> keySet() {
        Set<K> set = this.keySet;
        return set == null ? (this.keySet = new KeySetView(this)) : set;
    }

    @Override
    public Collection<V> values() {
        Collection<V> collection = this.values;
        return collection == null ? (this.values = new ValuesView(this)) : collection;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        Set<Map.Entry<K, V>> set = this.entrySet;
        return set == null ? (this.entrySet = new EntrySetView(this)) : set;
    }

    Map<K, V> evictionOrder(int n, Function<V, V> function, boolean bl) {
        Supplier<Iterator<Node<K, V>>> supplier = () -> {
            Comparator<Node> comparator = Comparator.comparingInt(node -> {
                Object k = node.getKey();
                return k == null ? 0 : this.frequencySketch().frequency(k);
            });
            if (bl) {
                LinkedDeque.PeekingIterator<Node> peekingIterator = LinkedDeque.PeekingIterator.comparing(this.accessOrderProbationDeque().descendingIterator(), this.accessOrderWindowDeque().descendingIterator(), comparator);
                return LinkedDeque.PeekingIterator.concat(this.accessOrderProtectedDeque().descendingIterator(), peekingIterator);
            }
            LinkedDeque.PeekingIterator<Node> peekingIterator = LinkedDeque.PeekingIterator.comparing(this.accessOrderWindowDeque().iterator(), this.accessOrderProbationDeque().iterator(), comparator.reversed());
            return LinkedDeque.PeekingIterator.concat(peekingIterator, this.accessOrderProtectedDeque().iterator());
        };
        return this.fixedSnapshot(supplier, n, function);
    }

    Map<K, V> expireAfterAccessOrder(int n, Function<V, V> function, boolean bl) {
        if (!this.evicts()) {
            Supplier<Iterator<Node<K, V>>> supplier = () -> bl ? this.accessOrderWindowDeque().iterator() : this.accessOrderWindowDeque().descendingIterator();
            return this.fixedSnapshot(supplier, n, function);
        }
        Supplier<Iterator<Node<K, V>>> supplier = () -> {
            Iterator iterator;
            Iterator iterator2;
            Iterator iterator3;
            Comparator<Node> comparator = Comparator.comparingLong(Node::getAccessTime);
            if (bl) {
                iterator3 = this.accessOrderWindowDeque().iterator();
                iterator2 = this.accessOrderProbationDeque().iterator();
                iterator = this.accessOrderProtectedDeque().iterator();
            } else {
                comparator = comparator.reversed();
                iterator3 = this.accessOrderWindowDeque().descendingIterator();
                iterator2 = this.accessOrderProbationDeque().descendingIterator();
                iterator = this.accessOrderProtectedDeque().descendingIterator();
            }
            return LinkedDeque.PeekingIterator.comparing(LinkedDeque.PeekingIterator.comparing(iterator3, iterator2, comparator), iterator, comparator);
        };
        return this.fixedSnapshot(supplier, n, function);
    }

    Map<K, V> expireAfterWriteOrder(int n, Function<V, V> function, boolean bl) {
        Supplier<Iterator<Node<K, V>>> supplier = () -> bl ? this.writeOrderDeque().iterator() : this.writeOrderDeque().descendingIterator();
        return this.fixedSnapshot(supplier, n, function);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<K, V> fixedSnapshot(Supplier<Iterator<Node<K, V>>> supplier, int n, Function<V, V> function) {
        Caffeine.requireArgument(n >= 0);
        this.evictionLock.lock();
        try {
            Object object;
            this.maintenance(null);
            int n2 = Math.min(n, this.size());
            Iterator<Node<K, V>> iterator = supplier.get();
            LinkedHashMap linkedHashMap = new LinkedHashMap(n2);
            while (linkedHashMap.size() < n && iterator.hasNext()) {
                object = iterator.next();
                Object k = ((Node)object).getKey();
                V v = function.apply(((Node)object).getValue());
                if (k == null || v == null || !((Node)object).isAlive()) continue;
                linkedHashMap.put(k, v);
            }
            object = Collections.unmodifiableMap(linkedHashMap);
            return object;
        }
        finally {
            this.evictionLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<K, V> variableSnapshot(boolean bl, int n, Function<V, V> function) {
        this.evictionLock.lock();
        try {
            this.maintenance(null);
            Map<K, V> map = this.timerWheel().snapshot(bl, n, function);
            return map;
        }
        finally {
            this.evictionLock.unlock();
        }
    }

    static <K, V> SerializationProxy<K, V> makeSerializationProxy(BoundedLocalCache<?, ?> boundedLocalCache, boolean bl) {
        SerializationProxy serializationProxy = new SerializationProxy();
        serializationProxy.weakKeys = boundedLocalCache.collectKeys();
        serializationProxy.weakValues = boundedLocalCache.nodeFactory.weakValues();
        serializationProxy.softValues = boundedLocalCache.nodeFactory.softValues();
        serializationProxy.isRecordingStats = boundedLocalCache.isRecordingStats();
        serializationProxy.removalListener = boundedLocalCache.removalListener();
        serializationProxy.ticker = boundedLocalCache.expirationTicker();
        serializationProxy.writer = boundedLocalCache.writer;
        if (boundedLocalCache.expiresAfterAccess()) {
            serializationProxy.expiresAfterAccessNanos = boundedLocalCache.expiresAfterAccessNanos();
        }
        if (boundedLocalCache.expiresAfterWrite()) {
            serializationProxy.expiresAfterWriteNanos = boundedLocalCache.expiresAfterWriteNanos();
        }
        if (boundedLocalCache.expiresVariable()) {
            serializationProxy.expiry = boundedLocalCache.expiry();
        }
        if (boundedLocalCache.evicts()) {
            if (bl) {
                serializationProxy.weigher = boundedLocalCache.weigher;
                serializationProxy.maximumWeight = boundedLocalCache.maximum();
            } else {
                serializationProxy.maximumSize = boundedLocalCache.maximum();
            }
        }
        return serializationProxy;
    }

    private /* synthetic */ void lambda$refreshIfNeeded$5(long l, Node node, long l2, long l3, CompletableFuture completableFuture, Object object, Object object2, Object object5, Throwable throwable) {
        long l4 = this.statsTicker().read() - l;
        if (throwable != null) {
            logger.log(Level.WARNING, "Exception thrown during refresh", throwable);
            node.casWriteTime(l2, l3);
            this.statsCounter().recordLoadFailure(l4);
            return;
        }
        Object object6 = this.isAsync && object5 != null ? completableFuture : object5;
        boolean[] blArray = new boolean[1];
        this.compute(object, (object3, object4) -> {
            if (object4 == null) {
                return object6;
            }
            if (object4 == object2 && node.getWriteTime() == l2) {
                return object6;
            }
            blArray[0] = true;
            return object4;
        }, false, false, true);
        if (blArray[0] && this.hasRemovalListener()) {
            this.notifyRemoval(object, object6, RemovalCause.REPLACED);
        }
        if (object5 == null) {
            this.statsCounter().recordLoadFailure(l4);
        } else {
            this.statsCounter().recordLoadSuccess(l4);
        }
    }

    static final class BoundedLocalAsyncLoadingCache<K, V>
    extends LocalAsyncLoadingCache<K, V>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        final BoundedLocalCache<K, CompletableFuture<V>> cache;
        final boolean isWeighted;
        @Nullable ConcurrentMap<K, CompletableFuture<V>> mapView;
        @Nullable Policy<K, V> policy;

        BoundedLocalAsyncLoadingCache(Caffeine<K, V> caffeine, AsyncCacheLoader<? super K, V> asyncCacheLoader) {
            super(asyncCacheLoader);
            this.isWeighted = caffeine.isWeighted();
            this.cache = LocalCacheFactory.newBoundedLocalCache(caffeine, new AsyncLoader<K, V>(asyncCacheLoader, caffeine), true);
        }

        @Override
        public BoundedLocalCache<K, CompletableFuture<V>> cache() {
            return this.cache;
        }

        @Override
        public ConcurrentMap<K, CompletableFuture<V>> asMap() {
            return this.mapView == null ? (this.mapView = new LocalAsyncCache.AsyncAsMapView(this)) : this.mapView;
        }

        @Override
        public Policy<K, V> policy() {
            if (this.policy == null) {
                Function<CompletableFuture, Object> function;
                BoundedLocalCache<K, CompletableFuture<V>> boundedLocalCache = this.cache;
                Function<CompletableFuture, Object> function2 = function = Async::getIfReady;
                this.policy = new BoundedPolicy<K, Object>(boundedLocalCache, function2, this.isWeighted);
            }
            return this.policy;
        }

        private void readObject(ObjectInputStream objectInputStream) {
            throw new InvalidObjectException("Proxy required");
        }

        Object writeReplace() {
            SerializationProxy serializationProxy = BoundedLocalCache.makeSerializationProxy(this.cache, this.isWeighted);
            if (this.cache.refreshAfterWrite()) {
                serializationProxy.refreshAfterWriteNanos = this.cache.refreshAfterWriteNanos();
            }
            serializationProxy.loader = this.loader;
            serializationProxy.async = true;
            return serializationProxy;
        }

        static final class AsyncLoader<K, V>
        implements CacheLoader<K, V> {
            final AsyncCacheLoader<? super K, V> loader;
            final Executor executor;

            AsyncLoader(AsyncCacheLoader<? super K, V> asyncCacheLoader, Caffeine<?, ?> caffeine) {
                this.executor = Objects.requireNonNull(caffeine.getExecutor());
                this.loader = Objects.requireNonNull(asyncCacheLoader);
            }

            @Override
            public V load(K k) {
                CompletableFuture<V> completableFuture = this.loader.asyncLoad(k, this.executor);
                return (V)completableFuture;
            }

            @Override
            public V reload(K k, V v) {
                CompletableFuture<V> completableFuture = this.loader.asyncReload(k, v, this.executor);
                return (V)completableFuture;
            }

            @Override
            public CompletableFuture<V> asyncReload(K k, V v, Executor executor) {
                return this.loader.asyncReload(k, v, executor);
            }
        }
    }

    static final class BoundedLocalAsyncCache<K, V>
    implements LocalAsyncCache<K, V>,
    Serializable {
        private static final long serialVersionUID = 1L;
        final BoundedLocalCache<K, CompletableFuture<V>> cache;
        final boolean isWeighted;
        @Nullable ConcurrentMap<K, CompletableFuture<V>> mapView;
        @Nullable LocalAsyncCache.CacheView<K, V> cacheView;
        @Nullable Policy<K, V> policy;

        BoundedLocalAsyncCache(Caffeine<K, V> caffeine) {
            this.cache = LocalCacheFactory.newBoundedLocalCache(caffeine, null, true);
            this.isWeighted = caffeine.isWeighted();
        }

        @Override
        public BoundedLocalCache<K, CompletableFuture<V>> cache() {
            return this.cache;
        }

        @Override
        public ConcurrentMap<K, CompletableFuture<V>> asMap() {
            return this.mapView == null ? (this.mapView = new LocalAsyncCache.AsyncAsMapView(this)) : this.mapView;
        }

        @Override
        public Cache<K, V> synchronous() {
            return this.cacheView == null ? (this.cacheView = new LocalAsyncCache.CacheView(this)) : this.cacheView;
        }

        @Override
        public Policy<K, V> policy() {
            if (this.policy == null) {
                Function<CompletableFuture, Object> function;
                BoundedLocalCache<K, CompletableFuture<V>> boundedLocalCache = this.cache;
                Function<CompletableFuture, Object> function2 = function = Async::getIfReady;
                this.policy = new BoundedPolicy<K, Object>(boundedLocalCache, function2, this.isWeighted);
            }
            return this.policy;
        }

        private void readObject(ObjectInputStream objectInputStream) {
            throw new InvalidObjectException("Proxy required");
        }

        Object writeReplace() {
            SerializationProxy serializationProxy = BoundedLocalCache.makeSerializationProxy(this.cache, this.isWeighted);
            if (this.cache.refreshAfterWrite()) {
                serializationProxy.refreshAfterWriteNanos = this.cache.refreshAfterWriteNanos();
            }
            serializationProxy.async = true;
            return serializationProxy;
        }
    }

    static final class BoundedLocalLoadingCache<K, V>
    extends BoundedLocalManualCache<K, V>
    implements LocalLoadingCache<K, V> {
        private static final long serialVersionUID = 1L;
        final Function<K, V> mappingFunction;
        final @Nullable Function<Iterable<? extends K>, Map<K, V>> bulkMappingFunction;

        BoundedLocalLoadingCache(Caffeine<K, V> caffeine, CacheLoader<? super K, V> cacheLoader) {
            super(caffeine, cacheLoader);
            Objects.requireNonNull(cacheLoader);
            this.mappingFunction = LocalLoadingCache.newMappingFunction(cacheLoader);
            this.bulkMappingFunction = LocalLoadingCache.newBulkMappingFunction(cacheLoader);
        }

        @Override
        public CacheLoader<? super K, V> cacheLoader() {
            return this.cache.cacheLoader;
        }

        @Override
        public Function<K, V> mappingFunction() {
            return this.mappingFunction;
        }

        @Override
        public @Nullable Function<Iterable<? extends K>, Map<K, V>> bulkMappingFunction() {
            return this.bulkMappingFunction;
        }

        private void readObject(ObjectInputStream objectInputStream) {
            throw new InvalidObjectException("Proxy required");
        }

        @Override
        Object writeReplace() {
            SerializationProxy serializationProxy = (SerializationProxy)super.writeReplace();
            if (this.cache.refreshAfterWrite()) {
                serializationProxy.refreshAfterWriteNanos = this.cache.refreshAfterWriteNanos();
            }
            serializationProxy.loader = this.cache.cacheLoader;
            return serializationProxy;
        }
    }

    static final class BoundedPolicy<K, V>
    implements Policy<K, V> {
        final BoundedLocalCache<K, V> cache;
        final Function<V, V> transformer;
        final boolean isWeighted;
        @Nullable Optional<Policy.Eviction<K, V>> eviction;
        @Nullable Optional<Policy.Expiration<K, V>> refreshes;
        @Nullable Optional<Policy.Expiration<K, V>> afterWrite;
        @Nullable Optional<Policy.Expiration<K, V>> afterAccess;
        @Nullable Optional<Policy.VarExpiration<K, V>> variable;

        BoundedPolicy(BoundedLocalCache<K, V> boundedLocalCache, Function<V, V> function, boolean bl) {
            this.transformer = function;
            this.isWeighted = bl;
            this.cache = boundedLocalCache;
        }

        @Override
        public boolean isRecordingStats() {
            return this.cache.isRecordingStats();
        }

        @Override
        public @Nullable V getIfPresentQuietly(Object object) {
            Node node = this.cache.data.get(this.cache.nodeFactory.newLookupKey(object));
            if (node == null || this.cache.hasExpired(node, this.cache.expirationTicker().read())) {
                return null;
            }
            return this.transformer.apply(node.getValue());
        }

        @Override
        public Optional<Policy.Eviction<K, V>> eviction() {
            Optional<Policy.Eviction<K, V>> optional;
            if (this.cache.evicts()) {
                if (this.eviction == null) {
                    this.eviction = Optional.of(new BoundedEviction());
                    optional = this.eviction;
                } else {
                    optional = this.eviction;
                }
            } else {
                optional = Optional.empty();
            }
            return optional;
        }

        @Override
        public Optional<Policy.Expiration<K, V>> expireAfterAccess() {
            if (!this.cache.expiresAfterAccess()) {
                return Optional.empty();
            }
            return this.afterAccess == null ? (this.afterAccess = Optional.of(new BoundedExpireAfterAccess())) : this.afterAccess;
        }

        @Override
        public Optional<Policy.Expiration<K, V>> expireAfterWrite() {
            if (!this.cache.expiresAfterWrite()) {
                return Optional.empty();
            }
            return this.afterWrite == null ? (this.afterWrite = Optional.of(new BoundedExpireAfterWrite())) : this.afterWrite;
        }

        @Override
        public Optional<Policy.VarExpiration<K, V>> expireVariably() {
            if (!this.cache.expiresVariable()) {
                return Optional.empty();
            }
            return this.variable == null ? (this.variable = Optional.of(new BoundedVarExpiration())) : this.variable;
        }

        @Override
        public Optional<Policy.Expiration<K, V>> refreshAfterWrite() {
            if (!this.cache.refreshAfterWrite()) {
                return Optional.empty();
            }
            return this.refreshes == null ? (this.refreshes = Optional.of(new BoundedRefreshAfterWrite())) : this.refreshes;
        }

        final class BoundedRefreshAfterWrite
        implements Policy.Expiration<K, V> {
            BoundedRefreshAfterWrite() {
            }

            @Override
            public OptionalLong ageOf(K k, TimeUnit timeUnit) {
                Objects.requireNonNull(k);
                Objects.requireNonNull(timeUnit);
                Object object = BoundedPolicy.this.cache.nodeFactory.newLookupKey(k);
                Node node = BoundedPolicy.this.cache.data.get(object);
                if (node == null) {
                    return OptionalLong.empty();
                }
                long l = BoundedPolicy.this.cache.expirationTicker().read() - node.getWriteTime();
                return l > BoundedPolicy.this.cache.refreshAfterWriteNanos() ? OptionalLong.empty() : OptionalLong.of(timeUnit.convert(l, TimeUnit.NANOSECONDS));
            }

            @Override
            public long getExpiresAfter(TimeUnit timeUnit) {
                return timeUnit.convert(BoundedPolicy.this.cache.refreshAfterWriteNanos(), TimeUnit.NANOSECONDS);
            }

            @Override
            public void setExpiresAfter(long l, TimeUnit timeUnit) {
                Caffeine.requireArgument(l >= 0L);
                BoundedPolicy.this.cache.setRefreshAfterWriteNanos(timeUnit.toNanos(l));
                BoundedPolicy.this.cache.scheduleAfterWrite();
            }

            @Override
            public Map<K, V> oldest(int n) {
                return BoundedPolicy.this.cache.expiresAfterWrite() ? BoundedPolicy.this.expireAfterWrite().get().oldest(n) : this.sortedByWriteTime(n, true);
            }

            @Override
            public Map<K, V> youngest(int n) {
                return BoundedPolicy.this.cache.expiresAfterWrite() ? BoundedPolicy.this.expireAfterWrite().get().youngest(n) : this.sortedByWriteTime(n, false);
            }

            Map<K, V> sortedByWriteTime(int n, boolean bl) {
                Comparator<Node> comparator = Comparator.comparingLong(Node::getWriteTime);
                Iterator iterator = ((Stream)BoundedPolicy.this.cache.data.values().stream().parallel()).sorted(bl ? comparator : comparator.reversed()).limit(n).iterator();
                return BoundedPolicy.this.cache.fixedSnapshot(() -> iterator, n, BoundedPolicy.this.transformer);
            }
        }

        final class BoundedVarExpiration
        implements Policy.VarExpiration<K, V> {
            BoundedVarExpiration() {
            }

            @Override
            public OptionalLong getExpiresAfter(K k, TimeUnit timeUnit) {
                Objects.requireNonNull(k);
                Objects.requireNonNull(timeUnit);
                Object object = BoundedPolicy.this.cache.nodeFactory.newLookupKey(k);
                Node node = BoundedPolicy.this.cache.data.get(object);
                if (node == null) {
                    return OptionalLong.empty();
                }
                long l = node.getVariableTime() - BoundedPolicy.this.cache.expirationTicker().read();
                return l <= 0L ? OptionalLong.empty() : OptionalLong.of(timeUnit.convert(l, TimeUnit.NANOSECONDS));
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setExpiresAfter(K k, long l, TimeUnit timeUnit) {
                Objects.requireNonNull(k);
                Objects.requireNonNull(timeUnit);
                Caffeine.requireArgument(l >= 0L);
                Object object = BoundedPolicy.this.cache.nodeFactory.newLookupKey(k);
                Node node = BoundedPolicy.this.cache.data.get(object);
                if (node != null) {
                    long l2;
                    long l3 = TimeUnit.NANOSECONDS.convert(l, timeUnit);
                    Node node2 = node;
                    synchronized (node2) {
                        l2 = BoundedPolicy.this.cache.expirationTicker().read();
                        node.setVariableTime(l2 + Math.min(l3, 0x3FFFFFFFFFFFFFFFL));
                    }
                    BoundedPolicy.this.cache.afterRead(node, l2, false);
                }
            }

            @Override
            public void put(K k, V v, long l, TimeUnit timeUnit) {
                this.put(k, v, l, timeUnit, false);
            }

            @Override
            public boolean putIfAbsent(K k, V v, long l, TimeUnit timeUnit) {
                Object v2 = this.put(k, v, l, timeUnit, true);
                return v2 == null;
            }

            @Nullable V put(K k, V object, final long l, final TimeUnit timeUnit, boolean bl) {
                Objects.requireNonNull(timeUnit);
                Objects.requireNonNull(object);
                Caffeine.requireArgument(l >= 0L);
                Expiry expiry = new Expiry<K, V>(){

                    @Override
                    public long expireAfterCreate(K k, V v, long l2) {
                        return timeUnit.toNanos(l);
                    }

                    @Override
                    public long expireAfterUpdate(K k, V v, long l3, long l2) {
                        return timeUnit.toNanos(l);
                    }

                    @Override
                    public long expireAfterRead(K k, V v, long l3, long l2) {
                        return l2;
                    }
                };
                if (BoundedPolicy.this.cache.isAsync) {
                    Async.AsyncExpiry asyncExpiry = new Async.AsyncExpiry(expiry);
                    expiry = asyncExpiry;
                    CompletableFuture completableFuture = CompletableFuture.completedFuture(object);
                    object = completableFuture;
                }
                return BoundedPolicy.this.cache.put(k, object, expiry, true, bl);
            }

            @Override
            public Map<K, V> oldest(int n) {
                return BoundedPolicy.this.cache.variableSnapshot(true, n, BoundedPolicy.this.transformer);
            }

            @Override
            public Map<K, V> youngest(int n) {
                return BoundedPolicy.this.cache.variableSnapshot(false, n, BoundedPolicy.this.transformer);
            }
        }

        final class BoundedExpireAfterWrite
        implements Policy.Expiration<K, V> {
            BoundedExpireAfterWrite() {
            }

            @Override
            public OptionalLong ageOf(K k, TimeUnit timeUnit) {
                Objects.requireNonNull(k);
                Objects.requireNonNull(timeUnit);
                Object object = BoundedPolicy.this.cache.nodeFactory.newLookupKey(k);
                Node node = BoundedPolicy.this.cache.data.get(object);
                if (node == null) {
                    return OptionalLong.empty();
                }
                long l = BoundedPolicy.this.cache.expirationTicker().read() - node.getWriteTime();
                return l > BoundedPolicy.this.cache.expiresAfterWriteNanos() ? OptionalLong.empty() : OptionalLong.of(timeUnit.convert(l, TimeUnit.NANOSECONDS));
            }

            @Override
            public long getExpiresAfter(TimeUnit timeUnit) {
                return timeUnit.convert(BoundedPolicy.this.cache.expiresAfterWriteNanos(), TimeUnit.NANOSECONDS);
            }

            @Override
            public void setExpiresAfter(long l, TimeUnit timeUnit) {
                Caffeine.requireArgument(l >= 0L);
                BoundedPolicy.this.cache.setExpiresAfterWriteNanos(timeUnit.toNanos(l));
                BoundedPolicy.this.cache.scheduleAfterWrite();
            }

            @Override
            public Map<K, V> oldest(int n) {
                return BoundedPolicy.this.cache.expireAfterWriteOrder(n, BoundedPolicy.this.transformer, true);
            }

            @Override
            public Map<K, V> youngest(int n) {
                return BoundedPolicy.this.cache.expireAfterWriteOrder(n, BoundedPolicy.this.transformer, false);
            }
        }

        final class BoundedExpireAfterAccess
        implements Policy.Expiration<K, V> {
            BoundedExpireAfterAccess() {
            }

            @Override
            public OptionalLong ageOf(K k, TimeUnit timeUnit) {
                Objects.requireNonNull(k);
                Objects.requireNonNull(timeUnit);
                Object object = BoundedPolicy.this.cache.nodeFactory.newLookupKey(k);
                Node node = BoundedPolicy.this.cache.data.get(object);
                if (node == null) {
                    return OptionalLong.empty();
                }
                long l = BoundedPolicy.this.cache.expirationTicker().read() - node.getAccessTime();
                return l > BoundedPolicy.this.cache.expiresAfterAccessNanos() ? OptionalLong.empty() : OptionalLong.of(timeUnit.convert(l, TimeUnit.NANOSECONDS));
            }

            @Override
            public long getExpiresAfter(TimeUnit timeUnit) {
                return timeUnit.convert(BoundedPolicy.this.cache.expiresAfterAccessNanos(), TimeUnit.NANOSECONDS);
            }

            @Override
            public void setExpiresAfter(long l, TimeUnit timeUnit) {
                Caffeine.requireArgument(l >= 0L);
                BoundedPolicy.this.cache.setExpiresAfterAccessNanos(timeUnit.toNanos(l));
                BoundedPolicy.this.cache.scheduleAfterWrite();
            }

            @Override
            public Map<K, V> oldest(int n) {
                return BoundedPolicy.this.cache.expireAfterAccessOrder(n, BoundedPolicy.this.transformer, true);
            }

            @Override
            public Map<K, V> youngest(int n) {
                return BoundedPolicy.this.cache.expireAfterAccessOrder(n, BoundedPolicy.this.transformer, false);
            }
        }

        final class BoundedEviction
        implements Policy.Eviction<K, V> {
            BoundedEviction() {
            }

            @Override
            public boolean isWeighted() {
                return BoundedPolicy.this.isWeighted;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public OptionalInt weightOf(@NonNull K k) {
                Objects.requireNonNull(k);
                if (!BoundedPolicy.this.isWeighted) {
                    return OptionalInt.empty();
                }
                Node node = BoundedPolicy.this.cache.data.get(BoundedPolicy.this.cache.nodeFactory.newLookupKey(k));
                if (node == null) {
                    return OptionalInt.empty();
                }
                Node node2 = node;
                synchronized (node2) {
                    return OptionalInt.of(node.getWeight());
                }
            }

            @Override
            public OptionalLong weightedSize() {
                if (BoundedPolicy.this.cache.evicts() && this.isWeighted()) {
                    BoundedPolicy.this.cache.evictionLock.lock();
                    try {
                        OptionalLong optionalLong = OptionalLong.of(Math.max(0L, BoundedPolicy.this.cache.weightedSize()));
                        return optionalLong;
                    }
                    finally {
                        BoundedPolicy.this.cache.evictionLock.unlock();
                    }
                }
                return OptionalLong.empty();
            }

            @Override
            public long getMaximum() {
                BoundedPolicy.this.cache.evictionLock.lock();
                try {
                    long l = BoundedPolicy.this.cache.maximum();
                    return l;
                }
                finally {
                    BoundedPolicy.this.cache.evictionLock.unlock();
                }
            }

            @Override
            public void setMaximum(long l) {
                BoundedPolicy.this.cache.evictionLock.lock();
                try {
                    BoundedPolicy.this.cache.setMaximumSize(l);
                    BoundedPolicy.this.cache.maintenance(null);
                }
                finally {
                    BoundedPolicy.this.cache.evictionLock.unlock();
                }
            }

            @Override
            public Map<K, V> coldest(int n) {
                return BoundedPolicy.this.cache.evictionOrder(n, BoundedPolicy.this.transformer, false);
            }

            @Override
            public Map<K, V> hottest(int n) {
                return BoundedPolicy.this.cache.evictionOrder(n, BoundedPolicy.this.transformer, true);
            }
        }
    }

    static class BoundedLocalManualCache<K, V>
    implements LocalManualCache<K, V>,
    Serializable {
        private static final long serialVersionUID = 1L;
        final BoundedLocalCache<K, V> cache;
        final boolean isWeighted;
        @Nullable Policy<K, V> policy;

        BoundedLocalManualCache(Caffeine<K, V> caffeine) {
            this(caffeine, null);
        }

        BoundedLocalManualCache(Caffeine<K, V> caffeine, @Nullable CacheLoader<? super K, V> cacheLoader) {
            this.cache = LocalCacheFactory.newBoundedLocalCache(caffeine, cacheLoader, false);
            this.isWeighted = caffeine.isWeighted();
        }

        @Override
        public BoundedLocalCache<K, V> cache() {
            return this.cache;
        }

        @Override
        public Policy<K, V> policy() {
            return this.policy == null ? (this.policy = new BoundedPolicy<K, V>(this.cache, Function.identity(), this.isWeighted)) : this.policy;
        }

        private void readObject(ObjectInputStream objectInputStream) {
            throw new InvalidObjectException("Proxy required");
        }

        Object writeReplace() {
            return BoundedLocalCache.makeSerializationProxy(this.cache, this.isWeighted);
        }
    }

    static final class PerformCleanupTask
    extends ForkJoinTask<Void>
    implements Runnable {
        private static final long serialVersionUID = 1L;
        final WeakReference<BoundedLocalCache<?, ?>> reference;

        PerformCleanupTask(BoundedLocalCache<?, ?> boundedLocalCache) {
            this.reference = new WeakReference(boundedLocalCache);
        }

        @Override
        public boolean exec() {
            try {
                this.run();
            }
            catch (Throwable throwable) {
                logger.log(Level.SEVERE, "Exception thrown when performing the maintenance task", throwable);
            }
            return false;
        }

        @Override
        public void run() {
            BoundedLocalCache boundedLocalCache = (BoundedLocalCache)this.reference.get();
            if (boundedLocalCache != null) {
                boundedLocalCache.performCleanUp(null);
            }
        }

        @Override
        public Void getRawResult() {
            return null;
        }

        @Override
        public void setRawResult(Void void_) {
        }

        @Override
        public void complete(Void void_) {
        }

        @Override
        public void completeExceptionally(Throwable throwable) {
        }

        @Override
        public boolean cancel(boolean bl) {
            return false;
        }
    }

    static final class EntrySpliterator<K, V>
    implements Spliterator<Map.Entry<K, V>> {
        final Spliterator<Node<K, V>> spliterator;
        final BoundedLocalCache<K, V> cache;

        EntrySpliterator(BoundedLocalCache<K, V> boundedLocalCache) {
            this(boundedLocalCache, boundedLocalCache.data.values().spliterator());
        }

        EntrySpliterator(BoundedLocalCache<K, V> boundedLocalCache, Spliterator<Node<K, V>> spliterator) {
            this.spliterator = Objects.requireNonNull(spliterator);
            this.cache = Objects.requireNonNull(boundedLocalCache);
        }

        @Override
        public void forEachRemaining(Consumer<? super Map.Entry<K, V>> consumer) {
            Objects.requireNonNull(consumer);
            Consumer<Node> consumer2 = node -> {
                Object k = node.getKey();
                Object v = node.getValue();
                long l = this.cache.expirationTicker().read();
                if (k != null && v != null && node.isAlive() && !this.cache.hasExpired((Node<K, V>)node, l)) {
                    consumer.accept(new WriteThroughEntry<K, V>(this.cache, k, v));
                }
            };
            this.spliterator.forEachRemaining(consumer2);
        }

        @Override
        public boolean tryAdvance(Consumer<? super Map.Entry<K, V>> consumer) {
            Objects.requireNonNull(consumer);
            boolean[] blArray = new boolean[]{false};
            Consumer<Node> consumer2 = node -> {
                Object k = node.getKey();
                Object v = node.getValue();
                long l = this.cache.expirationTicker().read();
                if (k != null && v != null && node.isAlive() && !this.cache.hasExpired((Node<K, V>)node, l)) {
                    consumer.accept(new WriteThroughEntry<K, V>(this.cache, k, v));
                    blArray[0] = true;
                }
            };
            while (this.spliterator.tryAdvance(consumer2)) {
                if (!blArray[0]) continue;
                return true;
            }
            return false;
        }

        @Override
        public @Nullable Spliterator<Map.Entry<K, V>> trySplit() {
            Spliterator<Node<K, V>> spliterator = this.spliterator.trySplit();
            return spliterator == null ? null : new EntrySpliterator<K, V>(this.cache, spliterator);
        }

        @Override
        public long estimateSize() {
            return this.spliterator.estimateSize();
        }

        @Override
        public int characteristics() {
            return 4353;
        }
    }

    static final class EntryIterator<K, V>
    implements Iterator<Map.Entry<K, V>> {
        final BoundedLocalCache<K, V> cache;
        final Iterator<Node<K, V>> iterator;
        final long now;
        @Nullable K key;
        @Nullable V value;
        @Nullable K removalKey;
        @Nullable Node<K, V> next;

        EntryIterator(BoundedLocalCache<K, V> boundedLocalCache) {
            this.iterator = boundedLocalCache.data.values().iterator();
            this.now = boundedLocalCache.expirationTicker().read();
            this.cache = boundedLocalCache;
        }

        @Override
        public boolean hasNext() {
            if (this.next != null) {
                return true;
            }
            while (this.iterator.hasNext()) {
                this.next = this.iterator.next();
                this.value = this.next.getValue();
                this.key = this.next.getKey();
                if (this.cache.hasExpired(this.next, this.now) || this.key == null || this.value == null || !this.next.isAlive()) {
                    this.value = null;
                    this.next = null;
                    this.key = null;
                    continue;
                }
                return true;
            }
            return false;
        }

        K nextKey() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.removalKey = this.key;
            this.value = null;
            this.next = null;
            this.key = null;
            return this.removalKey;
        }

        V nextValue() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.removalKey = this.key;
            V v = this.value;
            this.value = null;
            this.next = null;
            this.key = null;
            return v;
        }

        @Override
        public Map.Entry<K, V> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            WriteThroughEntry<K, V> writeThroughEntry = new WriteThroughEntry<K, V>(this.cache, this.key, this.value);
            this.removalKey = this.key;
            this.value = null;
            this.next = null;
            this.key = null;
            return writeThroughEntry;
        }

        @Override
        public void remove() {
            if (this.removalKey == null) {
                throw new IllegalStateException();
            }
            this.cache.remove(this.removalKey);
            this.removalKey = null;
        }
    }

    static final class EntrySetView<K, V>
    extends AbstractSet<Map.Entry<K, V>> {
        final BoundedLocalCache<K, V> cache;

        EntrySetView(BoundedLocalCache<K, V> boundedLocalCache) {
            this.cache = Objects.requireNonNull(boundedLocalCache);
        }

        @Override
        public int size() {
            return this.cache.size();
        }

        @Override
        public void clear() {
            this.cache.clear();
        }

        @Override
        public boolean contains(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            Node node = this.cache.data.get(this.cache.nodeFactory.newLookupKey(entry.getKey()));
            return node != null && Objects.equals(node.getValue(), entry.getValue());
        }

        @Override
        public boolean remove(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            return this.cache.remove(entry.getKey(), entry.getValue());
        }

        @Override
        public boolean removeIf(Predicate<? super Map.Entry<K, V>> predicate) {
            Objects.requireNonNull(predicate);
            boolean bl = false;
            for (Map.Entry<K, V> entry : this) {
                if (!predicate.test(entry)) continue;
                bl |= this.cache.remove(entry.getKey(), entry.getValue());
            }
            return bl;
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator<K, V>(this.cache);
        }

        @Override
        public Spliterator<Map.Entry<K, V>> spliterator() {
            return new EntrySpliterator<K, V>(this.cache);
        }
    }

    static final class ValueSpliterator<K, V>
    implements Spliterator<V> {
        final Spliterator<Node<K, V>> spliterator;
        final BoundedLocalCache<K, V> cache;

        ValueSpliterator(BoundedLocalCache<K, V> boundedLocalCache) {
            this(boundedLocalCache, boundedLocalCache.data.values().spliterator());
        }

        ValueSpliterator(BoundedLocalCache<K, V> boundedLocalCache, Spliterator<Node<K, V>> spliterator) {
            this.spliterator = Objects.requireNonNull(spliterator);
            this.cache = Objects.requireNonNull(boundedLocalCache);
        }

        @Override
        public void forEachRemaining(Consumer<? super V> consumer) {
            Objects.requireNonNull(consumer);
            Consumer<Node> consumer2 = node -> {
                Object k = node.getKey();
                Object v = node.getValue();
                long l = this.cache.expirationTicker().read();
                if (k != null && v != null && node.isAlive() && !this.cache.hasExpired((Node<K, V>)node, l)) {
                    consumer.accept((V)v);
                }
            };
            this.spliterator.forEachRemaining(consumer2);
        }

        @Override
        public boolean tryAdvance(Consumer<? super V> consumer) {
            Objects.requireNonNull(consumer);
            boolean[] blArray = new boolean[]{false};
            long l = this.cache.expirationTicker().read();
            Consumer<Node> consumer2 = node -> {
                Object k = node.getKey();
                Object v = node.getValue();
                if (k != null && v != null && !this.cache.hasExpired((Node<K, V>)node, l) && node.isAlive()) {
                    consumer.accept((V)v);
                    blArray[0] = true;
                }
            };
            while (this.spliterator.tryAdvance(consumer2)) {
                if (!blArray[0]) continue;
                return true;
            }
            return false;
        }

        @Override
        public @Nullable Spliterator<V> trySplit() {
            Spliterator<Node<K, V>> spliterator = this.spliterator.trySplit();
            return spliterator == null ? null : new ValueSpliterator<K, V>(this.cache, spliterator);
        }

        @Override
        public long estimateSize() {
            return this.spliterator.estimateSize();
        }

        @Override
        public int characteristics() {
            return 4352;
        }
    }

    static final class ValueIterator<K, V>
    implements Iterator<V> {
        final EntryIterator<K, V> iterator;

        ValueIterator(BoundedLocalCache<K, V> boundedLocalCache) {
            this.iterator = new EntryIterator<K, V>(boundedLocalCache);
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public V next() {
            return this.iterator.nextValue();
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }

    static final class ValuesView<K, V>
    extends AbstractCollection<V> {
        final BoundedLocalCache<K, V> cache;

        ValuesView(BoundedLocalCache<K, V> boundedLocalCache) {
            this.cache = Objects.requireNonNull(boundedLocalCache);
        }

        @Override
        public int size() {
            return this.cache.size();
        }

        @Override
        public void clear() {
            this.cache.clear();
        }

        @Override
        public boolean contains(Object object) {
            return this.cache.containsValue(object);
        }

        @Override
        public boolean removeIf(Predicate<? super V> predicate) {
            Objects.requireNonNull(predicate);
            boolean bl = false;
            for (Map.Entry<K, V> entry : this.cache.entrySet()) {
                if (!predicate.test(entry.getValue())) continue;
                bl |= this.cache.remove(entry.getKey(), entry.getValue());
            }
            return bl;
        }

        @Override
        public Iterator<V> iterator() {
            return new ValueIterator<K, V>(this.cache);
        }

        @Override
        public Spliterator<V> spliterator() {
            return new ValueSpliterator<K, V>(this.cache);
        }
    }

    static final class KeySpliterator<K, V>
    implements Spliterator<K> {
        final Spliterator<Node<K, V>> spliterator;
        final BoundedLocalCache<K, V> cache;

        KeySpliterator(BoundedLocalCache<K, V> boundedLocalCache) {
            this(boundedLocalCache, boundedLocalCache.data.values().spliterator());
        }

        KeySpliterator(BoundedLocalCache<K, V> boundedLocalCache, Spliterator<Node<K, V>> spliterator) {
            this.spliterator = Objects.requireNonNull(spliterator);
            this.cache = Objects.requireNonNull(boundedLocalCache);
        }

        @Override
        public void forEachRemaining(Consumer<? super K> consumer) {
            Objects.requireNonNull(consumer);
            Consumer<Node> consumer2 = node -> {
                Object k = node.getKey();
                Object v = node.getValue();
                long l = this.cache.expirationTicker().read();
                if (k != null && v != null && node.isAlive() && !this.cache.hasExpired((Node<K, V>)node, l)) {
                    consumer.accept((K)k);
                }
            };
            this.spliterator.forEachRemaining(consumer2);
        }

        @Override
        public boolean tryAdvance(Consumer<? super K> consumer) {
            Objects.requireNonNull(consumer);
            boolean[] blArray = new boolean[]{false};
            Consumer<Node> consumer2 = node -> {
                Object k = node.getKey();
                Object v = node.getValue();
                long l = this.cache.expirationTicker().read();
                if (k != null && v != null && node.isAlive() && !this.cache.hasExpired((Node<K, V>)node, l)) {
                    consumer.accept((K)k);
                    blArray[0] = true;
                }
            };
            while (this.spliterator.tryAdvance(consumer2)) {
                if (!blArray[0]) continue;
                return true;
            }
            return false;
        }

        @Override
        public @Nullable Spliterator<K> trySplit() {
            Spliterator<Node<K, V>> spliterator = this.spliterator.trySplit();
            return spliterator == null ? null : new KeySpliterator<K, V>(this.cache, spliterator);
        }

        @Override
        public long estimateSize() {
            return this.spliterator.estimateSize();
        }

        @Override
        public int characteristics() {
            return 4353;
        }
    }

    static final class KeyIterator<K, V>
    implements Iterator<K> {
        final EntryIterator<K, V> iterator;

        KeyIterator(BoundedLocalCache<K, V> boundedLocalCache) {
            this.iterator = new EntryIterator<K, V>(boundedLocalCache);
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public K next() {
            return this.iterator.nextKey();
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }

    static final class KeySetView<K, V>
    extends AbstractSet<K> {
        final BoundedLocalCache<K, V> cache;

        KeySetView(BoundedLocalCache<K, V> boundedLocalCache) {
            this.cache = Objects.requireNonNull(boundedLocalCache);
        }

        @Override
        public int size() {
            return this.cache.size();
        }

        @Override
        public void clear() {
            this.cache.clear();
        }

        @Override
        public boolean contains(Object object) {
            return this.cache.containsKey(object);
        }

        @Override
        public boolean remove(Object object) {
            return this.cache.remove(object) != null;
        }

        @Override
        public Iterator<K> iterator() {
            return new KeyIterator<K, V>(this.cache);
        }

        @Override
        public Spliterator<K> spliterator() {
            return new KeySpliterator<K, V>(this.cache);
        }

        @Override
        public Object[] toArray() {
            if (this.cache.collectKeys()) {
                ArrayList<K> arrayList = new ArrayList<K>(this.size());
                for (K k : this) {
                    arrayList.add(k);
                }
                return arrayList.toArray();
            }
            return ((ConcurrentHashMap.CollectionView)((Object)this.cache.data.keySet())).toArray();
        }

        @Override
        public <T> T[] toArray(T[] TArray) {
            if (this.cache.collectKeys()) {
                ArrayList<K> arrayList = new ArrayList<K>(this.size());
                for (K k : this) {
                    arrayList.add(k);
                }
                return arrayList.toArray(TArray);
            }
            return ((ConcurrentHashMap.CollectionView)((Object)this.cache.data.keySet())).toArray(TArray);
        }
    }

    final class UpdateTask
    implements Runnable {
        final int weightDifference;
        final Node<K, V> node;

        public UpdateTask(Node<K, V> node, int n) {
            this.weightDifference = n;
            this.node = node;
        }

        @Override
        @GuardedBy(value="evictionLock")
        public void run() {
            if (BoundedLocalCache.this.evicts()) {
                if (this.node.inWindow()) {
                    BoundedLocalCache.this.setWindowWeightedSize(BoundedLocalCache.this.windowWeightedSize() + (long)this.weightDifference);
                } else if (this.node.inMainProtected()) {
                    BoundedLocalCache.this.setMainProtectedWeightedSize(BoundedLocalCache.this.mainProtectedMaximum() + (long)this.weightDifference);
                }
                BoundedLocalCache.this.setWeightedSize(BoundedLocalCache.this.weightedSize() + (long)this.weightDifference);
                this.node.setPolicyWeight(this.node.getPolicyWeight() + this.weightDifference);
            }
            if (BoundedLocalCache.this.evicts() || BoundedLocalCache.this.expiresAfterAccess()) {
                BoundedLocalCache.this.onAccess(this.node);
            }
            if (BoundedLocalCache.this.expiresAfterWrite()) {
                BoundedLocalCache.reorder(BoundedLocalCache.this.writeOrderDeque(), this.node);
            } else if (BoundedLocalCache.this.expiresVariable()) {
                BoundedLocalCache.this.timerWheel().reschedule(this.node);
            }
        }
    }

    final class RemovalTask
    implements Runnable {
        final Node<K, V> node;

        RemovalTask(Node<K, V> node) {
            this.node = node;
        }

        @Override
        @GuardedBy(value="evictionLock")
        public void run() {
            if (this.node.inWindow() && (BoundedLocalCache.this.evicts() || BoundedLocalCache.this.expiresAfterAccess())) {
                BoundedLocalCache.this.accessOrderWindowDeque().remove(this.node);
            } else if (BoundedLocalCache.this.evicts()) {
                if (this.node.inMainProbation()) {
                    BoundedLocalCache.this.accessOrderProbationDeque().remove(this.node);
                } else {
                    BoundedLocalCache.this.accessOrderProtectedDeque().remove(this.node);
                }
            }
            if (BoundedLocalCache.this.expiresAfterWrite()) {
                BoundedLocalCache.this.writeOrderDeque().remove(this.node);
            } else if (BoundedLocalCache.this.expiresVariable()) {
                BoundedLocalCache.this.timerWheel().deschedule(this.node);
            }
            BoundedLocalCache.this.makeDead(this.node);
        }
    }

    final class AddTask
    implements Runnable {
        final Node<K, V> node;
        final int weight;

        AddTask(Node<K, V> node, int n) {
            this.weight = n;
            this.node = node;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @GuardedBy(value="evictionLock")
        public void run() {
            boolean bl;
            long l;
            if (BoundedLocalCache.this.evicts()) {
                Object k;
                long l2 = BoundedLocalCache.this.weightedSize();
                BoundedLocalCache.this.setWeightedSize(l2 + (long)this.weight);
                BoundedLocalCache.this.setWindowWeightedSize(BoundedLocalCache.this.windowWeightedSize() + (long)this.weight);
                this.node.setPolicyWeight(this.node.getPolicyWeight() + this.weight);
                l = BoundedLocalCache.this.maximum();
                if (l2 >= l >>> 1) {
                    long l3 = BoundedLocalCache.this.isWeighted() ? BoundedLocalCache.this.data.mappingCount() : l;
                    BoundedLocalCache.this.frequencySketch().ensureCapacity(l3);
                }
                if ((k = this.node.getKey()) != null) {
                    BoundedLocalCache.this.frequencySketch().increment(k);
                }
                BoundedLocalCache.this.setMissesInSample(BoundedLocalCache.this.missesInSample() + 1);
            }
            Node node = this.node;
            synchronized (node) {
                bl = this.node.isAlive();
            }
            if (bl) {
                if (BoundedLocalCache.this.expiresAfterWrite()) {
                    BoundedLocalCache.this.writeOrderDeque().add(this.node);
                }
                if (BoundedLocalCache.this.evicts() || BoundedLocalCache.this.expiresAfterAccess()) {
                    BoundedLocalCache.this.accessOrderWindowDeque().add(this.node);
                }
                if (BoundedLocalCache.this.expiresVariable()) {
                    BoundedLocalCache.this.timerWheel().schedule(this.node);
                }
            }
            if (BoundedLocalCache.this.isComputingAsync(this.node)) {
                node = this.node;
                synchronized (node) {
                    if (!Async.isReady((CompletableFuture)this.node.getValue())) {
                        l = BoundedLocalCache.this.expirationTicker().read() + 0x5FFFFFFFFFFFFFFEL;
                        BoundedLocalCache.this.setVariableTime(this.node, l);
                        BoundedLocalCache.this.setAccessTime(this.node, l);
                        BoundedLocalCache.this.setWriteTime(this.node, l);
                    }
                }
            }
        }
    }
}

