/*
 * Decompiled with CFR 0.152.
 */
package org.skills.utils.caffeine.cache;

import java.lang.reflect.Field;
import java.util.Iterator;
import org.skills.utils.caffeine.cache.BaseMpscLinkedArrayQueueColdProducerFields;
import org.skills.utils.caffeine.cache.BaseMpscLinkedArrayQueueConsumerFields;
import org.skills.utils.caffeine.cache.BaseMpscLinkedArrayQueueProducerFields;
import org.skills.utils.caffeine.cache.Caffeine;
import org.skills.utils.caffeine.cache.UnsafeAccess;
import org.skills.utils.caffeine.cache.UnsafeRefArrayAccess;

abstract class BaseMpscLinkedArrayQueue<E>
extends BaseMpscLinkedArrayQueueColdProducerFields<E> {
    private static final long P_INDEX_OFFSET;
    private static final long C_INDEX_OFFSET;
    private static final long P_LIMIT_OFFSET;
    private static final Object JUMP;

    BaseMpscLinkedArrayQueue(int n) {
        if (n < 2) {
            throw new IllegalArgumentException("Initial capacity must be 2 or more");
        }
        int n2 = Caffeine.ceilingPowerOfTwo(n);
        long l = (long)n2 - 1L << 1;
        E[] EArray = BaseMpscLinkedArrayQueue.allocate(n2 + 1);
        this.producerBuffer = EArray;
        this.producerMask = l;
        this.consumerBuffer = EArray;
        this.consumerMask = l;
        this.soProducerLimit(l);
    }

    @Override
    public final Iterator<E> iterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String toString() {
        return this.getClass().getName() + "@" + Integer.toHexString(this.hashCode());
    }

    @Override
    public boolean offer(E e) {
        Object[] objectArray;
        long l;
        long l2;
        long l3;
        if (null == e) {
            throw new NullPointerException();
        }
        block6: while (true) {
            l3 = this.lvProducerLimit();
            l2 = this.lvProducerIndex();
            if ((l2 & 1L) == 1L) continue;
            l = this.producerMask;
            objectArray = this.producerBuffer;
            if (l3 <= l2) {
                int n = this.offerSlowPath(l, l2, l3);
                switch (n) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        continue block6;
                    }
                    case 2: {
                        return false;
                    }
                    case 3: {
                        this.resize(l, objectArray, l2, e);
                        return true;
                    }
                }
            }
            if (this.casProducerIndex(l2, l2 + 2L)) break;
        }
        l3 = BaseMpscLinkedArrayQueue.modifiedCalcElementOffset(l2, l);
        UnsafeRefArrayAccess.soElement(objectArray, l3, e);
        return true;
    }

    private int offerSlowPath(long l, long l2, long l3) {
        long l4 = this.lvConsumerIndex();
        long l5 = this.getCurrentBufferCapacity(l);
        int n = 0;
        if (l4 + l5 > l2) {
            if (!this.casProducerLimit(l3, l4 + l5)) {
                n = 1;
            }
        } else {
            n = this.availableInQueue(l2, l4) <= 0L ? 2 : (this.casProducerIndex(l2, l2 + 1L) ? 3 : 1);
        }
        return n;
    }

    protected abstract long availableInQueue(long var1, long var3);

    private static long modifiedCalcElementOffset(long l, long l2) {
        return UnsafeRefArrayAccess.REF_ARRAY_BASE + ((l & l2) << UnsafeRefArrayAccess.REF_ELEMENT_SHIFT - 1);
    }

    @Override
    public E poll() {
        Object[] objectArray = this.consumerBuffer;
        long l = this.consumerIndex;
        long l2 = this.consumerMask;
        long l3 = BaseMpscLinkedArrayQueue.modifiedCalcElementOffset(l, l2);
        Object object = UnsafeRefArrayAccess.lvElement(objectArray, l3);
        if (object == null) {
            if (l != this.lvProducerIndex()) {
                while ((object = UnsafeRefArrayAccess.lvElement(objectArray, l3)) == null) {
                }
            } else {
                return null;
            }
        }
        if (object == JUMP) {
            Object[] objectArray2 = this.getNextBuffer(objectArray, l2);
            return (E)this.newBufferPoll(objectArray2, l);
        }
        UnsafeRefArrayAccess.soElement(objectArray, l3, null);
        this.soConsumerIndex(l + 2L);
        return (E)object;
    }

    @Override
    public E peek() {
        Object[] objectArray = this.consumerBuffer;
        long l = this.consumerIndex;
        long l2 = this.consumerMask;
        long l3 = BaseMpscLinkedArrayQueue.modifiedCalcElementOffset(l, l2);
        Object object = UnsafeRefArrayAccess.lvElement(objectArray, l3);
        if (object == null && l != this.lvProducerIndex()) {
            while ((object = UnsafeRefArrayAccess.lvElement(objectArray, l3)) == null) {
            }
        }
        if (object == JUMP) {
            return (E)this.newBufferPeek(this.getNextBuffer(objectArray, l2), l);
        }
        return (E)object;
    }

    private E[] getNextBuffer(E[] EArray, long l) {
        long l2 = BaseMpscLinkedArrayQueue.nextArrayOffset(l);
        Object[] objectArray = (Object[])UnsafeRefArrayAccess.lvElement(EArray, l2);
        UnsafeRefArrayAccess.soElement(EArray, l2, null);
        return objectArray;
    }

    private static long nextArrayOffset(long l) {
        return BaseMpscLinkedArrayQueue.modifiedCalcElementOffset(l + 2L, Long.MAX_VALUE);
    }

    private E newBufferPoll(E[] EArray, long l) {
        long l2 = this.newBufferAndOffset(EArray, l);
        E e = UnsafeRefArrayAccess.lvElement(EArray, l2);
        if (e == null) {
            throw new IllegalStateException("new buffer must have at least one element");
        }
        UnsafeRefArrayAccess.soElement(EArray, l2, null);
        this.soConsumerIndex(l + 2L);
        return e;
    }

    private E newBufferPeek(E[] EArray, long l) {
        long l2 = this.newBufferAndOffset(EArray, l);
        E e = UnsafeRefArrayAccess.lvElement(EArray, l2);
        if (null == e) {
            throw new IllegalStateException("new buffer must have at least one element");
        }
        return e;
    }

    private long newBufferAndOffset(E[] EArray, long l) {
        this.consumerBuffer = EArray;
        this.consumerMask = (long)EArray.length - 2L << 1;
        long l2 = BaseMpscLinkedArrayQueue.modifiedCalcElementOffset(l, this.consumerMask);
        return l2;
    }

    @Override
    public final int size() {
        long l;
        long l2;
        long l3 = this.lvConsumerIndex();
        do {
            l2 = l3;
            l = this.lvProducerIndex();
        } while (l2 != (l3 = this.lvConsumerIndex()));
        long l4 = l - l3 >> 1;
        if (l4 > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)l4;
    }

    @Override
    public final boolean isEmpty() {
        return this.lvConsumerIndex() == this.lvProducerIndex();
    }

    private long lvProducerIndex() {
        return UnsafeAccess.UNSAFE.getLongVolatile(this, P_INDEX_OFFSET);
    }

    private long lvConsumerIndex() {
        return UnsafeAccess.UNSAFE.getLongVolatile(this, C_INDEX_OFFSET);
    }

    private void soProducerIndex(long l) {
        UnsafeAccess.UNSAFE.putOrderedLong(this, P_INDEX_OFFSET, l);
    }

    private boolean casProducerIndex(long l, long l2) {
        return UnsafeAccess.UNSAFE.compareAndSwapLong(this, P_INDEX_OFFSET, l, l2);
    }

    private void soConsumerIndex(long l) {
        UnsafeAccess.UNSAFE.putOrderedLong(this, C_INDEX_OFFSET, l);
    }

    private long lvProducerLimit() {
        return this.producerLimit;
    }

    private boolean casProducerLimit(long l, long l2) {
        return UnsafeAccess.UNSAFE.compareAndSwapLong(this, P_LIMIT_OFFSET, l, l2);
    }

    private void soProducerLimit(long l) {
        UnsafeAccess.UNSAFE.putOrderedLong(this, P_LIMIT_OFFSET, l);
    }

    public long currentProducerIndex() {
        return this.lvProducerIndex() / 2L;
    }

    public long currentConsumerIndex() {
        return this.lvConsumerIndex() / 2L;
    }

    public abstract int capacity();

    public boolean relaxedOffer(E e) {
        return this.offer(e);
    }

    public E relaxedPoll() {
        Object[] objectArray = this.consumerBuffer;
        long l = this.consumerIndex;
        long l2 = this.consumerMask;
        long l3 = BaseMpscLinkedArrayQueue.modifiedCalcElementOffset(l, l2);
        Object object = UnsafeRefArrayAccess.lvElement(objectArray, l3);
        if (object == null) {
            return null;
        }
        if (object == JUMP) {
            Object[] objectArray2 = this.getNextBuffer(objectArray, l2);
            return (E)this.newBufferPoll(objectArray2, l);
        }
        UnsafeRefArrayAccess.soElement(objectArray, l3, null);
        this.soConsumerIndex(l + 2L);
        return (E)object;
    }

    public E relaxedPeek() {
        Object[] objectArray = this.consumerBuffer;
        long l = this.consumerIndex;
        long l2 = this.consumerMask;
        long l3 = BaseMpscLinkedArrayQueue.modifiedCalcElementOffset(l, l2);
        Object object = UnsafeRefArrayAccess.lvElement(objectArray, l3);
        if (object == JUMP) {
            return (E)this.newBufferPeek(this.getNextBuffer(objectArray, l2), l);
        }
        return (E)object;
    }

    private void resize(long l, E[] EArray, long l2, E e) {
        int n = this.getNextBufferSize(EArray);
        E[] EArray2 = BaseMpscLinkedArrayQueue.allocate(n);
        this.producerBuffer = EArray2;
        int n2 = n - 2 << 1;
        this.producerMask = n2;
        long l3 = BaseMpscLinkedArrayQueue.modifiedCalcElementOffset(l2, l);
        long l4 = BaseMpscLinkedArrayQueue.modifiedCalcElementOffset(l2, n2);
        UnsafeRefArrayAccess.soElement(EArray2, l4, e);
        UnsafeRefArrayAccess.soElement(EArray, BaseMpscLinkedArrayQueue.nextArrayOffset(l), EArray2);
        long l5 = this.lvConsumerIndex();
        long l6 = this.availableInQueue(l2, l5);
        if (l6 <= 0L) {
            throw new IllegalStateException();
        }
        this.soProducerLimit(l2 + Math.min((long)n2, l6));
        this.soProducerIndex(l2 + 2L);
        UnsafeRefArrayAccess.soElement(EArray, l3, JUMP);
    }

    public static <E> E[] allocate(int n) {
        return new Object[n];
    }

    protected abstract int getNextBufferSize(E[] var1);

    protected abstract long getCurrentBufferCapacity(long var1);

    static {
        Field field;
        try {
            field = BaseMpscLinkedArrayQueueProducerFields.class.getDeclaredField("producerIndex");
            P_INDEX_OFFSET = UnsafeAccess.UNSAFE.objectFieldOffset(field);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new RuntimeException(noSuchFieldException);
        }
        try {
            field = BaseMpscLinkedArrayQueueConsumerFields.class.getDeclaredField("consumerIndex");
            C_INDEX_OFFSET = UnsafeAccess.UNSAFE.objectFieldOffset(field);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new RuntimeException(noSuchFieldException);
        }
        try {
            field = BaseMpscLinkedArrayQueueColdProducerFields.class.getDeclaredField("producerLimit");
            P_LIMIT_OFFSET = UnsafeAccess.UNSAFE.objectFieldOffset(field);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new RuntimeException(noSuchFieldException);
        }
        JUMP = new Object();
    }
}

