/*
 * Decompiled with CFR 0.152.
 */
package org.skills.utils.caffeine;

import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.skills.utils.caffeine.SCQHeader;
import org.skills.utils.caffeine.base.UnsafeAccess;
import org.skills.utils.caffeine.checkerframework.checker.nullness.qual.NonNull;
import org.skills.utils.caffeine.checkerframework.checker.nullness.qual.Nullable;

@Deprecated
public final class SingleConsumerQueue<E>
extends SCQHeader.HeadAndTailRef<E>
implements Queue<E>,
Serializable {
    static final int NCPU = Runtime.getRuntime().availableProcessors();
    static final int ARENA_LENGTH = SingleConsumerQueue.ceilingPowerOfTwo((NCPU + 1) / 2);
    static final int ARENA_MASK = ARENA_LENGTH - 1;
    static final Function<?, ?> OPTIMISIC = Node::new;
    static final int SPINS = NCPU == 1 ? 0 : 2000;
    static final long PROBE = UnsafeAccess.objectFieldOffset(Thread.class, "threadLocalRandomProbe");
    final AtomicReference<Node<E>>[] arena = new AtomicReference[ARENA_LENGTH];
    final Function<E, Node<E>> factory;
    static final long serialVersionUID = 1L;

    static int ceilingPowerOfTwo(int n) {
        return 1 << -Integer.numberOfLeadingZeros(n - 1);
    }

    private SingleConsumerQueue(Function<E, Node<E>> function) {
        for (int i = 0; i < ARENA_LENGTH; ++i) {
            this.arena[i] = new AtomicReference();
        }
        Node<Object> node = new Node<Object>(null);
        this.factory = function;
        this.lazySetTail(node);
        this.head = node;
    }

    public static <E> SingleConsumerQueue<E> optimistic() {
        Function<?, ?> function = OPTIMISIC;
        return new SingleConsumerQueue(function);
    }

    public static <E> SingleConsumerQueue<E> linearizable() {
        return new SingleConsumerQueue<Object>(LinearizableNode::new);
    }

    @Override
    public boolean isEmpty() {
        return this.head == this.tail;
    }

    @Override
    public int size() {
        int n;
        Node node = this.head;
        Node node2 = this.tail;
        for (n = 0; node != node2 && n != Integer.MAX_VALUE; ++n) {
            Node node3 = node.getNextRelaxed();
            if (node3 == null) {
                while ((node3 = node.next) == null) {
                }
            }
            node = node3;
        }
        return n;
    }

    @Override
    public boolean contains(Object object) {
        if (object == null) {
            return false;
        }
        Iterator<E> iterator = this.iterator();
        while (iterator.hasNext()) {
            if (!object.equals(iterator.next())) continue;
            return true;
        }
        return false;
    }

    @Override
    public E peek() {
        Node node = this.head;
        Node node2 = this.tail;
        if (node == node2) {
            return null;
        }
        Node node3 = node.getNextRelaxed();
        if (node3 == null) {
            while ((node3 = node.next) == null) {
            }
        }
        return node3.value;
    }

    @Override
    public boolean offer(E e) {
        Objects.requireNonNull(e);
        Node<E> node = this.factory.apply(e);
        this.append(node, node);
        return true;
    }

    @Override
    public E poll() {
        Node node = this.head;
        Node node2 = node.getNextRelaxed();
        if (node2 == null) {
            if (node == this.tail) {
                return null;
            }
            while ((node2 = node.next) == null) {
            }
        }
        Object e = node2.value;
        node2.value = null;
        this.head = node2;
        if (this.factory == OPTIMISIC) {
            node.next = null;
        }
        return e;
    }

    @Override
    public boolean add(E e) {
        return this.offer(e);
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        Objects.requireNonNull(collection);
        Node<E> node = null;
        Node<E> node2 = null;
        for (E e : collection) {
            Objects.requireNonNull(e);
            if (node == null) {
                node2 = node = this.factory.apply(e);
                continue;
            }
            Node<E> node3 = new Node<E>(e);
            node2.lazySetNext(node3);
            node2 = node3;
        }
        if (node == null) {
            return false;
        }
        this.append(node, node2);
        return true;
    }

    void append(@NonNull Node<E> node, @NonNull Node<E> node2) {
        while (true) {
            Node<E> node3;
            Node node4;
            if (this.casTail(node4 = this.tail, node2)) {
                node4.lazySetNext(node);
                if (this.factory == OPTIMISIC) {
                    return;
                }
                while (true) {
                    node.complete();
                    if (node == node2) {
                        return;
                    }
                    node3 = node.getNextRelaxed();
                    if (node3 == null) {
                        return;
                    }
                    if (node3.value == null) {
                        node.next = null;
                    }
                    node = node3;
                }
            }
            node3 = this.transferOrCombine(node, node2);
            if (node3 == null) {
                node.await();
                return;
            }
            if (node3 == node) continue;
            node2 = node3;
        }
    }

    @Nullable Node<E> transferOrCombine(@NonNull Node<E> node, Node<E> node2) {
        Node<E> node3;
        int n = SingleConsumerQueue.index();
        AtomicReference<Node<E>> atomicReference = this.arena[n];
        while (true) {
            if ((node3 = atomicReference.get()) == null) {
                if (!atomicReference.compareAndSet(null, node)) continue;
                for (int i = 0; i < SPINS; ++i) {
                    if (atomicReference.get() == node) continue;
                    return null;
                }
                return atomicReference.compareAndSet(node, null) ? node : null;
            }
            if (atomicReference.compareAndSet(node3, null)) break;
        }
        node2.lazySetNext(node3);
        node2 = SingleConsumerQueue.findLast(node3);
        for (int i = 1; i < ARENA_LENGTH; ++i) {
            atomicReference = this.arena[i + n & ARENA_MASK];
            node3 = atomicReference.get();
            if (node3 == null || !atomicReference.compareAndSet(node3, null)) continue;
            node2.lazySetNext(node3);
            node2 = SingleConsumerQueue.findLast(node3);
        }
        return node2;
    }

    static int index() {
        int n = UnsafeAccess.UNSAFE.getInt(Thread.currentThread(), PROBE);
        if (n == 0) {
            ThreadLocalRandom.current();
            n = UnsafeAccess.UNSAFE.getInt(Thread.currentThread(), PROBE);
        }
        return n & ARENA_MASK;
    }

    static <E> @NonNull Node<E> findLast(@NonNull Node<E> node) {
        Node<E> node2;
        while ((node2 = node.getNextRelaxed()) != null) {
            node = node2;
        }
        return node;
    }

    @Override
    public Iterator<E> iterator() {
        return new Iterator<E>(){
            Node<E> prev;
            Node<E> t;
            Node<E> cursor;
            boolean failOnRemoval;
            {
                this.t = SingleConsumerQueue.this.tail;
                this.cursor = SingleConsumerQueue.this.head;
                this.failOnRemoval = true;
            }

            @Override
            public boolean hasNext() {
                return this.cursor != this.t;
            }

            @Override
            public E next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.advance();
                this.failOnRemoval = false;
                return this.cursor.value;
            }

            private void advance() {
                if (this.prev == null || !this.failOnRemoval) {
                    this.prev = this.cursor;
                }
                this.cursor = this.awaitNext();
            }

            @Override
            public void remove() {
                if (this.failOnRemoval) {
                    throw new IllegalStateException();
                }
                this.failOnRemoval = true;
                this.cursor.value = null;
                if (this.t == this.cursor) {
                    this.prev.lazySetNext(null);
                    if (SingleConsumerQueue.this.casTail(this.t, this.prev)) {
                        return;
                    }
                }
                this.prev.lazySetNext(this.awaitNext());
            }

            Node<E> awaitNext() {
                if (this.cursor.getNextRelaxed() == null) {
                    while (this.cursor.next == null) {
                    }
                }
                return this.cursor.getNextRelaxed();
            }
        };
    }

    Object writeReplace() {
        return new SerializationProxy(this);
    }

    private void readObject(ObjectInputStream objectInputStream) {
        throw new InvalidObjectException("Proxy required");
    }

    static final class LinearizableNode<E>
    extends Node<E> {
        volatile boolean done;

        LinearizableNode(@Nullable E e) {
            super(e);
        }

        @Override
        void complete() {
            this.done = true;
        }

        @Override
        void await() {
            while (!this.done) {
            }
        }

        @Override
        boolean isDone() {
            return this.done;
        }
    }

    static class Node<E> {
        static final long NEXT_OFFSET = UnsafeAccess.objectFieldOffset(Node.class, "next");
        @Nullable E value;
        volatile @Nullable Node<E> next;

        Node(@Nullable E e) {
            this.value = e;
        }

        @Nullable Node<E> getNextRelaxed() {
            return (Node)UnsafeAccess.UNSAFE.getObject(this, NEXT_OFFSET);
        }

        void lazySetNext(@Nullable Node<E> node) {
            UnsafeAccess.UNSAFE.putOrderedObject(this, NEXT_OFFSET, node);
        }

        void complete() {
        }

        void await() {
        }

        boolean isDone() {
            return true;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[" + this.value + "]";
        }
    }

    static final class SerializationProxy<E>
    implements Serializable {
        final boolean linearizable;
        final List<E> elements;
        static final long serialVersionUID = 1L;

        SerializationProxy(SingleConsumerQueue<E> singleConsumerQueue) {
            this.linearizable = singleConsumerQueue.factory.apply(null) instanceof LinearizableNode;
            this.elements = new ArrayList<E>(singleConsumerQueue);
        }

        Object readResolve() {
            SingleConsumerQueue<E> singleConsumerQueue = this.linearizable ? SingleConsumerQueue.linearizable() : SingleConsumerQueue.optimistic();
            singleConsumerQueue.addAll(this.elements);
            return singleConsumerQueue;
        }
    }
}

