/*
 * Decompiled with CFR 0.152.
 */
package org.skills.utils;

import com.google.common.base.Strings;
import java.util.concurrent.TimeUnit;
import org.skills.main.locale.MessageHandler;

public class NoEpochDate {
    public final long millis;
    public final long absoluteSeconds;
    public final long absoluteMinutes;
    public final long absoluteHours;
    public final long absoluteDays;
    public final long absoluteWeeks;
    public final long absoluteMonths;
    public final long years;
    public final long seconds;
    public final long minutes;
    public final long hours;
    public final long days;
    public final long weeks;
    public final long months;

    public NoEpochDate(long l) {
        this(l, TimeUnit.MILLISECONDS);
    }

    public NoEpochDate(long l, TimeUnit timeUnit) {
        this.millis = timeUnit.toMillis(Math.abs(l));
        this.absoluteSeconds = this.millis / 1000L;
        this.absoluteMinutes = this.absoluteSeconds / 60L;
        this.absoluteHours = this.absoluteMinutes / 60L;
        this.absoluteDays = this.absoluteHours / 24L;
        this.absoluteWeeks = this.absoluteDays / 7L;
        this.absoluteMonths = this.absoluteDays / 30L;
        this.years = this.absoluteDays / 356L;
        this.seconds = (long)Math.floor(this.absoluteSeconds % 60L);
        this.minutes = (long)Math.floor(this.absoluteMinutes % 60L);
        this.hours = (long)Math.floor(this.absoluteHours % 24L);
        this.days = (long)Math.floor(this.absoluteDays % 30L);
        this.weeks = (long)Math.floor(this.absoluteWeeks % 7L);
        this.months = (long)Math.floor(this.absoluteMonths % 12L);
    }

    private static String replaceVariables(String string, Object ... objectArray) {
        for (int i = objectArray.length; i > 0; i -= 2) {
            String string2 = String.valueOf(objectArray[i - 2]);
            String string3 = String.valueOf(objectArray[i - 1]);
            string = MessageHandler.replace(string, string2, string3);
        }
        return string;
    }

    private static String format(long l) {
        return l >= 10L ? Long.toString(l) : "0" + l;
    }

    public String toString() {
        return this.years + " " + this.absoluteMonths + ' ' + this.absoluteWeeks + ' ' + this.absoluteDays + ' ' + this.absoluteHours + ' ' + this.absoluteMinutes + ' ' + this.absoluteSeconds + ' ' + this.months + ' ' + this.weeks + ' ' + this.days + ' ' + this.hours + ' ' + this.minutes + ' ' + this.seconds + ' ' + this.millis;
    }

    public String format(String string) {
        if (Strings.isNullOrEmpty((String)string)) {
            return string;
        }
        if (string.equalsIgnoreCase("managed")) {
            return this.formatManaged();
        }
        return NoEpochDate.replaceVariables(string, "yyyy", this.years, "MM", NoEpochDate.format(this.months), "MMA", this.absoluteMonths, "wwww", this.weeks, "wwwwa", this.absoluteWeeks, "dd", NoEpochDate.format(this.days), "dda", this.absoluteDays, "hh", NoEpochDate.format(this.hours), "hhf", this.hours, "hha", NoEpochDate.format(this.absoluteHours), "hhaf", this.absoluteHours, "mm", NoEpochDate.format(this.minutes), "mmf", this.minutes, "mma", NoEpochDate.format(this.absoluteMinutes), "mmaf", NoEpochDate.format(this.absoluteMinutes), "ss", NoEpochDate.format(this.seconds), "ssf", this.seconds, "ssa", NoEpochDate.format(this.absoluteSeconds), "ssaf", this.absoluteSeconds, "mss", this.millis);
    }

    public String formatManaged() {
        if (this.absoluteMinutes == 0L) {
            return this.format("00:00:ssa");
        }
        if (this.absoluteHours == 0L) {
            return this.format("00:mma:ss");
        }
        if (this.absoluteDays == 0L) {
            return this.format("hha:mm:ss");
        }
        if (this.absoluteWeeks == 0L) {
            return this.format("dda days, hh:mm:ss");
        }
        if (this.absoluteMonths == 0L) {
            return this.format("wwwwa weeks, dd days, hh:mm:ss");
        }
        return this.format("MMA months, wwww weeks, dd days, hh:mm:ss");
    }
}

