/*
 * Decompiled with CFR 0.152.
 */
package org.skills.utils;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.util.Vector;
import org.skills.main.SkillsPro;
import org.skills.utils.MathUtils;

public class LocationUtils {
    public static final BlockFace[] AXIS = new BlockFace[]{BlockFace.NORTH, BlockFace.EAST, BlockFace.SOUTH, BlockFace.WEST};
    public static final BlockFace[] RADIAL = new BlockFace[]{BlockFace.NORTH, BlockFace.NORTH_EAST, BlockFace.EAST, BlockFace.SOUTH_EAST, BlockFace.SOUTH, BlockFace.SOUTH_WEST, BlockFace.WEST, BlockFace.NORTH_WEST};
    private static final double ROUND_SCALING = Math.pow(10.0, 1.0);

    public static void faceOther(Entity entity, Entity entity2) {
        entity.getLocation().setDirection(entity.getLocation().toVector().subtract(entity2.getLocation().toVector()));
    }

    private static double roundToDigits(double d) {
        return (double)Math.round(d * ROUND_SCALING) / ROUND_SCALING;
    }

    public static Location roundLocationPrecision(Location location) {
        return new Location(location.getWorld(), LocationUtils.roundToDigits(location.getX()), LocationUtils.roundToDigits(location.getY()), LocationUtils.roundToDigits(location.getZ()), (float)LocationUtils.roundToDigits(location.getYaw()), (float)LocationUtils.roundToDigits(location.getPitch()));
    }

    public static String toReadableLocation(Location location) {
        return location.getBlockX() + ", " + location.getBlockY() + ", " + location.getBlockZ();
    }

    public static String toReadableWorldLocation(Location location) {
        return location.getWorld().getName() + ", " + LocationUtils.toReadableLocation(location);
    }

    public static void whoooosh(Entity entity, Location location, double d, double d2, double d3) {
        Location location2 = entity.getLocation();
        location2.setY(location2.getY() + 0.5);
        entity.teleport(location2);
        double d4 = -0.1;
        double d5 = location.distance(location2);
        double d6 = (1.0 + d * d5) * (location.getX() - location2.getX()) / d5;
        double d7 = (1.0 + d2 * d5) * (location.getY() - location2.getY()) / d5 - 0.5 * d4 * d5;
        double d8 = (1.0 + d3 * d5) * (location.getZ() - location2.getZ()) / d5;
        Vector vector = new Vector(d6, d7, d8);
        entity.setVelocity(vector);
    }

    public static Location getHandLocation(Player player, boolean bl) {
        double d = bl ? -1.0 : 1.0;
        double d2 = Math.toRadians(d * (double)player.getLocation().getYaw() - 45.0);
        Location location = player.getLocation();
        double d3 = 0.5 * Math.sin(d2) + location.getX();
        double d4 = location.getY() + 0.7;
        double d5 = 0.5 * Math.cos(d2) + location.getZ();
        return new Location(player.getWorld(), d3, d4, d5);
    }

    public static BukkitTask rotate(final Entity entity, final float f, final boolean bl, final boolean bl2, final int n) {
        return new BukkitRunnable(){
            int times;
            float yawF;
            float pitchF;
            {
                this.times = n;
                this.yawF = entity.getLocation().getYaw();
                this.pitchF = entity.getLocation().getPitch();
            }

            public void run() {
                Location location = entity.getLocation();
                --this.times;
                if (bl) {
                    this.yawF += f;
                    location.setYaw(this.yawF);
                }
                if (bl2) {
                    this.pitchF += f;
                    location.setPitch(this.pitchF);
                }
                entity.teleport(location);
                if (this.times <= 0) {
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)SkillsPro.get(), 0L, 1L);
    }

    public static Location centerAxis(Location location) {
        Location location2 = location.clone();
        location2.setX((double)location2.getBlockX() + 0.5);
        location2.setY((double)location2.getBlockY());
        location2.setZ((double)location2.getBlockZ() + 0.5);
        return location2;
    }

    public static Location centerView(Location location) {
        Location location2 = location.clone();
        location2.setYaw(LocationUtils.centerYaw(location2.getYaw()));
        location2.setPitch(0.0f);
        return location2;
    }

    public static Location cleanLocation(Location location) {
        Location location2 = location.clone();
        location2.setX((double)location2.getBlockX() + 0.5);
        location2.setY((double)location2.getBlockY());
        location2.setZ((double)location2.getBlockZ() + 0.5);
        location2.setYaw(LocationUtils.centerYaw(location2.getYaw()));
        location2.setPitch(0.0f);
        return location2;
    }

    public static Location getSafeLocation(Location location) {
        Location location2 = location.clone();
        location2 = LocationUtils.centerAxis(location2);
        location2.setYaw((float)MathUtils.roundToDigits(location2.getYaw(), 1));
        location2.setPitch((float)MathUtils.roundToDigits(location2.getPitch(), 1));
        return location2;
    }

    public static boolean hasMoved(Location location, Location location2) {
        return location.getX() != location2.getX() || location.getY() != location2.getY() || location.getZ() != location2.getZ();
    }

    public static BlockFace yawToFaceRadial(float f) {
        return RADIAL[Math.round(f / 45.0f) & 7];
    }

    public static BlockFace yawToFace(float f) {
        return AXIS[Math.round(f / 90.0f) & 3];
    }

    public static float centerYaw(float f) {
        return LocationUtils.faceToYaw(LocationUtils.yawToFace(f));
    }

    public static float faceToYaw(BlockFace blockFace) {
        switch (blockFace) {
            case NORTH_EAST: {
                return 45.0f;
            }
            case EAST: {
                return 90.0f;
            }
            case SOUTH_EAST: {
                return 135.0f;
            }
            case SOUTH: {
                return 180.0f;
            }
            case SOUTH_WEST: {
                return 225.0f;
            }
            case WEST: {
                return 270.0f;
            }
            case NORTH_WEST: {
                return 315.0f;
            }
        }
        return 0.0f;
    }

    public static BlockFace pitchToFace(float f) {
        return f < -25.0f ? BlockFace.UP : (f > 25.0f ? BlockFace.DOWN : null);
    }

    public static float compareDirection(Location location, Location location2) {
        return (float)Math.toDegrees(Math.atan2((double)location.getBlockX() - location2.getX(), location2.getZ() - (double)location.getBlockZ()));
    }

    public static BlockFace getEntityBlockFace(LivingEntity livingEntity) {
        List list = livingEntity.getLastTwoTargetBlocks(null, 6);
        if (list.size() != 2) {
            return null;
        }
        Block block = (Block)list.get(1);
        Block block2 = (Block)list.get(0);
        return block.getFace(block2);
    }

    public static BlockFace getyawToFace(float f) {
        if ((f %= 360.0f) < 0.0f) {
            f += 360.0f;
        }
        f = Math.round(f / 45.0f);
        switch ((int)f) {
            case 1: {
                return BlockFace.NORTH_WEST;
            }
            case 2: {
                return BlockFace.NORTH;
            }
            case 3: {
                return BlockFace.NORTH_EAST;
            }
            case 4: {
                return BlockFace.EAST;
            }
            case 5: {
                return BlockFace.SOUTH_EAST;
            }
            case 6: {
                return BlockFace.SOUTH;
            }
            case 7: {
                return BlockFace.SOUTH_WEST;
            }
        }
        return BlockFace.WEST;
    }

    public static List<Chunk> getChunksAround(Location location, int n) {
        World world = location.getWorld();
        int n2 = location.getChunk().getX();
        int n3 = location.getChunk().getZ();
        ArrayList<Chunk> arrayList = new ArrayList<Chunk>();
        for (int i = n2 - n; i < n2 + n; ++i) {
            for (int j = n3 - n; j < n3 + n; ++j) {
                arrayList.add(world.getChunkAt(i, j));
            }
        }
        return arrayList;
    }

    public static enum MinecraftTime {
        FULL(24000L),
        DAY(1000L),
        NOON(6000L),
        SUNSET(12000L),
        NIGHT(13000L),
        MIDNIGHT(18000L),
        FULL_MOON(14000L),
        SUNRISE(22200L);

        private final long time;

        private MinecraftTime(long l) {
            this.time = l;
        }

        public static boolean isDay(World world) {
            return world.getTime() > 23460L || world.getTime() < 12000L;
        }

        public void setTime(Player player) {
            player.setPlayerTime(this.time, false);
        }
    }
}

