/*
 * Decompiled with CFR 0.152.
 */
package org.skills.utils;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashSet;
import java.util.UUID;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.NumberConversions;

public class Laser {
    private final int duration;
    private final int distanceSquared;
    private final Object createGuardianPacket;
    private final Object createSquidPacket;
    private final Object teamAddPacket;
    private final Object destroyPacket;
    private final Object metadataPacketGuardian;
    private final Object metadataPacketSquid;
    private final Object fakeGuardianDataWatcher;
    private final int squid;
    private final UUID squidUUID;
    private final int guardian;
    private final UUID guardianUUID;
    private final HashSet<Player> show = new HashSet();
    private Location start;
    private Location end;
    private BukkitRunnable run;

    public Laser(Location location, Location location2, int n, int n2) {
        this.start = location;
        this.end = location2;
        this.duration = n;
        this.distanceSquared = n2 * n2;
        this.createSquidPacket = Packets.createPacketSquidSpawn(location2);
        this.squid = (Integer)Packets.getField(Packets.packetSpawn, "a", this.createSquidPacket);
        this.squidUUID = (UUID)Packets.getField(Packets.packetSpawn, "b", this.createSquidPacket);
        this.metadataPacketSquid = Packets.createPacketMetadata(this.squid, Packets.fakeSquidWatcher);
        Packets.setDirtyWatcher(Packets.fakeSquidWatcher);
        this.fakeGuardianDataWatcher = Packets.createFakeDataWatcher();
        this.createGuardianPacket = Packets.createPacketGuardianSpawn(location, this.fakeGuardianDataWatcher, this.squid);
        this.guardian = (Integer)Packets.getField(Packets.packetSpawn, "a", this.createGuardianPacket);
        this.guardianUUID = (UUID)Packets.getField(Packets.packetSpawn, "b", this.createGuardianPacket);
        this.metadataPacketGuardian = Packets.createPacketMetadata(this.guardian, this.fakeGuardianDataWatcher);
        this.teamAddPacket = Packets.createPacketTeamAddEntities(this.squidUUID, this.guardianUUID);
        this.destroyPacket = Packets.createPacketRemoveEntities(this.squid, this.guardian);
    }

    public void start(Plugin plugin) {
        Validate.isTrue((this.run == null ? 1 : 0) != 0, (String)"Task already started");
        this.run = new BukkitRunnable(){
            final World world;
            int time;
            {
                this.world = Laser.this.start.getWorld();
                this.time = Laser.this.duration;
            }

            public void run() {
                try {
                    for (Player player : this.world.getPlayers()) {
                        if (Laser.this.isCloseEnough(player.getLocation())) {
                            if (!Laser.this.show.add(player)) continue;
                            Laser.this.sendStartPackets(player);
                            continue;
                        }
                        if (!Laser.this.show.remove(player)) continue;
                        Packets.sendPacket(player, Laser.this.destroyPacket);
                    }
                }
                catch (ReflectiveOperationException reflectiveOperationException) {
                    reflectiveOperationException.printStackTrace();
                }
                if (--this.time == 0) {
                    this.cancel();
                }
            }

            public synchronized void cancel() {
                super.cancel();
                try {
                    for (Player player : Laser.this.show) {
                        Packets.sendPacket(player, Laser.this.destroyPacket);
                    }
                }
                catch (ReflectiveOperationException reflectiveOperationException) {
                    reflectiveOperationException.printStackTrace();
                }
                Laser.this.run = null;
            }
        };
        this.run.runTaskTimerAsynchronously(plugin, 0L, 20L);
    }

    public void stop() {
        Validate.isTrue((this.run != null ? 1 : 0) != 0, (String)"Task not started");
        this.run.cancel();
    }

    public void moveStart(Location location) {
        this.start = location;
        Object object = Packets.createPacketMoveEntity(this.start, this.guardian);
        for (Player player : this.show) {
            Packets.sendPacket(player, object);
        }
    }

    public Location getStart() {
        return this.start;
    }

    public void moveEnd(Location location) {
        this.end = location;
        Object object = Packets.createPacketMoveEntity(this.end, this.squid);
        for (Player player : this.show) {
            Packets.sendPacket(player, object);
        }
    }

    public Location getEnd() {
        return this.end;
    }

    public void callColorChange() {
        for (Player player : this.show) {
            Packets.sendPacket(player, this.metadataPacketGuardian);
        }
    }

    public boolean isStarted() {
        return this.run != null;
    }

    private void sendStartPackets(Player player) {
        Packets.sendPacket(player, this.createSquidPacket);
        Packets.sendPacket(player, this.createGuardianPacket);
        if (Packets.version > 14) {
            Packets.sendPacket(player, this.metadataPacketSquid);
            Packets.sendPacket(player, this.metadataPacketGuardian);
        }
        Packets.sendPacket(player, Packets.packetTeamCreate);
        Packets.sendPacket(player, this.teamAddPacket);
    }

    private boolean isCloseEnough(Location location) {
        return this.distanceSquared(this.start, location) <= (double)this.distanceSquared || this.distanceSquared(this.end, location) <= (double)this.distanceSquared;
    }

    private double distanceSquared(Location location, Location location2) {
        return NumberConversions.square((double)(location.getX() - location2.getX())) + NumberConversions.square((double)(location.getY() - location2.getY())) + NumberConversions.square((double)(location.getZ() - location2.getZ()));
    }

    private static class Packets {
        private static final int version = Integer.parseInt(Bukkit.getServer().getClass().getPackage().getName().replace(".", ",").split(",")[3].substring(1).split("_")[1]);
        private static final String npack = "net.minecraft.server." + Bukkit.getServer().getClass().getPackage().getName().replace(".", ",").split(",")[3] + ".";
        private static final String cpack = Bukkit.getServer().getClass().getPackage().getName() + ".";
        private static int lastIssuedEID = 2000000000;
        private static Object packetTeamCreate;
        private static Constructor<?> watcherConstructor;
        private static Method watcherSet;
        private static Method watcherRegister;
        private static Method watcherDirty;
        private static Class<?> packetSpawn;
        private static Class<?> packetRemove;
        private static Class<?> packetTeleport;
        private static Class<?> packetTeam;
        private static Class<?> packetMetadata;
        private static Object watcherObject1;
        private static Object watcherObject2;
        private static Object watcherObject3;
        private static int squidID;
        private static int guardianID;
        private static Object fakeSquid;
        private static Object fakeSquidWatcher;

        private Packets() {
        }

        static int generateEID() {
            return lastIssuedEID++;
        }

        public static void sendPacket(Player player, Object object) {
            Object object2 = Class.forName(cpack + "entity.CraftPlayer").getDeclaredMethod("getHandle", new Class[0]).invoke((Object)player, new Object[0]);
            Object object3 = object2.getClass().getDeclaredField("playerConnection").get(object2);
            object3.getClass().getDeclaredMethod("sendPacket", Class.forName(npack + "Packet")).invoke(object3, object);
        }

        public static Object createFakeDataWatcher() {
            Object obj = watcherConstructor.newInstance(fakeSquid);
            if (version > 13) {
                Packets.setField(obj, "registrationLocked", false);
            }
            return obj;
        }

        public static void setDirtyWatcher(Object object) {
            if (version >= 15) {
                watcherDirty.invoke(object, watcherObject1);
            }
        }

        public static Object createPacketSquidSpawn(Location location) {
            Object obj = packetSpawn.newInstance();
            Packets.setField(obj, "a", Packets.generateEID());
            Packets.setField(obj, "b", UUID.randomUUID());
            Packets.setField(obj, "c", squidID);
            Packets.setField(obj, "d", location.getX());
            Packets.setField(obj, "e", location.getY());
            Packets.setField(obj, "f", location.getZ());
            Packets.setField(obj, "j", (byte)(location.getYaw() * 256.0f / 360.0f));
            Packets.setField(obj, "k", (byte)(location.getPitch() * 256.0f / 360.0f));
            if (version <= 14) {
                Packets.setField(obj, "m", fakeSquidWatcher);
            }
            return obj;
        }

        public static Object createPacketGuardianSpawn(Location location, Object object, int n) {
            Object obj = packetSpawn.newInstance();
            Packets.setField(obj, "a", Packets.generateEID());
            Packets.setField(obj, "b", UUID.randomUUID());
            Packets.setField(obj, "c", guardianID);
            Packets.setField(obj, "d", location.getX());
            Packets.setField(obj, "e", location.getY());
            Packets.setField(obj, "f", location.getZ());
            Packets.setField(obj, "j", (byte)(location.getYaw() * 256.0f / 360.0f));
            Packets.setField(obj, "k", (byte)(location.getPitch() * 256.0f / 360.0f));
            Packets.tryWatcherSet(object, watcherObject1, (byte)32);
            Packets.tryWatcherSet(object, watcherObject2, false);
            Packets.tryWatcherSet(object, watcherObject3, n);
            if (version <= 14) {
                Packets.setField(obj, "m", object);
            }
            return obj;
        }

        public static Object createPacketRemoveEntities(int n, int n2) {
            Object obj = packetRemove.newInstance();
            Packets.setField(obj, "a", new int[]{n, n2});
            return obj;
        }

        public static Object createPacketMoveEntity(Location location, int n) {
            Object obj = packetTeleport.newInstance();
            Packets.setField(obj, "a", n);
            Packets.setField(obj, "b", location.getX());
            Packets.setField(obj, "c", location.getY());
            Packets.setField(obj, "d", location.getZ());
            Packets.setField(obj, "e", (byte)(location.getYaw() * 256.0f / 360.0f));
            Packets.setField(obj, "f", (byte)(location.getPitch() * 256.0f / 360.0f));
            Packets.setField(obj, "g", true);
            return obj;
        }

        public static Object createPacketTeamAddEntities(UUID uUID, UUID uUID2) {
            Object obj = packetTeam.newInstance();
            Packets.setField(obj, "a", "noclip");
            Packets.setField(obj, "i", 3);
            Collection collection = (Collection)Packets.getField(packetTeam, "h", obj);
            collection.add(uUID.toString());
            collection.add(uUID2.toString());
            return obj;
        }

        private static Object createPacketMetadata(int n, Object object) {
            return packetMetadata.getConstructor(Integer.TYPE, object.getClass(), Boolean.TYPE).newInstance(n, object, false);
        }

        private static void tryWatcherSet(Object object, Object object2, Object object3) {
            block2: {
                try {
                    watcherSet.invoke(object, object2, object3);
                }
                catch (InvocationTargetException invocationTargetException) {
                    watcherRegister.invoke(object, object2, object3);
                    if (version < 15) break block2;
                    watcherDirty.invoke(object, object2);
                }
            }
        }

        private static Method getMethod(Class<?> clazz, String string) {
            for (Method method : clazz.getDeclaredMethods()) {
                if (!method.getName().equals(string)) continue;
                return method;
            }
            return null;
        }

        private static void setField(Object object, String string, Object object2) {
            Validate.notNull((Object)object);
            Field field = object.getClass().getDeclaredField(string);
            field.setAccessible(true);
            field.set(object, object2);
        }

        private static Object getField(Class<?> clazz, String string, Object object) {
            Field field = clazz.getDeclaredField(string);
            field.setAccessible(true);
            return field.get(object);
        }

        static {
            try {
                Object[] objectArray;
                String string = null;
                String string2 = null;
                String string3 = null;
                if (version < 13) {
                    string = "Z";
                    string2 = "bA";
                    string3 = "bB";
                    squidID = 94;
                    guardianID = 68;
                } else if (version == 13) {
                    string = "ac";
                    string2 = "bF";
                    string3 = "bG";
                    squidID = 70;
                    guardianID = 28;
                } else if (version == 14) {
                    string = "W";
                    string2 = "b";
                    string3 = "bD";
                    squidID = 73;
                    guardianID = 30;
                } else if (version == 15) {
                    string = "T";
                    string2 = "b";
                    string3 = "bA";
                    squidID = 74;
                    guardianID = 31;
                } else if (version >= 16) {
                    string = "S";
                    string2 = "b";
                    string3 = "d";
                    squidID = 74;
                    guardianID = 31;
                }
                watcherObject1 = Packets.getField(Class.forName(npack + "Entity"), string, null);
                watcherObject2 = Packets.getField(Class.forName(npack + "EntityGuardian"), string2, null);
                watcherObject3 = Packets.getField(Class.forName(npack + "EntityGuardian"), string3, null);
                watcherConstructor = Class.forName(npack + "DataWatcher").getDeclaredConstructor(Class.forName(npack + "Entity"));
                watcherSet = Packets.getMethod(Class.forName(npack + "DataWatcher"), "set");
                watcherRegister = Packets.getMethod(Class.forName(npack + "DataWatcher"), "register");
                if (version >= 15) {
                    watcherDirty = Packets.getMethod(Class.forName(npack + "DataWatcher"), "markDirty");
                }
                packetSpawn = Class.forName(npack + "PacketPlayOutSpawnEntityLiving");
                packetRemove = Class.forName(npack + "PacketPlayOutEntityDestroy");
                packetTeleport = Class.forName(npack + "PacketPlayOutEntityTeleport");
                packetTeam = Class.forName(npack + "PacketPlayOutScoreboardTeam");
                packetMetadata = Class.forName(npack + "PacketPlayOutEntityMetadata");
                packetTeamCreate = packetTeam.newInstance();
                Packets.setField(packetTeamCreate, "a", "noclip");
                Packets.setField(packetTeamCreate, "i", 0);
                Packets.setField(packetTeamCreate, "f", "never");
                Object object = Class.forName(cpack + "CraftWorld").getDeclaredMethod("getHandle", new Class[0]).invoke(Bukkit.getWorlds().get(0), new Object[0]);
                if (version < 14) {
                    Object[] objectArray2 = new Object[1];
                    objectArray = objectArray2;
                    objectArray2[0] = object;
                } else {
                    Object[] objectArray3 = new Object[2];
                    objectArray3[0] = Class.forName(npack + "EntityTypes").getDeclaredField("SQUID").get(null);
                    objectArray = objectArray3;
                    objectArray3[1] = object;
                }
                Object[] objectArray4 = objectArray;
                fakeSquid = Packets.getMethod(Class.forName(cpack + "entity.CraftSquid"), "getHandle").invoke(Class.forName(cpack + "entity.CraftSquid").getDeclaredConstructors()[0].newInstance(null, Class.forName(npack + "EntitySquid").getDeclaredConstructors()[0].newInstance(objectArray4)), new Object[0]);
                fakeSquidWatcher = Packets.createFakeDataWatcher();
                Packets.tryWatcherSet(fakeSquidWatcher, watcherObject1, (byte)32);
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                reflectiveOperationException.printStackTrace();
            }
        }
    }
}

