/*
 * Decompiled with CFR 0.152.
 */
package org.skills.utils;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class Cooldown {
    private static final Map<String, Cooldown> COOLDOWNS = new HashMap<String, Cooldown>();
    private final long time;
    private final long start;

    public Cooldown(Object object, String string, long l, TimeUnit timeUnit) {
        this.time = timeUnit.toMillis(l);
        this.start = System.currentTimeMillis();
        COOLDOWNS.put(object + string, this);
    }

    public Cooldown(Object object, String string, long l) {
        this(object, string, l, TimeUnit.MILLISECONDS);
    }

    public static boolean isInCooldown(Object object, String string) {
        return Cooldown.getTimeLeft(object, string) != 0L;
    }

    public static Cooldown stop(Object object, String string) {
        return COOLDOWNS.remove(object + string);
    }

    public static Cooldown getCooldown(Object object, String string) {
        return COOLDOWNS.get(object + string);
    }

    public static long getTimeLeft(Object object, String string) {
        Cooldown cooldown = Cooldown.getCooldown(object, string);
        if (cooldown == null) {
            return 0L;
        }
        long l = System.currentTimeMillis();
        long l2 = l - cooldown.start;
        if (l2 >= cooldown.time) {
            Cooldown.stop(object, string);
            return 0L;
        }
        return cooldown.time - l2;
    }
}

