/*
 * Decompiled with CFR 0.152.
 */
package org.skills.utils;

import java.util.function.Function;
import org.skills.utils.MathUtils;
import org.skills.utils.Pair;

public final class BooleanEval {
    public static boolean evaluate(String string, Function<String, String> function) {
        return BooleanEval.evaluate(string, function, false);
    }

    private static boolean evaluate(String string, Function<String, String> function, boolean bl) {
        int c;
        int n;
        int n2;
        int n3 = string.indexOf(40);
        while (n3 > -1) {
            String string2 = BooleanEval.getSubExpression(n3 + 1, string);
            n2 = string2.length();
            n = n3 + n2;
            if (BooleanEval.hasLogicOperator(string2)) {
                c = BooleanEval.evaluate(string2, function) ? 1 : 0;
                string = string.substring(0, n3) + (c != 0) + string.substring(n + 2);
            }
            n3 = string.indexOf(40, n);
        }
        boolean bl2 = bl;
        n2 = string.length();
        for (n = 0; n < n2; ++n) {
            c = string.charAt(n);
            if (!BooleanEval.isLogicOperator(c) || c == 33 && string.charAt(n + 1) != '=') continue;
            try {
                Pair<Integer, BooleanOperator> pair = BooleanEval.getLogicOperator(n, string);
                BooleanOperator booleanOperator = pair.getValue();
                if (booleanOperator != BooleanOperator.AND && booleanOperator != BooleanOperator.OR) {
                    if (!bl) {
                        ++n;
                        continue;
                    }
                } else {
                    bl2 = false;
                }
                int n4 = pair.getKey();
                String string3 = string.substring(0, n).trim();
                String string4 = string.substring(n + n4).trim();
                if (function != null) {
                    string3 = function.apply(string3);
                    string4 = function.apply(string4);
                }
                return booleanOperator.evaluate(string3, string4);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (bl2 && !bl) {
            return false;
        }
        int n5 = n = (string = string.trim()).charAt(0) == '!' ? 1 : 0;
        if (n != 0) {
            string = string.substring(1);
        }
        if (function != null) {
            string = function.apply(string);
        }
        if ((n2 = string.length()) == 5 || n2 == 4) {
            if (string.equals("true")) {
                return n == 0;
            }
            if (string.equals("false")) {
                return n != 0;
            }
        }
        if (bl2 && bl) {
            throw new IllegalArgumentException("Unknown boolean expression: " + string);
        }
        return BooleanEval.evaluate(string, function, true);
    }

    private static boolean hasLogicOperator(String string) {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            if (!BooleanEval.isLogicOperator(string.charAt(i))) continue;
            return true;
        }
        return false;
    }

    private static String getSubExpression(int n, String string) {
        int n2 = 1;
        int n3 = string.length();
        for (int i = n; i < n3; ++i) {
            char c = string.charAt(i);
            if (c == '(') {
                ++n2;
                continue;
            }
            if (c != ')' || --n2 != 0) continue;
            return string.substring(n, i);
        }
        throw new IllegalArgumentException("Invalid sub expression in expression: " + string);
    }

    private static boolean isLogicOperator(char c) {
        return c == '<' || c == '>' || c == '!' || c == '=' || c == '&' || c == '|';
    }

    private static Pair<Integer, BooleanOperator> getLogicOperator(int n, String string) {
        for (BooleanOperator booleanOperator : BooleanOperator.OPERATORS) {
            for (String string2 : booleanOperator.symbols) {
                int n2 = string2.length();
                String string3 = string.substring(n, n + n2);
                if (!string2.equals(string3)) continue;
                return Pair.of(n2, booleanOperator);
            }
        }
        throw new IllegalArgumentException(n + " Unknown logical operator starting from: '" + string.substring(n) + "' in expression: " + string);
    }

    private static enum BooleanOperator {
        AND(new String[]{"&&"}){

            @Override
            boolean evaluate(String string, String string2) {
                return BooleanEval.evaluate(string, null, true) && BooleanEval.evaluate(string2, null, true);
            }
        }
        ,
        OR(new String[]{"||"}){

            @Override
            boolean evaluate(String string, String string2) {
                return BooleanEval.evaluate(string, null, true) || BooleanEval.evaluate(string2, null, true);
            }
        }
        ,
        NOT_EQUALS(new String[]{"!="}){

            @Override
            boolean evaluate(String string, String string2) {
                try {
                    double d = MathUtils.evaluateEquation(string);
                    double d2 = MathUtils.evaluateEquation(string2);
                    return d == d2;
                }
                catch (Exception exception) {
                    return !string.equals(string2);
                }
            }
        }
        ,
        EQUALS(new String[]{"=", "=="}){

            @Override
            boolean evaluate(String string, String string2) {
                try {
                    double d = MathUtils.evaluateEquation(string);
                    double d2 = MathUtils.evaluateEquation(string2);
                    return d == d2;
                }
                catch (Exception exception) {
                    return string.equals(string2);
                }
            }
        }
        ,
        LESS_THAN_OR_EQUAL(new String[]{"<="}){

            @Override
            boolean evaluate(String string, String string2) {
                double d;
                double d2 = MathUtils.evaluateEquation(string);
                return d2 <= (d = MathUtils.evaluateEquation(string2));
            }
        }
        ,
        LESS_THAN(new String[]{"<"}){

            @Override
            boolean evaluate(String string, String string2) {
                double d;
                double d2 = MathUtils.evaluateEquation(string);
                return d2 < (d = MathUtils.evaluateEquation(string2));
            }
        }
        ,
        GREATER_THAN_OR_EQUAL(new String[]{">="}){

            @Override
            boolean evaluate(String string, String string2) {
                double d;
                double d2 = MathUtils.evaluateEquation(string);
                return d2 >= (d = MathUtils.evaluateEquation(string2));
            }
        }
        ,
        GREATER_THAN(new String[]{">"}){

            @Override
            boolean evaluate(String string, String string2) {
                double d;
                double d2 = MathUtils.evaluateEquation(string);
                return d2 > (d = MathUtils.evaluateEquation(string2));
            }
        };

        private static final BooleanOperator[] OPERATORS;
        private final String[] symbols;

        private BooleanOperator(String ... stringArray) {
            this.symbols = stringArray;
        }

        abstract boolean evaluate(String var1, String var2);

        static {
            OPERATORS = BooleanOperator.values();
        }
    }
}

