/*
 * Decompiled with CFR 0.152.
 */
package org.skills.types;

import com.google.common.base.Strings;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.bukkit.configuration.ConfigurationSection;
import org.skills.main.SkillsPro;

public class Stat {
    public static final Set<Stat> STATS = new HashSet<Stat>();
    public static Stat POINTS;
    private final String node;
    private final String name;
    private final String color;
    private final int maxLevel;

    public Stat(String string, String string2, String string3, int n) {
        this.node = string;
        this.name = string2;
        this.color = string3;
        this.maxLevel = n;
    }

    public static void init(SkillsPro skillsPro) {
        STATS.clear();
        ConfigurationSection configurationSection = skillsPro.getConfig().getConfigurationSection("stats.types");
        for (String string : configurationSection.getKeys(false)) {
            ConfigurationSection configurationSection2 = configurationSection.getConfigurationSection(string);
            Stat stat = new Stat(string, configurationSection2.getString("name"), configurationSection2.getString("color"), configurationSection2.getInt("max-level"));
            if (string.equalsIgnoreCase("pts")) {
                POINTS = stat;
            }
            STATS.add(stat);
        }
    }

    public static Stat getStat(String string) {
        if (Strings.isNullOrEmpty((String)string)) {
            return null;
        }
        return STATS.stream().filter(stat -> stat.node.equalsIgnoreCase(string)).findFirst().orElse(null);
    }

    public static boolean isPoints(String string) {
        return string.equals(POINTS.getDataNode());
    }

    public String getDataNode() {
        return this.node.toUpperCase(Locale.ENGLISH);
    }

    public String getColor() {
        return this.color;
    }

    public String getName() {
        return this.name;
    }

    public String getNode() {
        return this.node;
    }

    public int getMaxLevel() {
        return this.maxLevel;
    }
}

