/*
 * Decompiled with CFR 0.152.
 */
package org.skills.types;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import org.apache.commons.lang.Validate;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.skills.abilities.Ability;
import org.skills.abilities.AbilityManager;
import org.skills.main.SkillsConfig;
import org.skills.main.SkillsPro;
import org.skills.main.locale.MessageHandler;
import org.skills.main.locale.SkillsLang;
import org.skills.types.Energy;
import org.skills.types.Skill;
import org.skills.types.SkillScaling;
import org.skills.utils.YamlAdapter;

public class SkillManager {
    private static final HashMap<String, Skill> SKILLS = new HashMap();

    public SkillManager(SkillsPro skillsPro) {
        Ability.reload();
        AbilityManager.registerAll();
        Path path2 = skillsPro.getDataFolder().toPath().resolve("Skills");
        if (!Files.exists(path2, new LinkOption[0])) {
            URI uRI = null;
            try {
                uRI = SkillsPro.class.getResource("/Skills").toURI();
            }
            catch (URISyntaxException uRISyntaxException) {
                uRISyntaxException.printStackTrace();
            }
            try (FileSystem fileSystem = FileSystems.newFileSystem(uRI, new HashMap());){
                for (Path path3 : fileSystem.getRootDirectories()) {
                    Files.list(path3.resolve("/Skills")).forEach(path -> {
                        String string = path.getFileName().toString();
                        string = string.substring(0, string.length() - 4);
                        MessageHandler.sendConsolePluginMessage("&3Generating Skill&8: &e" + string);
                        String string2 = path.toString().substring(1);
                        YamlAdapter yamlAdapter = new YamlAdapter(new File(skillsPro.getDataFolder(), string2), string2).register();
                        Skill skill = new Skill(string);
                        skill.setAdapter(yamlAdapter);
                        SkillManager.registerScalings(skill);
                        SkillManager.register(skill);
                        skill.getAbilities().forEach(Ability::start);
                    });
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        } else {
            try {
                Files.list(path2).forEach(path -> {
                    String string = path.getFileName().toString();
                    string = string.substring(0, string.length() - 4);
                    MessageHandler.sendConsolePluginMessage("&3Setting up Skill&8: &e" + string);
                    String string2 = path.toString();
                    YamlAdapter yamlAdapter = new YamlAdapter(path.toFile(), string2);
                    Skill skill = new Skill(string);
                    skill.setAdapter(yamlAdapter);
                    SkillManager.registerScalings(skill);
                    SkillManager.register(skill);
                    skill.getAbilities().forEach(Ability::start);
                });
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        this.registerNone();
    }

    public static void unregister(String string) {
        SKILLS.remove(string.toLowerCase(Locale.ENGLISH));
    }

    public static boolean isSkillRegistered(String string) {
        return SKILLS.containsKey(string.toLowerCase(Locale.ENGLISH));
    }

    public static Skill getSkill(String string) {
        return SKILLS.get(string.toLowerCase(Locale.ENGLISH));
    }

    public static void register(Skill skill) {
        Validate.notEmpty((String)skill.getName(), (String)"Cannot register skill with null or empty name");
        SKILLS.put(skill.getName().toLowerCase(Locale.ENGLISH), skill);
    }

    public static HashMap<String, Skill> getSkills() {
        return SKILLS;
    }

    public static void registerScalings(Skill skill) {
        FileConfiguration fileConfiguration = skill.getAdapter().getConfig();
        skill.addScaling(SkillScaling.HEALTH, fileConfiguration.getString("health"));
        skill.addScaling(SkillScaling.MAX_HEALTH, fileConfiguration.getString("max-health"));
        skill.addScaling(SkillScaling.MAX_ENERGY, fileConfiguration.getString("max-energy"));
        skill.addScaling(SkillScaling.ENERGY_REGEN, fileConfiguration.getString("energy-regen"));
        skill.addScaling(SkillScaling.MAX_LEVEL, fileConfiguration.getString("max-level"));
        skill.addScaling(SkillScaling.REQUIRED_LEVEL, fileConfiguration.getString("required-level"));
        skill.addScaling(SkillScaling.COST, fileConfiguration.getString("cost"));
        skill.setDisplayName(MessageHandler.colorize(fileConfiguration.getString("name")));
        skill.setStats(fileConfiguration.getStringList("stats"));
        Energy energy = Energy.getEnergy(fileConfiguration.getString("energy"));
        if (energy == null) {
            energy = Energy.ENERGY.get(0);
        }
        skill.setEnergy(energy);
        LinkedHashMap<String, Ability> linkedHashMap = new LinkedHashMap<String, Ability>();
        ConfigurationSection configurationSection = fileConfiguration.getConfigurationSection("abilities");
        for (String string : configurationSection.getKeys(false)) {
            Ability ability;
            if ((string = string.replace('-', '_')).equalsIgnoreCase("passive")) {
                string = skill.getName().toLowerCase(Locale.ENGLISH) + "_passive";
            }
            if ((ability = AbilityManager.getAbility(string)) == null) {
                MessageHandler.sendConsolePluginMessage("&cCould not find ability named &e" + string + " &cto register for &e" + skill.getName());
                continue;
            }
            linkedHashMap.put(string, ability);
        }
        skill.setAbilities(linkedHashMap);
    }

    private void registerNone() {
        MessageHandler.sendConsolePluginMessage("&3Setting up Skill&8: &eNone (Default)");
        Skill skill = new Skill("none");
        skill.addScaling(SkillScaling.MAX_LEVEL, SkillsConfig.DEFAULT_MAX_LEVEL.getString());
        skill.setDisplayName(SkillsLang.NO_SKILL_DISPLAYNAME.parse(new Object[0]));
        SkillManager.register(skill);
    }
}

