/*
 * Decompiled with CFR 0.152.
 */
package org.skills.types;

import com.google.common.base.Enums;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.bukkit.configuration.ConfigurationSection;
import org.skills.main.SkillsPro;

public class Energy {
    public static final List<Energy> ENERGY = new ArrayList<Energy>();
    private final String node;
    private final String name;
    private final String symbol;
    private final String color;
    private final String soundNotEnough;
    private final String soundFull;
    private final Charging charging;
    private final List<String> elements;

    public Energy(String string, String string2, String string3, String string4, Charging charging, String string5, String string6, List<String> list) {
        this.node = string;
        this.name = string2;
        this.symbol = string3;
        this.color = string4;
        this.charging = charging;
        this.elements = list;
        this.soundNotEnough = string5;
        this.soundFull = string6;
    }

    public static Energy getEnergy(String string) {
        if (Strings.isNullOrEmpty((String)string)) {
            return null;
        }
        return ENERGY.stream().filter(energy -> energy.node.equalsIgnoreCase(string)).findFirst().orElse(null);
    }

    public static void init(SkillsPro skillsPro) {
        ENERGY.clear();
        ConfigurationSection configurationSection = skillsPro.getConfig().getConfigurationSection("energy");
        for (String string : configurationSection.getKeys(false)) {
            ConfigurationSection configurationSection2 = configurationSection.getConfigurationSection(string);
            String string2 = configurationSection2.getString("charging");
            string2 = string2 == null ? "AUTO" : string2.toUpperCase(Locale.ENGLISH);
            String string3 = configurationSection2.getString("sounds.full");
            String string4 = configurationSection2.getString("sounds.not-enough");
            Energy energy = new Energy(string, configurationSection2.getString("name"), configurationSection2.getString("symbol"), configurationSection2.getString("color"), (Charging)((Object)Enums.getIfPresent(Charging.class, (String)string2).or((Object)Charging.AUTO)), string4, string3, configurationSection2.getStringList("elements"));
            ENERGY.add(energy);
        }
    }

    public List<String> getElements() {
        return this.elements;
    }

    public String getColor() {
        return this.color;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public String getName() {
        return this.name;
    }

    public Charging getCharging() {
        return this.charging;
    }

    public String getSoundNotEnough() {
        return this.soundNotEnough;
    }

    public String getSoundFull() {
        return this.soundFull;
    }

    public static enum Charging {
        AUTO,
        AUTO_REVERSE,
        KILL,
        HIT,
        EAT;

    }
}

