/*
 * Decompiled with CFR 0.152.
 */
package org.skills.services.manager;

import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Objects;
import me.clip.placeholderapi.PlaceholderAPI;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.skills.data.managers.SkilledPlayer;
import org.skills.main.SLogger;
import org.skills.main.SkillsPro;
import org.skills.main.locale.MessageHandler;
import org.skills.services.ServiceCitizens;
import org.skills.services.ServiceDiscordSRV;
import org.skills.services.ServiceFactions;
import org.skills.services.ServiceKingdoms;
import org.skills.services.ServiceMassiveFactions;
import org.skills.services.ServiceMyPet;
import org.skills.services.ServiceResidence;
import org.skills.services.ServiceWorldGuard;
import org.skills.services.mobs.ServiceBoss;
import org.skills.services.mobs.ServiceEliteMobs;
import org.skills.services.mobs.ServiceLorinthsRpgMobs;
import org.skills.services.mobs.ServiceMythicMobs;
import org.skills.services.placeholders.ServicePlaceholderAPI;
import org.skills.services.placeholders.SkillsPlaceholders;
import org.skills.utils.Pair;
import org.skills.utils.StringUtils;
import org.skills.utils.xseries.XMaterial;

public class ServiceHandler {
    private static ImmutableSet<String> managers = ImmutableSet.of();

    public ServiceHandler(SkillsPro skillsPro) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (String string : skillsPro.getDescription().getSoftDepend()) {
            Plugin plugin = Bukkit.getPluginManager().getPlugin(string);
            if (plugin != null && plugin.isEnabled()) {
                builder.add((Object)string);
                MessageHandler.sendConsolePluginMessage("&e" + plugin.getName() + " &3found and hooked.");
                continue;
            }
            MessageHandler.sendConsolePluginMessage("&e" + string + " &cnot found.");
        }
        managers = builder.build();
        this.registerPlaceHolders();
    }

    public static boolean isAvailable(String string) {
        return managers.contains((Object)string);
    }

    public static String translatePlaceholders(OfflinePlayer offlinePlayer, String string) {
        Objects.requireNonNull(offlinePlayer, "Cannot translate placeholder for null player");
        Validate.isTrue((string != null ? 1 : 0) != 0, (String)"Cannot translate null string");
        string = StringUtils.replace((String)string, (String)"%player%", (String)offlinePlayer.getName());
        if (offlinePlayer.isOnline()) {
            string = StringUtils.replace((String)string, (String)"%displayname%", (String)((Player)offlinePlayer).getDisplayName());
        }
        return ServiceHandler.isAvailable("PlaceholderAPI") ? PlaceholderAPI.setPlaceholders((OfflinePlayer)offlinePlayer, (String)string) : SkillsPlaceholders.translatePlaceholders(offlinePlayer, string);
    }

    public static boolean isMyPet(Entity entity) {
        return ServiceHandler.isAvailable("MyPet") && ServiceMyPet.isMyPet(entity);
    }

    public static Player getPetOwner(Entity entity) {
        return ServiceMyPet.getPetOwner(entity);
    }

    public static boolean isNPC(Entity entity) {
        return ServiceHandler.isAvailable("Citizens") && ServiceCitizens.isNPC(entity);
    }

    public static boolean areFriendly(Entity entity, Entity entity2) {
        if (entity.getEntityId() == entity2.getEntityId()) {
            return true;
        }
        if (ServiceHandler.isAvailable("Citizens") && (ServiceCitizens.isNPC(entity) || ServiceCitizens.isNPC(entity2))) {
            return true;
        }
        if (entity instanceof Player && entity2 instanceof Player) {
            SkilledPlayer skilledPlayer;
            SkilledPlayer skilledPlayer2 = SkilledPlayer.getSkilledPlayer((OfflinePlayer)((Player)entity));
            if (skilledPlayer2.isFrendly(skilledPlayer = SkilledPlayer.getSkilledPlayer((OfflinePlayer)((Player)entity2)))) {
                return true;
            }
            if (Bukkit.getPluginManager().getPlugin("Kingdoms") != null) {
                return !ServiceKingdoms.canFight((Player)entity, (Player)entity2);
            }
            Plugin plugin = Bukkit.getPluginManager().getPlugin("Factions");
            if (plugin != null) {
                try {
                    if (Bukkit.getPluginManager().getPlugin("MasiveCore") != null && !plugin.getDescription().getWebsite().contains("factionsuuid") ? !ServiceMassiveFactions.canFight((Player)entity, (Player)entity2) : !ServiceFactions.canFight((Player)entity, (Player)entity2)) {
                        return true;
                    }
                }
                catch (Throwable throwable) {
                    SLogger.error("Factions support has encountered an error!");
                    throwable.printStackTrace();
                }
            }
        }
        return false;
    }

    public static void logPartyChat(Player player, String string) {
        if (ServiceHandler.isAvailable("DiscordSRV")) {
            ServiceDiscordSRV.logPartyChat(player, string);
        }
    }

    public static boolean isKingdomMob(LivingEntity livingEntity) {
        return ServiceHandler.isAvailable("Kingdoms") && ServiceKingdoms.isKingdomMob(livingEntity);
    }

    public static boolean canFight(Entity entity, Entity entity2) {
        if (ServiceHandler.areFriendly(entity, entity2)) {
            return false;
        }
        if (ServiceHandler.isAvailable("Residence")) {
            return ServiceResidence.canFight(entity, entity2);
        }
        if (ServiceHandler.isAvailable("WorldGuard")) {
            try {
                if (XMaterial.isNewVersion() ? !ServiceWorldGuard.canFight(entity, entity2) : !ServiceWorldGuard.canFightOld(entity, entity2)) {
                    return false;
                }
            }
            catch (Throwable throwable) {
                Plugin plugin = Bukkit.getPluginManager().getPlugin("WorldGuard");
                String string = plugin == null ? "NOT FOUND" : plugin.getDescription().getVersion();
                SLogger.error("WorldGuard support [" + string + "] has encountered an error!");
                throwable.printStackTrace();
            }
        }
        return true;
    }

    public static Pair<String, Number> getMobProperties(LivingEntity livingEntity) {
        Pair<String, Number> pair;
        if (livingEntity.hasMetadata("NPC")) {
            return Pair.of(ServiceCitizens.getNPCName((Entity)livingEntity), 0);
        }
        if (ServiceHandler.isAvailable("MythicMobs") && (pair = ServiceMythicMobs.getMobProperties(livingEntity)) != null) {
            return pair;
        }
        if (ServiceHandler.isAvailable("Boss") && (pair = ServiceBoss.getMobProperties(livingEntity)) != null) {
            return pair;
        }
        if (ServiceHandler.isAvailable("EliteMobs") && (pair = ServiceEliteMobs.getMobProperties(livingEntity)) != null) {
            return pair;
        }
        if (ServiceHandler.isAvailable("LorinthsRpgMobs")) {
            return ServiceLorinthsRpgMobs.getMobProperties(livingEntity);
        }
        return null;
    }

    public static boolean isPvPOff(Player player) {
        if (!ServiceHandler.isAvailable("WorldGuard")) {
            return false;
        }
        if (XMaterial.isNewVersion()) {
            return ServiceWorldGuard.isPvPOff(player);
        }
        return ServiceWorldGuard.isPvPOffOld(player);
    }

    public static boolean isInRegion(Player player, List<String> list) {
        if (list == null || list.isEmpty()) {
            return false;
        }
        if (ServiceHandler.isAvailable("WorldGuard")) {
            return false;
        }
        return ServiceWorldGuard.isInRegion(player, list);
    }

    private void registerPlaceHolders() {
        if (ServiceHandler.isAvailable("PlaceholderAPI")) {
            boolean bl = new ServicePlaceholderAPI().register();
            if (bl) {
                MessageHandler.sendConsolePluginMessage("&3Successfully registered placeholders.");
            } else {
                MessageHandler.sendConsolePluginMessage("&cCould not register placeholders!");
            }
        }
    }
}

