/*
 * Decompiled with CFR 0.152.
 */
package org.skills.party;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.skills.data.database.DataContainer;
import org.skills.data.managers.SkilledPlayer;
import org.skills.main.SkillsPro;
import org.skills.party.PartyRank;
import org.skills.utils.FastUUID;
import org.skills.utils.caffeine.checkerframework.checker.nullness.qual.NonNull;

public class SkillsParty
extends DataContainer {
    private String name;
    private UUID id;
    private UUID leader;
    private List<UUID> members = new CopyOnWriteArrayList<UUID>();

    public SkillsParty(UUID uUID, String string, boolean bl) {
        if (!bl) {
            this.id = UUID.randomUUID();
        }
        this.leader = uUID;
        this.name = string;
    }

    public static SkillsParty createParty(OfflinePlayer offlinePlayer, String string) {
        SkillsParty skillsParty = new SkillsParty(offlinePlayer.getUniqueId(), string, false);
        SkilledPlayer skilledPlayer = SkilledPlayer.getSkilledPlayer(offlinePlayer);
        skilledPlayer.setParty(skillsParty);
        skilledPlayer.setRank(PartyRank.LEADER);
        skillsParty.members.add(skillsParty.leader);
        SkillsPro.get().getPartyManager().load(skillsParty);
        return skillsParty;
    }

    public static SkillsParty getParty(UUID uUID) {
        Objects.requireNonNull(uUID, "Cannot get party with null ID");
        return (SkillsParty)SkillsPro.get().getPartyManager().getData(uUID);
    }

    public void disband() {
        for (UUID uUID : this.members) {
            SkilledPlayer skilledPlayer = SkilledPlayer.getSkilledPlayer(uUID);
            skilledPlayer.setParty((UUID)null);
            skilledPlayer.setRank(null);
        }
        SkillsPro.get().getPartyManager().delete(this.id);
    }

    public List<Player> getOnlineMembers() {
        ArrayList<Player> arrayList = new ArrayList<Player>();
        for (UUID uUID : this.members) {
            Player player = Bukkit.getPlayer((UUID)uUID);
            if (player == null) continue;
            arrayList.add(player);
        }
        return arrayList;
    }

    public List<UUID> getMembers() {
        return this.members;
    }

    public void setMembers(List<UUID> list) {
        this.members = list;
    }

    public List<OfflinePlayer> getPlayerMembers() {
        ArrayList<OfflinePlayer> arrayList = new ArrayList<OfflinePlayer>();
        for (UUID uUID : this.members) {
            OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)uUID);
            arrayList.add(offlinePlayer);
        }
        return arrayList;
    }

    public UUID getLeader() {
        return this.leader;
    }

    public void setLeader(UUID uUID) {
        this.leader = uUID;
    }

    public UUID getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    @Override
    public @NonNull String getKey() {
        return FastUUID.toString(this.id);
    }

    @Override
    @NotNull
    public String getCompressedData() {
        return SkillsParty.compressUUID(this.leader) + this.name + SkillsParty.compressCollecton(this.members, uUID -> DataContainer.compressUUID(uUID));
    }

    @Override
    public void setIdentifier(@NonNull String string) {
        this.id = FastUUID.fromString(string);
    }
}

