/*
 * Decompiled with CFR 0.152.
 */
package org.skills.masteries.managers;

import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.skills.data.managers.SkilledPlayer;
import org.skills.gui.GUIParser;
import org.skills.gui.InteractiveGUI;
import org.skills.main.SkillsMasteryConfig;
import org.skills.main.locale.SkillsLang;
import org.skills.masteries.managers.Mastery;
import org.skills.masteries.managers.MasteryManager;

public class MasteryGUIManager {
    public static void setMastery(SkilledPlayer skilledPlayer, Player player, Mastery mastery, boolean bl) {
        int n = skilledPlayer.getMasteryLevel(mastery);
        if (bl) {
            if (n >= mastery.getMaxLevel()) {
                SkillsLang.MASTERY_MAXIMUM_LEVEL.sendMessage(player, new Object[0]);
                return;
            }
            int n2 = mastery.getRequiredLevel(skilledPlayer);
            if (skilledPlayer.getLevel() < n2) {
                SkillsLang.MASTERY_REQUIRED_LEVEL.sendMessage(player, "%level%", n2);
                return;
            }
            int n3 = mastery.getUpgradeCost(skilledPlayer);
            if (skilledPlayer.getSouls() >= (long)n3) {
                skilledPlayer.addSouls(-n3);
                skilledPlayer.addMasteryLevel(mastery, 1);
                SkillsLang.MASTERY_UPGRADED.sendMessage(player, "%mastery%", mastery.getDisplayName(), "%cost%", n3);
            } else {
                SkillsLang.NOT_ENOUGH_SOULS.sendMessage(player, "%mastery%", mastery.getDisplayName(), "%cost%", n3);
            }
        } else if (n > 0) {
            int n4 = mastery.getDowngradeCost(skilledPlayer);
            skilledPlayer.addSouls(n4);
            skilledPlayer.addMasteryLevel(mastery, -1);
            SkillsLang.MASTERY_DOWNGRADED.sendMessage(player, "%mastery%", mastery.getDisplayName(), "%cost%", n4);
        } else {
            SkillsLang.MASTERY_CANT_DOWNGRADE.sendMessage(player, "%mastery%", mastery.getDisplayName());
        }
        MasteryGUIManager.openMenu(skilledPlayer, player, true);
    }

    public static void openMenu(SkilledPlayer skilledPlayer, Player player, boolean bl) {
        InteractiveGUI interactiveGUI = GUIParser.parseOption(player, "masteries");
        for (Mastery mastery : MasteryManager.getMasteries()) {
            String string;
            try {
                string = String.valueOf(mastery.getScaling(skilledPlayer, new Object[0]));
            }
            catch (ArithmeticException arithmeticException) {
                string = mastery.getScalingEquation(skilledPlayer);
            }
            Object[] objectArray = new Object[]{"%cost%", mastery.getUpgradeCost(skilledPlayer), "%level%", skilledPlayer.getMasteryLevel(mastery), "%max-level%", mastery.getMaxLevel(), "%required-level%", mastery.getRequiredLevel(skilledPlayer), "%amount%", string};
            InteractiveGUI.ActionRunnable[] actionRunnableArray = SkillsMasteryConfig.DOWNGRADE.getBoolean() != false ? new InteractiveGUI.ActionRunnable[]{new InteractiveGUI.ActionRunnable(ClickType.LEFT, () -> MasteryGUIManager.setMastery(skilledPlayer, player, mastery, true)), new InteractiveGUI.ActionRunnable(ClickType.RIGHT, () -> MasteryGUIManager.setMastery(skilledPlayer, player, mastery, false))} : new InteractiveGUI.ActionRunnable[]{new InteractiveGUI.ActionRunnable(ClickType.LEFT, () -> MasteryGUIManager.setMastery(skilledPlayer, player, mastery, true))};
            interactiveGUI.push(mastery.getConfigName(), objectArray, null, actionRunnableArray);
        }
        interactiveGUI.setRest();
        interactiveGUI.openInventory(player, bl);
    }
}

