/*
 * Decompiled with CFR 0.152.
 */
package org.skills.masteries.managers;

import com.google.common.base.Strings;
import java.util.Locale;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.bukkit.GameMode;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.java.JavaPlugin;
import org.skills.data.managers.SkilledPlayer;
import org.skills.main.SkillsConfig;
import org.skills.main.SkillsMasteryConfig;
import org.skills.main.SkillsPro;
import org.skills.main.locale.MessageHandler;
import org.skills.masteries.managers.MasteryManager;
import org.skills.services.manager.ServiceHandler;
import org.skills.types.Stat;
import org.skills.utils.MathUtils;
import org.skills.utils.caffeine.checkerframework.checker.nullness.qual.NonNull;

public abstract class Mastery
implements Listener {
    private final String name;

    public Mastery(@NonNull String string) {
        this(string, false);
    }

    protected Mastery(String string, boolean bl) {
        this.name = string;
        if (bl && SkillsMasteryConfig.ENABLED.withProperties(this.getConfigName()).getBoolean().booleanValue()) {
            MasteryManager.registerDefault(this);
        }
    }

    public static boolean isPlaced(Block block) {
        return block.hasMetadata("PLACED");
    }

    public void register(@NonNull JavaPlugin javaPlugin) {
        Objects.requireNonNull(javaPlugin, "Plugin instance for mastery cannot be null");
        if (javaPlugin instanceof SkillsPro) {
            throw new IllegalArgumentException("Plugin instance for mastery should not be an instance of Skills");
        }
        Validate.notEmpty((String)this.name, (String)"Mastery name cannot be null or empty");
        MasteryManager.registerMastery(javaPlugin, this);
    }

    public int getUpgradeCost(SkilledPlayer skilledPlayer) {
        return this.getCost(skilledPlayer, skilledPlayer.getMasteryLevel(this));
    }

    public int getDowngradeCost(SkilledPlayer skilledPlayer) {
        return this.getCost(skilledPlayer, skilledPlayer.getMasteryLevel(this) - 1);
    }

    private int getCost(SkilledPlayer skilledPlayer, int n) {
        String string = SkillsMasteryConfig.COST.withProperties(this.getConfigName()).getString();
        return (int)this.getAbsoluteScaling(skilledPlayer, string, "lvl", n);
    }

    public double getAbsoluteScaling(SkilledPlayer skilledPlayer, String string, Object ... objectArray) {
        if (Strings.isNullOrEmpty((String)string)) {
            return 0.0;
        }
        return MathUtils.evaluateEquation(this.getTranslatedScaling(skilledPlayer, string, objectArray));
    }

    public int getRequiredLevel(SkilledPlayer skilledPlayer) {
        String string = this.getExtra("required-level").getString();
        if (Strings.isNullOrEmpty((String)string)) {
            return 0;
        }
        return (int)this.getAbsoluteScaling(skilledPlayer, string, new Object[0]);
    }

    public SkillsMasteryConfig getExtra(String string) {
        return SkillsMasteryConfig.EXTRA.withProperties(this.getConfigName(), string);
    }

    public double getExtraScaling(SkilledPlayer skilledPlayer, String string) {
        return this.getAbsoluteScaling(skilledPlayer, SkillsMasteryConfig.EXTRA.withProperties(this.getConfigName(), string).getString(), new Object[0]);
    }

    public double getScaling(SkilledPlayer skilledPlayer, Object ... objectArray) {
        return this.getAbsoluteScaling(skilledPlayer, this.getScalingEquation(skilledPlayer), objectArray);
    }

    public String getScalingEquation(SkilledPlayer skilledPlayer) {
        return SkillsMasteryConfig.SCALING.withProperties(this.getConfigName()).getString();
    }

    public String getTranslatedScaling(SkilledPlayer skilledPlayer, String string, Object ... objectArray) {
        String string2 = ServiceHandler.translatePlaceholders(skilledPlayer.getOfflinePlayer(), string);
        string2 = MessageHandler.replaceVariables(string2, objectArray);
        string2 = StringUtils.replace((String)string2, (String)"lvl", (String)String.valueOf(skilledPlayer.getMasteryLevel(this)));
        for (Stat stat : Stat.STATS) {
            string2 = string2.replace('%' + stat.getNode().toLowerCase(Locale.ENGLISH) + '%', String.valueOf(skilledPlayer.getStat(stat)));
        }
        return string2;
    }

    public SkilledPlayer checkup(Player player) {
        if (!player.hasPermission("skills.masteries.creative") && player.getGameMode() == GameMode.CREATIVE) {
            return null;
        }
        if (!player.hasPermission("skills.mastery." + this.getConfigName())) {
            return null;
        }
        if (SkillsConfig.isInDisabledWorld(player.getLocation())) {
            return null;
        }
        SkilledPlayer skilledPlayer = SkilledPlayer.getSkilledPlayer((OfflinePlayer)player);
        if (skilledPlayer.getMasteryLevel(this) < 1) {
            return null;
        }
        if (!this.hasChance(skilledPlayer)) {
            return null;
        }
        return skilledPlayer;
    }

    public String getConfigName() {
        return this.name.toLowerCase(Locale.ENGLISH).replace('_', '-');
    }

    public boolean hasChance(SkilledPlayer skilledPlayer) {
        int n = (int)this.getAbsoluteScaling(skilledPlayer, SkillsMasteryConfig.CHANCE.withProperties(this.getConfigName()).getString(), new Object[0]);
        return MathUtils.hasChance(n);
    }

    public void unregister() {
        MasteryManager.unregisterMastery(this.name);
    }

    public @NonNull String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return SkillsMasteryConfig.NAME.withProperties(this.getConfigName()).getString();
    }

    public int getMaxLevel() {
        return SkillsMasteryConfig.MAX_LEVEL.withProperties(this.getConfigName()).getInt();
    }
}

