/*
 * Decompiled with CFR 0.152.
 */
package org.skills.masteries.efficiency;

import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.skills.data.managers.SkilledPlayer;
import org.skills.main.SkillsConfig;
import org.skills.main.SkillsPro;
import org.skills.masteries.managers.Mastery;
import org.skills.utils.versionsupport.VersionSupport;

public class MasteryRegeneration
extends Mastery {
    public MasteryRegeneration() {
        super("Regeneration", true);
    }

    @EventHandler
    public void onEat(PlayerItemConsumeEvent playerItemConsumeEvent) {
        if (SkillsConfig.isInDisabledWorld(playerItemConsumeEvent.getPlayer().getLocation())) {
            return;
        }
        Player player = playerItemConsumeEvent.getPlayer();
        SkilledPlayer skilledPlayer = SkilledPlayer.getSkilledPlayer((OfflinePlayer)player);
        int n = skilledPlayer.getMasteryLevel(this);
        if (n > 0) {
            EntityRegainHealthEvent entityRegainHealthEvent = new EntityRegainHealthEvent((Entity)player, (double)n, EntityRegainHealthEvent.RegainReason.EATING);
            Bukkit.getPluginManager().callEvent((Event)entityRegainHealthEvent);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onDamage(EntityDamageEvent entityDamageEvent) {
        if (entityDamageEvent.getEntity() instanceof Player) {
            final Player player = (Player)entityDamageEvent.getEntity();
            if (SkillsConfig.isInDisabledWorld(player.getLocation())) {
                return;
            }
            final SkilledPlayer skilledPlayer = this.checkup(player);
            if (skilledPlayer == null) {
                return;
            }
            int n = VersionSupport.getHealthPercent((LivingEntity)player, entityDamageEvent);
            if ((double)n <= this.getExtraScaling(skilledPlayer, "percent")) {
                new BukkitRunnable(){
                    int repeat;
                    {
                        this.repeat = (int)MasteryRegeneration.this.getScaling(skilledPlayer, new Object[0]);
                    }

                    public void run() {
                        if (!player.isValid()) {
                            this.cancel();
                            return;
                        }
                        VersionSupport.heal(player, 1.0);
                        if (this.repeat-- <= 0) {
                            this.cancel();
                        }
                    }
                }.runTaskTimer((Plugin)SkillsPro.get(), 0L, 10L);
            }
        }
    }
}

