/*
 * Decompiled with CFR 0.152.
 */
package org.skills.masteries.efficiency;

import java.util.Optional;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.inventory.ItemStack;
import org.skills.data.managers.SkilledPlayer;
import org.skills.main.SkillsConfig;
import org.skills.masteries.managers.Mastery;
import org.skills.utils.MathUtils;
import org.skills.utils.versionsupport.VersionSupport;
import org.skills.utils.xseries.XMaterial;

public class MasteryMining
extends Mastery {
    public MasteryMining() {
        super("Mining", true);
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGH)
    public void onMining(BlockBreakEvent blockBreakEvent) {
        Player player = blockBreakEvent.getPlayer();
        if (player.getGameMode() == GameMode.CREATIVE) {
            return;
        }
        if (MasteryMining.isPlaced(blockBreakEvent.getBlock())) {
            return;
        }
        if (SkillsConfig.isInDisabledWorld(blockBreakEvent.getPlayer().getLocation())) {
            return;
        }
        SkilledPlayer skilledPlayer = this.checkup(player);
        if (skilledPlayer == null) {
            return;
        }
        XMaterial xMaterial = XMaterial.matchXMaterial(blockBreakEvent.getBlock().getType());
        ConfigurationSection configurationSection = this.getExtra("blocks." + xMaterial.name()).getSection();
        if (configurationSection == null) {
            return;
        }
        int n = skilledPlayer.getMasteryLevel(this);
        if (!MathUtils.hasChance((int)this.getAbsoluteScaling(skilledPlayer, configurationSection.getString("chance"), "lvl", n))) {
            return;
        }
        int n2 = (int)this.getAbsoluteScaling(skilledPlayer, configurationSection.getString("exp"), "lvl", n);
        int n3 = (int)this.getAbsoluteScaling(skilledPlayer, configurationSection.getString("xp"), "lvl", n);
        int n4 = (int)this.getAbsoluteScaling(skilledPlayer, configurationSection.getString("souls"), "lvl", n);
        Location location = blockBreakEvent.getBlock().getLocation();
        skilledPlayer.addXP(n3);
        skilledPlayer.addSouls(n4);
        VersionSupport.dropExp(location, n2);
        ConfigurationSection configurationSection2 = configurationSection.getConfigurationSection("drops");
        if (configurationSection2 == null) {
            return;
        }
        for (String string : configurationSection2.getKeys(false)) {
            Optional<XMaterial> optional = XMaterial.matchXMaterial(configurationSection2.getString(string + ".material"));
            if (!optional.isPresent()) continue;
            ItemStack itemStack = optional.get().parseItem();
            int n5 = (int)this.getAbsoluteScaling(skilledPlayer, configurationSection2.getString(string + ".amount"), "lvl", n);
            if (n5 > 0) {
                itemStack.setAmount(n5);
            }
            player.getWorld().dropItemNaturally(location, itemStack);
        }
    }
}

