/*
 * Decompiled with CFR 0.152.
 */
package org.skills.masteries.efficiency;

import java.util.Optional;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.inventory.ItemStack;
import org.skills.data.managers.SkilledPlayer;
import org.skills.main.SkillsConfig;
import org.skills.masteries.managers.Mastery;
import org.skills.utils.MathUtils;
import org.skills.utils.versionsupport.VersionSupport;
import org.skills.utils.xseries.XMaterial;

public class MasteryHarvesting
extends Mastery {
    public MasteryHarvesting() {
        super("Harvesting", true);
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGH)
    public void onHarvest(BlockBreakEvent blockBreakEvent) {
        Player player = blockBreakEvent.getPlayer();
        if (player.getGameMode() == GameMode.CREATIVE) {
            return;
        }
        if (SkillsConfig.isInDisabledWorld(blockBreakEvent.getPlayer().getLocation())) {
            return;
        }
        if (!VersionSupport.isCropFullyGrown(blockBreakEvent.getBlock())) {
            return;
        }
        SkilledPlayer skilledPlayer = this.checkup(player);
        if (skilledPlayer == null) {
            return;
        }
        XMaterial xMaterial = XMaterial.matchXMaterial(blockBreakEvent.getBlock().getType());
        ConfigurationSection configurationSection = this.getExtra("blocks." + xMaterial.name()).getSection();
        if (configurationSection == null) {
            return;
        }
        int n = skilledPlayer.getMasteryLevel(this);
        if (!MathUtils.hasChance((int)this.getAbsoluteScaling(skilledPlayer, configurationSection.getString("chance"), new Object[0]))) {
            return;
        }
        int n2 = (int)this.getAbsoluteScaling(skilledPlayer, configurationSection.getString("exp"), new Object[0]);
        int n3 = (int)this.getAbsoluteScaling(skilledPlayer, configurationSection.getString("xp"), new Object[0]);
        int n4 = (int)this.getAbsoluteScaling(skilledPlayer, configurationSection.getString("souls"), new Object[0]);
        Location location = blockBreakEvent.getBlock().getLocation();
        skilledPlayer.addXP(n3);
        skilledPlayer.addSouls(n4);
        VersionSupport.dropExp(location, n2);
        ConfigurationSection configurationSection2 = configurationSection.getConfigurationSection("drops");
        if (configurationSection2 == null) {
            return;
        }
        for (String string : configurationSection2.getKeys(false)) {
            Optional<XMaterial> optional = XMaterial.matchXMaterial(configurationSection2.getString(string + ".material"));
            if (!optional.isPresent()) continue;
            ItemStack itemStack = optional.get() == XMaterial.POTATOES ? XMaterial.POTATO.parseItem() : (optional.get() == XMaterial.BEETROOTS ? XMaterial.BEETROOT.parseItem() : (optional.get() == XMaterial.CARROTS ? XMaterial.CARROT.parseItem() : optional.get().parseItem()));
            int n5 = (int)this.getAbsoluteScaling(skilledPlayer, configurationSection2.getString(string + ".amount"), "lvl", n);
            if (n5 > 0) {
                itemStack.setAmount(n5);
            }
            player.getWorld().dropItemNaturally(location, itemStack);
        }
    }
}

