/*
 * Decompiled with CFR 0.152.
 */
package org.skills.managers.blood;

import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.skills.main.SkillsConfig;
import org.skills.managers.blood.HeartPulse;
import org.skills.managers.blood.WorldBorderAPI;
import org.skills.utils.versionsupport.VersionSupport;

public class RedScreenManager
implements Listener {
    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onPlayerDamage(EntityDamageEvent entityDamageEvent) {
        if (!(entityDamageEvent.getEntity() instanceof Player)) {
            return;
        }
        double d = entityDamageEvent.getFinalDamage();
        if (d <= 0.0) {
            return;
        }
        Player player = (Player)entityDamageEvent.getEntity();
        if (player.getHealth() - d <= 0.0) {
            return;
        }
        int n = VersionSupport.getHealthPercent((LivingEntity)player, entityDamageEvent);
        if (SkillsConfig.PULSE_ENABLED.getBoolean() && n < SkillsConfig.PULSE_HEALTH.getInt()) {
            HeartPulse.pulse(player, n);
        }
        if (SkillsConfig.RED_SCREEN_ENABLED.getBoolean()) {
            WorldBorderAPI.send(player, n);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onDeath(PlayerDeathEvent playerDeathEvent) {
        Player player = playerDeathEvent.getEntity();
        if (SkillsConfig.RED_SCREEN_ENABLED.getBoolean()) {
            WorldBorderAPI.remove(player);
        }
        if (SkillsConfig.PULSE_ENABLED.getBoolean()) {
            HeartPulse.remove(player);
        }
    }
}

