/*
 * Decompiled with CFR 0.152.
 */
package org.skills.managers;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.math.NumberUtils;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.FireworkEffect;
import org.bukkit.OfflinePlayer;
import org.bukkit.Particle;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Firework;
import org.bukkit.entity.Player;
import org.bukkit.inventory.meta.FireworkMeta;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.skills.data.managers.SkilledPlayer;
import org.skills.main.SkillsConfig;
import org.skills.main.locale.MessageHandler;
import org.skills.managers.Title;
import org.skills.services.manager.ServiceHandler;
import org.skills.types.Stat;
import org.skills.utils.MathUtils;
import org.skills.utils.StringUtils;
import org.skills.utils.xseries.messages.Titles;
import org.skills.utils.xseries.particles.ParticleDisplay;
import org.skills.utils.xseries.particles.XParticle;

public class LevelUp {
    private final String message;
    private final ConfigurationSection title;
    private final String xp;
    private final String souls;
    private final String statPoints;
    private final List<String> commands;
    private Title titleEval;
    private String messageEval;
    private int xpEval;
    private int soulsEval;
    private int statPointsEval;
    private List<String> commandsEval;

    private LevelUp(ConfigurationSection configurationSection) {
        this.message = configurationSection.getString("message");
        this.title = configurationSection.getConfigurationSection("title");
        this.xp = configurationSection.getString("xp");
        this.souls = configurationSection.getString("souls");
        this.statPoints = configurationSection.getString("statpoints");
        this.commands = configurationSection.getStringList("commands");
        Validate.isTrue((this.xp != null ? 1 : 0) != 0, (String)("Could not find XP property for level: " + configurationSection.getName()));
    }

    public static int getLevel(SkilledPlayer skilledPlayer, int n) {
        return (int)MathUtils.evaluateEquation(ServiceHandler.translatePlaceholders(skilledPlayer.getOfflinePlayer(), StringUtils.replace((String)LevelUp.getProperties(n).getXp(), (String)"lvl", (String)String.valueOf(n))));
    }

    public static LevelUp getProperties(int n) {
        Validate.isTrue((n >= 0 ? 1 : 0) != 0, (String)"No levelup properties for levels lower than 0");
        ConfigurationSection configurationSection = SkillsConfig.LEVELS.getSection();
        ConfigurationSection configurationSection2 = configurationSection.getConfigurationSection(String.valueOf(n));
        if (configurationSection2 == null) {
            Set<String> set = SkillsConfig.LEVELS.getSectionSet();
            int n2 = 0;
            for (String string : set) {
                int n3 = NumberUtils.toInt((String)string, (int)n2);
                if (n3 > n && n2 <= n) {
                    configurationSection2 = configurationSection.getConfigurationSection(String.valueOf(n2));
                    break;
                }
                n2 = n3;
            }
            if (configurationSection2 == null) {
                configurationSection2 = configurationSection.getConfigurationSection(String.valueOf(n2));
            }
        }
        return new LevelUp(configurationSection2);
    }

    public void perform(SkilledPlayer skilledPlayer, Object ... objectArray) {
        Player player;
        OfflinePlayer offlinePlayer = skilledPlayer.getOfflinePlayer();
        if (offlinePlayer.isOnline()) {
            player = (Player)offlinePlayer;
            if (this.messageEval != null) {
                player.sendMessage(MessageHandler.replaceVariables(this.messageEval, objectArray));
            }
            if (this.titleEval != null) {
                Titles.sendTitle(player, this.titleEval.fadeIn, this.titleEval.stay, this.titleEval.fadeOut, MessageHandler.replaceVariables(this.titleEval.title, objectArray), MessageHandler.replaceVariables(this.titleEval.subtitle, objectArray));
            }
        }
        skilledPlayer.addSouls(this.soulsEval);
        skilledPlayer.addStat(Stat.POINTS, this.statPointsEval);
        player = (Player)offlinePlayer;
        for (String string : this.commandsEval) {
            ConsoleCommandSender consoleCommandSender;
            Object object = consoleCommandSender = string.toUpperCase().startsWith("CONSOLE:") ? Bukkit.getConsoleSender() : player;
            if (consoleCommandSender instanceof Player && (player == null || !player.isOnline())) continue;
            int n = string.indexOf(58);
            String string2 = MessageHandler.replaceVariables(string.substring(n + 1), objectArray);
            Bukkit.dispatchCommand((CommandSender)consoleCommandSender, (String)string2);
        }
    }

    public void celebrate(Player player, JavaPlugin javaPlugin, int n) {
        int n2;
        ParticleDisplay particleDisplay = ParticleDisplay.simple(player.getLocation(), Particle.CRIT_MAGIC);
        int n3 = Math.min(Math.max(5, n / 2), 15);
        XParticle.dnaReplication(javaPlugin, 1.0, 0.2, 3, 1.0, n3, 2, particleDisplay);
        int n4 = Math.max(1, n / 5);
        int n5 = Math.max(1, n / 2);
        ArrayList<Color> arrayList = new ArrayList<Color>();
        for (n2 = 0; n2 < n5; ++n2) {
            arrayList.add(Color.fromRGB((int)MathUtils.randInt(0, 255), (int)MathUtils.randInt(0, 255), (int)MathUtils.randInt(0, 255)));
        }
        for (n2 = 0; n2 < Math.min(n4, 5); ++n2) {
            Firework firework = (Firework)player.getWorld().spawnEntity(player.getLocation(), EntityType.FIREWORK);
            FireworkMeta fireworkMeta = firework.getFireworkMeta();
            FireworkEffect fireworkEffect = FireworkEffect.builder().withColor((Iterable)arrayList.stream().limit(n5).collect(Collectors.toList())).with(FireworkEffect.Type.values()[MathUtils.randInt(0, FireworkEffect.Type.values().length - 1)]).withTrail().build();
            if (n3 > 10) {
                fireworkMeta.setPower(1);
            }
            fireworkMeta.addEffect(fireworkEffect);
            firework.setMetadata("LVLUP", (MetadataValue)new FixedMetadataValue((Plugin)javaPlugin, null));
            firework.setFireworkMeta(fireworkMeta);
        }
    }

    public LevelUp evaluate(SkilledPlayer skilledPlayer, int n) {
        Object object;
        OfflinePlayer offlinePlayer = skilledPlayer.getOfflinePlayer();
        this.xpEval = (int)MathUtils.evaluateEquation(ServiceHandler.translatePlaceholders(offlinePlayer, StringUtils.replace((String)this.xp, (String)"lvl", (String)String.valueOf(n))));
        this.soulsEval = Strings.isNullOrEmpty((String)this.souls) ? 0 : (int)MathUtils.evaluateEquation(ServiceHandler.translatePlaceholders(offlinePlayer, StringUtils.replace((String)this.souls, (String)"lvl", (String)String.valueOf(n))));
        this.statPointsEval = Strings.isNullOrEmpty((String)this.statPoints) ? 0 : (int)MathUtils.evaluateEquation(ServiceHandler.translatePlaceholders(offlinePlayer, StringUtils.replace((String)this.statPoints, (String)"lvl", (String)String.valueOf(n))));
        String string = this.messageEval = Strings.isNullOrEmpty((String)this.message) ? null : MessageHandler.colorize(MessageHandler.replaceVariables(ServiceHandler.translatePlaceholders(offlinePlayer, this.message), "%lvl%", n, "%xp_required%", this.xpEval, "%gained_stats%", this.statPointsEval, "%gained_souls%", this.soulsEval));
        if (this.title != null) {
            object = this.title.getString("title");
            String string2 = Strings.isNullOrEmpty((String)object) ? "" : MessageHandler.colorize(MessageHandler.replaceVariables(ServiceHandler.translatePlaceholders(offlinePlayer, (String)object), "%lvl%", n, "%xp_required%", this.xpEval, "%gained_stats%", this.statPointsEval, "%gained_souls%", this.soulsEval));
            String string3 = this.title.getString("subtitle");
            String string4 = Strings.isNullOrEmpty((String)string3) ? "" : MessageHandler.colorize(MessageHandler.replaceVariables(ServiceHandler.translatePlaceholders(offlinePlayer, string3), "%lvl%", n, "%xp_required%", this.xpEval, "%gained_stats%", this.statPointsEval, "%gained_souls%", this.soulsEval));
            this.titleEval = new Title(string2, string4, this.title.getInt("fade-in"), this.title.getInt("stay"), this.title.getInt("fade-out"));
        }
        object = new ArrayList();
        if (this.commands != null) {
            for (String string3 : this.commands) {
                object.add(MessageHandler.colorize(ServiceHandler.translatePlaceholders(offlinePlayer, string3)));
            }
        }
        this.commandsEval = object;
        return this;
    }

    public List<String> getCommands() {
        return this.commands;
    }

    public String getStatPoints() {
        return this.statPoints;
    }

    public String getSouls() {
        return this.souls;
    }

    public String getXp() {
        return this.xp;
    }

    public String getMessage() {
        return this.message;
    }

    public int getXpEval() {
        return this.xpEval;
    }

    public void setXpEval(int n) {
        this.xpEval = n;
    }

    public int getSoulsEval() {
        return this.soulsEval;
    }

    public void setSoulsEval(int n) {
        this.soulsEval = n;
    }

    public int getStatPointsEval() {
        return this.statPointsEval;
    }

    public void setStatPointsEval(int n) {
        this.statPointsEval = n;
    }

    public List<String> getCommandsEval() {
        return this.commandsEval;
    }

    public void setCommandsEval(List<String> list) {
        this.commandsEval = list;
    }
}

