/*
 * Decompiled with CFR 0.152.
 */
package org.skills.managers;

import com.google.common.base.Enums;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.apache.commons.lang.math.NumberUtils;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Firework;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.skills.abilities.Ability;
import org.skills.api.events.CustomHudChangeEvent;
import org.skills.api.events.SkillLevelUpEvent;
import org.skills.api.events.SkillSoulGainEvent;
import org.skills.api.events.SkillXPGainEvent;
import org.skills.data.managers.PlayerDataManager;
import org.skills.data.managers.SkilledPlayer;
import org.skills.events.SkillsEvent;
import org.skills.events.SkillsEventManager;
import org.skills.events.SkillsEventType;
import org.skills.main.SkillsConfig;
import org.skills.main.SkillsPro;
import org.skills.main.locale.MessageHandler;
import org.skills.main.locale.SkillsLang;
import org.skills.managers.HealthAndEnergyManager;
import org.skills.managers.LastHitManager;
import org.skills.managers.LevelUp;
import org.skills.services.manager.ServiceHandler;
import org.skills.utils.Hologram;
import org.skills.utils.MathUtils;
import org.skills.utils.Pair;
import org.skills.utils.StringUtils;

public class LevelManager
implements Listener {
    protected static final String SPAWNER = "SPAWNER";
    private static final ScriptEngine ENGINE;
    private static final List<CustomAmount> CUSTOM_XP;
    private static final List<CustomAmount> CUSTOM_SOULS;
    private final SkillsPro plugin;

    public LevelManager(SkillsPro skillsPro) {
        this.plugin = skillsPro;
        MessageHandler.sendConsolePluginMessage("&3Setting up Level Manager...");
        this.load();
    }

    public static boolean evaluate(Player player, double d, List<String> list) {
        for (String string : list) {
            String string2 = ServiceHandler.translatePlaceholders((OfflinePlayer)player, string);
            string2 = StringUtils.replace((String)string2, (String)"%level%", (String)String.valueOf(d));
            try {
                boolean bl = (Boolean)ENGINE.eval(string2);
                if (!bl) continue;
                return true;
            }
            catch (ScriptException scriptException) {
                MessageHandler.sendConsolePluginMessage("&4Unable to parse condition for level margin&8: &e" + string + " &7-> &e" + string2);
                MessageHandler.sendConsolePluginMessage("&c" + scriptException.getMessage());
                return false;
            }
        }
        return false;
    }

    public static List<Player> partyMembersInRange(Player player, SkilledPlayer skilledPlayer) {
        double d = SkillsConfig.PARTY_MEMBERS_MAX_RANGE.getDouble();
        if (d < 1.0) {
            return skilledPlayer.getParty().getOnlineMembers();
        }
        ArrayList<Player> arrayList = new ArrayList<Player>();
        for (Entity entity : player.getNearbyEntities(d, d, d)) {
            if (!(entity instanceof Player)) continue;
            Player player2 = (Player)entity;
            SkilledPlayer skilledPlayer2 = SkilledPlayer.getSkilledPlayer((OfflinePlayer)player2);
            if (!skilledPlayer.getPartyId().equals(skilledPlayer2.getPartyId())) continue;
            arrayList.add(player2);
        }
        return arrayList;
    }

    public static void onLevelUp(SkillLevelUpEvent skillLevelUpEvent) {
        SkilledPlayer skilledPlayer = skillLevelUpEvent.getInfo();
        Player player = skillLevelUpEvent.getPlayer();
        int n = skillLevelUpEvent.getNewLevel();
        PlayerDataManager.addLevel((OfflinePlayer)player, n);
        LevelUp levelUp = skillLevelUpEvent.getLevelProperties().evaluate(skilledPlayer, n);
        levelUp.perform(skilledPlayer, "%next_maxxp%", skilledPlayer.getLevelXP(n));
        if (SkillsConfig.LEVEL_CELEBRATION.getBoolean()) {
            levelUp.celebrate(player, SkillsPro.get(), n);
        }
        HealthAndEnergyManager.updateStats(player);
    }

    public void load() {
        Object object;
        boolean bl;
        ConfigurationSection configurationSection = SkillsConfig.XP.getSection();
        if (configurationSection == null) {
            MessageHandler.sendConsolePluginMessage("&4Outdated config.yml missing XP and Souls section.");
            MessageHandler.sendConsolePluginMessage("&4Custom XP and souls will not be loaded.");
            return;
        }
        for (Object object2 : configurationSection.getKeys(false)) {
            String string = configurationSection.getString((String)object2);
            boolean bl2 = false;
            bl = false;
            EntityType entityType = null;
            if (((String)object2).startsWith("TYPE:")) {
                object = StringUtils.deleteWhitespace(((String)(object2 = ((String)object2).substring(5))).toUpperCase(Locale.ENGLISH));
                entityType = (EntityType)Enums.getIfPresent(EntityType.class, (String)object).orNull();
                if (entityType == null) {
                    MessageHandler.sendConsolePluginMessage("&cInvalid entity type specified for XP&8: &e" + (String)object + " &cin &e" + (String)object2);
                    continue;
                }
            } else if (((String)object2).startsWith("CUSTOM:")) {
                object2 = ((String)object2).substring(7);
                bl = true;
            } else if (((String)object2).startsWith("CONTAINS:")) {
                object2 = ((String)object2).substring(9);
                bl2 = true;
            } else {
                object2 = MessageHandler.colorize((String)object2);
            }
            object = new CustomAmount((String)object2, string, entityType, bl2, bl);
            CUSTOM_XP.add((CustomAmount)object);
        }
        ConfigurationSection configurationSection2 = this.plugin.getConfig().getConfigurationSection("souls");
        for (String string : configurationSection2.getKeys(false)) {
            Object object3;
            String string2 = configurationSection2.getString(string);
            bl = false;
            boolean bl3 = false;
            object = null;
            if (string.startsWith("TYPE:")) {
                object3 = StringUtils.deleteWhitespace((string = string.substring(5)).toUpperCase(Locale.ENGLISH));
                object = (EntityType)Enums.getIfPresent(EntityType.class, (String)object3).orNull();
                if (object == null) {
                    MessageHandler.sendConsolePluginMessage("&cInvalid entity type specified for XP&8: &e" + (String)object3 + " &cin &e" + string);
                    continue;
                }
            } else if (string.startsWith("CUSTOM:")) {
                string = string.substring(7);
                bl3 = true;
            } else if (string.startsWith("CONTAINS:")) {
                string = string.substring(9);
                bl = true;
            } else {
                string = MessageHandler.colorize(string);
            }
            object3 = new CustomAmount(string, string2, (EntityType)object, bl, bl3);
            CUSTOM_SOULS.add((CustomAmount)object3);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onKillGains(EntityDeathEvent entityDeathEvent) {
        Object object;
        Object object2;
        Object object4;
        LivingEntity livingEntity = entityDeathEvent.getEntity();
        if (livingEntity.getType() == EntityType.ARMOR_STAND) {
            return;
        }
        if (Ability.isSkillEntity((Entity)livingEntity)) {
            return;
        }
        if (ServiceHandler.isKingdomMob(livingEntity)) {
            return;
        }
        if (SkillsConfig.isInDisabledWorld(livingEntity.getWorld())) {
            return;
        }
        LivingEntity livingEntity2 = LastHitManager.getKiller(entityDeathEvent);
        if (!(livingEntity2 instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity2;
        SkilledPlayer skilledPlayer = SkilledPlayer.getSkilledPlayer((OfflinePlayer)player);
        Pair<String, Number> pair = ServiceHandler.getMobProperties(livingEntity);
        double d = 0.0;
        if (player.hasPermission("skills.xp") && !SkillsConfig.DISABLED_WORLDS_XP_GAIN.getStringList().contains(player.getWorld().getName())) {
            double d2;
            SkillsEvent skillsEvent;
            double d3 = -1.0;
            object4 = CUSTOM_XP.iterator();
            while (object4.hasNext()) {
                CustomAmount object32 = (CustomAmount)object4.next();
                if (!object32.matches(livingEntity, pair)) continue;
                d3 = object32.evaluate(player, pair);
                break;
            }
            if (d3 == -1.0) {
                d3 = entityDeathEvent.getDroppedExp();
            }
            if ((object4 = SkillsEventManager.getEvent(SkillsEventType.XP)) != null) {
                d3 *= ((SkillsEvent)object4).calcMultiplier((OfflinePlayer)player);
            }
            if ((skillsEvent = skilledPlayer.getBonus(SkillsEventType.XP)) != null) {
                d3 *= skillsEvent.calcMultiplier((OfflinePlayer)player);
            }
            if (skilledPlayer.hasParty()) {
                object2 = LevelManager.partyMembersInRange(player, skilledPlayer);
                Object object3 = StringUtils.replace((String)StringUtils.replace((String)ServiceHandler.translatePlaceholders((OfflinePlayer)player, SkillsConfig.PARTY_XP_PER_MEMBER.getString()), (String)"xp", (String)String.valueOf(d3)), (String)"members-in-range", (String)String.valueOf(object2.size()));
                double d4 = MathUtils.evaluateEquation((String)object3);
                if (SkillsConfig.PARTY_DISTRIBUTE.getBoolean()) {
                    object = object2.iterator();
                    while (object.hasNext()) {
                        Player player2 = (Player)object.next();
                        SkilledPlayer skilledPlayer2 = SkilledPlayer.getSkilledPlayer((OfflinePlayer)player2);
                        skilledPlayer2.addXP(d4);
                    }
                } else {
                    d3 += d4;
                }
            }
            if (pair != null && SkillsConfig.MYTHICMOBS_WORLDS_WITH_LEVEL_MARGIN.getStringList().contains(livingEntity.getWorld().getName()) && LevelManager.evaluate(player, d2 = pair.getValue().doubleValue(), SkillsConfig.MYTHICMOBS_XP_CONDITIONS.getStringList())) {
                d3 = 0.0;
            }
            for (Object object3 : player.getEffectivePermissions()) {
                String string;
                if (!object3.getValue() || !(string = object3.getPermission()).startsWith("skills.xp.")) continue;
                string = string.substring(10);
                double d5 = NumberUtils.toDouble((String)string, (double)1.0);
                d3 *= d5;
            }
            if (livingEntity.hasMetadata(SPAWNER)) {
                d3 = (int)SkillsConfig.SPAWNERS_XP.fromEquation((OfflinePlayer)player, "%xp%", d3);
            }
            if (d3 != 0.0 && !SkillsConfig.DISABLED_WORLDS_XP_GAIN.getStringList().contains(livingEntity.getWorld().getName())) {
                object2 = new SkillXPGainEvent(player, (Entity)livingEntity, d3);
                Bukkit.getPluginManager().callEvent((Event)object2);
                if (!((SkillXPGainEvent)((Object)object2)).isCancelled()) {
                    skilledPlayer.addXP(((SkillXPGainEvent)((Object)object2)).getGained());
                    d = ((SkillXPGainEvent)((Object)object2)).getGained();
                }
            }
        }
        int n = 0;
        if (player.hasPermission("skills.souls") && !SkillsConfig.DISABLED_WORLDS_XP_GAIN.getStringList().contains(player.getWorld().getName())) {
            double d6;
            SkillsEvent skillsEvent;
            int n2 = 1;
            object4 = CUSTOM_SOULS.iterator();
            while (object4.hasNext()) {
                CustomAmount customAmount = (CustomAmount)object4.next();
                if (!customAmount.matches(livingEntity, pair)) continue;
                n2 = (int)customAmount.evaluate(player, pair);
                break;
            }
            if ((object4 = skilledPlayer.getBonus(SkillsEventType.SOUL)) != null) {
                n2 = (int)((double)n2 * ((SkillsEvent)object4).calcMultiplier((OfflinePlayer)player));
            }
            if (skilledPlayer.hasParty()) {
                List<Player> list = LevelManager.partyMembersInRange(player, skilledPlayer);
                object2 = StringUtils.replace((String)StringUtils.replace((String)ServiceHandler.translatePlaceholders((OfflinePlayer)player, SkillsConfig.PARTY_SOULS_PER_MEMBER.getString()), (String)"souls", (String)String.valueOf(n2)), (String)"members-in-range", (String)String.valueOf(list.size()));
                int n3 = (int)MathUtils.evaluateEquation((String)object2);
                if (SkillsConfig.PARTY_DISTRIBUTE.getBoolean()) {
                    for (Player player3 : list) {
                        object = SkilledPlayer.getSkilledPlayer((OfflinePlayer)player3);
                        ((SkilledPlayer)object).addSouls(n3);
                    }
                } else {
                    n2 += n3;
                }
            }
            if ((skillsEvent = SkillsEventManager.getEvent(SkillsEventType.SOUL)) != null) {
                n2 = (int)((double)n2 * skillsEvent.calcMultiplier((OfflinePlayer)player));
            }
            if (pair != null && SkillsConfig.MYTHICMOBS_WORLDS_WITH_LEVEL_MARGIN.getStringList().contains(livingEntity.getWorld().getName()) && LevelManager.evaluate(player, d6 = pair.getValue().doubleValue(), SkillsConfig.MYTHICMOBS_SOUL_CONDITIONS.getStringList())) {
                n2 = 0;
            }
            for (Object object3 : player.getEffectivePermissions()) {
                String string;
                if (!object3.getValue() || !(string = object3.getPermission()).startsWith("skills.souls.")) continue;
                string = string.substring(13);
                double d7 = NumberUtils.toDouble((String)string, (double)1.0);
                n2 = (int)((double)n2 * d7);
            }
            if (livingEntity.hasMetadata(SPAWNER)) {
                n2 = (int)SkillsConfig.SPAWNERS_SOULS.fromEquation((OfflinePlayer)player, "%souls%", n2);
            }
            if (n2 != 0 && !SkillsConfig.DISABLED_WORLDS_SOUL_GAIN.getStringList().contains(livingEntity.getWorld().getName())) {
                object2 = new SkillSoulGainEvent(player, (Entity)livingEntity, n2);
                Bukkit.getPluginManager().callEvent((Event)object2);
                if (!((SkillSoulGainEvent)((Object)object2)).isCancelled()) {
                    skilledPlayer.addSouls(((SkillSoulGainEvent)((Object)object2)).getGained());
                    n = ((SkillSoulGainEvent)((Object)object2)).getGained();
                }
            }
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (Ability ability : skilledPlayer.getSkill().getAbilities()) {
            int n4 = skilledPlayer.getImprovementLevel(ability);
            if (ability.getName().equals("passive") || n4 == 3) continue;
            int n5 = ability.getCost(skilledPlayer);
            if (skilledPlayer.getSouls() < (long)n5 || skilledPlayer.getSouls() - (long)n >= (long)n5) continue;
            stringBuilder.append(SkillsLang.ABILITY_UPGRADE_NOTIFICATION_LIST.parse(player, new Object[]{"%ability%", ability.getTitle(skilledPlayer), "%ability_level%", n4 + 1}));
        }
        if (stringBuilder.length() != 0) {
            SkillsLang.ABILITY_UPGRADE_NOTIFICATION.sendMessage(player, "%abilities%", stringBuilder);
        }
        d = MathUtils.roundToDigits(d, 2);
        if (SkillsConfig.HOLOGRAM_ENABLED.getBoolean() && !SkillsConfig.HOLOGRAM_DISABLED_MOBS.getStringList().contains(livingEntity.getType().name())) {
            Hologram.spawn(livingEntity.getLocation().clone().add(0.0, -2.0, 0.0), SkillsConfig.HOLOGRAM_COMPACT.getDouble(), SkillsConfig.HOLOGRAM_STAY.getLong(), SkillsConfig.HOLOGRAM_LINES.getStringList(), "%xp%", d, "%souls%", n);
        }
        if (SkillsConfig.KILL_MESSAGE.getBoolean()) {
            object4 = livingEntity.getCustomName() == null ? livingEntity.getName() : livingEntity.getCustomName();
            SkillsLang.KILL_MESSAGE.sendMessage(player, "%xp%", d, "%souls%", n, "%name%", object4);
        }
        CustomHudChangeEvent.call(player);
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onFireworkDamage(EntityDamageByEntityEvent entityDamageByEntityEvent) {
        if (entityDamageByEntityEvent.getDamager() instanceof Firework) {
            Firework firework = (Firework)entityDamageByEntityEvent.getDamager();
            if (firework.hasMetadata("LVLUP")) {
                entityDamageByEntityEvent.setCancelled(true);
            }
        } else if (entityDamageByEntityEvent.getDamager() instanceof Player && SkillsConfig.HOLOGRAM_ENABLED.getBoolean() && !SkillsConfig.HOLOGRAM_DISABLED_MOBS.getStringList().contains(entityDamageByEntityEvent.getEntity().getType().name())) {
            Hologram.spawn(entityDamageByEntityEvent.getEntity().getLocation().add(0.0, -2.0, 0.0), SkillsConfig.HOLOGRAM_COMPACT.getDouble(), SkillsConfig.HOLOGRAM_STAY.getLong(), SkillsConfig.HOLOGRAM_DAMAGE_INDICATOR.getStringList(), "%damage%", MathUtils.roundToDigits(entityDamageByEntityEvent.getFinalDamage(), SkillsConfig.HOLOGRAM_DAMAGE_INDICATOR_PRECISION.getInt()), "%direct_damage%", MathUtils.roundToDigits(entityDamageByEntityEvent.getDamage(), SkillsConfig.HOLOGRAM_DAMAGE_INDICATOR_PRECISION.getInt()));
        }
    }

    @EventHandler
    public void onDeath(PlayerDeathEvent playerDeathEvent) {
        Player player = playerDeathEvent.getEntity();
        SkilledPlayer skilledPlayer = SkilledPlayer.getSkilledPlayer((OfflinePlayer)player);
        if (skilledPlayer.getLevel() < SkillsConfig.LOSS_MIN_LEVEL.getInt()) {
            return;
        }
        long l = 0L;
        double d = 0.0;
        LivingEntity livingEntity = LastHitManager.getKiller((EntityDeathEvent)playerDeathEvent);
        Pair<String, Number> pair = livingEntity instanceof LivingEntity ? ServiceHandler.getMobProperties(livingEntity) : null;
        if (!SkillsConfig.DISABLED_WORLDS_SOUL_LOSS.getStringList().contains(player.getWorld().getName()) && skilledPlayer.getSouls() > 1L) {
            if (SkillsConfig.LOSE_SAME_SOULS_AS_KILLER_SOULS_GAIN.getBoolean()) {
                if (livingEntity != null) {
                    l = 1L;
                    for (CustomAmount customAmount : CUSTOM_SOULS) {
                        if (!customAmount.matches(livingEntity, pair)) continue;
                        l = (int)customAmount.evaluate(player, pair);
                        break;
                    }
                } else {
                    l = (int)MathUtils.evaluateEquation(ServiceHandler.translatePlaceholders((OfflinePlayer)player, SkillsConfig.SOULS_LOSS_UPON_DEATH.getString()));
                }
            } else {
                l = (int)MathUtils.evaluateEquation(ServiceHandler.translatePlaceholders((OfflinePlayer)player, SkillsConfig.SOULS_LOSS_UPON_DEATH.getString()));
            }
            if (skilledPlayer.getSouls() - l < 0L) {
                l = skilledPlayer.getSouls();
            }
            skilledPlayer.setSouls(Math.max(0L, skilledPlayer.getSouls() - l));
        }
        if (!SkillsConfig.DISABLED_WORLDS_XP_LOSS.getStringList().contains(player.getWorld().getName()) && skilledPlayer.getXP() > 1.0) {
            if (SkillsConfig.LOSE_SAME_XP_AS_KILLER_XP_GAIN.getBoolean()) {
                if (livingEntity != null) {
                    d = -1.0;
                    for (CustomAmount customAmount : CUSTOM_XP) {
                        if (!customAmount.matches(livingEntity, pair)) continue;
                        d = customAmount.evaluate(player, pair);
                        break;
                    }
                    if (d == -1.0) {
                        d = playerDeathEvent.getDroppedExp();
                    }
                } else {
                    d = MathUtils.evaluateEquation(ServiceHandler.translatePlaceholders((OfflinePlayer)player, SkillsConfig.XP_LOSS_UPON_DEATH.getString()));
                }
            } else {
                d = MathUtils.evaluateEquation(ServiceHandler.translatePlaceholders((OfflinePlayer)player, SkillsConfig.XP_LOSS_UPON_DEATH.getString()));
            }
            if (skilledPlayer.getXP() - d < 0.0) {
                d = skilledPlayer.getXP();
            }
            skilledPlayer.setAbsoluteXP(Math.max(0.0, skilledPlayer.getXP() - d));
        }
        SkillsLang.DEATH.sendMessage(player, "%souls%", l, "%xp%", d);
    }

    @EventHandler
    public void mobSpawnEvent(CreatureSpawnEvent creatureSpawnEvent) {
        if (creatureSpawnEvent.getSpawnReason() == CreatureSpawnEvent.SpawnReason.SPAWNER) {
            creatureSpawnEvent.getEntity().setMetadata(SPAWNER, (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)""));
        }
    }

    static {
        ScriptEngine scriptEngine;
        CUSTOM_XP = new ArrayList<CustomAmount>();
        CUSTOM_SOULS = new ArrayList<CustomAmount>();
        try {
            scriptEngine = new ScriptEngineManager().getEngineByName("JavaScript");
        }
        catch (Throwable throwable) {
            MessageHandler.sendConsolePluginMessage("&4Unable to load JavaScript evaluator. Looks like your Java version has some bugs.");
            throwable.printStackTrace();
            scriptEngine = null;
        }
        ENGINE = scriptEngine;
    }

    public static class CustomAmount {
        public boolean isContains;
        public boolean isCustomMob;
        public EntityType type;
        public String expression;
        public String equation;

        public CustomAmount(String string, String string2, EntityType entityType, boolean bl, boolean bl2) {
            this.expression = string;
            this.type = entityType;
            this.isContains = bl;
            this.isCustomMob = bl2;
            this.equation = string2;
        }

        public boolean matches(LivingEntity livingEntity, Pair<String, Number> pair) {
            if (this.isContains) {
                return livingEntity.getCustomName() != null && livingEntity.getCustomName().contains(this.expression);
            }
            if (this.isCustomMob && pair != null) {
                return this.expression.equalsIgnoreCase(pair.getKey());
            }
            if (livingEntity.getCustomName() != null && livingEntity.getCustomName().equalsIgnoreCase(this.expression)) {
                return true;
            }
            return livingEntity.getType() == this.type;
        }

        public double evaluate(Player player, Pair<String, Number> pair) {
            String string = ServiceHandler.translatePlaceholders((OfflinePlayer)player, this.equation);
            if (this.isCustomMob && pair != null) {
                string = MessageHandler.replace(string, "lvl", pair.getValue().doubleValue());
            }
            return MathUtils.evaluateEquation(string);
        }
    }
}

