/*
 * Decompiled with CFR 0.152.
 */
package org.skills.managers;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.OfflinePlayer;
import org.bukkit.boss.BossBar;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityCombustEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.plugin.Plugin;
import org.skills.api.events.CustomHudChangeEvent;
import org.skills.api.events.SkillXPGainEvent;
import org.skills.commands.general.CommandSelect;
import org.skills.data.managers.SkilledPlayer;
import org.skills.main.SkillsConfig;
import org.skills.main.SkillsPro;
import org.skills.main.locale.MessageHandler;
import org.skills.managers.EnchantmentManager;
import org.skills.managers.LastHitManager;
import org.skills.services.manager.ServiceHandler;
import org.skills.types.Energy;
import org.skills.types.Skill;
import org.skills.types.SkillManager;
import org.skills.types.SkillScaling;
import org.skills.utils.Cooldown;
import org.skills.utils.StringUtils;
import org.skills.utils.versionsupport.VersionSupport;
import org.skills.utils.xseries.ReflectionUtils;
import org.skills.utils.xseries.XSound;
import org.skills.utils.xseries.messages.ActionBar;

public class HealthAndEnergyManager
implements Listener {
    private static final MethodHandle EXP_PACKET;
    private static final Map<Integer, BossBar> LEVEL_BOSSBARS;

    public HealthAndEnergyManager(SkillsPro skillsPro) {
        int n;
        int n2 = SkillsConfig.ACTIONBAR_FREQUENCY.getInt();
        if (SkillsConfig.ACTIONBAR_ENABLED.getBoolean() && n2 > 0) {
            Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)skillsPro, () -> {
                for (Player player : Bukkit.getOnlinePlayers()) {
                    if (!player.hasPermission("skills.actionbar") || SkillsConfig.isInDisabledWorld(player.getLocation())) continue;
                    CustomHudChangeEvent customHudChangeEvent = new CustomHudChangeEvent(player);
                    Bukkit.getPluginManager().callEvent((Event)customHudChangeEvent);
                    if (customHudChangeEvent.isCancelled()) continue;
                    ActionBar.sendActionBar(player, customHudChangeEvent.getHud());
                }
            }, 100L, (long)n2);
        }
        if ((n = SkillsConfig.BOSSBAR_LEVELS_FREQUENCY.getInt()) > 0) {
            Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)skillsPro, () -> {
                for (Player player : Bukkit.getOnlinePlayers()) {
                    BossBar bossBar = LEVEL_BOSSBARS.get(player.getEntityId());
                    if (bossBar == null) continue;
                    bossBar.setTitle(MessageHandler.colorize(ServiceHandler.translatePlaceholders((OfflinePlayer)player, SkillsConfig.BOSSBAR_LEVELS.getSection().getString("title"))));
                }
            }, 100L, (long)n);
        }
        Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)skillsPro, () -> {
            for (Player player : Bukkit.getOnlinePlayers()) {
                boolean bl;
                SkilledPlayer skilledPlayer;
                if (SkillsConfig.isInDisabledWorld(player.getLocation()) || !(skilledPlayer = SkilledPlayer.getSkilledPlayer((OfflinePlayer)player)).hasSkill()) continue;
                Energy energy = skilledPlayer.getSkill().getEnergy();
                boolean bl2 = bl = energy.getCharging() == Energy.Charging.AUTO_REVERSE;
                if (energy.getCharging() != Energy.Charging.AUTO && !bl) continue;
                double d = skilledPlayer.getEnergy();
                double d2 = skilledPlayer.getScaling(SkillScaling.ENERGY_REGEN);
                double d3 = d;
                if (bl) {
                    d3 = d - d2 <= 0.0 ? 0.0 : (d3 -= d2);
                } else {
                    if (!Cooldown.isInCooldown(player.getUniqueId(), "ENERGY_BOOSTER")) {
                        skilledPlayer.setEnergyBooster(0.0);
                    }
                    double d4 = skilledPlayer.getEnergyBooster();
                    d2 += d4;
                    double d5 = skilledPlayer.getScaling(SkillScaling.MAX_ENERGY);
                    if (d3 >= d5) continue;
                    d3 = d + d2 >= d5 ? d5 : (d3 += d2);
                    if (d3 >= d5) {
                        XSound.play(player, energy.getSoundFull());
                    }
                }
                if (!player.isOnline()) continue;
                skilledPlayer.setEnergy(d3);
            }
        }, 60L, 20L);
    }

    public static BossBar getBossBar(Player player) {
        return LEVEL_BOSSBARS.get(player.getEntityId());
    }

    public static void updateStats(Player player) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)SkillsPro.get(), () -> {
            Object object;
            SkilledPlayer skilledPlayer = SkilledPlayer.getSkilledPlayer((OfflinePlayer)player);
            float f = (float)(skilledPlayer.getXP() / skilledPlayer.getLevelXP(skilledPlayer.getLevel()));
            Validate.isTrue(((double)f <= 1.0 && (double)f >= 0.0 ? 1 : 0) != 0, (String)("Invalid BossBar percent for " + player.getName() + ": " + f + " -> XP: " + skilledPlayer.getXP() + ", Next Level XP: " + skilledPlayer.getLevelXP(skilledPlayer.getLevel()) + " for level " + skilledPlayer.getLevel()));
            if (SkillsConfig.VANILLA_EXP_BAR_ENABLED.getBoolean()) {
                int n;
                object = SkillsConfig.VANILLA_EXP_BAR_SHOWN_NUMBER.getString().toLowerCase(Locale.ENGLISH);
                switch (object) {
                    case "xp": {
                        n = (int)skilledPlayer.getXP();
                        break;
                    }
                    case "level": {
                        n = skilledPlayer.getLevel();
                        break;
                    }
                    case "souls": {
                        n = (int)skilledPlayer.getSouls();
                        break;
                    }
                    default: {
                        MessageHandler.sendConsolePluginMessage("&4Invalid 'shown-number' option for vanilla EXP bar&8: &e" + (String)object);
                        n = 0;
                    }
                }
                player.setLevel(n);
                player.setExp(f);
            }
            if (SkillsConfig.BOSSBAR_LEVELS_ENABLED.getBoolean() && player.hasPermission("skills.bossbar") && (object = LEVEL_BOSSBARS.get(player.getEntityId())) != null) {
                object.setTitle(MessageHandler.colorize(ServiceHandler.translatePlaceholders((OfflinePlayer)player, SkillsConfig.BOSSBAR_LEVELS.getSection().getString("title"))));
                object.setProgress((double)f);
            }
            if (!skilledPlayer.hasSkill()) {
                return;
            }
            object = skilledPlayer.getSkill();
            double d = ((Skill)object).getScaling(skilledPlayer, SkillScaling.MAX_HEALTH);
            double d2 = ((Skill)object).getScaling(skilledPlayer, SkillScaling.HEALTH);
            double d3 = Math.min(d2, d);
            VersionSupport.setMaxHealth((LivingEntity)player, d3);
        });
    }

    public static void setExp(Player player, float f, int n, int n2) {
        try {
            Object object = EXP_PACKET.invoke(f, n, n2);
            ReflectionUtils.sendPacket(player, object);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onHitEnergyCharge(EntityDamageByEntityEvent entityDamageByEntityEvent) {
        if (!(entityDamageByEntityEvent.getDamager() instanceof Player)) {
            return;
        }
        Player player = (Player)entityDamageByEntityEvent.getDamager();
        SkilledPlayer skilledPlayer = SkilledPlayer.getSkilledPlayer((OfflinePlayer)player);
        if (!skilledPlayer.hasSkill()) {
            return;
        }
        Energy energy = skilledPlayer.getSkill().getEnergy();
        if (energy.getCharging() == Energy.Charging.HIT) {
            if (energy.getElements() == null || energy.getElements().isEmpty()) {
                skilledPlayer.chargeEnergy();
                return;
            }
            for (String string : energy.getElements()) {
                if (!entityDamageByEntityEvent.getEntityType().name().equals(string)) continue;
                skilledPlayer.chargeEnergy();
                break;
            }
        }
    }

    @EventHandler
    public void onHitEnergyCharge(EntityDeathEvent entityDeathEvent) {
        Player player = LastHitManager.getFinalHitMob(entityDeathEvent.getEntity());
        if (player == null) {
            return;
        }
        SkilledPlayer skilledPlayer = SkilledPlayer.getSkilledPlayer((OfflinePlayer)player);
        if (!skilledPlayer.hasSkill()) {
            return;
        }
        Energy energy = skilledPlayer.getSkill().getEnergy();
        if (energy.getCharging() == Energy.Charging.KILL) {
            if (energy.getElements() == null || energy.getElements().isEmpty()) {
                skilledPlayer.chargeEnergy();
                return;
            }
            for (String string : energy.getElements()) {
                if (!entityDeathEvent.getEntityType().name().equals(string)) continue;
                skilledPlayer.chargeEnergy();
                break;
            }
        }
    }

    @EventHandler
    public void onRespawn(PlayerRespawnEvent playerRespawnEvent) {
        if (SkillsConfig.isInDisabledWorld(playerRespawnEvent.getPlayer().getLocation())) {
            return;
        }
        Bukkit.getScheduler().runTaskLater((Plugin)SkillsPro.get(), () -> HealthAndEnergyManager.updateStats(playerRespawnEvent.getPlayer()), 1L);
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent playerJoinEvent) {
        String string;
        Player player = playerJoinEvent.getPlayer();
        SkilledPlayer skilledPlayer = SkilledPlayer.getSkilledPlayer((OfflinePlayer)player);
        skilledPlayer.setScaledHealth();
        if (!player.hasPlayedBefore()) {
            string = SkillsConfig.DEFAULT_SKILL.getString();
            if (!string.equalsIgnoreCase("none")) {
                Skill skill = SkillManager.getSkill(string);
                if (skill == null) {
                    MessageHandler.sendConsolePluginMessage("&4Unknown default skill option&8: &e" + string);
                } else {
                    skilledPlayer.setActiveSkill(skill);
                }
            }
            if (SkillsConfig.AUTO_SELECT_ON_JOIN.getBoolean()) {
                Bukkit.getScheduler().runTaskLater((Plugin)SkillsPro.get(), () -> CommandSelect.openMenu(player, skilledPlayer), 20L);
            }
        }
        if (SkillsConfig.isInDisabledWorld(playerJoinEvent.getPlayer().getWorld())) {
            return;
        }
        if (player.hasPermission("skills.bossbar")) {
            if (SkillsConfig.BOSSBAR_LEVELS_ENABLED.getBoolean()) {
                string = StringUtils.parseBossBarFromConfig(SkillsConfig.BOSSBAR_LEVELS_FREQUENCY.getInt() < 0 ? null : player, SkillsConfig.BOSSBAR_LEVELS.getSection());
                LEVEL_BOSSBARS.put(player.getEntityId(), (BossBar)string);
            }
            if (SkillsConfig.BOSSBAR_BONUSES_ENABLED.getBoolean()) {
                skilledPlayer.getBonuses().forEach((skillsEventType, skillsEvent) -> skillsEvent.start());
            }
        }
        HealthAndEnergyManager.updateStats(player);
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent playerQuitEvent) {
        Player player = playerQuitEvent.getPlayer();
        if (SkillsConfig.BOSSBAR_LEVELS_ENABLED.getBoolean()) {
            Integer n;
            BossBar bossBar = LEVEL_BOSSBARS.remove(player.getEntityId());
            if (bossBar != null) {
                bossBar.removeAll();
            }
            if ((n = EnchantmentManager.EXPS.remove(player.getUniqueId())) != null) {
                player.setTotalExperience(n.intValue());
            }
        }
        CustomHudChangeEvent.ANIMATIONS.remove(player.getUniqueId());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onWorldChange(PlayerChangedWorldEvent playerChangedWorldEvent) {
        Player player = playerChangedWorldEvent.getPlayer();
        if (SkillsConfig.isInDisabledWorld(player.getLocation())) {
            BossBar bossBar = LEVEL_BOSSBARS.get(player.getEntityId());
            if (bossBar != null) {
                bossBar.removeAll();
            }
            VersionSupport.setMaxHealth((LivingEntity)player, 20.0);
        } else if (SkillsConfig.isInDisabledWorld(playerChangedWorldEvent.getFrom())) {
            if (SkillsConfig.BOSSBAR_LEVELS_ENABLED.getBoolean() && player.hasPermission("skills.bossbar")) {
                BossBar bossBar = StringUtils.parseBossBarFromConfig(player, SkillsConfig.BOSSBAR_LEVELS.getSection());
                LEVEL_BOSSBARS.put(player.getEntityId(), bossBar);
            }
            HealthAndEnergyManager.updateStats(player);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onExpSkillGain(SkillXPGainEvent skillXPGainEvent) {
        if (!SkillsConfig.BOSSBAR_LEVELS_ENABLED.getBoolean() && !SkillsConfig.VANILLA_EXP_BAR_ENABLED.getBoolean()) {
            return;
        }
        HealthAndEnergyManager.updateStats(skillXPGainEvent.getPlayer());
    }

    @EventHandler(ignoreCancelled=true)
    public void hologramFire(EntityCombustEvent entityCombustEvent) {
        if (!SkillsConfig.DISABLE_CREATIVE_FIRE.getBoolean()) {
            return;
        }
        if (entityCombustEvent.getEntity() instanceof Player && ((Player)entityCombustEvent.getEntity()).getGameMode() == GameMode.CREATIVE) {
            entityCombustEvent.setCancelled(true);
        }
    }

    static {
        LEVEL_BOSSBARS = new HashMap<Integer, BossBar>();
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        MethodHandle methodHandle = null;
        try {
            methodHandle = lookup.findConstructor(ReflectionUtils.getNMSClass("PacketPlayOutExperience"), MethodType.methodType(Void.TYPE, Float.TYPE, Integer.TYPE, Integer.TYPE));
        }
        catch (IllegalAccessException | NoSuchMethodException reflectiveOperationException) {
            reflectiveOperationException.printStackTrace();
        }
        EXP_PACKET = methodHandle;
    }
}

