/*
 * Decompiled with CFR 0.152.
 */
package org.skills.managers;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.enchantment.EnchantItemEvent;
import org.bukkit.event.enchantment.PrepareItemEnchantEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerExpChangeEvent;
import org.skills.data.managers.SkilledPlayer;
import org.skills.main.SkillsConfig;
import org.skills.main.locale.MessageHandler;

public class EnchantmentManager
implements Listener {
    protected static final Map<UUID, Integer> EXPS = new HashMap<UUID, Integer>();

    public static void onDisable() {
        for (Map.Entry<UUID, Integer> entry : EXPS.entrySet()) {
            Player player = Bukkit.getPlayer((UUID)entry.getKey());
            if (player == null) {
                return;
            }
            player.setTotalExperience(entry.getValue().intValue());
        }
        EXPS.clear();
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGH)
    public void onEnchantmentTableOpen(InventoryOpenEvent inventoryOpenEvent) {
        if (!(inventoryOpenEvent.getPlayer() instanceof Player)) {
            return;
        }
        InventoryType inventoryType = inventoryOpenEvent.getView().getType();
        if (inventoryType != InventoryType.ENCHANTING && inventoryType != InventoryType.ANVIL) {
            return;
        }
        if (SkillsConfig.VANILLA_EXP_BAR_ENABLED.getBoolean() && !SkillsConfig.VANILLA_EXP_BAR_REAL_SYNC.getBoolean()) {
            Player player = (Player)inventoryOpenEvent.getPlayer();
            int n = EXPS.getOrDefault(player.getUniqueId(), player.getTotalExperience());
            player.setLevel(0);
            player.setExp(0.0f);
            player.setTotalExperience(0);
            player.giveExp(n);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onPrepare(PrepareItemEnchantEvent prepareItemEnchantEvent) {
        if (!SkillsConfig.SYNC_ENCHANTMENT_TABLES_ENABLED.getBoolean()) {
            return;
        }
        String string = SkillsConfig.SYNC_ENCHANTMENT_TABLES_COST_TYPE.getString().toLowerCase(Locale.ENGLISH);
        if (string.equals("vanilla")) {
            return;
        }
        Player player = prepareItemEnchantEvent.getEnchanter();
        SkilledPlayer skilledPlayer = SkilledPlayer.getSkilledPlayer((OfflinePlayer)player);
        String string2 = SkillsConfig.SYNC_ENCHANTMENT_TABLES_REQUIREMENT_LEVEL_EQUATION.getString();
    }

    @EventHandler(ignoreCancelled=true)
    public void onEnchant(EnchantItemEvent enchantItemEvent) {
        if (!SkillsConfig.SYNC_ENCHANTMENT_TABLES_ENABLED.getBoolean()) {
            return;
        }
        String string = SkillsConfig.SYNC_ENCHANTMENT_TABLES_COST_TYPE.getString().toLowerCase(Locale.ENGLISH);
        if (string.equals("vanilla")) {
            return;
        }
        Player player = enchantItemEvent.getEnchanter();
        SkilledPlayer skilledPlayer = SkilledPlayer.getSkilledPlayer((OfflinePlayer)player);
        player.setLevel(player.getLevel() + enchantItemEvent.getExpLevelCost());
        switch (string) {
            case "souls": {
                skilledPlayer.addSouls(-enchantItemEvent.getExpLevelCost());
                break;
            }
            case "xp": {
                skilledPlayer.addXP(-enchantItemEvent.getExpLevelCost());
                break;
            }
            case "levels": {
                skilledPlayer.setLevel(skilledPlayer.getLevel() - enchantItemEvent.getExpLevelCost());
            }
        }
    }

    @EventHandler
    public void onDeath(PlayerDeathEvent playerDeathEvent) {
        Player player;
        Integer n;
        if (SkillsConfig.VANILLA_EXP_BAR_ENABLED.getBoolean() && !SkillsConfig.VANILLA_EXP_BAR_REAL_SYNC.getBoolean() && (n = EXPS.remove((player = playerDeathEvent.getEntity()).getUniqueId())) != null) {
            playerDeathEvent.setDroppedExp(n.intValue());
        }
    }

    @EventHandler
    public void onEnchantTableReturnFakeXP(InventoryCloseEvent inventoryCloseEvent) {
        InventoryType inventoryType = inventoryCloseEvent.getView().getType();
        if (inventoryType != InventoryType.ENCHANTING && inventoryType != InventoryType.ANVIL) {
            return;
        }
        if (!(inventoryCloseEvent.getPlayer() instanceof Player)) {
            return;
        }
        Player player = (Player)inventoryCloseEvent.getPlayer();
        if (SkillsConfig.VANILLA_EXP_BAR_ENABLED.getBoolean() && !SkillsConfig.VANILLA_EXP_BAR_REAL_SYNC.getBoolean()) {
            EXPS.put(player.getUniqueId(), player.getTotalExperience());
            SkilledPlayer skilledPlayer = SkilledPlayer.getSkilledPlayer((OfflinePlayer)player);
            float f = (float)(skilledPlayer.getXP() / skilledPlayer.getLevelXP(skilledPlayer.getLevel()));
            Validate.isTrue(((double)f <= 1.0 && (double)f >= 0.0 ? 1 : 0) != 0, (String)("Invalid BossBar percent for " + player.getName() + ": " + f + " -> XP: " + skilledPlayer.getXP() + ", Next Level XP: " + skilledPlayer.getLevelXP(skilledPlayer.getLevel()) + " for level " + skilledPlayer.getLevel()));
            if (SkillsConfig.VANILLA_EXP_BAR_ENABLED.getBoolean()) {
                int n;
                String string;
                switch (string = SkillsConfig.VANILLA_EXP_BAR_SHOWN_NUMBER.getString().toLowerCase(Locale.ENGLISH)) {
                    case "xp": {
                        n = (int)skilledPlayer.getXP();
                        break;
                    }
                    case "level": {
                        n = skilledPlayer.getLevel();
                        break;
                    }
                    case "souls": {
                        n = (int)skilledPlayer.getSouls();
                        break;
                    }
                    default: {
                        MessageHandler.sendConsolePluginMessage("&4Invalid 'shown-number' option for vanilla EXP bar&8: &e" + string);
                        n = 0;
                    }
                }
                player.setLevel(n);
                player.setExp(f);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onExpBar(PlayerExpChangeEvent playerExpChangeEvent) {
        if (!SkillsConfig.VANILLA_EXP_BAR_ENABLED.getBoolean()) {
            return;
        }
        UUID uUID = playerExpChangeEvent.getPlayer().getUniqueId();
        EXPS.put(uUID, EXPS.getOrDefault(uUID, playerExpChangeEvent.getPlayer().getTotalExperience()) + playerExpChangeEvent.getAmount());
        playerExpChangeEvent.setAmount(0);
    }
}

