/*
 * Decompiled with CFR 0.152.
 */
package org.skills.main.locale;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.EnumMap;
import java.util.Locale;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.file.FileConfiguration;
import org.skills.main.SLogger;
import org.skills.main.SkillsConfig;
import org.skills.main.SkillsPro;
import org.skills.main.locale.MessageHandler;
import org.skills.main.locale.SkillsLang;
import org.skills.services.manager.ServiceHandler;
import org.skills.utils.StringUtils;
import org.skills.utils.YamlAdapter;
import org.skills.utils.xseries.XMaterial;

public class LanguageManager
extends YamlAdapter {
    private static final EnumMap<SkillsLang, String> LANGS = new EnumMap(SkillsLang.class);
    public static boolean created = false;

    public LanguageManager(SkillsPro skillsPro) {
        super(new File(skillsPro.getDataFolder(), StringUtils.remove((String)SkillsConfig.LANG.getString(), (String)".yml").toLowerCase(Locale.ENGLISH) + ".yml"));
        this.load();
    }

    public static String getMessage(SkillsLang skillsLang) {
        return LANGS.get((Object)skillsLang);
    }

    public static String buildMessage(String string, OfflinePlayer offlinePlayer, Object ... objectArray) {
        string = MessageHandler.replaceVariables(string, objectArray);
        if (offlinePlayer == null) {
            return MessageHandler.colorize(string);
        }
        string = ServiceHandler.translatePlaceholders(offlinePlayer, string);
        return MessageHandler.colorize(string);
    }

    public boolean isSet(String string) {
        return XMaterial.isNewVersion() ? this.getConfig().isSet(string) : this.getConfig().contains(string);
    }

    private boolean saveDefaultLang() {
        InputStream inputStream = SkillsPro.get().getResource("languages/" + this.getFile().getName());
        if (inputStream == null) {
            return false;
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
        try (BufferedWriter bufferedWriter = Files.newBufferedWriter(this.getFile().toPath(), StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.WRITE);){
            String string;
            while ((string = bufferedReader.readLine()) != null) {
                bufferedWriter.write(string);
                bufferedWriter.newLine();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.reloadConfig();
        return true;
    }

    public void load() {
        int n = 0;
        if (!this.getFile().exists()) {
            created = true;
            FileConfiguration fileConfiguration = this.getConfig();
            if (this.saveDefaultLang()) {
                for (SkillsLang skillsLang : SkillsLang.VALUES) {
                    String string = fileConfiguration.getString(skillsLang.getPath());
                    if (string == null) {
                        fileConfiguration.set(skillsLang.getPath(), (Object)skillsLang.getDefaultValue());
                        string = skillsLang.getDefaultValue();
                    }
                    LANGS.put(skillsLang, string);
                }
            } else {
                for (SkillsLang skillsLang : SkillsLang.VALUES) {
                    this.getConfig().set(skillsLang.getPath(), (Object)skillsLang.getDefaultValue());
                    LANGS.put(skillsLang, skillsLang.getDefaultValue());
                }
            }
            this.saveConfig();
            n = SkillsLang.values().length;
        } else {
            this.reloadConfig();
            boolean bl = false;
            for (SkillsLang skillsLang : SkillsLang.VALUES) {
                if (!this.isSet(skillsLang.getPath())) {
                    SLogger.warn("Setting missing language option " + (Object)((Object)skillsLang) + "...");
                    this.getConfig().set(skillsLang.getPath(), (Object)skillsLang.getDefaultValue());
                    LANGS.put(skillsLang, skillsLang.getDefaultValue());
                    bl = true;
                } else {
                    LANGS.put(skillsLang, this.getConfig().getString(skillsLang.getPath()));
                }
                ++n;
            }
            if (bl) {
                this.saveConfig();
            }
        }
        MessageHandler.sendConsolePluginMessage("&2Loaded a total of &6" + n + " &2language statements.");
    }
}

