/*
 * Decompiled with CFR 0.152.
 */
package org.skills.main;

import com.google.common.base.Strings;
import java.util.List;
import java.util.Set;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.skills.main.locale.MessageHandler;
import org.skills.utils.xseries.XMaterial;

public class SkillsSkillConfig {
    private final FileConfiguration config;
    private final String option;
    private String dynamicOption;
    private String property;

    public SkillsSkillConfig(FileConfiguration fileConfiguration, String string) {
        this.config = fileConfiguration;
        this.option = string;
    }

    public String getOption() {
        return this.option;
    }

    public SkillsSkillConfig withOption(Object ... objectArray) {
        this.dynamicOption = MessageHandler.replaceVariables(this.option, objectArray);
        return this;
    }

    public SkillsSkillConfig withProperty(String string) {
        this.property = (Strings.isNullOrEmpty((String)this.dynamicOption) ? this.option : this.dynamicOption) + '.' + string;
        return this;
    }

    public SkillsSkillConfig back() {
        this.property = this.property.substring(0, this.property.lastIndexOf(46) - 1);
        return this;
    }

    public String getDynamicOption() {
        return Strings.isNullOrEmpty((String)this.property) ? (Strings.isNullOrEmpty((String)this.dynamicOption) ? this.option : this.dynamicOption) : this.property;
    }

    public boolean isSet() {
        return XMaterial.isNewVersion() ? this.config.isSet(this.getDynamicOption()) : this.config.contains(this.getDynamicOption());
    }

    public String getString() {
        return this.config.getString(this.getDynamicOption());
    }

    public List<String> getStringList() {
        return this.config.getStringList(this.getDynamicOption());
    }

    public Set<String> getSectionSet() {
        return this.config.getConfigurationSection(this.getDynamicOption()).getKeys(false);
    }

    public boolean getBoolean() {
        return this.config.getBoolean(this.getDynamicOption());
    }

    public int getInt() {
        return this.config.getInt(this.getDynamicOption());
    }

    public double getDouble() {
        return this.config.getDouble(this.getDynamicOption());
    }

    public long getLong() {
        return this.config.getLong(this.getDynamicOption());
    }

    public ConfigurationSection getSection() {
        return this.config.getConfigurationSection(this.getDynamicOption());
    }
}

