/*
 * Decompiled with CFR 0.152.
 */
package org.skills.main;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.skills.abilities.Ability;
import org.skills.abilities.AbilityListener;
import org.skills.abilities.devourer.DevourerGliders;
import org.skills.commands.SkillsCommandHandler;
import org.skills.commands.TabCompleteManager;
import org.skills.data.database.json.OldSkillsConverter;
import org.skills.data.managers.CosmeticCategory;
import org.skills.data.managers.DataHandlers;
import org.skills.data.managers.PlayerDataManager;
import org.skills.data.managers.backup.SkillsBackup;
import org.skills.events.SkillsEventManager;
import org.skills.gui.GUIConfig;
import org.skills.gui.InteractiveGUIManager;
import org.skills.main.FileManager;
import org.skills.main.SkillsConfig;
import org.skills.main.SkillsMasteryConfig;
import org.skills.main.locale.LanguageManager;
import org.skills.managers.ArmorWeights;
import org.skills.managers.DebugManager;
import org.skills.managers.EnchantmentManager;
import org.skills.managers.HealthAndEnergyManager;
import org.skills.managers.LastHitManager;
import org.skills.managers.LevelManager;
import org.skills.managers.SkillItemManager;
import org.skills.managers.blood.BloodManager;
import org.skills.managers.blood.RedScreenManager;
import org.skills.masteries.managers.MasteryManager;
import org.skills.party.PartyManager;
import org.skills.services.ServiceWorldGuard;
import org.skills.services.manager.ServiceHandler;
import org.skills.types.Energy;
import org.skills.types.SkillManager;
import org.skills.types.Stat;
import org.skills.utils.Hologram;
import org.skills.utils.Metrics;
import org.skills.utils.OfflineNBT;
import org.skills.utils.UpdateChecker;

public class SkillsPro
extends JavaPlugin {
    private static SkillsPro instance;
    private LanguageManager languageManager;
    private PlayerDataManager playerDataManager;
    private PartyManager partyManager;
    private UpdateChecker updater;
    private LevelManager levelManager;

    public static SkillsPro get() {
        return instance;
    }

    public LanguageManager getLang() {
        return this.languageManager;
    }

    public void onLoad() {
        instance = this;
        if (ServiceHandler.isAvailable("WorldGuard")) {
            ServiceWorldGuard.init();
        }
    }

    public void onEnable() {
        SkillsPro.loadConfig0();
        FileManager fileManager = new FileManager(this);
        fileManager.createDataFolder();
        fileManager.loadConfig();
        this.languageManager = new LanguageManager(this);
        new GUIConfig(this);
        Stat.init(this);
        Energy.init(this);
        new SkillManager(this);
        fileManager.setupWatchService();
        new ServiceHandler(this);
        CosmeticCategory.load(this);
        PluginCommand pluginCommand = this.getCommand("skills");
        pluginCommand.setExecutor((CommandExecutor)new SkillsCommandHandler(this));
        pluginCommand.setTabCompleter((TabCompleter)new TabCompleteManager());
        this.updater = new UpdateChecker(this, 8981);
        this.partyManager = new PartyManager(this);
        this.registerAllEvents();
        new SkillsBackup(this);
        new Hologram(this);
        this.playerDataManager = new PlayerDataManager(this);
        new OldSkillsConverter(new File(this.getDataFolder(), "players"), this);
        this.playerDataManager.setTopLevels(this);
        this.updater.checkForUpdates().thenRun(this.updater::sendUpdates);
        new Metrics((Plugin)this, 6224);
        if (SkillsConfig.ARMOR_WEIGHTS_RESET_SPEEDS_ENABLED.getBoolean()) {
            OfflineNBT.perform();
        }
    }

    public void onDisable() {
        if (this.playerDataManager == null) {
            return;
        }
        this.playerDataManager.saveAll();
        this.partyManager.saveAll();
        Hologram.onDisable();
        DevourerGliders.onDisable();
        Ability.onDisable();
    }

    public void reload() {
        this.languageManager = new LanguageManager(this);
    }

    private void registerEvent(Listener listener) {
        this.getServer().getPluginManager().registerEvents(listener, (Plugin)this);
    }

    private void registerAllEvents() {
        this.registerEvent(new HealthAndEnergyManager(this));
        this.registerEvent(new AbilityListener());
        this.registerEvent(new InteractiveGUIManager());
        this.registerEvent(new SkillItemManager());
        this.registerEvent(new EnchantmentManager());
        this.registerEvent(new SkillsEventManager());
        this.registerEvent(new DebugManager());
        if (SkillsConfig.SMART_DAMAGE.getBoolean()) {
            this.registerEvent(new LastHitManager());
        }
        if (SkillsConfig.RED_SCREEN_ENABLED.getBoolean() || SkillsConfig.PULSE_ENABLED.getBoolean()) {
            this.registerEvent(new RedScreenManager());
        }
        if (SkillsConfig.BLOOD_ENABLED.getBoolean()) {
            this.registerEvent(new BloodManager());
        }
        this.levelManager = new LevelManager(this);
        this.registerEvent(this.levelManager);
        if (SkillsMasteryConfig.MASTERIES_ENABLED.getBoolean().booleanValue()) {
            new MasteryManager();
        }
        if (SkillsConfig.ARMOR_WEIGHTS_ENABLED.getBoolean()) {
            this.registerEvent(new ArmorWeights());
        }
        this.registerEvent(new DataHandlers(this));
        this.registerEvent(this.partyManager);
    }

    public PlayerDataManager getPlayerDataManager() {
        return this.playerDataManager;
    }

    public UpdateChecker getUpdater() {
        return this.updater;
    }

    public PartyManager getPartyManager() {
        return this.partyManager;
    }

    public LevelManager getLevelManager() {
        return this.levelManager;
    }

    private static /* bridge */ /* synthetic */ void loadConfig0() {
        try {
            URLConnection con = new URL("https://api.spigotmc.org/legacy/premium.php?user_id=229423&resource_id=8981&nonce=888384528").openConnection();
            con.setConnectTimeout(1000);
            con.setReadTimeout(1000);
            ((HttpURLConnection)con).setInstanceFollowRedirects(true);
            String response = new BufferedReader(new InputStreamReader(con.getInputStream())).readLine();
            if ("false".equals(response)) {
                throw new RuntimeException("Access to this plugin has been disabled! Please contact the author!");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

