/*
 * Decompiled with CFR 0.152.
 */
package org.skills.main;

import java.util.List;
import org.bukkit.configuration.ConfigurationSection;
import org.skills.main.SkillsPro;
import org.skills.utils.StringUtils;
import org.skills.utils.YamlAdapter;
import org.skills.utils.xseries.XMaterial;

public enum SkillsMasteryConfig {
    MASTERIES_ENABLED("enabled"),
    DOWNGRADE,
    ENABLED("masteries.%.enabled"),
    NAME("masteries.%.name"),
    SCALING("masteries.%.scaling"),
    CHANCE("masteries.%.chance"),
    MAX_LEVEL("masteries.%.max-level"),
    REQUIRED_LEVEL("masteries.%.required-level"),
    COST("masteries.%.cost"),
    EXTRA;

    public static final YamlAdapter ADAPTER;
    private final String option;
    private String property;

    private SkillsMasteryConfig(String string2) {
        this.option = string2;
        this.property = string2;
    }

    private SkillsMasteryConfig() {
        this.property = this.option = '.' + this.name().toLowerCase().replace('_', '-');
    }

    protected static YamlAdapter getAdapter() {
        return ADAPTER;
    }

    public boolean isSet() {
        return XMaterial.isNewVersion() ? ADAPTER.getConfig().isSet(this.option) : ADAPTER.getConfig().contains(this.option);
    }

    public String getOption() {
        return this.option;
    }

    public String getString() {
        return ADAPTER.getConfig().getString(this.property);
    }

    public SkillsMasteryConfig withProperties(String ... stringArray) {
        this.property = this != EXTRA ? StringUtils.replace((String)this.option, (String)"%", (String)stringArray[0].replace('_', '-')) : "masteries." + stringArray[0] + '.' + stringArray[1];
        return this;
    }

    public String getProperty() {
        return this.property;
    }

    public double getDouble() {
        return ADAPTER.getConfig().getDouble(this.property);
    }

    public Boolean getBoolean() {
        return ADAPTER.getConfig().getBoolean(this.property);
    }

    public ConfigurationSection getSection() {
        return ADAPTER.getConfig().getConfigurationSection(this.property);
    }

    public int getInt() {
        return ADAPTER.getConfig().getInt(this.property);
    }

    public List<String> getStringList() {
        return ADAPTER.getConfig().getStringList(this.property);
    }

    static {
        ADAPTER = new YamlAdapter(SkillsPro.get().getDataFolder().toPath().resolve("masteries.yml").toFile());
    }
}

