/*
 * Decompiled with CFR 0.152.
 */
package org.skills.main;

import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.event.HandlerList;
import org.bukkit.plugin.Plugin;
import org.skills.gui.GUIConfig;
import org.skills.main.SkillsConfig;
import org.skills.main.SkillsMasteryConfig;
import org.skills.main.SkillsPro;
import org.skills.main.locale.MessageHandler;
import org.skills.masteries.managers.MasteryManager;
import org.skills.types.Energy;
import org.skills.types.Skill;
import org.skills.types.SkillManager;
import org.skills.types.Stat;

public class FileManager {
    public static boolean created;
    public static boolean isNew;
    private final SkillsPro plugin;

    public FileManager(SkillsPro skillsPro) {
        this.plugin = skillsPro;
    }

    public void createDataFolder() {
        Path path = this.plugin.getDataFolder().toPath();
        isNew = !Files.exists(path, new LinkOption[0]);
        try {
            Files.createDirectories(path, new FileAttribute[0]);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void loadConfig() {
        Path path = this.plugin.getDataFolder().toPath().resolve("config.yml");
        if (!Files.exists(path, new LinkOption[0])) {
            this.plugin.getConfig().options().copyDefaults(true);
            this.plugin.saveDefaultConfig();
            created = true;
        }
        this.plugin.reloadConfig();
        SkillsMasteryConfig.getAdapter().register();
        SkillsMasteryConfig.getAdapter().reloadConfig();
    }

    public void setupWatchService() {
        Path path = this.plugin.getDataFolder().toPath();
        WatchService watchService = null;
        try {
            watchService = FileSystems.getDefault().newWatchService();
            path.register(watchService, StandardWatchEventKinds.ENTRY_MODIFY);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        final HashMap hashMap = new HashMap();
        try {
            Files.walkFileTree(path.resolve("guis").resolve(SkillsConfig.LANG.getString()), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path path, BasicFileAttributes basicFileAttributes) {
                    WatchService watchService = FileSystems.getDefault().newWatchService();
                    path.register(watchService, StandardWatchEventKinds.ENTRY_MODIFY);
                    hashMap.put(path, watchService);
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        Path path2 = path.resolve("Skills");
        WatchService watchService2 = null;
        try {
            watchService2 = FileSystems.getDefault().newWatchService();
            path2.register(watchService2, StandardWatchEventKinds.ENTRY_MODIFY);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        WatchService watchService3 = watchService;
        WatchService watchService4 = watchService2;
        Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)this.plugin, () -> {
            Object object;
            Object object2;
            WatchKey watchKey = watchService3.poll();
            if (watchKey != null) {
                for (WatchEvent object3 : watchKey.pollEvents()) {
                    object2 = object3.context().toString();
                    if (((String)object2).equalsIgnoreCase("config.yml")) {
                        MessageHandler.sendConsolePluginMessage("&2Detected changes for config, reloading...");
                        Stat.init(this.plugin);
                        Energy.init(this.plugin);
                        this.plugin.getLevelManager().load();
                        this.plugin.reloadConfig();
                        continue;
                    }
                    if (((String)object2).equalsIgnoreCase("masteries.yml")) {
                        MessageHandler.sendConsolePluginMessage("&2Detected changes for masteries, reloading...");
                        SkillsMasteryConfig.getAdapter().register();
                        SkillsMasteryConfig.getAdapter().reloadConfig();
                        MasteryManager.getMasteries().forEach(HandlerList::unregisterAll);
                        if (!SkillsMasteryConfig.MASTERIES_ENABLED.getBoolean().booleanValue()) continue;
                        new MasteryManager();
                        continue;
                    }
                    if (!((String)object2).equalsIgnoreCase(SkillsConfig.LANG.getString() + ".yml")) continue;
                    MessageHandler.sendConsolePluginMessage("&2Detected changes for language file, reloading...");
                    this.plugin.reload();
                }
                watchKey.reset();
            }
            for (Map.Entry entry : hashMap.entrySet()) {
                watchKey = ((WatchService)entry.getValue()).poll();
                if (watchKey == null) continue;
                for (WatchEvent watchEvent : watchKey.pollEvents()) {
                    object = watchEvent.context().toString();
                    MessageHandler.sendConsolePluginMessage("&2Detected changes for GUI&8: &9" + (String)object);
                    GUIConfig.registerGUI((Plugin)this.plugin, ((String)object).substring(0, ((String)object).length() - 4));
                }
                watchKey.reset();
            }
            watchKey = watchService4.poll();
            if (watchKey != null) {
                for (WatchEvent watchEvent : watchKey.pollEvents()) {
                    object2 = (Path)watchEvent.context();
                    String string2 = object2.toString();
                    string2 = string2.substring(0, string2.length() - 4);
                    MessageHandler.sendConsolePluginMessage("&2Detected changes for skill&8: &9" + string2);
                    object = SkillManager.getSkill(string2);
                    ((Skill)object).getAdapter().reloadConfig();
                    SkillManager.registerScalings((Skill)object);
                }
                watchKey.reset();
            }
        }, 200L, 100L);
    }
}

