/*
 * Decompiled with CFR 0.152.
 */
package org.skills.gui;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.skills.gui.GUIOption;
import org.skills.gui.InteractiveGUI;
import org.skills.main.SkillsConfig;
import org.skills.main.SkillsPro;
import org.skills.main.locale.MessageHandler;
import org.skills.utils.StringUtils;
import org.skills.utils.xseries.XSound;

public class InteractiveGUIManager
implements Listener {
    protected static final Map<Integer, GUIOption> CONVERSATION = new HashMap<Integer, GUIOption>();
    protected static final Map<Integer, InteractiveGUI> GUIS = new HashMap<Integer, InteractiveGUI>();

    private static int firstPartial(Inventory inventory, ItemStack itemStack, Predicate<Integer> predicate) {
        ItemStack[] itemStackArray = inventory.getContents();
        for (int i = 0; i < inventory.getSize(); ++i) {
            ItemStack itemStack2;
            if (!predicate.test(i) || (itemStack2 = itemStackArray[i]) == null || !itemStack2.isSimilar(itemStack) || itemStack2.getMaxStackSize() == itemStack2.getAmount()) continue;
            return i;
        }
        return -1;
    }

    public static Map<Integer, InteractiveGUI> getGuis() {
        return GUIS;
    }

    private static List<ItemStack> distribute(Inventory inventory, ItemStack itemStack, Predicate<Integer> predicate) {
        Object object;
        int n;
        int n2 = itemStack.getMaxStackSize();
        while ((n = InteractiveGUIManager.firstPartial(inventory, itemStack, predicate)) != -1) {
            object = inventory.getItem(n);
            if (itemStack.getAmount() + object.getAmount() <= n2) {
                object.setAmount(object.getAmount() + itemStack.getAmount());
                return new ArrayList<ItemStack>();
            }
            int n3 = n2 - object.getAmount();
            object.setAmount(object.getAmount() + n3);
            itemStack.setAmount(itemStack.getAmount() - n3);
        }
        object = new ArrayList();
        while (itemStack.getAmount() > n2) {
            ItemStack itemStack2 = itemStack.clone();
            itemStack2.setAmount(n2);
            object.add(itemStack2);
            itemStack.setAmount(itemStack.getAmount() - n2);
        }
        object.add(itemStack);
        ItemStack[] itemStackArray = inventory.getContents();
        for (int i = 0; i < inventory.getSize(); ++i) {
            if (!predicate.test(i) || itemStackArray[i] != null) continue;
            inventory.setItem(i, (ItemStack)object.remove(0));
            if (!object.isEmpty()) continue;
            return object;
        }
        return object;
    }

    private static void end(Player player) {
        CONVERSATION.remove(player.getEntityId());
        InteractiveGUI interactiveGUI = GUIS.remove(player.getEntityId());
        if (interactiveGUI != null) {
            interactiveGUI.cancelRefreshTask();
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void onChat(AsyncPlayerChatEvent asyncPlayerChatEvent) {
        Runnable runnable;
        Player player = asyncPlayerChatEvent.getPlayer();
        GUIOption gUIOption = CONVERSATION.get(player.getEntityId());
        if (gUIOption == null) {
            return;
        }
        asyncPlayerChatEvent.setCancelled(true);
        InteractiveGUI interactiveGUI = GUIS.get(player.getEntityId());
        String string = asyncPlayerChatEvent.getMessage();
        if (string.equalsIgnoreCase("cancel")) {
            InteractiveGUI.endConversation(player);
            runnable = () -> interactiveGUI.openInventory(player);
        } else {
            runnable = () -> gUIOption.getConversation().run(string);
        }
        Bukkit.getScheduler().runTask((Plugin)SkillsPro.get(), runnable);
    }

    @EventHandler(ignoreCancelled=true)
    public void onDrag(InventoryDragEvent inventoryDragEvent) {
        if (!(inventoryDragEvent.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)inventoryDragEvent.getWhoClicked();
        InteractiveGUI interactiveGUI = GUIS.get(player.getEntityId());
        if (interactiveGUI == null) {
            return;
        }
        inventoryDragEvent.setCancelled(true);
    }

    @EventHandler(ignoreCancelled=true)
    public void onClick(InventoryClickEvent inventoryClickEvent) {
        Map<ClickType, Runnable> map;
        if (inventoryClickEvent.getAction() == InventoryAction.NOTHING) {
            return;
        }
        if (!(inventoryClickEvent.getWhoClicked() instanceof Player)) {
            return;
        }
        Inventory inventory = inventoryClickEvent.getClickedInventory();
        if (inventory == null) {
            return;
        }
        Player player = (Player)inventoryClickEvent.getWhoClicked();
        InteractiveGUI interactiveGUI = GUIS.get(player.getEntityId());
        if (interactiveGUI == null) {
            return;
        }
        if (inventory.getType() == InventoryType.PLAYER) {
            if (inventoryClickEvent.getCurrentItem() != null && inventoryClickEvent.isShiftClick()) {
                if (interactiveGUI.getInteractableSlots().isEmpty()) {
                    inventoryClickEvent.setCancelled(true);
                    return;
                }
                if (interactiveGUI.canInteractWithEmpty()) {
                    return;
                }
                List<ItemStack> list = InteractiveGUIManager.distribute(player.getOpenInventory().getTopInventory(), inventoryClickEvent.getCurrentItem(), interactiveGUI::isSlotInteractable);
                if (list.isEmpty()) {
                    inventoryClickEvent.setCurrentItem(null);
                }
                inventoryClickEvent.setCancelled(true);
            }
            return;
        }
        if (interactiveGUI.getInteractableSlots().contains(inventoryClickEvent.getSlot())) {
            return;
        }
        GUIOption gUIOption = interactiveGUI.getAction(inventoryClickEvent.getSlot());
        if (gUIOption == null) {
            if (!interactiveGUI.canInteractWithEmpty()) {
                inventoryClickEvent.setCancelled(true);
            }
            return;
        }
        if (!gUIOption.canBeTaken() || inventoryClickEvent.getCursor() != null) {
            inventoryClickEvent.setCancelled(true);
        }
        if (gUIOption.getRunnables() != null) {
            Runnable runnable;
            map = gUIOption.getRunnables();
            Runnable runnable2 = runnable = map.size() == 1 ? (Runnable)map.values().iterator().next() : (Runnable)map.get(inventoryClickEvent.getClick());
            if (runnable != null) {
                try {
                    runnable.run();
                }
                catch (Exception exception) {
                    MessageHandler.sendConsolePluginMessage("&cAn exception has occurred while handling GUI option '" + gUIOption.getName() + "' for player " + player.getName() + ':');
                    exception.printStackTrace();
                }
            }
        }
        StringUtils.performCommands(player, gUIOption.getCommands());
        map = gUIOption.getSound();
        if (map != null && !((String)((Object)map)).equals("default")) {
            XSound.play(player, (String)((Object)map));
        }
        if (!Strings.isNullOrEmpty((String)gUIOption.getMessage())) {
            MessageHandler.sendPlayerMessage(player, gUIOption.getMessage());
        }
    }

    @EventHandler
    public void onClose(InventoryCloseEvent inventoryCloseEvent) {
        if (!(inventoryCloseEvent.getPlayer() instanceof Player)) {
            return;
        }
        int n = inventoryCloseEvent.getPlayer().getEntityId();
        if (CONVERSATION.containsKey(n)) {
            return;
        }
        InteractiveGUI interactiveGUI = GUIS.remove(n);
        if (interactiveGUI != null) {
            interactiveGUI.cancelRefreshTask();
            if (interactiveGUI.getOnClose() != null) {
                interactiveGUI.getOnClose().run();
            }
        }
    }

    @EventHandler
    public void onLeave(PlayerQuitEvent playerQuitEvent) {
        InteractiveGUIManager.end(playerQuitEvent.getPlayer());
    }

    @EventHandler
    public void onDeath(PlayerDeathEvent playerDeathEvent) {
        InteractiveGUIManager.end(playerDeathEvent.getEntity());
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onDamage(EntityDamageEvent entityDamageEvent) {
        if (!(entityDamageEvent.getEntity() instanceof Player)) {
            return;
        }
        if (!SkillsConfig.CLOSE_GUI_ON_DAMAGE.getBoolean()) {
            return;
        }
        Player player = (Player)entityDamageEvent.getEntity();
        if (GUIS.containsKey(player.getEntityId())) {
            player.closeInventory();
        }
    }

    private static /* synthetic */ void lambda$onDrag$2(InventoryView inventoryView, ItemStack itemStack) {
        inventoryView.setCursor(itemStack);
    }
}

