/*
 * Decompiled with CFR 0.152.
 */
package org.skills.gui;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import org.skills.gui.Conversable;
import org.skills.gui.GUIOption;
import org.skills.gui.GUIParser;
import org.skills.gui.InteractiveGUIManager;
import org.skills.main.SkillsPro;
import org.skills.main.locale.MessageHandler;
import org.skills.utils.StringUtils;
import org.skills.utils.xseries.XItemStack;
import org.skills.utils.xseries.XSound;

public class InteractiveGUI {
    private final String name;
    private final Set<String> holders;
    private final Map<Integer, GUIOption> options = new ConcurrentHashMap<Integer, GUIOption>();
    private final ConfigurationSection optionsSection;
    private final List<Integer> refresh = new ArrayList<Integer>();
    private final List<Integer> interactableSlots;
    private final List<String> commands;
    private final String sound;
    private final Inventory inventory;
    private final boolean disallowCreative;
    private final List<Object> edits;
    private final Player owner;
    private final OfflinePlayer placeholder;
    private final String message;
    private Integer refreshTask;
    private Runnable onClose;

    public InteractiveGUI(Inventory inventory, Player player, OfflinePlayer offlinePlayer, String string, String string2, List<String> list, List<Integer> list2, String string3, boolean bl, ConfigurationSection configurationSection, List<Object> list3) {
        this.inventory = inventory;
        this.name = string;
        this.sound = string2;
        this.commands = list;
        this.interactableSlots = list2;
        this.message = string3;
        this.disallowCreative = bl;
        this.optionsSection = configurationSection;
        this.edits = list3;
        this.owner = player;
        this.placeholder = offlinePlayer;
        this.holders = ConcurrentHashMap.newKeySet();
        if (configurationSection != null) {
            this.holders.addAll(configurationSection.getKeys(false));
        }
    }

    public InteractiveGUI(Player player, OfflinePlayer offlinePlayer, String string, String string2, int n, String string3, List<String> list, List<Integer> list2, String string4, boolean bl, ConfigurationSection configurationSection, List<Object> list3) {
        this(Bukkit.createInventory((InventoryHolder)player, (int)n, (String)string2), player, offlinePlayer, string, string3, list, list2, string4, bl, configurationSection, list3);
    }

    public InteractiveGUI(Player player, OfflinePlayer offlinePlayer, InventoryType inventoryType, String string, String string2, String string3, List<String> list, List<Integer> list2, String string4, boolean bl, ConfigurationSection configurationSection, List<Object> list3) {
        this(Bukkit.createInventory((InventoryHolder)player, (InventoryType)inventoryType, (String)string2), player, offlinePlayer, string, string3, list, list2, string4, bl, configurationSection, list3);
    }

    public static void endConversation(Player player) {
        InteractiveGUIManager.CONVERSATION.remove(player.getEntityId());
    }

    public void startConversation(Player player, String string) {
        this.holders.add(string);
        InteractiveGUIManager.CONVERSATION.put(player.getEntityId(), this.options.get(this.getHolder(string, new Object[0]).getSlots().get(0)));
        player.closeInventory();
    }

    public void refresh() {
        for (GUIOption gUIOption : this.options.values()) {
            ItemStack itemStack = GUIParser.deserializeItem(this, this.optionsSection.getConfigurationSection(gUIOption.getName()));
            GUIOption.defineVariables(itemStack, (OfflinePlayer)this.owner, this.edits);
            gUIOption.getSlots().forEach(n -> this.owner.getOpenInventory().getTopInventory().setItem(n.intValue(), itemStack));
        }
        this.owner.updateInventory();
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    public InteractiveGUI push(String string, Runnable runnable, Object ... objectArray) {
        return this.push(string, objectArray, null, new ActionRunnable(ClickType.LEFT, runnable));
    }

    public InteractiveGUI push(String string, Runnable runnable, Conversable conversable, Object ... objectArray) {
        return this.push(string, objectArray, conversable, new ActionRunnable(ClickType.LEFT, runnable));
    }

    public Set<String> getHolders() {
        return this.holders;
    }

    public InteractiveGUI push(String string, Object[] objectArray, Runnable runnable) {
        return this.push(string, objectArray, null, new ActionRunnable(ClickType.LEFT, runnable));
    }

    public Player getOwner() {
        return this.owner;
    }

    public InteractiveGUI push(String string, Object[] objectArray, Conversable conversable, ActionRunnable ... actionRunnableArray) {
        List<Object> list = this.wrapEditors(objectArray);
        GUIOption gUIOption = GUIParser.option(this, string, this.placeholder, list);
        if (gUIOption == null) {
            return this;
        }
        gUIOption.defineVariables(this, list);
        gUIOption.getSlots().forEach(n -> this.inventory.setItem(n.intValue(), gUIOption.getItem()));
        EnumMap<ClickType, Runnable> enumMap = new EnumMap<ClickType, Runnable>(ClickType.class);
        for (ActionRunnable actionRunnable : actionRunnableArray) {
            enumMap.put(actionRunnable.getClick(), actionRunnable.getRunnable());
        }
        gUIOption.setRunnables(enumMap);
        gUIOption.setConversation(conversable);
        this.holders.remove(string);
        gUIOption.getSlots().forEach(n -> this.options.put((Integer)n, gUIOption));
        return this;
    }

    public Map<Integer, GUIOption> getOptions() {
        return this.options;
    }

    public InteractiveGUI push(GUIOption gUIOption, ItemStack itemStack, int n, Runnable runnable, Object ... objectArray) {
        return this.push(gUIOption, itemStack, n, objectArray, null, new ActionRunnable(ClickType.LEFT, runnable));
    }

    private List<Object> wrapEditors(Object[] objectArray) {
        if (objectArray == null || objectArray.length == 0) {
            return this.edits;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>(Arrays.asList(objectArray));
        arrayList.addAll(this.edits);
        return arrayList;
    }

    public InteractiveGUI push(GUIOption gUIOption, ItemStack itemStack, int n, Object[] objectArray, Conversable conversable, ActionRunnable ... actionRunnableArray) {
        if (itemStack == null) {
            itemStack = gUIOption.getItem();
        }
        GUIOption.defineVariables(itemStack, this.placeholder, this.wrapEditors(objectArray));
        EnumMap<ClickType, Runnable> enumMap = new EnumMap<ClickType, Runnable>(ClickType.class);
        for (ActionRunnable actionRunnable : actionRunnableArray) {
            enumMap.put(actionRunnable.getClick(), actionRunnable.getRunnable());
        }
        gUIOption.setRunnables(enumMap);
        gUIOption.setConversation(conversable);
        this.inventory.setItem(n, itemStack);
        this.options.put(n, gUIOption);
        return this;
    }

    public GUIOption getHolder(String string, Object ... objectArray) {
        return GUIParser.option(this, string, this.placeholder, this.wrapEditors(objectArray));
    }

    public GUIOption getHoldingOption(String string, Object ... objectArray) {
        GUIOption gUIOption = this.getHolder(string, objectArray);
        if (gUIOption == null) {
            return null;
        }
        gUIOption.getSlots().forEach(n -> this.options.put((Integer)n, gUIOption));
        this.holders.remove(string);
        return gUIOption;
    }

    public void dispose(String string, GUIOption gUIOption) {
        gUIOption.getSlots().forEach(n -> this.options.put((Integer)n, gUIOption));
        this.dispose(string);
    }

    public void dispose(String ... stringArray) {
        for (String string : stringArray) {
            this.holders.remove(string);
        }
    }

    public void setRest() {
        for (String string : this.holders) {
            GUIOption gUIOption = GUIParser.option(this, string, this.placeholder, this.edits);
            if (gUIOption == null) continue;
            gUIOption.defineVariables(this, this.edits);
            gUIOption.getSlots().forEach(n -> {
                this.inventory.setItem(n.intValue(), gUIOption.getItem());
                this.options.put((Integer)n, gUIOption);
            });
        }
        this.holders.clear();
    }

    public void openInventory(Player player) {
        this.openInventory(player, false, false);
    }

    public void openInventory(Player player, boolean bl) {
        this.openInventory(player, bl, false);
    }

    public void openInventory(Player player, boolean bl, boolean bl2) {
        if (!bl2) {
            if (Bukkit.isPrimaryThread()) {
                player.openInventory(this.inventory);
                InteractiveGUI interactiveGUI = InteractiveGUIManager.GUIS.put(player.getEntityId(), this);
                if (interactiveGUI != null) {
                    interactiveGUI.cancelRefreshTask();
                }
            } else {
                Bukkit.getScheduler().runTask((Plugin)SkillsPro.get(), () -> {
                    player.openInventory(this.inventory);
                    InteractiveGUI interactiveGUI = InteractiveGUIManager.GUIS.put(player.getEntityId(), this);
                    if (interactiveGUI != null) {
                        interactiveGUI.cancelRefreshTask();
                    }
                });
            }
        }
        InteractiveGUIManager.CONVERSATION.remove(player.getEntityId());
        if (!bl) {
            StringUtils.performCommands(player, this.commands);
            if (!Strings.isNullOrEmpty((String)this.sound)) {
                XSound.play(player, this.sound);
            }
            if (!Strings.isNullOrEmpty((String)this.message)) {
                MessageHandler.sendPlayerMessage(player, this.message);
            }
        } else if (bl2) {
            this.refresh();
        }
    }

    public GUIOption getAction(int n) {
        return this.options.get(n);
    }

    public void onClose(Runnable runnable) {
        this.onClose = runnable;
    }

    public Runnable getOnClose() {
        return this.onClose;
    }

    public String getName() {
        return this.name;
    }

    public List<Integer> getInteractableSlots() {
        if (this.canInteractWithEmpty()) {
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            for (int i = 0; i < this.inventory.getSize(); ++i) {
                if (this.options.containsKey(i)) continue;
                arrayList.add(i);
            }
            return arrayList;
        }
        return this.interactableSlots;
    }

    public boolean canInteractWithEmpty() {
        return this.interactableSlots.size() == 1 && this.interactableSlots.get(0) == 999;
    }

    public int firstEmpty() {
        for (int n : this.interactableSlots) {
            if (this.inventory.getItem(n) != null) continue;
            return n;
        }
        return -1;
    }

    public boolean isSlotInteractable(int n) {
        return this.interactableSlots.contains(n);
    }

    public List<ItemStack> getInteractableItems() {
        ArrayList<ItemStack> arrayList = new ArrayList<ItemStack>();
        if (this.canInteractWithEmpty()) {
            for (int i = 0; i < this.inventory.getSize(); ++i) {
                ItemStack itemStack;
                if (this.options.containsKey(i) || (itemStack = this.inventory.getItem(i)) == null) continue;
                arrayList.add(itemStack);
            }
        } else {
            for (int n : this.interactableSlots) {
                ItemStack itemStack = this.inventory.getItem(n);
                if (itemStack == null) continue;
                arrayList.add(itemStack);
            }
        }
        return arrayList;
    }

    public void returnItems() {
        XItemStack.giveOrDrop(this.owner, this.getInteractableItems().toArray(new ItemStack[0]));
    }

    public List<String> getCommands() {
        return this.commands;
    }

    public List<Integer> getRefresh() {
        return this.refresh;
    }

    public Integer getRefreshTask() {
        return this.refreshTask;
    }

    public void setRefreshTask(BukkitTask bukkitTask) {
        this.setRefreshTask(bukkitTask.getTaskId());
    }

    public void setRefreshTask(Integer n) {
        this.cancelRefreshTask();
        this.refreshTask = n;
    }

    public void cancelRefreshTask() {
        if (this.refreshTask != null) {
            Bukkit.getScheduler().cancelTask(this.refreshTask.intValue());
        }
    }

    public boolean isDisallowCreative() {
        return this.disallowCreative;
    }

    public ConfigurationSection getOptionsSection() {
        return this.optionsSection;
    }

    public OfflinePlayer getPlaceholder() {
        return this.placeholder;
    }

    public static class ActionRunnable {
        private final ClickType click;
        private final Runnable runnable;

        public ActionRunnable(ClickType clickType, Runnable runnable) {
            this.click = clickType;
            this.runnable = runnable;
        }

        public Runnable getRunnable() {
            return this.runnable;
        }

        public ClickType getClick() {
            return this.click;
        }
    }
}

