/*
 * Decompiled with CFR 0.152.
 */
package org.skills.gui;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.bukkit.GameMode;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.skills.gui.GUIConfig;
import org.skills.gui.GUIOption;
import org.skills.gui.InteractiveGUI;
import org.skills.main.locale.MessageHandler;
import org.skills.services.manager.ServiceHandler;
import org.skills.utils.xseries.XItemStack;
import org.skills.utils.xseries.XSound;

public class GUIParser {
    public static ItemStack deserializeItem(@NotNull InteractiveGUI interactiveGUI, ConfigurationSection configurationSection) {
        ItemStack itemStack = XItemStack.deserialize(configurationSection);
        if (itemStack == null) {
            MessageHandler.sendConsolePluginMessage("&4Could not parse item for option: &e" + configurationSection.getName() + " &4in GUI &e" + interactiveGUI.getName() + " &4with properties&8:");
            configurationSection.getValues(true).forEach((string, object) -> MessageHandler.sendConsolePluginMessage("&6" + string + "&8: &e" + (object instanceof ConfigurationSection ? "" : object)));
            return null;
        }
        return itemStack;
    }

    public static void e(@NotNull String string) {
        string.substring(3);
    }

    private static String translate(OfflinePlayer offlinePlayer, String string, List<Object> list) {
        return MessageHandler.replaceVariables(ServiceHandler.translatePlaceholders(offlinePlayer, string), list);
    }

    public static InteractiveGUI parseOption(Player player, String string) {
        return GUIParser.parseOption(player, (OfflinePlayer)player, string, new ArrayList<Object>());
    }

    public static InteractiveGUI parseOption(Player player, String string, Object ... objectArray) {
        return GUIParser.parseOption(player, (OfflinePlayer)player, string, objectArray);
    }

    public static InteractiveGUI parseOption(Player player, OfflinePlayer offlinePlayer, String string, Object ... objectArray) {
        return GUIParser.parseOption(player, offlinePlayer, string, Arrays.asList(objectArray));
    }

    public static InteractiveGUI parseOption(Player player, OfflinePlayer offlinePlayer, String string, List<Object> list) {
        String string2;
        Object object;
        int n;
        FileConfiguration fileConfiguration = GUIConfig.getGUI(string);
        if (fileConfiguration == null) {
            return null;
        }
        fileConfiguration.options().pathSeparator('\u0000');
        boolean bl = fileConfiguration.getBoolean("disallow-creative");
        if (bl && player.getGameMode() == GameMode.CREATIVE) {
            MessageHandler.sendPlayerMessage(player, "&cYou can't open this GUI in creative mode.");
            XSound.BLOCK_NOTE_BLOCK_BASS.play((Entity)player);
            return null;
        }
        String string3 = MessageHandler.replaceVariables(fileConfiguration.getString("title"), list);
        String string4 = fileConfiguration.getString("type");
        String string5 = fileConfiguration.getString("sound");
        List list2 = fileConfiguration.getStringList("commands");
        List list3 = fileConfiguration.getIntegerList("interactable");
        if (!list3.isEmpty() && (n = ((Integer)list3.get(0)).intValue()) < 0) {
            list3.set(0, -((Integer)list3.get(0)).intValue());
            object = new ArrayList();
            for (int i = 0; i < 53; ++i) {
                if (list3.contains(i)) continue;
                object.add(i);
            }
            list3 = object;
        }
        n = -1;
        object = null;
        if (string4 == null) {
            n = fileConfiguration.getInt("rows") * 9;
            if (n < 1) {
                MessageHandler.sendConsolePluginMessage("&4Invalid rows for slots '&e" + n + "&4' for GUI&8: &e" + string);
                return null;
            }
        } else {
            try {
                string4 = string4.toUpperCase(Locale.ENGLISH);
                object = InventoryType.valueOf((String)string4);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                MessageHandler.sendConsolePluginMessage("&4Could not find inventory type '&e" + string4 + "&4' for GUI&8: &e" + string);
                return null;
            }
        }
        if (string3 != null) {
            string3 = MessageHandler.colorize(ServiceHandler.translatePlaceholders((OfflinePlayer)player, string3));
        }
        if (!Strings.isNullOrEmpty((String)(string2 = fileConfiguration.getString("message")))) {
            string2 = GUIParser.translate(offlinePlayer, string2, list);
        }
        ConfigurationSection configurationSection = fileConfiguration.getConfigurationSection("options");
        return string4 == null ? new InteractiveGUI(player, offlinePlayer, string, string3, n, string5, (List<String>)list2, (List<Integer>)list3, string2, bl, configurationSection, list) : new InteractiveGUI(player, offlinePlayer, (InventoryType)object, string, string3, string5, (List<String>)list2, (List<Integer>)list3, string2, bl, configurationSection, list);
    }

    public static GUIOption option(InteractiveGUI interactiveGUI, String string, OfflinePlayer offlinePlayer, List<Object> list) {
        Iterator iterator;
        ConfigurationSection configurationSection;
        String string2;
        Object object;
        ConfigurationSection configurationSection2 = interactiveGUI.getOptionsSection().getConfigurationSection(string);
        if (configurationSection2 == null) {
            return null;
        }
        if (configurationSection2.getString("material") == null) {
            object = configurationSection2.getKeys(false).iterator();
            while (object.hasNext()) {
                string2 = (String)object.next();
                configurationSection = configurationSection2.getConfigurationSection(string2);
                if (configurationSection == null || !GUIOption.conditional(interactiveGUI, string, offlinePlayer, (String)((Object)(iterator = configurationSection.getString("condition"))), list)) continue;
                configurationSection2 = configurationSection;
                break;
            }
        }
        if ((object = GUIParser.deserializeItem(interactiveGUI, configurationSection2)) == null) {
            return null;
        }
        if (object.getAmount() > interactiveGUI.getInventory().getMaxStackSize()) {
            interactiveGUI.getInventory().setMaxStackSize(object.getAmount());
        }
        string2 = configurationSection2.getString("sound");
        configurationSection = configurationSection2.getConfigurationSection("sound");
        if (configurationSection != null) {
            for (String string3 : configurationSection.getKeys(false)) {
                if (!GUIOption.conditional(interactiveGUI, string, offlinePlayer, string3, list)) continue;
                string2 = configurationSection.getString(string3);
                break;
            }
        }
        iterator = configurationSection2.getStringList("commands");
        boolean bl = configurationSection2.getBoolean("can-take");
        boolean bl2 = configurationSection2.getBoolean("refresh");
        String string4 = configurationSection2.getString("message");
        configurationSection = configurationSection2.getConfigurationSection("message");
        if (configurationSection != null) {
            for (Object object2 : configurationSection.getKeys(false)) {
                if (!GUIOption.conditional(interactiveGUI, string, offlinePlayer, (String)object2, list)) continue;
                string4 = configurationSection.getString((String)object2);
                break;
            }
        }
        if (!Strings.isNullOrEmpty((String)string4)) {
            string4 = ServiceHandler.translatePlaceholders(offlinePlayer, string4);
        }
        Object object3 = new ArrayList(configurationSection2.getIntegerList("slots"));
        configurationSection = configurationSection2.getConfigurationSection("slots");
        if (configurationSection != null) {
            for (String string5 : configurationSection.getKeys(false)) {
                if (!GUIOption.conditional(interactiveGUI, string, offlinePlayer, string5, list)) continue;
                object3 = configurationSection.getIntegerList(string5);
                break;
            }
        }
        if (object3.isEmpty()) {
            configurationSection2 = interactiveGUI.getOptionsSection().getConfigurationSection(string);
            int n = configurationSection2.getInt("slot");
            if (!configurationSection2.contains("slot")) {
                if (!configurationSection2.contains("posx") || !configurationSection2.contains("posy")) {
                    MessageHandler.sendConsolePluginMessage("&4Could not find item slot option for item&8: &e" + string);
                    return new GUIOption(string, (ItemStack)object, (List<Integer>)new ArrayList<Integer>(), string2, bl, (List<String>)((Object)iterator), string4);
                }
                int n2 = configurationSection2.getInt("posx");
                int n3 = configurationSection2.getInt("posy");
                n = n3 * 9 - (9 - n2) - 1;
            }
            object3.add(n);
        }
        if (bl2) {
            interactiveGUI.getRefresh().addAll((Collection<Integer>)object3);
        }
        return new GUIOption(string, (ItemStack)object, (List<Integer>)object3, string2, bl, (List<String>)((Object)iterator), string4);
    }
}

