/*
 * Decompiled with CFR 0.152.
 */
package org.skills.gui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang.Validate;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.skills.gui.Conversable;
import org.skills.gui.InteractiveGUI;
import org.skills.main.locale.MessageHandler;
import org.skills.services.manager.ServiceHandler;
import org.skills.utils.BooleanEval;

public class GUIOption {
    private static final Pattern PERMISSION_PATTERN = Pattern.compile("perm:((?:\\w|\\.|,)+)");
    private final String name;
    private final List<Integer> slots;
    private final String sound;
    private final List<String> commands;
    private final boolean canBeTaken;
    private final ItemStack item;
    private String message;
    private Map<ClickType, Runnable> runnables;
    private Conversable conversation;

    public GUIOption(String string, ItemStack itemStack, List<Integer> list, String string2, boolean bl, List<String> list2, String string3) {
        this.name = string;
        this.item = itemStack;
        this.slots = list;
        this.canBeTaken = bl;
        this.commands = list2;
        this.sound = string2;
        this.message = string3;
    }

    public static void defineVariables(ItemStack itemStack, OfflinePlayer offlinePlayer, Object ... objectArray) {
        GUIOption.defineVariables(itemStack, offlinePlayer, Arrays.asList(objectArray));
    }

    public static void defineVariables(ItemStack itemStack, OfflinePlayer offlinePlayer, List<Object> list) {
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (itemMeta.hasDisplayName()) {
            itemMeta.setDisplayName(MessageHandler.colorize(ServiceHandler.translatePlaceholders(offlinePlayer, MessageHandler.replaceVariables(itemMeta.getDisplayName(), list))));
        }
        if (itemMeta.hasLore()) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (String string : itemMeta.getLore()) {
                arrayList.add(MessageHandler.colorize(ServiceHandler.translatePlaceholders(offlinePlayer, MessageHandler.replaceVariables(string, list))));
            }
            itemMeta.setLore(arrayList);
        }
        itemStack.setItemMeta(itemMeta);
    }

    public static boolean conditional(InteractiveGUI interactiveGUI, String string2, OfflinePlayer offlinePlayer, String string3, List<Object> list) {
        Validate.notEmpty((String)string3, (String)"Cannot evaluate null or empty condition.");
        try {
            return BooleanEval.evaluate(string3, string -> {
                string = ServiceHandler.translatePlaceholders(offlinePlayer, MessageHandler.replaceVariables(string, list));
                if (offlinePlayer instanceof Player) {
                    return PERMISSION_PATTERN.matcher((CharSequence)string).replaceAll(Boolean.toString(((Player)offlinePlayer).hasPermission("$1".replace(',', '.'))));
                }
                return PERMISSION_PATTERN.matcher((CharSequence)string).replaceAll("true");
            });
        }
        catch (IllegalArgumentException illegalArgumentException) {
            MessageHandler.sendConsolePluginMessage("&4Error while evaluating a conditional item &e" + string2 + " &c in GUI&8: &e" + interactiveGUI.getName());
            return true;
        }
    }

    public String getName() {
        return this.name;
    }

    public GUIOption clone() {
        GUIOption gUIOption = new GUIOption(this.name, this.item.clone(), new ArrayList<Integer>(this.slots), this.sound, this.canBeTaken, new ArrayList<String>(this.commands), this.message);
        gUIOption.setConversation(this.conversation);
        gUIOption.setRunnables(this.runnables);
        return gUIOption;
    }

    public void defineVariables(InteractiveGUI interactiveGUI, List<Object> list) {
        GUIOption.defineVariables(this.item, interactiveGUI.getPlaceholder(), list);
    }

    public List<Integer> getSlots() {
        return this.slots;
    }

    public String getSound() {
        return this.sound;
    }

    public List<String> getCommands() {
        return this.commands;
    }

    public boolean canBeTaken() {
        return this.canBeTaken;
    }

    public ItemStack getItem() {
        return this.item;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String string) {
        this.message = string;
    }

    public Map<ClickType, Runnable> getRunnables() {
        return this.runnables;
    }

    public void setRunnables(Map<ClickType, Runnable> map) {
        this.runnables = map;
    }

    public Conversable getConversation() {
        return this.conversation;
    }

    public void setConversation(Conversable conversable) {
        this.conversation = conversable;
    }
}

